/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.InputObject;
import edu.hws.jcm.awt.Limits;
import edu.hws.jcm.awt.Tie;
import edu.hws.jcm.awt.Tieable;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.draw.DisplayCanvas;
import edu.hws.jcm.draw.Draggable;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class CoordinateRect
implements Tieable,
Limits,
Computable,
InputObject {
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private int gap = 5;
    protected Vector drawItems = new Vector();
    protected boolean changed;
    private long serialNumber;
    protected Tie syncWith;
    public static final int XMIN = 0;
    public static final int XMAX = 1;
    public static final int YMIN = 2;
    public static final int YMAX = 3;
    protected Controller onChange;
    private int left;
    private int top;
    private int width = -1;
    private int height = -1;
    private double restore_xmin = Double.NaN;
    private double restore_xmax;
    private double restore_ymin;
    private double restore_ymax;
    private DisplayCanvas canvas;

    public CoordinateRect() {
        this(-5.0, 5.0, -5.0, 5.0);
    }

    public CoordinateRect(double d, double d2, double d3, double d4) {
        this.setLimits(d, d2, d3, d4);
        this.serialNumber = 0L;
        this.setRestoreBuffer();
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        if (n >= 0 && this.gap != n) {
            int n2 = this.gap;
            this.gap = n;
            this.changed = true;
            ++this.serialNumber;
            this.needsRedraw();
        }
    }

    public double[] getLimits() {
        return new double[]{this.xmin, this.xmax, this.ymin, this.ymax};
    }

    public void setLimits(double d, double d2, double d3, double d4) {
        double[] dArray = this.getLimits();
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
        this.checkLimits();
        double[] dArray2 = this.getLimits();
        if (dArray[0] == dArray2[0] && dArray[1] == dArray2[1] && dArray[2] == dArray2[2] && dArray[3] == dArray2[3]) {
            return;
        }
        this.changed = true;
        ++this.serialNumber;
        if (this.syncWith != null) {
            this.syncWith.check();
        }
        if (this.onChange != null) {
            this.onChange.compute();
        }
        this.needsRedraw();
    }

    public void setLimits(double[] dArray) {
        if (dArray != null && dArray.length >= 4) {
            this.setLimits(dArray[0], dArray[1], dArray[2], dArray[3]);
        }
    }

    public void setOnChange(Controller controller) {
        this.onChange = controller;
    }

    public Controller getOnChange() {
        return this.onChange;
    }

    public Value getValueObject(final int n) {
        return new Value(){

            public double getVal() {
                switch (n) {
                    case 0: {
                        return CoordinateRect.this.getXmin();
                    }
                    case 1: {
                        return CoordinateRect.this.getXmax();
                    }
                    case 2: {
                        return CoordinateRect.this.getYmin();
                    }
                }
                return CoordinateRect.this.getYmax();
            }
        };
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public void setSyncWith(Tie tie) {
        this.syncWith = tie;
    }

    public void sync(Tie tie, Tieable tieable) {
        if (tieable != this) {
            if (!(tieable instanceof Limits)) {
                throw new IllegalArgumentException("Internal programming error:  A CoordinateRect can only be tied to a Limits object.");
            }
            double[] dArray = ((Limits)((Object)tieable)).getLimits();
            if (dArray != null && dArray.length >= 4) {
                double[] dArray2 = this.getLimits();
                if (dArray[0] == dArray2[0] && dArray[1] == dArray2[1] && dArray[2] == dArray2[2] && dArray[3] == dArray2[3]) {
                    return;
                }
                this.xmin = dArray[0];
                this.xmax = dArray[1];
                this.ymin = dArray[2];
                this.ymax = dArray[3];
                this.checkLimits();
                this.serialNumber = tieable.getSerialNumber();
                this.changed = true;
                if (this.onChange != null) {
                    this.onChange.compute();
                }
                this.needsRedraw();
            }
        }
    }

    private void checkLimits() {
        double d;
        if (this.xmin == this.xmax) {
            this.xmin -= 1.0;
            this.xmax += 1.0;
        } else if (this.xmin > this.xmax) {
            d = this.xmin;
            this.xmin = this.xmax;
            this.xmax = d;
        }
        if (this.ymin == this.ymax) {
            this.ymin -= 1.0;
            this.ymax += 1.0;
        }
        if (this.ymin > this.ymax) {
            d = this.ymin;
            this.ymin = this.ymax;
            this.ymax = d;
        }
    }

    public int getLeft() {
        return this.left;
    }

    public int getWidth() {
        return this.width;
    }

    public int getTop() {
        return this.top;
    }

    public int getHeight() {
        return this.height;
    }

    public double getPixelWidth() {
        return (this.xmax - this.xmin) / (double)(this.width - 2 * this.gap - 1);
    }

    public double getPixelHeight() {
        return (this.ymax - this.ymin) / (double)(this.height - 2 * this.gap - 1);
    }

    public int xToPixel(double d) {
        int n = this.left + this.gap + (int)((d - this.xmin) / (this.xmax - this.xmin) * (double)(this.width - 2 * this.gap - 1));
        if (n < -32000) {
            return -32000;
        }
        if (n > 32000) {
            return 32000;
        }
        return n;
    }

    public int yToPixel(double d) {
        int n = this.top + this.gap + (int)((this.ymax - d) / (this.ymax - this.ymin) * (double)(this.height - 2 * this.gap - 1));
        if (n < -32000) {
            return -32000;
        }
        if (n > 32000) {
            return 32000;
        }
        return n;
    }

    public double pixelToX(int n) {
        return this.xmin + (double)(n - this.left - this.gap) * (this.xmax - this.xmin) / (double)(this.width - 2 * this.gap - 1);
    }

    public double pixelToY(int n) {
        return this.ymax - (double)(n - this.top - this.gap) * (this.ymax - this.ymin) / (double)(this.height - 2 * this.gap - 1);
    }

    public double[] restore() {
        if (Double.isNaN(this.restore_xmin)) {
            return null;
        }
        this.setLimits(this.restore_xmin, this.restore_xmax, this.restore_ymin, this.restore_ymax);
        return this.getLimits();
    }

    public void clearRestoreBuffer() {
        this.restore_xmin = Double.NaN;
    }

    public void setRestoreBuffer() {
        if (this.badData()) {
            return;
        }
        this.checkLimits();
        this.restore_xmin = this.xmin;
        this.restore_xmax = this.xmax;
        this.restore_ymin = this.ymin;
        this.restore_ymax = this.ymax;
    }

    private boolean badData() {
        return Double.isNaN(this.xmin) || Double.isInfinite(this.xmin) || Double.isNaN(this.ymin) || Double.isInfinite(this.ymin) || Double.isNaN(this.xmax) || Double.isInfinite(this.xmax) || Double.isNaN(this.ymax) || Double.isInfinite(this.ymax);
    }

    public double[] zoomIn() {
        if (this.badData()) {
            return this.getLimits();
        }
        double d = (this.xmax - this.xmin) / 4.0;
        double d2 = (this.ymax - this.ymin) / 4.0;
        double d3 = (this.xmin + this.xmax) / 2.0;
        double d4 = (this.ymin + this.ymax) / 2.0;
        if (Math.abs(d2) < 1.0E-100 || Math.abs(d) < 1.0E-100) {
            return null;
        }
        this.setLimits(d3 - d, d3 + d, d4 - d2, d4 + d2);
        return this.getLimits();
    }

    public double[] zoomOut() {
        if (this.badData()) {
            return this.getLimits();
        }
        double d = this.xmax - this.xmin;
        double d2 = this.ymax - this.ymin;
        double d3 = (this.xmin + this.xmax) / 2.0;
        double d4 = (this.ymin + this.ymax) / 2.0;
        if (Math.abs(d) > 1.0E100 || Math.abs(d2) > 1.0E100) {
            return null;
        }
        this.setLimits(d3 - d, d3 + d, d4 - d2, d4 + d2);
        return this.getLimits();
    }

    public double[] zoomInOnPixel(int n, int n2) {
        if (this.badData()) {
            return this.getLimits();
        }
        double d = (this.xmax - this.xmin) / 4.0;
        double d2 = (this.ymax - this.ymin) / 4.0;
        if (Math.abs(d2) < 1.0E-100 || Math.abs(d) < 1.0E-100) {
            return null;
        }
        double d3 = this.pixelToX(n);
        double d4 = this.pixelToY(n2);
        double d5 = (this.xmin + this.xmax) / 2.0;
        double d6 = (this.ymin + this.ymax) / 2.0;
        double d7 = (d5 + d3) / 2.0;
        double d8 = (d6 + d4) / 2.0;
        this.setLimits(d7 - d, d7 + d, d8 - d2, d8 + d2);
        return this.getLimits();
    }

    public double[] zoomOutFromPixel(int n, int n2) {
        if (this.badData()) {
            return this.getLimits();
        }
        double d = this.xmax - this.xmin;
        double d2 = this.ymax - this.ymin;
        if (Math.abs(d) > 1.0E100 || Math.abs(d2) > 1.0E100) {
            return null;
        }
        double d3 = this.pixelToX(n);
        double d4 = this.pixelToY(n2);
        double d5 = (this.xmin + this.xmax) / 2.0;
        double d6 = (this.ymin + this.ymax) / 2.0;
        double d7 = 2.0 * d5 - d3;
        double d8 = 2.0 * d6 - d4;
        this.setLimits(d7 - d, d7 + d, d8 - d2, d8 + d2);
        return this.getLimits();
    }

    public double[] equalizeAxes() {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.badData()) {
            return this.getLimits();
        }
        double d5 = this.xmax - this.xmin;
        double d6 = d5 / (double)(this.width - 2 * this.gap - 1);
        double d7 = this.ymax - this.ymin;
        double d8 = d7 / (double)(this.height - 2 * this.gap - 1);
        if (d6 < d8) {
            double d9 = (this.xmax + this.xmin) / 2.0;
            double d10 = d5 / 2.0 * d8 / d6;
            d4 = d9 + d10;
            d3 = d9 - d10;
            d2 = this.ymin;
            d = this.ymax;
        } else if (d6 > d8) {
            double d11 = (this.ymax + this.ymin) / 2.0;
            double d12 = d7 / 2.0 * d6 / d8;
            d = d11 + d12;
            d2 = d11 - d12;
            d3 = this.xmin;
            d4 = this.xmax;
        } else {
            return null;
        }
        this.setLimits(d3, d4, d2, d);
        return this.getLimits();
    }

    void setOwner(DisplayCanvas displayCanvas) {
        this.canvas = displayCanvas;
    }

    private void needsRedraw() {
        if (this.canvas != null) {
            this.canvas.doRedraw(this);
        }
    }

    public void checkInput() {
        int n = this.drawItems.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.drawItems.elementAt(i) instanceof InputObject)) continue;
            ((InputObject)this.drawItems.elementAt(i)).checkInput();
        }
    }

    public void compute() {
        int n = this.drawItems.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.drawItems.elementAt(i) instanceof Computable)) continue;
            ((Computable)this.drawItems.elementAt(i)).compute();
        }
    }

    public void notifyControllerOnChange(Controller controller) {
        int n = this.drawItems.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.drawItems.elementAt(i) instanceof InputObject)) continue;
            ((InputObject)this.drawItems.elementAt(i)).notifyControllerOnChange(controller);
        }
    }

    public synchronized void add(Drawable drawable) {
        if (drawable != null && !this.drawItems.contains(drawable)) {
            drawable.setOwnerData(this.canvas, this);
            this.drawItems.addElement(drawable);
        }
    }

    public synchronized void remove(Drawable drawable) {
        if (drawable != null && this.drawItems.removeElement(drawable)) {
            drawable.setOwnerData(null, null);
        }
    }

    public int getDrawableCount() {
        return this.drawItems == null ? 0 : this.drawItems.size();
    }

    public Drawable getDrawable(int n) {
        if (this.drawItems != null && n >= 0 && n < this.drawItems.size()) {
            return (Drawable)this.drawItems.elementAt(n);
        }
        return null;
    }

    Draggable checkDraggables(MouseEvent mouseEvent) {
        int n = this.drawItems.size();
        for (int i = n - 1; i >= 0; --i) {
            if (!(this.drawItems.elementAt(i) instanceof Draggable) || !((Draggable)this.drawItems.elementAt(i)).startDrag(mouseEvent)) continue;
            return (Draggable)this.drawItems.elementAt(i);
        }
        return null;
    }

    public void draw(Graphics graphics, int n, int n2) {
        this.draw(graphics, 0, 0, n, n2);
    }

    public synchronized void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.badData()) {
            graphics.setColor(Color.red);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.drawString("(undefined limits)", n + 6, n2 + 15);
        }
        if (this.changed || this.left != n || this.top != n2 || this.width != n3 || this.height != n4) {
            this.width = n3;
            this.height = n4;
            this.left = n;
            this.top = n2;
            this.checkLimits();
            this.changed = true;
        }
        this.doDraw(graphics);
        this.changed = false;
    }

    protected void doDraw(Graphics graphics) {
        int n = this.drawItems.size();
        for (int i = 0; i < n; ++i) {
            Drawable drawable = (Drawable)this.drawItems.elementAt(i);
            if (!drawable.getVisible()) continue;
            drawable.draw(graphics, this.changed);
        }
    }
}

