/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.eventutils;

import java.util.HashMap;
import org.j3d.util.interpolator.BooleanInterpolator;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSequencerNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseSequencerNode;

public abstract class BaseBooleanSequencer
extends BaseSequencerNode {
    protected static final int LAST_BOOLEAN_SEQUENCER_INDEX = 6;
    private static final int NUM_FIELDS = 7;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected boolean[] vfKeyValue;
    protected int numKeyValue;
    protected boolean vfValueChanged;
    private BooleanInterpolator interpolator;

    protected BaseBooleanSequencer() {
        super("BooleanSequencer");
        this.hasChanged = new boolean[7];
        this.vfKeyValue = FieldConstants.EMPTY_MFBOOL;
        this.vfValueChanged = false;
    }

    protected BaseBooleanSequencer(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSequencerNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("keyValue");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfKeyValue = new boolean[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.booleanArrayValue, 0, this.vfKeyValue, 0, vRMLFieldData.numElements);
                this.numKeyValue = vRMLFieldData.numElements;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setFraction(float f) {
        this.vfFraction = f;
        if (this.vfKey != null && this.vfKey.length > 0 && this.interpolator != null && this.vfKeyValue.length > 0) {
            boolean bl = this.interpolator.booleanValue(this.vfFraction);
            this.setValueChanged(bl);
        }
    }

    public void setKey(float[] fArray, int n) {
        super.setKey(fArray, n);
        if (!this.inSetup) {
            this.rebuildInterpolator();
            this.setFraction(this.vfFraction);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.rebuildInterpolator();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanArrayValue = this.vfKeyValue;
                vRMLFieldData.dataType = (short)8;
                vRMLFieldData.numElements = this.numKeyValue;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfValueChanged;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfKeyValue, this.numKeyValue);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfValueChanged);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseBooleanSequencer sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseBooleanSequencer sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setFraction(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, boolean[] blArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.setKeyValue(blArray, n2);
                break;
            }
            default: {
                super.setValue(n, blArray, n2);
            }
        }
    }

    private void rebuildInterpolator() {
        if (this.vfKey == null || this.vfKeyValue == null) {
            this.interpolator = null;
            return;
        }
        int n = this.vfKey.length < this.vfKeyValue.length ? this.vfKey.length : this.vfKeyValue.length;
        this.interpolator = new BooleanInterpolator(n, 2);
        for (int i = 0; i < n; ++i) {
            this.interpolator.addKeyFrame(this.vfKey[i], this.vfKeyValue[i]);
        }
    }

    private void setKeyValue(boolean[] blArray, int n) {
        this.numKeyValue = n;
        if (n != 0) {
            if (n > this.vfKeyValue.length) {
                this.vfKeyValue = new boolean[n];
            }
            System.arraycopy(blArray, 0, this.vfKeyValue, 0, n);
        }
        if (!this.inSetup) {
            this.rebuildInterpolator();
            this.setFraction(this.vfFraction);
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setValueChanged(boolean bl) {
        this.vfValueChanged = bl;
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(21);
        BaseBooleanSequencer.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseBooleanSequencer.fieldDecl[1] = new VRMLFieldDeclaration(1, "SFBool", "next");
        BaseBooleanSequencer.fieldDecl[3] = new VRMLFieldDeclaration(1, "SFBool", "previous");
        BaseBooleanSequencer.fieldDecl[3] = new VRMLFieldDeclaration(1, "SFFloat", "set_fraction");
        BaseBooleanSequencer.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFFloat", "key");
        BaseBooleanSequencer.fieldDecl[5] = new VRMLFieldDeclaration(3, "MFBool", "keyValue");
        BaseBooleanSequencer.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFBool", "value_changed");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("next", new Integer(1));
        fieldMap.put("previous", new Integer(3));
        fieldMap.put("set_fraction", new Integer(3));
        n = new Integer(4);
        fieldMap.put("key", n);
        fieldMap.put("set_key", n);
        fieldMap.put("key_changed", n);
        n = new Integer(5);
        fieldMap.put("keyValue", n);
        fieldMap.put("set_keyValue", n);
        fieldMap.put("keyValueChanged", n);
        fieldMap.put("value_changed", new Integer(6));
    }
}

