/*---------------------------------------------------------------------------*\

    FILE....: MESS.CPP
    TYPE....: C Function File
    AUTHOR..: John Kostogiannis
    DATE....: 20/11/97

    Interface functions for messages.  Messages are information sent by
    various modules to a message window just like printf to the console. 

    Used for driver debugging.
	
    DR 12/9/99:
    Removed all Windows stuff for Linux port.  These functions were used
    mainly for console-mode debug anyway.


         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <cstdio>
#include <cstdarg>
#include <string>
#include <sys/time.h>

#include "mess.h"


static int         enable;
static int         file_enable;
static std::string file_name;

static void (*__mprintf)(const char *stuff, ...);


void mess_init() {
	__mprintf = NULL;
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_on
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    Enables mprintf statements.  Either this function of mprintf_off should
    be called during program initialisation to place the mprintf functions
    in a known state.

\*-------------------------------------------------------------------------*/

void mess_mprintf_on(){
	enable = ON;
	file_enable = OFF;
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_on
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    This version send mprintf messages to a text file, rather than the
    console.

\*-------------------------------------------------------------------------*/

void mess_mprintf_on(const char *fn)
{
	enable      = ON;
	file_enable = ON;
	file_name   = fn;

	FILE *f = fopen(file_name.c_str(), "wt");
	assert(f != NULL);
	fclose(f);
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_off
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    Disables mprintf statements.  Either this function or mprintf_on should
    be called during program initialisation to place the mprintf functions
    in a known state.

\*-------------------------------------------------------------------------*/

void mess_mprintf_off()
{
	enable = OFF;
        file_enable = OFF;
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    Similar to printf, but send messages to console, file, or just does
    nothing when mprintf is disabled.

\*-------------------------------------------------------------------------*/

void mprintf(const char *fmt, ...)
{
	if(enable) {
		va_list  argptr;
		va_start(argptr, fmt);

		if (__mprintf){
			char  tmp[1024];
			vsnprintf(tmp, sizeof(tmp), fmt, argptr);
			__mprintf(tmp);
		}
		else if(file_enable) {
			FILE *f = fopen(file_name.c_str(), "at");
			assert(f);
			int ret = vfprintf(f,fmt,argptr);
			assert(ret);
			fclose(f);
		}
		else {
			timeval tv;
			gettimeofday(&tv, NULL);
			fprintf(stdout, "%lu.%-6lu: ", tv.tv_sec % 100000, tv.tv_usec);
			vfprintf(stdout, fmt, argptr);
		}

		va_end(argptr);
	}
}

void mess_set_messages(void (*func)(const char *stuff, ...))
{
//	mprintf("MESS_SET_MESSAGES: CHANGING MPRINT FUNCTION!\n");
        __mprintf = func;
}

