/*---------------------------------------------------------------------------*\

    FILE....: COMP.CPP
    TYPE....: C++ Module
    AUTHOR..: David Rowe
    DATE....: 17/3/98

	Compression class packs and unpacks compressed speech between the DSP
	FIFOs which require one sample per 16 bit word, and the compressed
	format used by the PC which packs samples as tightly as possible.
	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "comp.h"

/*---------------------------------------------------------------------------*\

						class PCMCompression

\*---------------------------------------------------------------------------*/

void PCMCompression::pack(char *packedbytesout, word *wordsin, USHORT nwordsin)
//	char *packedbytesout	output array of packed bytes
//  word *wordsin			input array of words
//	USHORT nwordsin			number of input words
{
	int i;

	for(i=0; i<nwordsin; i++)
		packedbytesout[i] = (char)wordsin[i];
}

void PCMCompression::unpack(word *wordsout, char *packedbytesin, USHORT nbytesin)
//	word *wordsout			output array of words
//  char *packedbytesin		input array of packed bytes
//	USHORT nbytesin			number of input bytes
{
	int i;

	for(i=0; i<nbytesin; i++)
		wordsout[i] = (word)packedbytesin[i];
}

/*---------------------------------------------------------------------------*\

						class LinearCompression

\*---------------------------------------------------------------------------*/

void LinearCompression::pack(char *packedbytesout, word *wordsin, USHORT nwordsin)
//	char *packedbytesout	output array of packed bytes
//  word *wordsin			input array of words
//	USHORT nwordsin			number of input words
{
	int i;
	word *w=(word*)packedbytesout;

	for(i=0; i<nwordsin; i++)
		w[i] = wordsin[i];
}

void LinearCompression::unpack(word *wordsout, char *packedbytesin, USHORT nbytesin)
//	word *wordsout			output array of words
//  char *packedbytesin		input array of packed bytes
//	USHORT nbytesin			number of input bytes
{
	int i;
	word *w=(word*)packedbytesin;

	USHORT nwords = bytes2words(nbytesin);
	for(i=0; i<nwords; i++)
		wordsout[i] = w[i];
}

/*---------------------------------------------------------------------------*\

						class ADPCMCompression

\*---------------------------------------------------------------------------*/

void ADPCMCompression::pack(char *packedbytesout, word *wordsin, USHORT nwordsin)
//	char *packedbytesout	output array of packed bytes
//  word *wordsin			input array of words
//	USHORT nwordsin			number of input words
{
	int i;

	USHORT nbytes = words2bytes(nwordsin);
	for(i=0; i<nbytes; i++) {
		packedbytesout[i] = wordsin[2*i] << 4;
		packedbytesout[i] |= wordsin[2*i+1];
	}
}

void ADPCMCompression::unpack(word *wordsout, char *packedbytesin, USHORT nbytesin)
//	word *wordsout			output array of words
//  char *packedbytesin		input array of packed bytes
//	USHORT bytesin			number of input bytes
{
	int i;

	for(i=0; i<nbytesin; i++) {
		wordsout[2*i] = packedbytesin[i]>>4;
		wordsout[2*i+1] = packedbytesin[i] & 0xf;
	}
}

