/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.opensolaris.os.dtrace.ProbeDescription;

public final class Error
implements Serializable {
    static final long serialVersionUID = 5069931629562700614L;
    public static final String DTRACEFLT_BADADDR = "DTRACEFLT_BADADDR";
    public static final String DTRACEFLT_BADALIGN = "DTRACEFLT_BADALIGN";
    public static final String DTRACEFLT_ILLOP = "DTRACEFLT_ILLOP";
    public static final String DTRACEFLT_DIVZERO = "DTRACEFLT_DIVZERO";
    public static final String DTRACEFLT_NOSCRATCH = "DTRACEFLT_NOSCRATCH";
    public static final String DTRACEFLT_KPRIV = "DTRACEFLT_KPRIV";
    public static final String DTRACEFLT_UPRIV = "DTRACEFLT_UPRIV";
    public static final String DTRACEFLT_TUPOFLOW = "DTRACEFLT_TUPOFLOW";
    public static final String DTRACEFLT_LIBRARY = "DTRACEFLT_LIBRARY";
    private final ProbeDescription probeDescription;
    private final int epid;
    private final int cpu;
    private final int action;
    private final int offset;
    private final String fault;
    private final long address;
    private final String defaultMessage;

    public Error(ProbeDescription pdesc, int enabledProbeID, int errorCPU, int errorAction, int errorOffset, String faultName, long faultAddress, String errorMessage) {
        this.probeDescription = pdesc;
        this.epid = enabledProbeID;
        this.cpu = errorCPU;
        this.action = errorAction;
        this.offset = errorOffset;
        this.fault = faultName;
        this.address = faultAddress;
        this.defaultMessage = errorMessage;
        this.validate();
    }

    private final void validate() {
        if (this.probeDescription == null) {
            throw new NullPointerException("enabled probe description is null");
        }
        if (this.defaultMessage == null) {
            throw new NullPointerException("default message is null");
        }
    }

    public ProbeDescription getProbeDescription() {
        return this.probeDescription;
    }

    public int getEnabledProbeID() {
        return this.epid;
    }

    public int getCPU() {
        return this.cpu;
    }

    public int getAction() {
        return this.action;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getFault() {
        return this.fault;
    }

    public long getAddress() {
        return this.address;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Error.class.getName());
        buf.append("[probeDescription = ");
        buf.append(this.probeDescription);
        buf.append(", epid = ");
        buf.append(this.epid);
        buf.append(", cpu = ");
        buf.append(this.cpu);
        buf.append(", action = ");
        buf.append(this.action);
        buf.append(", offset = ");
        buf.append(this.offset);
        buf.append(", fault = ");
        buf.append(this.fault);
        buf.append(", address = ");
        buf.append(this.address);
        buf.append(", defaultMessage = ");
        buf.append(this.defaultMessage);
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(Error.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"probeDescription", "enabledProbeID", "CPU", "action", "offset", "fault", "address", "defaultMessage"});
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }
}

