/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import jsyntaxpane.SyntaxStyle;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.util.JarServiceProvider;

public class SyntaxStyles {
    Map<TokenType, SyntaxStyle> styles;
    private static SyntaxStyles instance = SyntaxStyles.createInstance();
    private static final Logger LOG = Logger.getLogger(SyntaxStyles.class.getName());
    private static SyntaxStyle DEFAULT_STYLE = new SyntaxStyle(Color.BLACK, 0);

    public void mergeStyles(Properties styles) {
        for (String token : styles.stringPropertyNames()) {
            String stv = styles.getProperty(token);
            try {
                TokenType tt = TokenType.valueOf(token);
                SyntaxStyle tokenStyle = new SyntaxStyle(stv);
                this.put(tt, tokenStyle);
            }
            catch (IllegalArgumentException ex) {
                LOG.warning("illegal token type or style for: " + token);
            }
        }
    }

    private SyntaxStyles() {
    }

    private static SyntaxStyles createInstance() {
        SyntaxStyles syntaxstyles = new SyntaxStyles();
        Properties styles = JarServiceProvider.readProperties(SyntaxStyles.class);
        syntaxstyles.mergeStyles(styles);
        return syntaxstyles;
    }

    public static SyntaxStyles getInstance() {
        return instance;
    }

    public void put(TokenType type, SyntaxStyle style) {
        if (this.styles == null) {
            this.styles = new HashMap<TokenType, SyntaxStyle>();
        }
        this.styles.put(type, style);
    }

    @Deprecated
    public void setGraphicsStyle(Graphics g, TokenType type) {
        Font c = g.getFont();
        SyntaxStyle ss = this.styles.get((Object)type);
        if (ss != null) {
            g.setFont(g.getFont().deriveFont(ss.getFontStyle()));
            g.setColor(ss.getColor());
        } else {
            g.setFont(g.getFont().deriveFont(0));
            g.setColor(Color.BLACK);
        }
    }

    public SyntaxStyle getStyle(TokenType type) {
        if (this.styles.containsKey((Object)type)) {
            return this.styles.get((Object)type);
        }
        return DEFAULT_STYLE;
    }

    public int drawText(Segment segment, int x, int y, Graphics graphics, TabExpander e, Token token) {
        SyntaxStyle s = this.getStyle(token.type);
        return s.drawText(segment, x, y, graphics, e, token.start);
    }
}

