/*
 * path.c  --- path string functions
 *
 */
/*
 * Copyright (C) 1996-1999  Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This file is part of the VFlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __VFLIB_PATH_H__
#define __VFLIB_PATH_H__

extern char  *vf_path_core_subst_ext(char *f, char *ext);
extern char  *vf_path_base(char *f);
extern char  *vf_path_base_core(char *f);
extern int    vf_path_absolute(char *f);
extern int    vf_path_file_read_ok(char *f);
extern int    vf_path_directory_read_ok(char *f);
extern int    vf_path_terminated_by_delim(char *f);
extern int    vf_path_terminated_by_2delims(char *f);
extern void   vf_path_del_terminating_2delims(char *f);
extern int    vf_path_cons_path(char *path, int n, char *dir, char *file);
extern int    vf_path_cons_path2(char *path, int n, 
				 char *dir, char *file, char *ext);
extern int    vf_path_concat(char *path, int n, char *f);
extern char  *vf_path_runtime_dir(char *subdir, char *envname);
extern char  *vf_path_find_runtime_file(char *subdir, char *file,
					char *envname);

#endif /*__VFLIB_PATH_H__*/
