/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#include "ukccplugin.h"

#include <ukcc/widgets/switchbutton.h>

UkccPlugin::UkccPlugin() : mFirstLoad(true)
{
    QTranslator *translator = new QTranslator(this);
    translator->load(QLocale(), "ukccpanel", "_", UKCCPANEL_TRANSLATION_DIR);
    QApplication::installTranslator(translator);

    pluginName = tr("Panel");
    pluginType = SYSTEM;
}

UkccPlugin::~UkccPlugin()
{

}

QString UkccPlugin::plugini18nName()
{
    return pluginName;
}

int UkccPlugin::pluginTypes()
{
    return PERSONALIZED;
}

QWidget *UkccPlugin::pluginUi()
{
    // 需要加上这个判断标志位，否则每次点击都会新建一个QWidget(只加载一次)
    if (mFirstLoad) {
        widget = new QWidget;
        mFirstLoad = false;
        initUI();
    }
    return widget;
}

bool UkccPlugin::isEnable() const
{
    return true;
}

const QString UkccPlugin::name() const
{
    return QStringLiteral("ukccpanel");
}

bool UkccPlugin::isShowOnHomePage() const
{
    //任务栏不需要显示在控制面板首页上
    return false;
}

QIcon UkccPlugin::icon() const
{
    return QIcon("/usr/share/ukui-panel/panel/img/ukui-panel-symbolic.svg");
}

QString UkccPlugin::translationPath() const
{
    return "/usr/share/ukui-panel/plugin-ukccpanel/translation/ukccpanel_%1.ts";
}

void UkccPlugin::initSearchText()
{
    //~ contents_path /ukccpanel/Panel
    tr("Panel");
    //~ contents_path /ukccpanel/Always show  icon in panel
    tr("Always show  icon in panel");
}

void UkccPlugin::initUI()
{
    // 整体布局
    mverticalLayout = new QVBoxLayout(widget);
    mverticalLayout->setSpacing(8);
    mverticalLayout->setContentsMargins(0, 0, 0, 0);

    generalSettings();
    displayBtnOnPanel();

    mverticalLayout->addStretch();

}

void UkccPlugin::setFrame_Noframe(QFrame *frame)
{
    frame->setMinimumSize(QSize(550, 60));
    frame->setMaximumSize(QSize(16777215, 60));
    frame->setFrameShape(QFrame::NoFrame);
}


void UkccPlugin::generalSettings()
{

    CustomTitleLabel = new TitleLabel(widget);
    CustomTitleLabel->setText(tr("Panel"));
    mverticalLayout->addWidget(CustomTitleLabel);

    m_generalSettingsFrame = new GeneralSettings(widget);
    mverticalLayout->addWidget(m_generalSettingsFrame);

    QSpacerItem *spaceitem = new QSpacerItem(40, 40, QSizePolicy::Fixed);
    mverticalLayout->addSpacerItem(spaceitem);
}


void UkccPlugin::displayBtnOnPanel()
{
    m_panelDisplayLabel = new TitleLabel(widget);
    m_panelDisplayLabel->setText(tr("Always show  icon in panel"));
    mverticalLayout->addWidget(m_panelDisplayLabel);

    m_alwaysDisplayonPanelFrame = new AlwaysDisplayonPanel(widget);
    mverticalLayout->addWidget(m_alwaysDisplayonPanelFrame);
}

QFrame *UkccPlugin::setLine(QFrame *frame)
{
    QFrame *line = new QFrame(frame);
    line->setMinimumSize(QSize(0, 1));
    line->setMaximumSize(QSize(16777215, 1));
    line->setLineWidth(0);
    line->setFrameShape(QFrame::HLine);
    line->setFrameShadow(QFrame::Sunken);
    return line;
}


