// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_PWRCAL_UHD_USRP_CAL_H_
#define FLATBUFFERS_GENERATED_PWRCAL_UHD_USRP_CAL_H_

#include "flatbuffers/flatbuffers.h"

#include "cal_metadata_generated.h"

namespace uhd {
namespace usrp {
namespace cal {

struct PowerMap;

struct FreqPowerMap;
struct FreqPowerMapBuilder;

struct TempFreqMap;
struct TempFreqMapBuilder;

struct PowerCal;
struct PowerCalBuilder;

FLATBUFFERS_MANUALLY_ALIGNED_STRUCT(8) PowerMap FLATBUFFERS_FINAL_CLASS {
 private:
  double gain_;
  double power_dbm_;

 public:
  PowerMap()
      : gain_(0),
        power_dbm_(0) {
  }
  PowerMap(double _gain, double _power_dbm)
      : gain_(flatbuffers::EndianScalar(_gain)),
        power_dbm_(flatbuffers::EndianScalar(_power_dbm)) {
  }
  double gain() const {
    return flatbuffers::EndianScalar(gain_);
  }
  bool KeyCompareLessThan(const PowerMap *o) const {
    return gain() < o->gain();
  }
  int KeyCompareWithValue(double val) const {
    return static_cast<int>(gain() > val) - static_cast<int>(gain() < val);
  }
  double power_dbm() const {
    return flatbuffers::EndianScalar(power_dbm_);
  }
};
FLATBUFFERS_STRUCT_END(PowerMap, 16);

struct FreqPowerMap FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef FreqPowerMapBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_FREQ = 4,
    VT_POWERS = 6,
    VT_MIN_POWER = 8,
    VT_MAX_POWER = 10
  };
  uint64_t freq() const {
    return GetField<uint64_t>(VT_FREQ, 0);
  }
  bool KeyCompareLessThan(const FreqPowerMap *o) const {
    return freq() < o->freq();
  }
  int KeyCompareWithValue(uint64_t val) const {
    return static_cast<int>(freq() > val) - static_cast<int>(freq() < val);
  }
  const flatbuffers::Vector<const uhd::usrp::cal::PowerMap *> *powers() const {
    return GetPointer<const flatbuffers::Vector<const uhd::usrp::cal::PowerMap *> *>(VT_POWERS);
  }
  double min_power() const {
    return GetField<double>(VT_MIN_POWER, 0.0);
  }
  double max_power() const {
    return GetField<double>(VT_MAX_POWER, 0.0);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint64_t>(verifier, VT_FREQ) &&
           VerifyOffset(verifier, VT_POWERS) &&
           verifier.VerifyVector(powers()) &&
           VerifyField<double>(verifier, VT_MIN_POWER) &&
           VerifyField<double>(verifier, VT_MAX_POWER) &&
           verifier.EndTable();
  }
};

struct FreqPowerMapBuilder {
  typedef FreqPowerMap Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_freq(uint64_t freq) {
    fbb_.AddElement<uint64_t>(FreqPowerMap::VT_FREQ, freq, 0);
  }
  void add_powers(flatbuffers::Offset<flatbuffers::Vector<const uhd::usrp::cal::PowerMap *>> powers) {
    fbb_.AddOffset(FreqPowerMap::VT_POWERS, powers);
  }
  void add_min_power(double min_power) {
    fbb_.AddElement<double>(FreqPowerMap::VT_MIN_POWER, min_power, 0.0);
  }
  void add_max_power(double max_power) {
    fbb_.AddElement<double>(FreqPowerMap::VT_MAX_POWER, max_power, 0.0);
  }
  explicit FreqPowerMapBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<FreqPowerMap> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<FreqPowerMap>(end);
    return o;
  }
};

inline flatbuffers::Offset<FreqPowerMap> CreateFreqPowerMap(
    flatbuffers::FlatBufferBuilder &_fbb,
    uint64_t freq = 0,
    flatbuffers::Offset<flatbuffers::Vector<const uhd::usrp::cal::PowerMap *>> powers = 0,
    double min_power = 0.0,
    double max_power = 0.0) {
  FreqPowerMapBuilder builder_(_fbb);
  builder_.add_max_power(max_power);
  builder_.add_min_power(min_power);
  builder_.add_freq(freq);
  builder_.add_powers(powers);
  return builder_.Finish();
}

inline flatbuffers::Offset<FreqPowerMap> CreateFreqPowerMapDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    uint64_t freq = 0,
    std::vector<uhd::usrp::cal::PowerMap> *powers = nullptr,
    double min_power = 0.0,
    double max_power = 0.0) {
  auto powers__ = powers ? _fbb.CreateVectorOfSortedStructs<uhd::usrp::cal::PowerMap>(powers) : 0;
  return uhd::usrp::cal::CreateFreqPowerMap(
      _fbb,
      freq,
      powers__,
      min_power,
      max_power);
}

struct TempFreqMap FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef TempFreqMapBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_TEMPERATURE = 4,
    VT_FREQS = 6
  };
  int32_t temperature() const {
    return GetField<int32_t>(VT_TEMPERATURE, 0);
  }
  bool KeyCompareLessThan(const TempFreqMap *o) const {
    return temperature() < o->temperature();
  }
  int KeyCompareWithValue(int32_t val) const {
    return static_cast<int>(temperature() > val) - static_cast<int>(temperature() < val);
  }
  const flatbuffers::Vector<flatbuffers::Offset<uhd::usrp::cal::FreqPowerMap>> *freqs() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<uhd::usrp::cal::FreqPowerMap>> *>(VT_FREQS);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_TEMPERATURE) &&
           VerifyOffset(verifier, VT_FREQS) &&
           verifier.VerifyVector(freqs()) &&
           verifier.VerifyVectorOfTables(freqs()) &&
           verifier.EndTable();
  }
};

struct TempFreqMapBuilder {
  typedef TempFreqMap Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_temperature(int32_t temperature) {
    fbb_.AddElement<int32_t>(TempFreqMap::VT_TEMPERATURE, temperature, 0);
  }
  void add_freqs(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<uhd::usrp::cal::FreqPowerMap>>> freqs) {
    fbb_.AddOffset(TempFreqMap::VT_FREQS, freqs);
  }
  explicit TempFreqMapBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<TempFreqMap> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<TempFreqMap>(end);
    return o;
  }
};

inline flatbuffers::Offset<TempFreqMap> CreateTempFreqMap(
    flatbuffers::FlatBufferBuilder &_fbb,
    int32_t temperature = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<uhd::usrp::cal::FreqPowerMap>>> freqs = 0) {
  TempFreqMapBuilder builder_(_fbb);
  builder_.add_freqs(freqs);
  builder_.add_temperature(temperature);
  return builder_.Finish();
}

inline flatbuffers::Offset<TempFreqMap> CreateTempFreqMapDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    int32_t temperature = 0,
    std::vector<flatbuffers::Offset<uhd::usrp::cal::FreqPowerMap>> *freqs = nullptr) {
  auto freqs__ = freqs ? _fbb.CreateVectorOfSortedTables<uhd::usrp::cal::FreqPowerMap>(freqs) : 0;
  return uhd::usrp::cal::CreateTempFreqMap(
      _fbb,
      temperature,
      freqs__);
}

struct PowerCal FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef PowerCalBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_METADATA = 4,
    VT_TEMP_FREQ_MAP = 6,
    VT_REF_GAIN = 8
  };
  const Metadata *metadata() const {
    return GetPointer<const Metadata *>(VT_METADATA);
  }
  const flatbuffers::Vector<flatbuffers::Offset<uhd::usrp::cal::TempFreqMap>> *temp_freq_map() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<uhd::usrp::cal::TempFreqMap>> *>(VT_TEMP_FREQ_MAP);
  }
  int32_t ref_gain() const {
    return GetField<int32_t>(VT_REF_GAIN, -1);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_METADATA) &&
           verifier.VerifyTable(metadata()) &&
           VerifyOffset(verifier, VT_TEMP_FREQ_MAP) &&
           verifier.VerifyVector(temp_freq_map()) &&
           verifier.VerifyVectorOfTables(temp_freq_map()) &&
           VerifyField<int32_t>(verifier, VT_REF_GAIN) &&
           verifier.EndTable();
  }
};

struct PowerCalBuilder {
  typedef PowerCal Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_metadata(flatbuffers::Offset<Metadata> metadata) {
    fbb_.AddOffset(PowerCal::VT_METADATA, metadata);
  }
  void add_temp_freq_map(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<uhd::usrp::cal::TempFreqMap>>> temp_freq_map) {
    fbb_.AddOffset(PowerCal::VT_TEMP_FREQ_MAP, temp_freq_map);
  }
  void add_ref_gain(int32_t ref_gain) {
    fbb_.AddElement<int32_t>(PowerCal::VT_REF_GAIN, ref_gain, -1);
  }
  explicit PowerCalBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<PowerCal> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<PowerCal>(end);
    return o;
  }
};

inline flatbuffers::Offset<PowerCal> CreatePowerCal(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<Metadata> metadata = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<uhd::usrp::cal::TempFreqMap>>> temp_freq_map = 0,
    int32_t ref_gain = -1) {
  PowerCalBuilder builder_(_fbb);
  builder_.add_ref_gain(ref_gain);
  builder_.add_temp_freq_map(temp_freq_map);
  builder_.add_metadata(metadata);
  return builder_.Finish();
}

inline flatbuffers::Offset<PowerCal> CreatePowerCalDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<Metadata> metadata = 0,
    std::vector<flatbuffers::Offset<uhd::usrp::cal::TempFreqMap>> *temp_freq_map = nullptr,
    int32_t ref_gain = -1) {
  auto temp_freq_map__ = temp_freq_map ? _fbb.CreateVectorOfSortedTables<uhd::usrp::cal::TempFreqMap>(temp_freq_map) : 0;
  return uhd::usrp::cal::CreatePowerCal(
      _fbb,
      metadata,
      temp_freq_map__,
      ref_gain);
}

inline const uhd::usrp::cal::PowerCal *GetPowerCal(const void *buf) {
  return flatbuffers::GetRoot<uhd::usrp::cal::PowerCal>(buf);
}

inline const uhd::usrp::cal::PowerCal *GetSizePrefixedPowerCal(const void *buf) {
  return flatbuffers::GetSizePrefixedRoot<uhd::usrp::cal::PowerCal>(buf);
}

inline const char *PowerCalIdentifier() {
  return "dB/m";
}

inline bool PowerCalBufferHasIdentifier(const void *buf) {
  return flatbuffers::BufferHasIdentifier(
      buf, PowerCalIdentifier());
}

inline bool VerifyPowerCalBuffer(
    flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<uhd::usrp::cal::PowerCal>(PowerCalIdentifier());
}

inline bool VerifySizePrefixedPowerCalBuffer(
    flatbuffers::Verifier &verifier) {
  return verifier.VerifySizePrefixedBuffer<uhd::usrp::cal::PowerCal>(PowerCalIdentifier());
}

inline const char *PowerCalExtension() {
  return "cal";
}

inline void FinishPowerCalBuffer(
    flatbuffers::FlatBufferBuilder &fbb,
    flatbuffers::Offset<uhd::usrp::cal::PowerCal> root) {
  fbb.Finish(root, PowerCalIdentifier());
}

inline void FinishSizePrefixedPowerCalBuffer(
    flatbuffers::FlatBufferBuilder &fbb,
    flatbuffers::Offset<uhd::usrp::cal::PowerCal> root) {
  fbb.FinishSizePrefixed(root, PowerCalIdentifier());
}

}  // namespace cal
}  // namespace usrp
}  // namespace uhd

#endif  // FLATBUFFERS_GENERATED_PWRCAL_UHD_USRP_CAL_H_
