#
# Copyright 2023 Ettus Research, a National Instruments Company
#
# SPDX-License-Identifier: GPL-3.0-or-later
#
"""
X4xx Clock parameter lookup tables
These lookup tables are pre-calculated and fixed for the hardware X440 uses.
"""
# The shape of this lookup table is
# Converter_Rate: (PLL_Fin1, PLL_Fin2, ...)
RFDC_PLL_CONFIGS = {
    # pylint: disable=line-too-long
    1000000000.0: (500000000.0, 200000000.0, 125000000.0, 250000000.0),
    1024000000.0: (204800000.0, 512000000.0, 128000000.0, 256000000.0),
    1064960000.0: (532480000.0, 266240000.0, 106496000.0, 133120000.0, 212992000.0),
    1105920000.0: (122880000.0, 368640000.0, 184320000.0),
    1152000000.0: (384000000.0, 192000000.0, 128000000.0),
    1198080000.0: (399360000.0, 199680000.0, 133120000.0),
    1200000000.0: (600000000.0, 300000000.0, 120000000.0, 150000000.0, 200000000.0, 400000000.0),
    1228800000.0: (409600000.0, 307200000.0, 153600000.0, 204800000.0, 245760000.0, 122880000.0),
    1250000000.0: (312500000.0, 156250000.0, 125000000.0, 250000000.0),
    1280000000.0: (256000000.0, 128000000.0, 320000000.0, 160000000.0),
    1310720000.0: (163840000.0, 327680000.0),
    1331200000.0: (266240000.0, 133120000.0),
    1440000000.0: (120000000.0, 160000000.0),
    1474560000.0: (491520000.0, 245760000.0, 368640000.0, 122880000.0, 163840000.0, 294912000.0, 184320000.0, 147456000.0),
    1500000000.0: (500000000.0, 300000000.0, 125000000.0, 250000000.0, 375000000.0, 187500000.0, 150000000.0),
    1536000000.0: (307200000.0, 153600000.0, 256000000.0, 384000000.0, 512000000.0, 192000000.0, 128000000.0),
    1597440000.0: (122880000.0, 532480000.0, 266240000.0, 319488000.0, 399360000.0, 199680000.0, 159744000.0, 133120000.0, 106496000.0),
    1600000000.0: (200000000.0, 400000000.0, 320000000.0, 160000000.0),
    1638400000.0: (409600000.0, 204800000.0, 163840000.0, 327680000.0),
    1680000000.0: (120000000.0,),
    1720320000.0: (245760000.0, 122880000.0),
    1750000000.0: (250000000.0, 125000000.0),
    1792000000.0: (256000000.0, 128000000.0),
    1800000000.0: (600000000.0, 300000000.0, 120000000.0, 150000000.0, 200000000.0),
    1843200000.0: (307200000.0, 204800000.0, 368640000.0, 122880000.0, 153600000.0, 184320000.0),
    1863680000.0: (266240000.0, 133120000.0),
    1920000000.0: (384000000.0, 192000000.0, 320000000.0, 120000000.0, 128000000.0, 160000000.0),
    1966080000.0: (491520000.0, 245760000.0, 122880000.0, 163840000.0, 327680000.0, 196608000.0),
    1996800000.0: (153600000.0, 399360000.0, 133120000.0, 199680000.0),
    2000000000.0: (500000000.0, 200000000.0, 125000000.0, 250000000.0, 400000000.0),
    2048000000.0: (409600000.0, 204800000.0, 256000000.0, 128000000.0, 512000000.0),
    2100000000.0: (300000000.0, 150000000.0),
    2129920000.0: (163840000.0, 532480000.0, 212992000.0, 133120000.0, 266240000.0, 106496000.0),
    2150400000.0: (307200000.0, 153600000.0),
    2160000000.0: (120000000.0,),
    2211840000.0: (245760000.0, 122880000.0, 147456000.0, 368640000.0, 184320000.0),
    2240000000.0: (320000000.0, 160000000.0),
    2250000000.0: (250000000.0, 187500000.0, 125000000.0, 150000000.0, 375000000.0),
    2293760000.0: (163840000.0, 327680000.0),
    2304000000.0: (153600000.0, 384000000.0, 192000000.0, 128000000.0, 256000000.0),
    2396160000.0: (184320000.0, 399360000.0, 159744000.0, 199680000.0, 266240000.0, 133120000.0),
    2400000000.0: (600000000.0, 300000000.0, 120000000.0, 150000000.0, 200000000.0, 400000000.0, 160000000.0),
    2457600000.0: (491520000.0, 409600000.0, 245760000.0, 204800000.0, 307200000.0, 163840000.0, 153600000.0, 122880000.0),
    2500000000.0: (500000000.0, 312500000.0, 250000000.0, 125000000.0, 156250000.0),
    2560000000.0: (512000000.0, 256000000.0, 320000000.0, 160000000.0, 128000000.0),
    2580480000.0: (122880000.0, 368640000.0, 184320000.0),
    2621440000.0: (163840000.0, 327680000.0),
    2662400000.0: (204800000.0, 532480000.0, 106496000.0, 133120000.0, 266240000.0),
    2688000000.0: (384000000.0, 192000000.0, 128000000.0),
    2700000000.0: (300000000.0, 150000000.0),
    2764800000.0: (307200000.0, 153600000.0, 184320000.0),
    2795520000.0: (399360000.0, 199680000.0, 133120000.0),
    2800000000.0: (200000000.0, 400000000.0),
    2867200000.0: (409600000.0, 204800000.0),
    2880000000.0: (192000000.0, 120000000.0, 320000000.0, 160000000.0),
    2949120000.0: (491520000.0, 245760000.0, 122880000.0, 163840000.0, 589824000.0, 368640000.0, 327680000.0, 294912000.0, 196608000.0, 184320000.0, 147456000.0, 117964800.0),
    3000000000.0: (500000000.0, 600000000.0, 125000000.0, 250000000.0, 375000000.0, 300000000.0, 200000000.0, 187500000.0, 150000000.0, 120000000.0),
    3072000000.0: (307200000.0, 204800000.0, 512000000.0, 122880000.0, 153600000.0, 384000000.0, 256000000.0, 192000000.0, 128000000.0),
    3194880000.0: (245760000.0, 122880000.0, 399360000.0, 319488000.0, 532480000.0, 266240000.0, 212992000.0, 199680000.0, 159744000.0, 133120000.0, 127795200.0, 106496000.0),
    3200000000.0: (128000000.0, 200000000.0, 320000000.0, 160000000.0, 400000000.0),
    3250000000.0: (250000000.0, 125000000.0),
    3276800000.0: (409600000.0, 204800000.0, 163840000.0, 327680000.0),
    3300000000.0: (300000000.0, 150000000.0),
    3317760000.0: (122880000.0, 368640000.0, 184320000.0),
    3328000000.0: (256000000.0, 128000000.0, 133120000.0),
    3360000000.0: (120000000.0, 160000000.0),
    3379200000.0: (307200000.0, 153600000.0),
    3440640000.0: (491520000.0, 245760000.0, 122880000.0, 163840000.0),
    3456000000.0: (384000000.0, 192000000.0, 128000000.0),
    3461120000.0: (266240000.0, 133120000.0),
    3500000000.0: (500000000.0, 125000000.0, 250000000.0),
    3520000000.0: (320000000.0, 160000000.0),
    3584000000.0: (512000000.0, 256000000.0, 128000000.0),
    3594240000.0: (399360000.0, 199680000.0, 133120000.0),
    3600000000.0: (600000000.0, 300000000.0, 120000000.0, 150000000.0, 200000000.0, 400000000.0),
    3604480000.0: (163840000.0, 327680000.0),
    3686400000.0: (409600000.0, 307200000.0, 153600000.0, 204800000.0, 245760000.0, 122880000.0, 368640000.0, 184320000.0, 147456000.0),
    3727360000.0: (532480000.0, 266240000.0, 106496000.0, 133120000.0),
    3750000000.0: (312500000.0, 125000000.0, 250000000.0, 375000000.0, 187500000.0, 150000000.0, 156250000.0),
    3840000000.0: (153600000.0, 384000000.0, 192000000.0, 128000000.0, 256000000.0, 120000000.0, 320000000.0, 160000000.0),
    3900000000.0: (300000000.0, 150000000.0),
    3932160000.0: (491520000.0, 245760000.0, 122880000.0, 163840000.0, 327680000.0, 196608000.0),
    3993600000.0: (307200000.0, 153600000.0, 199680000.0, 266240000.0, 399360000.0, 159744000.0, 133120000.0),
    4000000000.0: (500000000.0, 200000000.0, 125000000.0, 250000000.0, 400000000.0, 160000000.0),
    4055040000.0: (122880000.0, 368640000.0, 184320000.0),
    4096000000.0: (409600000.0, 204800000.0, 256000000.0, 512000000.0, 163840000.0, 128000000.0)
    # pylint: enable=line-too-long
}

# Lists the LMK VCOs rates to be used per Master Clock Rate
# Format: {MCR: LMK-VCO rate}
MCR_LMK_VCO = {
    125000000.0: [3000000000.0,],
    128000000.0: [3072000000.0,],
    133120000.0: [3194880000.0,],
    150000000.0: [3000000000.0,],
    153600000.0: [2457600000.0,],
    160000000.0: [3200000000.0,],
    163840000.0: [2949120000.0,2457600000.0],
    184320000.0: [2949120000.0,],
    199680000.0: [3194880000.0,],
    200000000.0: [3200000000.0,],
    204800000.0: [3072000000.0,2457600000.0],
    240000000.0: [3000000000.0,],
    245760000.0: [3194880000.0,3072000000.0,2949120000.0,2457600000.0],
    250000000.0: [3000000000.0,2500000000.0],
    256000000.0: [3200000000.0,3200000000.0],
    266240000.0: [3194880000.0,],
    300000000.0: [3000000000.0,],
    307200000.0: [2457600000.0,],
    320000000.0: [3200000000.0,],
    327680000.0: [2949120000.0,2457600000.0],
    360000000.0: [3000000000.0,],
    368640000.0: [2949120000.0,],
    375000000.0: [3000000000.0,],
    384000000.0: [3072000000.0,],
    399360000.0: [3194880000.0,],
    400000000.0: [3200000000.0,],
    409600000.0: [3072000000.0,2457600000.0],
    450000000.0: [3000000000.0,],
    460800000.0: [3072000000.0,2457600000.0],
    480000000.0: [3000000000.0,3000000000.0],
    491520000.0: [3194880000.0,3072000000.0,2949120000.0,2457600000.0],
    500000000.0: [3000000000.0,2500000000.0],
    512000000.0: [3072000000.0,3200000000.0],
    532480000.0: [3194880000.0,],
    552960000.0: [2949120000.0,],
    599040000.0: [3194880000.0,],
    600000000.0: [3000000000.0,3000000000.0],
    614400000.0: [2457600000.0,],
    625000000.0: [2500000000.0,],
    640000000.0: [3200000000.0,3072000000.0],
    655360000.0: [2949120000.0,2457600000.0],
    665600000.0: [3194880000.0,],
    720000000.0: [3000000000.0,],
    737280000.0: [2949120000.0,],
    750000000.0: [3000000000.0,],
    768000000.0: [3072000000.0,],
    798720000.0: [3194880000.0,],
    800000000.0: [3200000000.0,],
    819200000.0: [3072000000.0,2949120000.0,2457600000.0],
    840000000.0: [3000000000.0,],
    860160000.0: [3194880000.0,3072000000.0,2949120000.0,2457600000.0],
    875000000.0: [3000000000.0,2500000000.0],
    896000000.0: [3200000000.0,3072000000.0],
    900000000.0: [3000000000.0,],
    921600000.0: [3072000000.0,2949120000.0,2457600000.0],
    931840000.0: [3194880000.0,],
    960000000.0: [3000000000.0,3200000000.0],
    983040000.0: [3194880000.0,3072000000.0,2949120000.0,2457600000.0],
    998400000.0: [3194880000.0,],
    1000000000.0: [3000000000.0,3200000000.0,2500000000.0],
    1024000000.0: [3200000000.0,3072000000.0,2457600000.0],
    1050000000.0: [3000000000.0,],
    1064960000.0: [3194880000.0,],
    1075200000.0: [3072000000.0,2457600000.0],
    1080000000.0: [3000000000.0,],
    1105920000.0: [2949120000.0,3194880000.0,3072000000.0,2457600000.0],
    1120000000.0: [3200000000.0,],
    1125000000.0: [3000000000.0,2500000000.0],
    1146880000.0: [2949120000.0,2457600000.0],
    1152000000.0: [3072000000.0,3200000000.0],
    1198080000.0: [3194880000.0,],
    1200000000.0: [3200000000.0,3000000000.0],
    1228800000.0: [2457600000.0,],
    1280000000.0: [3200000000.0,3072000000.0],
    1290240000.0: [2949120000.0,],
    1310720000.0: [2949120000.0,2457600000.0],
    1331200000.0: [3194880000.0,],
    1350000000.0: [3000000000.0,],
    1382400000.0: [3072000000.0,2457600000.0],
    1397760000.0: [3194880000.0,],
    1400000000.0: [3200000000.0,3000000000.0],
    1433600000.0: [3072000000.0,2457600000.0],
    1440000000.0: [3000000000.0,3200000000.0],
    1474560000.0: [2949120000.0,],
    1500000000.0: [3000000000.0,],
    1536000000.0: [3072000000.0,],
    1600000000.0: [3200000000.0,],
    1625000000.0: [3000000000.0,2500000000.0],
    1638400000.0: [3072000000.0,2949120000.0,2457600000.0],
    1650000000.0: [3000000000.0,],
    1658880000.0: [2949120000.0,],
    1664000000.0: [3200000000.0,3072000000.0],
    1680000000.0: [3000000000.0,],
    1689600000.0: [3072000000.0,2457600000.0],
    1720320000.0: [3194880000.0,3072000000.0,2949120000.0,2457600000.0],
    1730560000.0: [3194880000.0,],
    1750000000.0: [3000000000.0,2500000000.0],
    1760000000.0: [3200000000.0,],
    1792000000.0: [3200000000.0,3072000000.0],
    1797120000.0: [3194880000.0,],
    1800000000.0: [3000000000.0,3200000000.0],
    1802240000.0: [2949120000.0,2457600000.0],
    1843200000.0: [2949120000.0,3194880000.0,3072000000.0,2457600000.0],
    1863680000.0: [3194880000.0,],
    1875000000.0: [3000000000.0,2500000000.0],
    1920000000.0: [3000000000.0,3200000000.0,3072000000.0],
    1950000000.0: [3000000000.0,],
    1966080000.0: [3194880000.0,3072000000.0,2949120000.0,2457600000.0],
    1996800000.0: [3194880000.0,3072000000.0,2457600000.0],
    2000000000.0: [3000000000.0,3200000000.0,2500000000.0],
    2027520000.0: [2949120000.0,],
    2048000000.0: [3200000000.0,3072000000.0,2457600000.0]
 }

MMCM_LOCKGROUP_LOOKUP = ( \
    # This table is composed of:
    # LockRefDly_LockFBDly_LockCnt_LockSatHigh_UnlockCnt
    0b00110_00110_1111101000_1111101001_0000000001,      # M=1 (not allowed)
    0b00110_00110_1111101000_1111101001_0000000001,      # M=2
    0b01000_01000_1111101000_1111101001_0000000001,      # M=3
    0b01011_01011_1111101000_1111101001_0000000001,      # M=4
    0b01110_01110_1111101000_1111101001_0000000001,      # M=5
    0b10001_10001_1111101000_1111101001_0000000001,      # M=6
    0b10011_10011_1111101000_1111101001_0000000001,      # M=7
    0b10110_10110_1111101000_1111101001_0000000001,      # M=8
    0b11001_11001_1111101000_1111101001_0000000001,      # M=9
    0b11100_11100_1111101000_1111101001_0000000001,      # M=10
    0b11111_11111_1110000100_1111101001_0000000001,      # M=11
    0b11111_11111_1100111001_1111101001_0000000001,      # M=12
    0b11111_11111_1011101110_1111101001_0000000001,      # M=13
    0b11111_11111_1010111100_1111101001_0000000001,
    0b11111_11111_1010001010_1111101001_0000000001,
    0b11111_11111_1001110001_1111101001_0000000001,
    0b11111_11111_1000111111_1111101001_0000000001,
    0b11111_11111_1000100110_1111101001_0000000001,
    0b11111_11111_1000001101_1111101001_0000000001,
    0b11111_11111_0111110100_1111101001_0000000001,
    0b11111_11111_0111011011_1111101001_0000000001,
    0b11111_11111_0111000010_1111101001_0000000001,
    0b11111_11111_0110101001_1111101001_0000000001,
    0b11111_11111_0110010000_1111101001_0000000001,
    0b11111_11111_0110010000_1111101001_0000000001,
    0b11111_11111_0101110111_1111101001_0000000001,
    0b11111_11111_0101011110_1111101001_0000000001,
    0b11111_11111_0101011110_1111101001_0000000001,
    0b11111_11111_0101000101_1111101001_0000000001,
    0b11111_11111_0101000101_1111101001_0000000001,
    0b11111_11111_0100101100_1111101001_0000000001,
    0b11111_11111_0100101100_1111101001_0000000001,
    0b11111_11111_0100101100_1111101001_0000000001,
    0b11111_11111_0100010011_1111101001_0000000001,
    0b11111_11111_0100010011_1111101001_0000000001,
    0b11111_11111_0100010011_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,
    0b11111_11111_0011111010_1111101001_0000000001,      # M=127
    0b11111_11111_0011111010_1111101001_0000000001       # M=128
)

MMCM_FILTERGROUP_LOOKUP = ( \
    #This table corresponds to optimized filter mode. 
    #CP_RES_LFHF
    0b0111_1111_11,    # M=1 - not legal
    0b0111_1111_11,    # M=2
    0b1110_1111_11,    # M=3
    0b1111_1111_11,    # M=4
    0b1111_1011_11,    # M=5
    0b1111_1101_11,    # M=6
    0b1111_0011_11,    # M=7
    0b1110_0101_11,    #8
    0b1111_1001_11,    #9
    0b1111_1001_11,    #10
    0b1110_1110_11,    #11
    0b1111_1110_11,    #12
    0b1111_0001_11,    #13
    0b1111_0001_11,
    0b1111_0001_11,
    0b1110_0110_11,
    0b1110_0110_11,
    0b1111_0110_11,
    0b1110_1010_11,
    0b1110_1010_11,
    0b1111_1010_11,
    0b1111_1010_11,
    0b1111_1010_11,
    0b1111_1010_11,
    0b1111_1010_11,
    0b1101_1100_11,
    0b1101_1100_11,
    0b1101_1100_11,
    0b1110_1100_11,
    0b1110_1100_11,
    0b1110_1100_11,
    0b1111_1100_11,
    0b1111_1100_11,
    0b1111_1100_11,
    0b1111_1100_11,
    0b1111_1100_11,
    0b1111_1100_11,
    0b1110_0010_11,
    0b1110_0010_11,
    0b1110_0010_11,
    0b1110_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1111_0010_11,
    0b1100_0100_11,
    0b1100_0100_11,
    0b1100_0100_11,
    0b1100_0100_11,
    0b1100_0100_11,
    0b1100_0100_11,
    0b1100_0100_11,
    0b1100_0100_11,
    0b1101_0100_11,
    0b1101_0100_11,
    0b1101_0100_11,
    0b1101_0100_11,
    0b1101_0100_11,
    0b1101_0100_11,
    0b1101_0100_11,
    0b1110_0100_11,
    0b1110_0100_11,
    0b1110_0100_11,
    0b1110_0100_11,
    0b1110_0100_11,
    0b1110_0100_11,
    0b1110_0100_11,
    0b1110_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1111_0100_11,
    0b1101_1000_11,
    0b1101_1000_11,
    0b1101_1000_11,
    0b1101_1000_11,
    0b1101_1000_11,
    0b1101_1000_11,
    0b1101_1000_11,
    0b1101_1000_11,
    0b1101_1000_11     # M=128
)
