//
// Copyright 2023 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: pl_cpld_base_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // SIGNATURE_REGISTER                  : 0x0 (pl_cpld_regs.v)
  // REVISION_REGISTER                   : 0x4 (pl_cpld_regs.v)
  // OLDEST_COMPATIBLE_REVISION_REGISTER : 0x8 (pl_cpld_regs.v)
  // SCRATCH_REGISTER                    : 0xC (pl_cpld_regs.v)
  // GIT_HASH_REGISTER                   : 0x10 (pl_cpld_regs.v)
  // LED_REGISTER                        : 0x20 (pl_cpld_regs.v)
  // CABLE_PRESENT_REG                   : 0x30 (pl_cpld_regs.v)

//===============================================================================
// RegTypes
//===============================================================================

//===============================================================================
// Register Group MB_CPLD_LED_REGS
//===============================================================================

  // LED_REGISTER Register (from pl_cpld_regs.v)
  localparam LED_REGISTER = 'h20; // Register Offset
  localparam LED_REGISTER_SIZE = 16;  // register width in bits
  localparam LED_REGISTER_MASK = 16'hFFFF;
  localparam QSFP0_LED_LINK_SIZE = 4;  //LED_REGISTER:QSFP0_LED_LINK
  localparam QSFP0_LED_LINK_MSB  = 3;  //LED_REGISTER:QSFP0_LED_LINK
  localparam QSFP0_LED_LINK      = 0;  //LED_REGISTER:QSFP0_LED_LINK
  localparam QSFP0_LED_ACTIVE_SIZE = 4;  //LED_REGISTER:QSFP0_LED_ACTIVE
  localparam QSFP0_LED_ACTIVE_MSB  = 7;  //LED_REGISTER:QSFP0_LED_ACTIVE
  localparam QSFP0_LED_ACTIVE      = 4;  //LED_REGISTER:QSFP0_LED_ACTIVE
  localparam QSFP1_LED_LINK_SIZE =  4;  //LED_REGISTER:QSFP1_LED_LINK
  localparam QSFP1_LED_LINK_MSB  = 11;  //LED_REGISTER:QSFP1_LED_LINK
  localparam QSFP1_LED_LINK      =  8;  //LED_REGISTER:QSFP1_LED_LINK
  localparam QSFP1_LED_ACTIVE_SIZE =  4;  //LED_REGISTER:QSFP1_LED_ACTIVE
  localparam QSFP1_LED_ACTIVE_MSB  = 15;  //LED_REGISTER:QSFP1_LED_ACTIVE
  localparam QSFP1_LED_ACTIVE      = 12;  //LED_REGISTER:QSFP1_LED_ACTIVE

//===============================================================================
// Register Group PL_CMI_REGS
//===============================================================================

  // CABLE_PRESENT_REG Register (from pl_cpld_regs.v)
  localparam CABLE_PRESENT_REG = 'h30; // Register Offset
  localparam CABLE_PRESENT_REG_SIZE = 2;  // register width in bits
  localparam CABLE_PRESENT_REG_MASK = 2'h3;
  localparam IPASS0_CABLE_PRESENT_SIZE = 1;  //CABLE_PRESENT_REG:IPASS0_CABLE_PRESENT
  localparam IPASS0_CABLE_PRESENT_MSB  = 0;  //CABLE_PRESENT_REG:IPASS0_CABLE_PRESENT
  localparam IPASS0_CABLE_PRESENT      = 0;  //CABLE_PRESENT_REG:IPASS0_CABLE_PRESENT
  localparam IPASS1_CABLE_PRESENT_SIZE = 1;  //CABLE_PRESENT_REG:IPASS1_CABLE_PRESENT
  localparam IPASS1_CABLE_PRESENT_MSB  = 1;  //CABLE_PRESENT_REG:IPASS1_CABLE_PRESENT
  localparam IPASS1_CABLE_PRESENT      = 1;  //CABLE_PRESENT_REG:IPASS1_CABLE_PRESENT

//===============================================================================
// Register Group PL_CPLD_BASE_REGS
//===============================================================================

  // SIGNATURE_REGISTER Register (from pl_cpld_regs.v)
  localparam SIGNATURE_REGISTER = 'h0; // Register Offset
  localparam SIGNATURE_REGISTER_SIZE = 32;  // register width in bits
  localparam SIGNATURE_REGISTER_MASK = 32'hFFFFFFFF;
  localparam PRODUCT_SIGNATURE_SIZE = 32;  //SIGNATURE_REGISTER:PRODUCT_SIGNATURE
  localparam PRODUCT_SIGNATURE_MSB  = 31;  //SIGNATURE_REGISTER:PRODUCT_SIGNATURE
  localparam PRODUCT_SIGNATURE      =  0;  //SIGNATURE_REGISTER:PRODUCT_SIGNATURE

  // REVISION_REGISTER Register (from pl_cpld_regs.v)
  localparam REVISION_REGISTER = 'h4; // Register Offset
  localparam REVISION_REGISTER_SIZE = 32;  // register width in bits
  localparam REVISION_REGISTER_MASK = 32'hFFFFFFFF;
  localparam REVISION_HH_SIZE = 8;  //REVISION_REGISTER:REVISION_HH
  localparam REVISION_HH_MSB  = 7;  //REVISION_REGISTER:REVISION_HH
  localparam REVISION_HH      = 0;  //REVISION_REGISTER:REVISION_HH
  localparam REVISION_DD_SIZE =  8;  //REVISION_REGISTER:REVISION_DD
  localparam REVISION_DD_MSB  = 15;  //REVISION_REGISTER:REVISION_DD
  localparam REVISION_DD      =  8;  //REVISION_REGISTER:REVISION_DD
  localparam REVISION_MM_SIZE =  8;  //REVISION_REGISTER:REVISION_MM
  localparam REVISION_MM_MSB  = 23;  //REVISION_REGISTER:REVISION_MM
  localparam REVISION_MM      = 16;  //REVISION_REGISTER:REVISION_MM
  localparam REVISION_YY_SIZE =  8;  //REVISION_REGISTER:REVISION_YY
  localparam REVISION_YY_MSB  = 31;  //REVISION_REGISTER:REVISION_YY
  localparam REVISION_YY      = 24;  //REVISION_REGISTER:REVISION_YY

  // OLDEST_COMPATIBLE_REVISION_REGISTER Register (from pl_cpld_regs.v)
  localparam OLDEST_COMPATIBLE_REVISION_REGISTER = 'h8; // Register Offset
  localparam OLDEST_COMPATIBLE_REVISION_REGISTER_SIZE = 32;  // register width in bits
  localparam OLDEST_COMPATIBLE_REVISION_REGISTER_MASK = 32'hFFFFFFFF;
  localparam OLD_REVISION_HH_SIZE = 8;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_HH
  localparam OLD_REVISION_HH_MSB  = 7;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_HH
  localparam OLD_REVISION_HH      = 0;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_HH
  localparam OLD_REVISION_DD_SIZE =  8;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_DD
  localparam OLD_REVISION_DD_MSB  = 15;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_DD
  localparam OLD_REVISION_DD      =  8;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_DD
  localparam OLD_REVISION_MM_SIZE =  8;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_MM
  localparam OLD_REVISION_MM_MSB  = 23;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_MM
  localparam OLD_REVISION_MM      = 16;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_MM
  localparam OLD_REVISION_YY_SIZE =  8;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_YY
  localparam OLD_REVISION_YY_MSB  = 31;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_YY
  localparam OLD_REVISION_YY      = 24;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_YY

  // SCRATCH_REGISTER Register (from pl_cpld_regs.v)
  localparam SCRATCH_REGISTER = 'hC; // Register Offset
  localparam SCRATCH_REGISTER_SIZE = 32;  // register width in bits
  localparam SCRATCH_REGISTER_MASK = 32'h0;

  // GIT_HASH_REGISTER Register (from pl_cpld_regs.v)
  localparam GIT_HASH_REGISTER = 'h10; // Register Offset
  localparam GIT_HASH_REGISTER_SIZE = 32;  // register width in bits
  localparam GIT_HASH_REGISTER_MASK = 32'hFFFFFFFF;
  localparam GIT_HASH_SIZE = 28;  //GIT_HASH_REGISTER:GIT_HASH
  localparam GIT_HASH_MSB  = 27;  //GIT_HASH_REGISTER:GIT_HASH
  localparam GIT_HASH      =  0;  //GIT_HASH_REGISTER:GIT_HASH
  localparam GIT_CLEAN_SIZE =  4;  //GIT_HASH_REGISTER:GIT_CLEAN
  localparam GIT_CLEAN_MSB  = 31;  //GIT_HASH_REGISTER:GIT_CLEAN
  localparam GIT_CLEAN      = 28;  //GIT_HASH_REGISTER:GIT_CLEAN
