---------------------------------------------------------------------------------------
-- Title          : Wishbone slave core for WR Transmission control, status and debug
---------------------------------------------------------------------------------------
-- File           : wr_streamers_wbgen2_pkg.vhd
-- Author         : auto-generated by wbgen2 from wr_streamers_wb.wb
-- Created        : Wed Aug 16 22:45:12 2017
-- Version        : 0x00000001
-- Standard       : VHDL'87
---------------------------------------------------------------------------------------
-- THIS FILE WAS GENERATED BY wbgen2 FROM SOURCE FILE wr_streamers_wb.wb
-- DO NOT HAND-EDIT UNLESS IT'S ABSOLUTELY NECESSARY!
---------------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

package wr_streamers_wbgen2_pkg is
  
  
  -- Input registers (user design -> WB slave)
  
  type t_wr_streamers_in_registers is record
    sscr1_rx_latency_acc_overflow_i          : std_logic;
    sscr1_rst_ts_cyc_i                       : std_logic_vector(27 downto 0);
    sscr2_rst_ts_tai_lsb_i                   : std_logic_vector(31 downto 0);
    sscr3_rst_ts_tai_msb_i                   : std_logic_vector(7 downto 0);
    rx_stat0_rx_latency_max_i                : std_logic_vector(27 downto 0);
    rx_stat1_rx_latency_min_i                : std_logic_vector(27 downto 0);
    tx_stat2_tx_sent_cnt_lsb_i               : std_logic_vector(31 downto 0);
    tx_stat3_tx_sent_cnt_msb_i               : std_logic_vector(31 downto 0);
    rx_stat4_rx_rcvd_cnt_lsb_i               : std_logic_vector(31 downto 0);
    rx_stat5_rx_rcvd_cnt_msb_i               : std_logic_vector(31 downto 0);
    rx_stat6_rx_loss_cnt_lsb_i               : std_logic_vector(31 downto 0);
    rx_stat7_rx_loss_cnt_msb_i               : std_logic_vector(31 downto 0);
    rx_stat8_rx_lost_block_cnt_lsb_i         : std_logic_vector(31 downto 0);
    rx_stat9_rx_lost_block_cnt_msb_i         : std_logic_vector(31 downto 0);
    rx_stat10_rx_latency_acc_lsb_i           : std_logic_vector(31 downto 0);
    rx_stat11_rx_latency_acc_msb_i           : std_logic_vector(31 downto 0);
    rx_stat12_rx_latency_acc_cnt_lsb_i       : std_logic_vector(31 downto 0);
    rx_stat13_rx_latency_acc_cnt_msb_i       : std_logic_vector(31 downto 0);
    dbg_data_i                               : std_logic_vector(31 downto 0);
    dummy_dummy_i                            : std_logic_vector(31 downto 0);
    end record;
  
  constant c_wr_streamers_in_registers_init_value: t_wr_streamers_in_registers := (
    sscr1_rx_latency_acc_overflow_i => '0',
    sscr1_rst_ts_cyc_i => (others => '0'),
    sscr2_rst_ts_tai_lsb_i => (others => '0'),
    sscr3_rst_ts_tai_msb_i => (others => '0'),
    rx_stat0_rx_latency_max_i => (others => '0'),
    rx_stat1_rx_latency_min_i => (others => '0'),
    tx_stat2_tx_sent_cnt_lsb_i => (others => '0'),
    tx_stat3_tx_sent_cnt_msb_i => (others => '0'),
    rx_stat4_rx_rcvd_cnt_lsb_i => (others => '0'),
    rx_stat5_rx_rcvd_cnt_msb_i => (others => '0'),
    rx_stat6_rx_loss_cnt_lsb_i => (others => '0'),
    rx_stat7_rx_loss_cnt_msb_i => (others => '0'),
    rx_stat8_rx_lost_block_cnt_lsb_i => (others => '0'),
    rx_stat9_rx_lost_block_cnt_msb_i => (others => '0'),
    rx_stat10_rx_latency_acc_lsb_i => (others => '0'),
    rx_stat11_rx_latency_acc_msb_i => (others => '0'),
    rx_stat12_rx_latency_acc_cnt_lsb_i => (others => '0'),
    rx_stat13_rx_latency_acc_cnt_msb_i => (others => '0'),
    dbg_data_i => (others => '0'),
    dummy_dummy_i => (others => '0')
    );
    
    -- Output registers (WB slave -> user design)
    
    type t_wr_streamers_out_registers is record
      ver_id_o                                 : std_logic_vector(31 downto 0);
      sscr1_rst_stats_o                        : std_logic;
      sscr1_rst_seq_id_o                       : std_logic;
      sscr1_snapshot_stats_o                   : std_logic;
      tx_cfg0_ethertype_o                      : std_logic_vector(15 downto 0);
      tx_cfg1_mac_local_lsb_o                  : std_logic_vector(31 downto 0);
      tx_cfg2_mac_local_msb_o                  : std_logic_vector(15 downto 0);
      tx_cfg3_mac_target_lsb_o                 : std_logic_vector(31 downto 0);
      tx_cfg4_mac_target_msb_o                 : std_logic_vector(15 downto 0);
      tx_cfg5_qtag_ena_o                       : std_logic;
      tx_cfg5_qtag_vid_o                       : std_logic_vector(11 downto 0);
      tx_cfg5_qtag_prio_o                      : std_logic_vector(2 downto 0);
      rx_cfg0_ethertype_o                      : std_logic_vector(15 downto 0);
      rx_cfg0_accept_broadcast_o               : std_logic;
      rx_cfg0_filter_remote_o                  : std_logic;
      rx_cfg1_mac_local_lsb_o                  : std_logic_vector(31 downto 0);
      rx_cfg2_mac_local_msb_o                  : std_logic_vector(15 downto 0);
      rx_cfg3_mac_remote_lsb_o                 : std_logic_vector(31 downto 0);
      rx_cfg4_mac_remote_msb_o                 : std_logic_vector(15 downto 0);
      rx_cfg5_fixed_latency_o                  : std_logic_vector(27 downto 0);
      cfg_or_tx_ethtype_o                      : std_logic;
      cfg_or_tx_mac_loc_o                      : std_logic;
      cfg_or_tx_mac_tar_o                      : std_logic;
      cfg_or_tx_qtag_o                         : std_logic;
      cfg_or_rx_ethertype_o                    : std_logic;
      cfg_or_rx_mac_loc_o                      : std_logic;
      cfg_or_rx_mac_rem_o                      : std_logic;
      cfg_or_rx_acc_broadcast_o                : std_logic;
      cfg_or_rx_ftr_remote_o                   : std_logic;
      cfg_or_rx_fix_lat_o                      : std_logic;
      dbg_ctrl_mux_o                           : std_logic;
      dbg_ctrl_start_byte_o                    : std_logic_vector(7 downto 0);
      end record;
    
    constant c_wr_streamers_out_registers_init_value: t_wr_streamers_out_registers := (
      ver_id_o => (others => '0'),
      sscr1_rst_stats_o => '0',
      sscr1_rst_seq_id_o => '0',
      sscr1_snapshot_stats_o => '0',
      tx_cfg0_ethertype_o => (others => '0'),
      tx_cfg1_mac_local_lsb_o => (others => '0'),
      tx_cfg2_mac_local_msb_o => (others => '0'),
      tx_cfg3_mac_target_lsb_o => (others => '0'),
      tx_cfg4_mac_target_msb_o => (others => '0'),
      tx_cfg5_qtag_ena_o => '0',
      tx_cfg5_qtag_vid_o => (others => '0'),
      tx_cfg5_qtag_prio_o => (others => '0'),
      rx_cfg0_ethertype_o => (others => '0'),
      rx_cfg0_accept_broadcast_o => '0',
      rx_cfg0_filter_remote_o => '0',
      rx_cfg1_mac_local_lsb_o => (others => '0'),
      rx_cfg2_mac_local_msb_o => (others => '0'),
      rx_cfg3_mac_remote_lsb_o => (others => '0'),
      rx_cfg4_mac_remote_msb_o => (others => '0'),
      rx_cfg5_fixed_latency_o => (others => '0'),
      cfg_or_tx_ethtype_o => '0',
      cfg_or_tx_mac_loc_o => '0',
      cfg_or_tx_mac_tar_o => '0',
      cfg_or_tx_qtag_o => '0',
      cfg_or_rx_ethertype_o => '0',
      cfg_or_rx_mac_loc_o => '0',
      cfg_or_rx_mac_rem_o => '0',
      cfg_or_rx_acc_broadcast_o => '0',
      cfg_or_rx_ftr_remote_o => '0',
      cfg_or_rx_fix_lat_o => '0',
      dbg_ctrl_mux_o => '0',
      dbg_ctrl_start_byte_o => (others => '0')
      );
    function "or" (left, right: t_wr_streamers_in_registers) return t_wr_streamers_in_registers;
    function f_x_to_zero (x:std_logic) return std_logic;
    function f_x_to_zero (x:std_logic_vector) return std_logic_vector;
end package;

package body wr_streamers_wbgen2_pkg is
function f_x_to_zero (x:std_logic) return std_logic is
begin
if x = '1' then
return '1';
else
return '0';
end if;
end function;
function f_x_to_zero (x:std_logic_vector) return std_logic_vector is
variable tmp: std_logic_vector(x'length-1 downto 0);
begin
for i in 0 to x'length-1 loop
if x(i) = '1' then
tmp(i):= '1';
else
tmp(i):= '0';
end if; 
end loop; 
return tmp;
end function;
function "or" (left, right: t_wr_streamers_in_registers) return t_wr_streamers_in_registers is
variable tmp: t_wr_streamers_in_registers;
begin
tmp.sscr1_rx_latency_acc_overflow_i := f_x_to_zero(left.sscr1_rx_latency_acc_overflow_i) or f_x_to_zero(right.sscr1_rx_latency_acc_overflow_i);
tmp.sscr1_rst_ts_cyc_i := f_x_to_zero(left.sscr1_rst_ts_cyc_i) or f_x_to_zero(right.sscr1_rst_ts_cyc_i);
tmp.sscr2_rst_ts_tai_lsb_i := f_x_to_zero(left.sscr2_rst_ts_tai_lsb_i) or f_x_to_zero(right.sscr2_rst_ts_tai_lsb_i);
tmp.sscr3_rst_ts_tai_msb_i := f_x_to_zero(left.sscr3_rst_ts_tai_msb_i) or f_x_to_zero(right.sscr3_rst_ts_tai_msb_i);
tmp.rx_stat0_rx_latency_max_i := f_x_to_zero(left.rx_stat0_rx_latency_max_i) or f_x_to_zero(right.rx_stat0_rx_latency_max_i);
tmp.rx_stat1_rx_latency_min_i := f_x_to_zero(left.rx_stat1_rx_latency_min_i) or f_x_to_zero(right.rx_stat1_rx_latency_min_i);
tmp.tx_stat2_tx_sent_cnt_lsb_i := f_x_to_zero(left.tx_stat2_tx_sent_cnt_lsb_i) or f_x_to_zero(right.tx_stat2_tx_sent_cnt_lsb_i);
tmp.tx_stat3_tx_sent_cnt_msb_i := f_x_to_zero(left.tx_stat3_tx_sent_cnt_msb_i) or f_x_to_zero(right.tx_stat3_tx_sent_cnt_msb_i);
tmp.rx_stat4_rx_rcvd_cnt_lsb_i := f_x_to_zero(left.rx_stat4_rx_rcvd_cnt_lsb_i) or f_x_to_zero(right.rx_stat4_rx_rcvd_cnt_lsb_i);
tmp.rx_stat5_rx_rcvd_cnt_msb_i := f_x_to_zero(left.rx_stat5_rx_rcvd_cnt_msb_i) or f_x_to_zero(right.rx_stat5_rx_rcvd_cnt_msb_i);
tmp.rx_stat6_rx_loss_cnt_lsb_i := f_x_to_zero(left.rx_stat6_rx_loss_cnt_lsb_i) or f_x_to_zero(right.rx_stat6_rx_loss_cnt_lsb_i);
tmp.rx_stat7_rx_loss_cnt_msb_i := f_x_to_zero(left.rx_stat7_rx_loss_cnt_msb_i) or f_x_to_zero(right.rx_stat7_rx_loss_cnt_msb_i);
tmp.rx_stat8_rx_lost_block_cnt_lsb_i := f_x_to_zero(left.rx_stat8_rx_lost_block_cnt_lsb_i) or f_x_to_zero(right.rx_stat8_rx_lost_block_cnt_lsb_i);
tmp.rx_stat9_rx_lost_block_cnt_msb_i := f_x_to_zero(left.rx_stat9_rx_lost_block_cnt_msb_i) or f_x_to_zero(right.rx_stat9_rx_lost_block_cnt_msb_i);
tmp.rx_stat10_rx_latency_acc_lsb_i := f_x_to_zero(left.rx_stat10_rx_latency_acc_lsb_i) or f_x_to_zero(right.rx_stat10_rx_latency_acc_lsb_i);
tmp.rx_stat11_rx_latency_acc_msb_i := f_x_to_zero(left.rx_stat11_rx_latency_acc_msb_i) or f_x_to_zero(right.rx_stat11_rx_latency_acc_msb_i);
tmp.rx_stat12_rx_latency_acc_cnt_lsb_i := f_x_to_zero(left.rx_stat12_rx_latency_acc_cnt_lsb_i) or f_x_to_zero(right.rx_stat12_rx_latency_acc_cnt_lsb_i);
tmp.rx_stat13_rx_latency_acc_cnt_msb_i := f_x_to_zero(left.rx_stat13_rx_latency_acc_cnt_msb_i) or f_x_to_zero(right.rx_stat13_rx_latency_acc_cnt_msb_i);
tmp.dbg_data_i := f_x_to_zero(left.dbg_data_i) or f_x_to_zero(right.dbg_data_i);
tmp.dummy_dummy_i := f_x_to_zero(left.dummy_dummy_i) or f_x_to_zero(right.dummy_dummy_i);
return tmp;
end function;
end package body;
