/**
 * UGENE - Integrated Bioinformatics Tools.
 * Copyright (C) 2008-2011 UniPro <ugene@unipro.ru>
 * http://ugene.unipro.ru
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef _U2_ADVANNOTATION_CREATION_H_
#define _U2_ADVANNOTATION_CREATION_H_

#include <U2Core/Task.h>
#include <U2Core/AnnotationTableObject.h>

#include <QtGui/QAction>
#include <QtCore/QPointer>

namespace U2 {

class CreateAnnotationsTask;
class AnnotatedDNAView;
class DNASequenceObject;

class U2VIEW_EXPORT ADVAnnotationCreation : public QObject {
    Q_OBJECT
public:
    ADVAnnotationCreation(AnnotatedDNAView* v);

    QAction* getCreateAnnotationAction() const {return createAction;}

private slots:
    void sl_createAnnotation();

private:
    AnnotatedDNAView* ctx;
    QAction* createAction;
};


class U2VIEW_EXPORT  ADVCreateAnnotationsTask : public Task {
    Q_OBJECT
public:
    ADVCreateAnnotationsTask(AnnotatedDNAView* _ctx, const GObjectReference& aobjRef, 
                            const QString& group, const QList<SharedAnnotationData>& data);
        
    ReportResult report();

private:
    QPointer<AnnotatedDNAView> ctx;
    CreateAnnotationsTask* t;
};


} // namespace



#endif
