# -*- coding: utf-8 -*-
#
# timezoneBackend - provides the backend for system time zone calls
#
# Copyright © 2001 - 2007, 2009 Red Hat, Inc.
# Copyright © 2001 - 2004 Brent Fox <bfox@redhat.com>
#                         Tammy Fox <tfox@redhat.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Authors:
# Brent Fox <bfox@redhat.com>
# Tammy Fox <tfox@redhat.com>
# Nils Philippsen <nphilipp@redhat.com>

import os
import time
import errno
from slip.util.files import linkorcopyfile

def bool(val):
    if val: return "true"
    return "false"

class timezoneBackend(object):
    def writeConfig (self, timezone, utc=0):
        timezonefile = timezone.replace (' ', '_')
        fromFile = "/usr/share/zoneinfo/" + timezonefile

        if utc == 0 or utc == 'false':
            utc = "false"
        else:
            utc = "true"

        linkorcopyfile (fromFile, "/etc/localtime")

        #Check to see if /var/spool/postfix/etc/localtime exists
        if os.access("/var/spool/postfix/etc/localtime", os.F_OK) == 1:
            #If it does, copy the new time zone file into the chroot jail
            linkorcopyfile (fromFile, "/var/spool/postfix/etc/localtime")

        #Write info to the /etc/sysconfig/clock file
        f = open("/etc/sysconfig/clock", "w")
        f.write ("# The time zone of the system is defined by the contents of /etc/localtime.\n")
        f.write ("# This file is only for evaluation by system-config-date, do not rely on its\n")
        f.write ("# contents elsewhere.\n")
        f.write('ZONE="%s"\n' % timezone)
        f.close()

        if self._adjtimeHasUTCInfo:
            f = open("/etc/adjtime", "r")
            l = f.readlines()
            f.close()

            f = open("/etc/adjtime", "w")
            f.write(l[0])
            f.write(l[1])
            if utc == 'true':
                f.write("UTC\n")
            else:
                f.write("LOCAL\n")
            f.close()

    def getTimezoneInfo (self):
        return (self.tz, self.utc)

    def setTimezoneInfo (self, timezone, asUtc = 0):
        self.tz = timezone
        self.utc = asUtc

    def __init__(self):
        self.tz = "America/New_York"
        self.utc = "false"
        path = '/etc/sysconfig/clock'
        lines = []
        self._canHwClock = None
        self._adjtimeHasUTCInfo = None

        if os.access(path, os.R_OK):
            fd = open(path, 'r')
            lines = fd.readlines()
            fd.close()
        else:
            #There's no /etc/sysconfig/clock file, so make one
            fd = open(path, 'w')
            fd.close
            pass

        try:
            for line in lines:
                line = line.strip ()
                if len (line) and line[0] == '#':
                    continue
                try:
                    tokens = line.split ("=")
                    if tokens[0] == "ZONE":
                        self.tz = tokens[1].replace ('"', '')
                        self.tz = self.tz.replace ('_', ' ')
                except:
                    pass
        except:
            pass
        if os.access("/etc/adjtime", os.R_OK):
            fd = open("/etc/adjtime", 'r')
            lines = fd.readlines()
            fd.close()
            try:
                line = lines[2].strip()
                self._adjtimeHasUTCInfo = True
            except IndexError:
                line = 'UTC'
                self._adjtimeHasUTCInfo = False
            if line == 'UTC':
                self.utc = 'true'
            else:
                self.utc = 'false'

    def _get_canHwClock (self):
        if self._canHwClock == None:
            if os.system ("/sbin/hwclock > /dev/null 2>&1") == 0:
                self._canHwClock = True
            else:
                self._canHwClock = False

        return self._canHwClock

    canHwClock = property (_get_canHwClock)

