/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [list.h]                       Type: List                                */
/*                                                                          */
/* Copyright (c) 1993 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef list_INCL
#define list_INCL


#include "standard.h"


#ifdef __cplusplus
extern "C" {
#endif


/* ---------------------------- The Type --------------------------------- */

/*  
   This module implements a functional,i.e. LISP-like list data type.
*/

#define List(Abs_T) list

AbstractType(List(Abs_T)); /* Abstract list type */

/* ---------------------------- Operations and predicates ---------------- */

c_bool empty(List(Abs_T) x);           /* whether list 'x' is empty         */

Abs_T list_fst(List(Abs_T) x)
#define fst(TYPE, LIST) ((TYPE) list_fst(LIST))
/* first member of list 'x' */
;

       List(Abs_T) rst(List(Abs_T) x); /* rest of list 'x'                  */
 List(Abs_T) cons(Abs_T fst, List(Abs_T) rst); /* list constructor          */
 List(Abs_T) *rst_ref(List(Abs_T) x); /* pointer to rest(x); use with care! */
Abs_T *fst_ref(List(Abs_T) x);       /* pointer to first(x); use with care! */
int   length(List(Abs_T) x);         /* length of list 'x'                  */

void pList(List(Abs_T) x, int Indent, void (*pMember)(Abs_T x))
/* prints list 'x' to stdout */
;

void pListEx
     (
       List(Abs_T) x, int Indent,
       void (*pMember)(Abs_T x, StdCPtr any), StdCPtr any
     )
/* prints list 'x' to stdout;
   uses 'any' as member context
*/
;

void freeList(List(Abs_T) x, void (*freeMember)(Abs_T x))
/* frees list 'x' */
;



#ifdef __cplusplus
}
#endif

#endif
