set (CPACK_PACKAGE_NAME ${PROJECT_NAME})
set (CPACK_PACKAGE_VERSION ${PROJECT_VERSION})
set (CPACK_SET_DESTDIR "ON")
if (APPLE)
	set(CPACK_GENERATOR "ZIP")
	set(CPACK_PACKAGE_FILE_NAME "${PROJECT_NAME}-${PROJECT_VERSION}-macosx-amd64")
	file(MAKE_DIRECTORY "${CMAKE_BINARY_DIR}/dist/osx")
	set (CPACK_INSTALL_PREFIX "")
	set(CPACK_OUTPUT_FILE_PREFIX "${CMAKE_BINARY_DIR}/dist/osx")
elseif (WIN32)
	set(CPACK_GENERATOR "ZIP")
	file(MAKE_DIRECTORY "${CMAKE_BINARY_DIR}/dist/windows")
	set (CPACK_INSTALL_PREFIX "")
	set(CPACK_OUTPUT_FILE_PREFIX "${CMAKE_BINARY_DIR}/dist/windows")
elseif(${CMAKE_SYSTEM_NAME} STREQUAL "Linux" AND EXISTS "/etc/debian_version")
	message(STATUS "Debian-based Linux OS detected")
	set(CPACK_GENERATOR "DEB")

	if ("${CMAKE_SYSTEM_PROCESSOR}" STREQUAL "x86_64")
		set(CPACK_PACKAGE_FILE_NAME "${CPACK_PACKAGE_NAME}-${PROJECT_VERSION}-amd64" )
	endif()

	set(CPACK_DEBIAN_PACKAGE_HOMEPAGE "https://github.com/texane/stlink")
	set(CPACK_DEBIAN_PACKAGE_MAINTAINER "Jerry Jacobs")
	set(CPACK_PACKAGE_CONTACT "jerry.jacobs@xor-gate.org")
	set(CPACK_DEBIAN_PACKAGE_DESCRIPTION "STM32 stlink programmer tools")
endif()
