/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.db.DBColumn;
import adql.db.DBIdentifier;
import adql.db.DBType;
import adql.db.DefaultDBColumn;
import adql.parser.ADQLParser;
import adql.parser.feature.LanguageFeature;
import adql.parser.grammar.ParseException;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLSet;
import adql.query.ClauseADQL;
import adql.query.ClauseConstraints;
import adql.query.ClauseOffset;
import adql.query.ClauseSelect;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.cast.CastFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class ADQLQuery
extends ADQLSet {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "QUERY", false, "An entire ADQL (sub-)query.");
    private ClauseSelect select;
    private FromContent from;
    private ClauseConstraints where;
    private ClauseADQL<ADQLOperand> groupBy;
    private ClauseConstraints having;

    public ADQLQuery() {
        this(ADQLParser.DEFAULT_VERSION);
    }

    public ADQLQuery(ADQLParser.ADQLVersion version) {
        super(version);
        this.select = new ClauseSelect();
        this.from = null;
        this.where = new ClauseConstraints("WHERE");
        this.groupBy = new ClauseADQL("GROUP BY");
        this.having = new ClauseConstraints("HAVING");
    }

    public ADQLQuery(ADQLQuery toCopy) throws Exception {
        super(toCopy);
        this.select = (ClauseSelect)toCopy.select.getCopy();
        this.from = (FromContent)toCopy.from.getCopy();
        this.where = (ClauseConstraints)toCopy.where.getCopy();
        this.groupBy = (ClauseADQL)toCopy.groupBy.getCopy();
        this.having = (ClauseConstraints)toCopy.having.getCopy();
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public void reset() {
        super.reset();
        this.select.clear();
        this.select.setDistinctColumns(false);
        this.select.setNoLimit();
        this.from = null;
        this.where.clear();
        this.groupBy.clear();
        this.having.clear();
    }

    public final ClauseSelect getSelect() {
        return this.select;
    }

    public void setSelect(ClauseSelect newSelect) throws NullPointerException {
        if (newSelect == null) {
            throw new NullPointerException("Impossible to replace the SELECT clause of a query by NULL!");
        }
        this.select = newSelect;
        this.position = null;
    }

    public final FromContent getFrom() {
        return this.from;
    }

    public void setFrom(FromContent newFrom) throws NullPointerException {
        if (newFrom == null) {
            throw new NullPointerException("Impossible to replace the FROM clause of a query by NULL!");
        }
        this.from = newFrom;
        this.position = null;
    }

    public final ClauseConstraints getWhere() {
        return this.where;
    }

    public void setWhere(ClauseConstraints newWhere) throws NullPointerException {
        if (newWhere == null) {
            this.where.clear();
        } else {
            this.where = newWhere;
        }
        this.position = null;
    }

    public final ClauseADQL<ADQLOperand> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(ClauseADQL<ADQLOperand> newGroupBy) throws NullPointerException {
        if (newGroupBy == null) {
            this.groupBy.clear();
        } else {
            this.groupBy = newGroupBy;
        }
        this.position = null;
    }

    public final ClauseConstraints getHaving() {
        return this.having;
    }

    public void setHaving(ClauseConstraints newHaving) throws NullPointerException {
        if (newHaving == null) {
            this.having.clear();
        } else {
            this.having = newHaving;
        }
        this.position = null;
    }

    @Override
    public boolean hasLimit() {
        return this.select.hasLimit();
    }

    @Override
    public int getLimit() {
        return this.select.getLimit();
    }

    @Override
    public final void setNoLimit() {
        this.select.setNoLimit();
    }

    @Override
    public final void setLimit(int limit) {
        this.select.setLimit(limit);
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ADQLQuery(this);
    }

    @Override
    public String getName() {
        return "{ADQL query}";
    }

    @Override
    public DBColumn[] getResultingColumns() {
        ArrayList<DBColumn> columns = new ArrayList<DBColumn>(this.select.size());
        for (SelectItem item : this.select) {
            ADQLOperand operand = item.getOperand();
            if (item instanceof SelectAllColumns) {
                try {
                    if (((SelectAllColumns)item).getAdqlTable() != null) {
                        columns.addAll(((SelectAllColumns)item).getAdqlTable().getDBColumns());
                        continue;
                    }
                    columns.addAll(this.from.getDBColumns());
                }
                catch (ParseException parseException) {}
                continue;
            }
            DBColumn col = null;
            if (item.hasAlias()) {
                String alias = item.isCaseSensitive() ? DBIdentifier.denormalize(item.getAlias(), true) : item.getAlias().toLowerCase();
                if (operand instanceof ADQLColumn && ((ADQLColumn)operand).getDBLink() != null) {
                    col = ((ADQLColumn)operand).getDBLink();
                    col = col.copy(alias, alias, col.getTable());
                } else {
                    col = new DefaultDBColumn(alias, null);
                }
            } else {
                DBColumn formerCol;
                col = operand instanceof ADQLColumn && ((ADQLColumn)operand).getDBLink() != null ? ((formerCol = ((ADQLColumn)operand).getDBLink()).isCaseSensitive() ? formerCol.copy(formerCol.getADQLName(), DBIdentifier.denormalize(formerCol.getADQLName(), true), formerCol.getTable()) : formerCol.copy(formerCol.getADQLName().toLowerCase(), formerCol.getADQLName().toLowerCase(), formerCol.getTable())) : new DefaultDBColumn(item.isCaseSensitive() ? DBIdentifier.denormalize(item.getName(), true) : item.getName().toLowerCase(), null);
            }
            if (operand instanceof UserDefinedFunction && ((UserDefinedFunction)operand).getDefinition() != null) {
                DBType type = ((UserDefinedFunction)operand).getDefinition().returnType;
                ((DefaultDBColumn)col).setDatatype(type);
            } else if (operand instanceof CastFunction && ((CastFunction)operand).getReturnType() != null) {
                ((DefaultDBColumn)col).setDatatype(((CastFunction)operand).getReturnType());
            } else if (operand instanceof PointFunction || operand instanceof CentroidFunction) {
                ((DefaultDBColumn)col).setDatatype(new DBType(DBType.DBDatatype.POINT));
            } else if (operand instanceof RegionFunction || operand instanceof CircleFunction || operand instanceof BoxFunction || operand instanceof PolygonFunction) {
                ((DefaultDBColumn)col).setDatatype(new DBType(DBType.DBDatatype.REGION));
            } else if (col instanceof DefaultDBColumn && col.getDatatype() == null && operand.isNumeric() != operand.isString()) {
                if (operand.isString()) {
                    ((DefaultDBColumn)col).setDatatype(new DBType(DBType.DBDatatype.VARCHAR));
                } else {
                    ((DefaultDBColumn)col).setDatatype(new DBType(DBType.DBDatatype.UNKNOWN_NUMERIC));
                }
            }
            columns.add(col);
        }
        DBColumn[] resColumns = new DBColumn[columns.size()];
        return columns.toArray(resColumns);
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;
            private ClauseADQL<?> currentClause = null;

            @Override
            public ADQLObject next() {
                ++this.index;
                switch (this.index) {
                    case 0: {
                        this.currentClause = ADQLQuery.this.with;
                        break;
                    }
                    case 1: {
                        this.currentClause = ADQLQuery.this.select;
                        break;
                    }
                    case 2: {
                        this.currentClause = null;
                        return ADQLQuery.this.from;
                    }
                    case 3: {
                        this.currentClause = ADQLQuery.this.where;
                        break;
                    }
                    case 4: {
                        this.currentClause = ADQLQuery.this.groupBy;
                        break;
                    }
                    case 5: {
                        this.currentClause = ADQLQuery.this.having;
                        break;
                    }
                    case 6: {
                        this.currentClause = ADQLQuery.this.orderBy;
                        break;
                    }
                    case 7: {
                        this.currentClause = null;
                        return ADQLQuery.this.offset;
                    }
                    default: {
                        throw new NoSuchElementException();
                    }
                }
                return this.currentClause;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < 8;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called!");
                }
                if (replacer == null) {
                    this.remove();
                } else {
                    switch (this.index) {
                        case 0: {
                            if (replacer instanceof ClauseADQL) {
                                ADQLQuery.this.with = (ClauseADQL)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseADQL (" + ADQLQuery.this.with.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                        case 1: {
                            if (replacer instanceof ClauseSelect) {
                                ADQLQuery.this.select = (ClauseSelect)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseSelect (" + ADQLQuery.this.select.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                        case 2: {
                            if (replacer instanceof FromContent) {
                                ADQLQuery.this.from = (FromContent)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a FromContent (" + ADQLQuery.this.from.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                        case 3: {
                            if (replacer instanceof ClauseConstraints) {
                                ADQLQuery.this.where = (ClauseConstraints)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseConstraints (" + ADQLQuery.this.where.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                        case 4: {
                            if (replacer instanceof ClauseADQL) {
                                ADQLQuery.this.groupBy = (ClauseADQL)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseADQL (" + ADQLQuery.this.groupBy.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                        case 5: {
                            if (replacer instanceof ClauseConstraints) {
                                ADQLQuery.this.having = (ClauseConstraints)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseConstraints (" + ADQLQuery.this.having.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                        case 6: {
                            if (replacer instanceof ClauseADQL) {
                                ADQLQuery.this.orderBy = (ClauseADQL)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseADQL (" + ADQLQuery.this.orderBy.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                        case 7: {
                            if (replacer instanceof ClauseOffset) {
                                ADQLQuery.this.offset = (ClauseOffset)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseOffset (" + ADQLQuery.this.offset.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        }
                    }
                    ADQLQuery.this.position = null;
                }
            }

            @Override
            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called!");
                }
                if (this.index == 1 || this.index == 2) {
                    throw new UnsupportedOperationException("Impossible to remove a " + (this.index == 1 ? "SELECT" : "FROM") + " clause from a query!");
                }
                if (this.index == 7) {
                    ADQLQuery.this.offset = null;
                    ADQLQuery.this.position = null;
                } else {
                    if (this.currentClause != null) {
                        this.currentClause.clear();
                    }
                    ADQLQuery.this.position = null;
                }
            }
        };
    }

    @Override
    public String toADQL() {
        StringBuffer adql = new StringBuffer();
        if (!this.with.isEmpty()) {
            adql.append(this.with.toADQL()).append('\n');
        }
        adql.append(this.select.toADQL());
        adql.append("\nFROM ").append(this.from.toADQL());
        if (!this.where.isEmpty()) {
            adql.append('\n').append(this.where.toADQL());
        }
        if (!this.groupBy.isEmpty()) {
            adql.append('\n').append(this.groupBy.toADQL());
        }
        if (!this.having.isEmpty()) {
            adql.append('\n').append(this.having.toADQL());
        }
        if (!this.orderBy.isEmpty()) {
            adql.append('\n').append(this.orderBy.toADQL());
        }
        if (this.offset != null) {
            adql.append('\n').append(this.offset.toADQL());
        }
        return adql.toString();
    }
}

