/* sqlheavy-error.c generated by valac 0.16.0, the Vala compiler
 * generated from sqlheavy-error.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))

/**
   * SQLHeavy Errors
   *
   * Most of these are from SQLite--see [[http://sqlite.org/c3ref/c_abort.html]] for documentation.
   */


gboolean sql_heavy_error_if_not_ok (gint ec, SQLHeavyQueryable* queryable, GError** error);
const gchar* sql_heavy_sqlite_errstr (gint ec);
gint sql_heavy_sqlite_code_from_error (GError* e);


gboolean sql_heavy_error_if_not_ok (gint ec, SQLHeavyQueryable* queryable, GError** error) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* msg;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
	_tmp0_ = ec;
	if (_tmp0_ == SQLITE_OK) {
		result = TRUE;
		return result;
	}
	_tmp1_ = ec;
	_tmp2_ = sql_heavy_sqlite_errstr (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	msg = _tmp3_;
	_tmp4_ = ec;
	switch (_tmp4_) {
		case SQLITE_ERROR:
		{
			const gchar* _tmp5_;
			GError* _tmp6_;
			_tmp5_ = msg;
			_tmp6_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ERROR, _tmp5_);
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_INTERNAL:
		{
			const gchar* _tmp7_;
			GError* _tmp8_;
			_tmp7_ = msg;
			_tmp8_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_INTERNAL, _tmp7_);
			_inner_error_ = _tmp8_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_PERM:
		{
			const gchar* _tmp9_;
			GError* _tmp10_;
			_tmp9_ = msg;
			_tmp10_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ACCESS_DENIED, _tmp9_);
			_inner_error_ = _tmp10_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_ABORT:
		{
			const gchar* _tmp11_;
			GError* _tmp12_;
			_tmp11_ = msg;
			_tmp12_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ABORTED, _tmp11_);
			_inner_error_ = _tmp12_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_BUSY:
		{
			const gchar* _tmp13_;
			GError* _tmp14_;
			_tmp13_ = msg;
			_tmp14_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_BUSY, _tmp13_);
			_inner_error_ = _tmp14_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_LOCKED:
		{
			const gchar* _tmp15_;
			GError* _tmp16_;
			_tmp15_ = msg;
			_tmp16_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_LOCKED, _tmp15_);
			_inner_error_ = _tmp16_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_NOMEM:
		{
			const gchar* _tmp17_;
			GError* _tmp18_;
			_tmp17_ = msg;
			_tmp18_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NO_MEMORY, _tmp17_);
			_inner_error_ = _tmp18_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_READONLY:
		{
			const gchar* _tmp19_;
			GError* _tmp20_;
			_tmp19_ = msg;
			_tmp20_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_READ_ONLY, _tmp19_);
			_inner_error_ = _tmp20_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_INTERRUPT:
		{
			const gchar* _tmp21_;
			GError* _tmp22_;
			_tmp21_ = msg;
			_tmp22_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_INTERRUPTED, _tmp21_);
			_inner_error_ = _tmp22_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_IOERR:
		{
			const gchar* _tmp23_;
			GError* _tmp24_;
			_tmp23_ = msg;
			_tmp24_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_IO, _tmp23_);
			_inner_error_ = _tmp24_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_CORRUPT:
		{
			const gchar* _tmp25_;
			GError* _tmp26_;
			_tmp25_ = msg;
			_tmp26_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CORRUPT, _tmp25_);
			_inner_error_ = _tmp26_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_FULL:
		{
			const gchar* _tmp27_;
			GError* _tmp28_;
			_tmp27_ = msg;
			_tmp28_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_FULL, _tmp27_);
			_inner_error_ = _tmp28_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_CANTOPEN:
		{
			const gchar* _tmp29_;
			GError* _tmp30_;
			_tmp29_ = msg;
			_tmp30_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CAN_NOT_OPEN, _tmp29_);
			_inner_error_ = _tmp30_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_EMPTY:
		{
			const gchar* _tmp31_;
			GError* _tmp32_;
			_tmp31_ = msg;
			_tmp32_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_EMPTY, _tmp31_);
			_inner_error_ = _tmp32_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_SCHEMA:
		{
			const gchar* _tmp33_;
			GError* _tmp34_;
			_tmp33_ = msg;
			_tmp34_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_SCHEMA, _tmp33_);
			_inner_error_ = _tmp34_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_TOOBIG:
		{
			const gchar* _tmp35_;
			GError* _tmp36_;
			_tmp35_ = msg;
			_tmp36_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_TOO_BIG, _tmp35_);
			_inner_error_ = _tmp36_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_CONSTRAINT:
		{
			const gchar* _tmp37_;
			GError* _tmp38_;
			_tmp37_ = msg;
			_tmp38_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CONSTRAINT, _tmp37_);
			_inner_error_ = _tmp38_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_MISMATCH:
		{
			const gchar* _tmp39_;
			GError* _tmp40_;
			_tmp39_ = msg;
			_tmp40_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISMATCH, _tmp39_);
			_inner_error_ = _tmp40_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_MISUSE:
		{
			const gchar* _tmp41_;
			GError* _tmp42_;
			_tmp41_ = msg;
			_tmp42_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISUSE, _tmp41_);
			_inner_error_ = _tmp42_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_NOLFS:
		{
			const gchar* _tmp43_;
			GError* _tmp44_;
			_tmp43_ = msg;
			_tmp44_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NOLFS, _tmp43_);
			_inner_error_ = _tmp44_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_AUTH:
		{
			const gchar* _tmp45_;
			GError* _tmp46_;
			_tmp45_ = msg;
			_tmp46_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_AUTH, _tmp45_);
			_inner_error_ = _tmp46_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_FORMAT:
		{
			const gchar* _tmp47_;
			GError* _tmp48_;
			_tmp47_ = msg;
			_tmp48_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_FORMAT, _tmp47_);
			_inner_error_ = _tmp48_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_RANGE:
		{
			const gchar* _tmp49_;
			GError* _tmp50_;
			_tmp49_ = msg;
			_tmp50_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, _tmp49_);
			_inner_error_ = _tmp50_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_NOTADB:
		{
			const gchar* _tmp51_;
			GError* _tmp52_;
			_tmp51_ = msg;
			_tmp52_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NOTADB, _tmp51_);
			_inner_error_ = _tmp52_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		default:
		{
			const gchar* _tmp53_;
			GError* _tmp54_;
			_tmp53_ = msg;
			_tmp54_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_UNKNOWN, _tmp53_);
			_inner_error_ = _tmp54_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_g_free0 (msg);
}


GQuark sql_heavy_error_quark (void) {
	return g_quark_from_static_string ("sql_heavy_error-quark");
}


/**
   * Convert an SQLHeavy.Error to an SQLite error code. This function
   * is used to convert errors thrown by user defined functions.
   *
   * @param e SQLHeavy error
   */
gint sql_heavy_sqlite_code_from_error (GError* e) {
	gint result = 0;
	GError* _tmp0_;
	_tmp0_ = e;
	if (g_error_matches (_tmp0_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_INTERNAL)) {
		result = SQLITE_INTERNAL;
		return result;
	} else {
		GError* _tmp1_;
		_tmp1_ = e;
		if (g_error_matches (_tmp1_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ACCESS_DENIED)) {
			result = SQLITE_PERM;
			return result;
		} else {
			GError* _tmp2_;
			_tmp2_ = e;
			if (g_error_matches (_tmp2_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ERROR)) {
				result = SQLITE_ERROR;
				return result;
			} else {
				GError* _tmp3_;
				_tmp3_ = e;
				if (g_error_matches (_tmp3_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ABORTED)) {
					result = SQLITE_ABORT;
					return result;
				} else {
					GError* _tmp4_;
					_tmp4_ = e;
					if (g_error_matches (_tmp4_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_BUSY)) {
						result = SQLITE_BUSY;
						return result;
					} else {
						GError* _tmp5_;
						_tmp5_ = e;
						if (g_error_matches (_tmp5_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_LOCKED)) {
							result = SQLITE_LOCKED;
							return result;
						} else {
							GError* _tmp6_;
							_tmp6_ = e;
							if (g_error_matches (_tmp6_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NO_MEMORY)) {
								result = SQLITE_NOMEM;
								return result;
							} else {
								GError* _tmp7_;
								_tmp7_ = e;
								if (g_error_matches (_tmp7_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_READ_ONLY)) {
									result = SQLITE_READONLY;
									return result;
								} else {
									GError* _tmp8_;
									_tmp8_ = e;
									if (g_error_matches (_tmp8_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_INTERRUPTED)) {
										result = SQLITE_INTERRUPT;
										return result;
									} else {
										GError* _tmp9_;
										_tmp9_ = e;
										if (g_error_matches (_tmp9_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_IO)) {
											result = SQLITE_IOERR;
											return result;
										} else {
											GError* _tmp10_;
											_tmp10_ = e;
											if (g_error_matches (_tmp10_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CORRUPT)) {
												result = SQLITE_CORRUPT;
												return result;
											} else {
												GError* _tmp11_;
												_tmp11_ = e;
												if (g_error_matches (_tmp11_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_FULL)) {
													result = SQLITE_FULL;
													return result;
												} else {
													GError* _tmp12_;
													_tmp12_ = e;
													if (g_error_matches (_tmp12_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CAN_NOT_OPEN)) {
														result = SQLITE_CANTOPEN;
														return result;
													} else {
														GError* _tmp13_;
														_tmp13_ = e;
														if (g_error_matches (_tmp13_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_EMPTY)) {
															result = SQLITE_EMPTY;
															return result;
														} else {
															GError* _tmp14_;
															_tmp14_ = e;
															if (g_error_matches (_tmp14_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_SCHEMA)) {
																result = SQLITE_SCHEMA;
																return result;
															} else {
																GError* _tmp15_;
																_tmp15_ = e;
																if (g_error_matches (_tmp15_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_TOO_BIG)) {
																	result = SQLITE_TOOBIG;
																	return result;
																} else {
																	GError* _tmp16_;
																	_tmp16_ = e;
																	if (g_error_matches (_tmp16_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CONSTRAINT)) {
																		result = SQLITE_CONSTRAINT;
																		return result;
																	} else {
																		GError* _tmp17_;
																		_tmp17_ = e;
																		if (g_error_matches (_tmp17_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISMATCH)) {
																			result = SQLITE_MISMATCH;
																			return result;
																		} else {
																			GError* _tmp18_;
																			_tmp18_ = e;
																			if (g_error_matches (_tmp18_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISUSE)) {
																				result = SQLITE_MISUSE;
																				return result;
																			} else {
																				GError* _tmp19_;
																				_tmp19_ = e;
																				if (g_error_matches (_tmp19_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NOLFS)) {
																					result = SQLITE_NOLFS;
																					return result;
																				} else {
																					GError* _tmp20_;
																					_tmp20_ = e;
																					if (g_error_matches (_tmp20_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_AUTH)) {
																						result = SQLITE_AUTH;
																						return result;
																					} else {
																						GError* _tmp21_;
																						_tmp21_ = e;
																						if (g_error_matches (_tmp21_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_FORMAT)) {
																							result = SQLITE_FORMAT;
																							return result;
																						} else {
																							GError* _tmp22_;
																							_tmp22_ = e;
																							if (g_error_matches (_tmp22_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE)) {
																								result = SQLITE_RANGE;
																								return result;
																							} else {
																								GError* _tmp23_;
																								_tmp23_ = e;
																								if (g_error_matches (_tmp23_, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NOTADB)) {
																									result = SQLITE_NOTADB;
																									return result;
																								} else {
																									result = SQLITE_ERROR;
																									return result;
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


/**
   * Convert an SQLite error code into a string representation.
   */
const gchar* sql_heavy_sqlite_errstr (gint ec) {
	const gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = ec;
	switch (_tmp0_) {
		case SQLITE_ERROR:
		{
			result = "SQL error or missing database";
			return result;
		}
		case SQLITE_INTERNAL:
		{
			result = "Internal logic error in SQLite";
			return result;
		}
		case SQLITE_PERM:
		{
			result = "Access permission denied";
			return result;
		}
		case SQLITE_ABORT:
		{
			result = "Callback routine requested an abort";
			return result;
		}
		case SQLITE_BUSY:
		{
			result = "The database file is locked";
			return result;
		}
		case SQLITE_LOCKED:
		{
			result = "A table in the database is locked";
			return result;
		}
		case SQLITE_NOMEM:
		{
			result = "A malloc failed";
			return result;
		}
		case SQLITE_READONLY:
		{
			result = "Attempt to write to a read-only database";
			return result;
		}
		case SQLITE_INTERRUPT:
		{
			result = "Operation interrupted";
			return result;
		}
		case SQLITE_IOERR:
		{
			result = "Some kind of disk I/O error occurred";
			return result;
		}
		case SQLITE_CORRUPT:
		{
			result = "The database disk image is malformed";
			return result;
		}
		case SQLITE_FULL:
		{
			result = "Insertion failed because database is full";
			return result;
		}
		case SQLITE_CANTOPEN:
		{
			result = "Unable to open the database file";
			return result;
		}
		case SQLITE_EMPTY:
		{
			result = "Database is empty";
			return result;
		}
		case SQLITE_SCHEMA:
		{
			result = "The database schema changed";
			return result;
		}
		case SQLITE_TOOBIG:
		{
			result = "String or BLOB exceeds size limit";
			return result;
		}
		case SQLITE_CONSTRAINT:
		{
			result = "Abort due to constraint violation";
			return result;
		}
		case SQLITE_MISMATCH:
		{
			result = "Data type mismatch";
			return result;
		}
		case SQLITE_MISUSE:
		{
			result = "Library used incorrectly";
			return result;
		}
		case SQLITE_NOLFS:
		{
			result = "Uses OS features not supported on host";
			return result;
		}
		case SQLITE_AUTH:
		{
			result = "Authorization denied";
			return result;
		}
		case SQLITE_FORMAT:
		{
			result = "Auxiliary database format error";
			return result;
		}
		case SQLITE_RANGE:
		{
			result = "Parameter out of range";
			return result;
		}
		case SQLITE_NOTADB:
		{
			result = "File opened that is not a database file";
			return result;
		}
		case SQLITE_ROW:
		{
			result = "sqlite3_step() has another row ready";
			return result;
		}
		case SQLITE_DONE:
		{
			result = "sqlite3_step() has finished executing";
			return result;
		}
		default:
		{
			result = "An unknown error occured";
			return result;
		}
	}
}



