/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Mon Jan 25 12:52:11 2021

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_52 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 26938, "epsg", 26938,
        "NAD83 / Alaska zone 8", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 8\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",54],PARAMETER[\"central_meridian\",-166],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26938\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26939, "epsg", 26939,
        "NAD83 / Alaska zone 9", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 9\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",54],PARAMETER[\"central_meridian\",-170],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26939\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26940, "epsg", 26940,
        "NAD83 / Alaska zone 10", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=51 +lon_0=-176 +x_0=1000000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 10\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",51],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-176],PARAMETER[\"standard_parallel_1\",53.8333333333");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"standard_parallel_2\",51.8333333333333]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",1000000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"26940\"]]");
    p = add_epsg_def_ex (filter, first, last, 26941, "epsg", 26941,
        "NAD83 / California zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 1\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",39.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-122],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",41.6666666666667],PARAMETER[\"standard_parallel_2\",4");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"26941\"]]");
    p = add_epsg_def_ex (filter, first, last, 26942, "epsg", 26942,
        "NAD83 / California zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y");
    add_proj4text (p, 2,
        "_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 2\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",37.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-122],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",39.8333333333333],PARAMETER[\"standard_parallel_2\",3");
    add_srs_wkt (p, 10,
        "8.3333333333333],PARAMETER[\"false_easting\",2000000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",500000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26942\"]]");
    p = add_epsg_def_ex (filter, first, last, 26943, "epsg", 26943,
        "NAD83 / California zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 3\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",36.5],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",-120.5],PARAMETER[\"standard_parallel_1\",38.433");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"standard_parallel_2\",37.0666666");
    add_srs_wkt (p, 10,
        "666667],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"26943\"]]");
    p = add_epsg_def_ex (filter, first, last, 26944, "epsg", 26944,
        "NAD83 / California zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 4\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",35.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-119],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",37.25],PARAMETER[\"standard_parallel_2\",36],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",2000000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"26944\"]]");
    p = add_epsg_def_ex (filter, first, last, 26945, "epsg", 26945,
        "NAD83 / California zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 5\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",33.5],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",-118],PARAMETER[\"standard_parallel_1\",35.46666");
    add_srs_wkt (p, 9,
        "66666667],PARAMETER[\"standard_parallel_2\",34.033333333");
    add_srs_wkt (p, 10,
        "3333],PARAMETER[\"false_easting\",2000000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"26945\"]]");
    p = add_epsg_def_ex (filter, first, last, 26946, "epsg", 26946,
        "NAD83 / California zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000");
    add_proj4text (p, 2,
        " +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 6\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",32.1666666666667],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-116.25],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 9,
        "l_1\",33.8833333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",32.7833333333333],PARAMETER[\"false_easting\",2000000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26946\"]]");
    p = add_epsg_def_ex (filter, first, last, 26948, "epsg", 26948,
        "NAD83 / Arizona East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arizona East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",31],PARAMETER[\"central_meridian\",-110.166");
    add_srs_wkt (p, 8,
        "666666667],PARAMETER[\"scale_factor\",0.9999],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",213360],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"26948\"]]");
    p = add_epsg_def_ex (filter, first, last, 26949, "epsg", 26949,
        "NAD83 / Arizona Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arizona Central\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",31],PARAMETER[\"central_meridian\",-111.");
    add_srs_wkt (p, 8,
        "916666666667],PARAMETER[\"scale_factor\",0.9999],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",213360],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"26949\"]]");
    p = add_epsg_def_ex (filter, first, last, 26950, "epsg", 26950,
        "NAD83 / Arizona West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arizona West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",31],PARAMETER[\"central_meridian\",-113.75]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.999933333],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",213360],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26950\"]]");
    p = add_epsg_def_ex (filter, first, last, 26951, "epsg", 26951,
        "NAD83 / Arkansas North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arkansas North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",34.3333333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-92],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 9,
        "36.2333333333333],PARAMETER[\"standard_parallel_2\",34.9");
    add_srs_wkt (p, 10,
        "333333333333],PARAMETER[\"false_easting\",400000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"26951\"]]");
    p = add_epsg_def_ex (filter, first, last, 26952, "epsg", 26952,
        "NAD83 / Arkansas South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arkansas South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",32.6666666666667],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-92],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 9,
        "34.7666666666667],PARAMETER[\"standard_parallel_2\",33.3");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",400000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"26952\"]]");
    p = add_epsg_def_ex (filter, first, last, 26953, "epsg", 26953,
        "NAD83 / Colorado North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Colorado North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",39.3333333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-105.5],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",40.7833333333333],PARAMETER[\"standard_parallel_2\",3");
    add_srs_wkt (p, 10,
        "9.7166666666667],PARAMETER[\"false_easting\",914401.8289");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",304800.6096],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26953\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 26954, "epsg", 26954,
        "NAD83 / Colorado Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Colorado Central\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 7,
        "ER[\"latitude_of_origin\",37.8333333333333],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-105.5],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_1\",39.75],PARAMETER[\"standard_parallel_2\",38.45],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",914401.8289],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",304800.6096],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"26954\"]]");
    p = add_epsg_def_ex (filter, first, last, 26955, "epsg", 26955,
        "NAD83 / Colorado South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Colorado South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",36.6666666666667],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-105.5],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",38.4333333333333],PARAMETER[\"standard_parallel_2\",3");
    add_srs_wkt (p, 10,
        "7.2333333333333],PARAMETER[\"false_easting\",914401.8289");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",304800.6096],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26955\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 26956, "epsg", 26956,
        "NAD83 / Connecticut", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=1524");
    add_proj4text (p, 2,
        "00.3048 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Connecticut\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",40.8333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-72.75],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 9,
        "41.8666666666667],PARAMETER[\"standard_parallel_2\",41.2");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",304800.6096],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",152400.3048],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26956\"]]");
    p = add_epsg_def_ex (filter, first, last, 26957, "epsg", 26957,
        "NAD83 / Delaware", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Delaware\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",38],PARAMETER[\"central_meridian\",-75.4166666");
    add_srs_wkt (p, 8,
        "666667],PARAMETER[\"scale_factor\",0.999995],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",200000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"26957\"]]");
    p = add_epsg_def_ex (filter, first, last, 26958, "epsg", 26958,
        "NAD83 / Florida East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Florida East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",24.3333333333333],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-81],PARAMETER[\"scale_factor\",0.999941177],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",200000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"26958\"]]");
    p = add_epsg_def_ex (filter, first, last, 26959, "epsg", 26959,
        "NAD83 / Florida West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Florida West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",24.3333333333333],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-82],PARAMETER[\"scale_factor\",0.999941177],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",200000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"26959\"]]");
    p = add_epsg_def_ex (filter, first, last, 26960, "epsg", 26960,
        "NAD83 / Florida North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Florida North\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",29],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-84.5],PARAMETER[\"standard_parallel_1\",30.75],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",29.5833333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",600000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"26960\"]]");
    p = add_epsg_def_ex (filter, first, last, 26961, "epsg", 26961,
        "NAD83 / Hawaii zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.");
    add_proj4text (p, 1,
        "999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 1\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",18.8333333333333],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-155.5],PARAMETER[\"scale_factor\",0.999966667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"26961\"]]");
    p = add_epsg_def_ex (filter, first, last, 26962, "epsg", 26962,
        "NAD83 / Hawaii zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 2\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",20.3333333333333],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-156.666666666667],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "99966667],PARAMETER[\"false_easting\",500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"26962\"]]");
    p = add_epsg_def_ex (filter, first, last, 26963, "epsg", 26963,
        "NAD83 / Hawaii zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99");
    add_proj4text (p, 1,
        "999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 3\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",21.1666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-158],PARAMETER[\"scale_factor\",0.99999],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"26963\"]]");
    p = add_epsg_def_ex (filter, first, last, 26964, "epsg", 26964,
        "NAD83 / Hawaii zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.");
    add_proj4text (p, 1,
        "99999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 4\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",21.8333333333333],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-159.5],PARAMETER[\"scale_factor\",0.99999],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"26964\"]]");
    p = add_epsg_def_ex (filter, first, last, 26965, "epsg", 26965,
        "NAD83 / Hawaii zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 5\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",21.6666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-160.166666666667],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"26965\"]]");
    p = add_epsg_def_ex (filter, first, last, 26966, "epsg", 26966,
        "NAD83 / Georgia East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Georgia East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",30],PARAMETER[\"central_meridian\",-82.1666");
    add_srs_wkt (p, 8,
        "666666667],PARAMETER[\"scale_factor\",0.9999],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",200000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"26966\"]]");
    p = add_epsg_def_ex (filter, first, last, 26967, "epsg", 26967,
        "NAD83 / Georgia West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Georgia West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",30],PARAMETER[\"central_meridian\",-84.1666");
    add_srs_wkt (p, 8,
        "666666667],PARAMETER[\"scale_factor\",0.9999],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",700000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"26967\"]]");
    p = add_epsg_def_ex (filter, first, last, 26968, "epsg", 26968,
        "NAD83 / Idaho East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho East\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",41.6666666666667],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-112.166666666667],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "47368],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"26968\"]]");
    p = add_epsg_def_ex (filter, first, last, 26969, "epsg", 26969,
        "NAD83 / Idaho Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho Central\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",41.6666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-114],PARAMETER[\"scale_factor\",0.999947368],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"26969\"]]");
    p = add_epsg_def_ex (filter, first, last, 26970, "epsg", 26970,
        "NAD83 / Idaho West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
        ".999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho West\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",41.6666666666667],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-115.75],PARAMETER[\"scale_factor\",0.999933333],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",800000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"26970\"]]");
    p = add_epsg_def_ex (filter, first, last, 26971, "epsg", 26971,
        "NAD83 / Illinois East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Illinois East\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",36.6666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-88.3333333333333],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "99975],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"26971\"]]");
    p = add_epsg_def_ex (filter, first, last, 26972, "epsg", 26972,
        "NAD83 / Illinois West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Illinois West\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",36.6666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-90.1666666666667],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "99941177],PARAMETER[\"false_easting\",700000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"26972\"]]");
    p = add_epsg_def_ex (filter, first, last, 26973, "epsg", 26973,
        "NAD83 / Indiana East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Indiana East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",37.5],PARAMETER[\"central_meridian\",-85.66");
    add_srs_wkt (p, 8,
        "66666666667],PARAMETER[\"scale_factor\",0.999966667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",100000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",250000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"26973\"]]");
    p = add_epsg_def_ex (filter, first, last, 26974, "epsg", 26974,
        "NAD83 / Indiana West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Indiana West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",37.5],PARAMETER[\"central_meridian\",-87.08");
    add_srs_wkt (p, 8,
        "33333333333],PARAMETER[\"scale_factor\",0.999966667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",900000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",250000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"26974\"]]");
    p = add_epsg_def_ex (filter, first, last, 26975, "epsg", 26975,
        "NAD83 / Iowa North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Iowa North\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",41.5],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-93.5],PARAMETER[\"standard_parallel_1\",43.266666666666");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"standard_parallel_2\",42.0666666666667],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",1500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"26975\"]]");
    p = add_epsg_def_ex (filter, first, last, 26976, "epsg", 26976,
        "NAD83 / Iowa South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Iowa South\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",40],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 8,
        "3.5],PARAMETER[\"standard_parallel_1\",41.7833333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",40.6166666666667],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"26976\"]]");
    p = add_epsg_def_ex (filter, first, last, 26977, "epsg", 26977,
        "NAD83 / Kansas North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas North\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",38.3333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-98],PARAMETER[\"standard_parallel_1\",39.");
    add_srs_wkt (p, 9,
        "7833333333333],PARAMETER[\"standard_parallel_2\",38.7166");
    add_srs_wkt (p, 10,
        "666666667],PARAMETER[\"false_easting\",400000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"26977\"]]");
    p = add_epsg_def_ex (filter, first, last, 26978, "epsg", 26978,
        "NAD83 / Kansas South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y");
    add_proj4text (p, 2,
        "_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas South\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",36.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-98.5],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 9,
        "8.5666666666667],PARAMETER[\"standard_parallel_2\",37.26");
    add_srs_wkt (p, 10,
        "66666666667],PARAMETER[\"false_easting\",400000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",400000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"26978\"]]");
    p = add_epsg_def_ex (filter, first, last, 26979, "epsg", 26979,
        "NAD83 / Kentucky North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=37.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kentucky North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",37.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-84.25],PARAMETER[\"standard_parallel_1\",37.966666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"standard_parallel_2\",38.9666666666");
    add_srs_wkt (p, 10,
        "667],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2205\"]]");
    p = add_epsg_def_ex (filter, first, last, 26980, "epsg", 26980,
        "NAD83 / Kentucky South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kentucky South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",36.3333333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-85.75],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",37.9333333333333],PARAMETER[\"standard_parallel_2\",3");
    add_srs_wkt (p, 10,
        "6.7333333333333],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",500000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 13,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"26980\"]]");
    p = add_epsg_def_ex (filter, first, last, 26981, "epsg", 26981,
        "NAD83 / Louisiana North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Louisiana North\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",30.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-92.5],PARAMETER[\"standard_parallel_1\",32.6666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"standard_parallel_2\",31.16666666666");
    add_srs_wkt (p, 10,
        "67],PARAMETER[\"false_easting\",1000000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"26981\"]]");
    p = add_epsg_def_ex (filter, first, last, 26982, "epsg", 26982,
        "NAD83 / Louisiana South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91");
    add_proj4text (p, 1,
        ".33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Louisiana South\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",28.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-91.3333333333333],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",30.7],PARAMETER[\"standard_parallel_2\",29.3],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",1000000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26982\"]]");
    p = add_epsg_def_ex (filter, first, last, 26983, "epsg", 26983,
        "NAD83 / Maine East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine East\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",43.6666666666667],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-68.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",300000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"26983\"]]");
    p = add_epsg_def_ex (filter, first, last, 26984, "epsg", 26984,
        "NAD83 / Maine West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine West\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",42.8333333333333],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-70.1666666666667],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"false_easting\",900000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"26984\"]]");
    p = add_epsg_def_ex (filter, first, last, 26985, "epsg", 26985,
        "NAD83 / Maryland", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maryland\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",37.6666666666667],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-77],PARAMETER[\"standard_parallel_1\",39.45]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",38.3],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",400000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "26985\"]]");
    p = add_epsg_def_ex (filter, first, last, 26986, "epsg", 26986,
        "NAD83 / Massachusetts Mainland", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Massachusetts Mainland\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",41],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-71.5],PARAMETER[\"standard_parallel_1\",42.6");
    add_srs_wkt (p, 9,
        "833333333333],PARAMETER[\"standard_parallel_2\",41.71666");
    add_srs_wkt (p, 10,
        "66666667],PARAMETER[\"false_easting\",200000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",750000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26986\"]]");
    p = add_epsg_def_ex (filter, first, last, 26987, "epsg", 26987,
        "NAD83 / Massachusetts Island", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Massachusetts Island\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",41],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-70.5],PARAMETER[\"standard_parallel_1\",41.483");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"standard_parallel_2\",41.2833333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"26987\"]]");
    p = add_epsg_def_ex (filter, first, last, 26988, "epsg", 26988,
        "NAD83 / Michigan North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",44.7833333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-87],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 9,
        "47.0833333333333],PARAMETER[\"standard_parallel_2\",45.4");
    add_srs_wkt (p, 10,
        "833333333333],PARAMETER[\"false_easting\",8000000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26988\"]]");
    p = add_epsg_def_ex (filter, first, last, 26989, "epsg", 26989,
        "NAD83 / Michigan Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43");
    add_proj4text (p, 1,
        ".31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan Central\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 7,
        "ER[\"latitude_of_origin\",43.3166666666667],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-84.3666666666667],PARAMETER[\"standa");
    add_srs_wkt (p, 9,
        "rd_parallel_1\",45.7],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 10,
        "44.1833333333333],PARAMETER[\"false_easting\",6000000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"26989\"]]");
    p = add_epsg_def_ex (filter, first, last, 26990, "epsg", 26990,
        "NAD83 / Michigan South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41");
    add_proj4text (p, 1,
        ".5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",41.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-84.3666666666667],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",43.6666666666667],PARAMETER[\"standard_parallel_2\",42.");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"false_easting\",4000000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"26990\"]]");
    p = add_epsg_def_ex (filter, first, last, 26991, "epsg", 26991,
        "NAD83 / Minnesota North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y");
    add_proj4text (p, 2,
        "_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota North\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",46.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-93.1],PARAMETER[\"standard_parallel_1\",48.6333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"standard_parallel_2\",47.03333333333");
    add_srs_wkt (p, 10,
        "33],PARAMETER[\"false_easting\",800000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"26991\"]]");
    p = add_epsg_def_ex (filter, first, last, 26992, "epsg", 26992,
        "NAD83 / Minnesota Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +to");
    add_proj4text (p, 2,
        "wgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota Central\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",45],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-94.25],PARAMETER[\"standard_parallel_1\",47.05],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",45.6166666666667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",800000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"26992\"]]");
    p = add_epsg_def_ex (filter, first, last, 26993, "epsg", 26993,
        "NAD83 / Minnesota South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota South\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",43],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-94],PARAMETER[\"standard_parallel_1\",45.21666666666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"standard_parallel_2\",43.7833333333333],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",800000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"26993\"]]");
    p = add_epsg_def_ex (filter, first, last, 26994, "epsg", 26994,
        "NAD83 / Mississippi East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Mississippi East\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",29.5],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "88.8333333333333],PARAMETER[\"scale_factor\",0.99995],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",300000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"26994\"]]");
    p = add_epsg_def_ex (filter, first, last, 26995, "epsg", 26995,
        "NAD83 / Mississippi West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Mississippi West\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",29.5],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "90.3333333333333],PARAMETER[\"scale_factor\",0.99995],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",700000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"26995\"]]");
    p = add_epsg_def_ex (filter, first, last, 26996, "epsg", 26996,
        "NAD83 / Missouri East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Missouri East\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",35.8333333333333],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-90.5],PARAMETER[\"scale_factor\",0.999933333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",250000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"26996\"]]");
    p = add_epsg_def_ex (filter, first, last, 26997, "epsg", 26997,
        "NAD83 / Missouri Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Missouri Central\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",35.8333333333333],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-92.5],PARAMETER[\"scale_factor\",0.999933333");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"26997\"]]");
    p = add_epsg_def_ex (filter, first, last, 26998, "epsg", 26998,
        "NAD83 / Missouri West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.9");
    add_proj4text (p, 1,
        "99941177 +x_0=850000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Missouri West\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",36.1666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-94.5],PARAMETER[\"scale_factor\",0.999941177],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",850000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"26998\"]]");
    p = add_epsg_def_ex (filter, first, last, 27037, "epsg", 27037,
        "Nahrwan 1934 / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-249,-156,381,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / UTM zone 37N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1934\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6744\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4744\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 12,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 27038, "epsg", 27038,
        "Nahrwan 1934 / UTM zone 38N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=clrk80 +towgs84=-249,-156,381,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / UTM zone 38N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1934\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6744\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4744\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 12,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 27039, "epsg", 27039,
        "Nahrwan 1967 / UTM zone 39N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1967", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=-249,-156,381,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1967 / UTM zone 39N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1967\",DATUM[\"Nahrwan_1967\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6270\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4270\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"270");
    add_srs_wkt (p, 12,
        "39\"]]");
    p = add_epsg_def_ex (filter, first, last, 27040, "epsg", 27040,
        "Nahrwan 1967 / UTM zone 40N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1967", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=clrk80 +towgs84=-249,-156,381,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1967 / UTM zone 40N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1967\",DATUM[\"Nahrwan_1967\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6270\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4270\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"270");
    add_srs_wkt (p, 12,
        "40\"]]");
    p = add_epsg_def_ex (filter, first, last, 27120, "epsg", 27120,
        "Naparima 1972 / UTM zone 20N", 0, 0,
        "International 1924", "Greenwich",
        "Naparima_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-10,375,165,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Naparima 1972 / UTM zone 20N\",GEOGCS[\"Naparim");
    add_srs_wkt (p, 1,
        "a 1972\",DATUM[\"Naparima_1972\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6271\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4271");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-63]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2712");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 27200, "epsg", 27200,
        "NZGD49 / New Zealand Map Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "New_Zealand_Map_Grid", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=nzmg +lat_0=-41 +lon_0=173 +x_0=2510000 +y_0=60231");
    add_proj4text (p, 1,
        "50 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.0");
    add_proj4text (p, 2,
        "24,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / New Zealand Map Grid\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4272\"]],PROJECTION[\"New_Zealand_Map_Grid\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",-41],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",173],PARAMETER[\"false_easting\",2510000],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_northing\",6023150],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"27200\"]]");
    p = add_epsg_def_ex (filter, first, last, 27205, "epsg", 27205,
        "NZGD49 / Mount Eden Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-36.87986527777778 +lon_0=174.7643393");
    add_proj4text (p, 1,
        "611111 +k=0.9999 +x_0=300000 +y_0=700000 +ellps=intl +to");
    add_proj4text (p, 2,
        "wgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Eden Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-36.8798652777778],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",174.764339361111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",300000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",700000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"27205\"]]");
    p = add_epsg_def_ex (filter, first, last, 27206, "epsg", 27206,
        "NZGD49 / Bay of Plenty Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-37.76124980555556 +lon_0=176.4661972");
    add_proj4text (p, 1,
        "5 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Bay of Plenty Circuit\",GEOGCS[\"NZGD4");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-37.7612498055556],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",176.46619725],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27206\"]]");
    p = add_epsg_def_ex (filter, first, last, 27207, "epsg", 27207,
        "NZGD49 / Poverty Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-38.62470277777778 +lon_0=177.8856362");
    add_proj4text (p, 1,
        "777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Poverty Bay Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-38.6247027777778],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",177.885636277778],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27207\"]]");
    p = add_epsg_def_ex (filter, first, last, 27208, "epsg", 27208,
        "NZGD49 / Hawkes Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.65092930555556 +lon_0=176.6736805");
    add_proj4text (p, 1,
        "277778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Hawkes Bay Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-39.6509293055556],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",176.673680527778],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27208\"]]");
    p = add_epsg_def_ex (filter, first, last, 27209, "epsg", 27209,
        "NZGD49 / Taranaki Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.13575830555556 +lon_0=174.2280117");
    add_proj4text (p, 1,
        "5 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Taranaki Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-39.1357583055556],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",174.22801175],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27209\"]]");
    p = add_epsg_def_ex (filter, first, last, 27210, "epsg", 27210,
        "NZGD49 / Tuhirangi Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.51247038888889 +lon_0=175.6400368");
    add_proj4text (p, 1,
        "055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Tuhirangi Circuit\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-39.5124703888889],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",175.640036805556],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27210\"]]");
    p = add_epsg_def_ex (filter, first, last, 27211, "epsg", 27211,
        "NZGD49 / Wanganui Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.24194713888889 +lon_0=175.4880996");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wanganui Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-40.2419471388889],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",175.488099611111],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27211\"]]");
    p = add_epsg_def_ex (filter, first, last, 27212, "epsg", 27212,
        "NZGD49 / Wairarapa Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.92553263888889 +lon_0=175.6473496");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wairarapa Circuit\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-40.9255326388889],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",175.647349666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27212\"]]");
    p = add_epsg_def_ex (filter, first, last, 27213, "epsg", 27213,
        "NZGD49 / Wellington Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.30131963888888 +lon_0=174.7766231");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wellington Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-41.3013196388889],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",174.776623111111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27213\"]]");
    p = add_epsg_def_ex (filter, first, last, 27214, "epsg", 27214,
        "NZGD49 / Collingwood Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.71475905555556 +lon_0=172.6720465");
    add_proj4text (p, 1,
        " +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47");
    add_proj4text (p, 2,
        ",-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Collingwood Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-40.7147590555556],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",172.6720465],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27214\"]]");
    p = add_epsg_def_ex (filter, first, last, 27215, "epsg", 27215,
        "NZGD49 / Nelson Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.27454472222222 +lon_0=173.2993168");
    add_proj4text (p, 1,
        "055555 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Nelson Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-41.2745447222222],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",173.299316805556],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27215\"]]");
    p = add_epsg_def_ex (filter, first, last, 27216, "epsg", 27216,
        "NZGD49 / Karamea Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.28991152777778 +lon_0=172.1090281");
    add_proj4text (p, 1,
        "944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Karamea Circuit\",GEOGCS[\"NZGD49\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-41.2899115277778],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",172.109028194444],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27216\"]]");
    p = add_epsg_def_ex (filter, first, last, 27217, "epsg", 27217,
        "NZGD49 / Buller Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.81080286111111 +lon_0=171.5812600");
    add_proj4text (p, 1,
        "555556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Buller Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-41.8108028611111],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",171.581260055556],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27217\"]]");
    p = add_epsg_def_ex (filter, first, last, 27218, "epsg", 27218,
        "NZGD49 / Grey Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.33369427777778 +lon_0=171.5497713");
    add_proj4text (p, 1,
        "055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Grey Circuit\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-42.3336942777778],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",171.549771305556],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27218\"]]");
    p = add_epsg_def_ex (filter, first, last, 27219, "epsg", 27219,
        "NZGD49 / Amuri Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.68911658333333 +lon_0=173.0101333");
    add_proj4text (p, 1,
        "888889 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Amuri Circuit\",GEOGCS[\"NZGD49\",DATU");
    add_srs_wkt (p, 1,
        "M[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-42.6891165833333],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",173.010133388889],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27219\"]]");
    p = add_epsg_def_ex (filter, first, last, 27220, "epsg", 27220,
        "NZGD49 / Marlborough Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.54448666666666 +lon_0=173.8020741");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Marlborough Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-41.5444866666667],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",173.802074111111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27220\"]]");
    p = add_epsg_def_ex (filter, first, last, 27221, "epsg", 27221,
        "NZGD49 / Hokitika Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.88632236111111 +lon_0=170.9799935");
    add_proj4text (p, 1,
        " +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47");
    add_proj4text (p, 2,
        ",-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Hokitika Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-42.8863223611111],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",170.9799935],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"27221\"]]");
    p = add_epsg_def_ex (filter, first, last, 27222, "epsg", 27222,
        "NZGD49 / Okarito Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.11012813888889 +lon_0=170.2609258");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Okarito Circuit\",GEOGCS[\"NZGD49\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-43.1101281388889],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",170.260925833333],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27222\"]]");
    p = add_epsg_def_ex (filter, first, last, 27223, "epsg", 27223,
        "NZGD49 / Jacksons Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.97780288888889 +lon_0=168.606267 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,");
    add_proj4text (p, 2,
        "-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Jacksons Bay Circuit\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-43.9778028888889],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",168.606267],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27223\"]]");
    p = add_epsg_def_ex (filter, first, last, 27224, "epsg", 27224,
        "NZGD49 / Mount Pleasant Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.59063758333333 +lon_0=172.7271935");
    add_proj4text (p, 1,
        "833333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Pleasant Circuit\",GEOGCS[\"NZGD");
    add_srs_wkt (p, 1,
        "49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-43.5906375833333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",172.727193583333],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",300000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"27224\"]]");
    p = add_epsg_def_ex (filter, first, last, 27225, "epsg", 27225,
        "NZGD49 / Gawler Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.74871155555556 +lon_0=171.3607484");
    add_proj4text (p, 1,
        "722222 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Gawler Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-43.7487115555556],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",171.360748472222],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27225\"]]");
    p = add_epsg_def_ex (filter, first, last, 27226, "epsg", 27226,
        "NZGD49 / Timaru Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.40222036111111 +lon_0=171.0572508");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Timaru Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-44.4022203611111],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",171.057250833333],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27226\"]]");
    p = add_epsg_def_ex (filter, first, last, 27227, "epsg", 27227,
        "NZGD49 / Lindis Peak Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.73526797222222 +lon_0=169.4677550");
    add_proj4text (p, 1,
        "833333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Lindis Peak Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-44.7352679722222],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",169.467755083333],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27227\"]]");
    p = add_epsg_def_ex (filter, first, last, 27228, "epsg", 27228,
        "NZGD49 / Mount Nicholas Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.13290258333333 +lon_0=168.3986411");
    add_proj4text (p, 1,
        "944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Nicholas Circuit\",GEOGCS[\"NZGD");
    add_srs_wkt (p, 1,
        "49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-45.1329025833333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",168.398641194444],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",300000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"27228\"]]");
    p = add_epsg_def_ex (filter, first, last, 27229, "epsg", 27229,
        "NZGD49 / Mount York Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.56372616666666 +lon_0=167.7388617");
    add_proj4text (p, 1,
        "777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount York Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-45.5637261666667],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",167.738861777778],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27229\"]]");
    p = add_epsg_def_ex (filter, first, last, 27230, "epsg", 27230,
        "NZGD49 / Observation Point Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.81619661111111 +lon_0=170.6285951");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Observation Point Circuit\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ZGD49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",-45.8161966111111],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",170.628595166667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",300000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",700000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"27230\"]]");
    p = add_epsg_def_ex (filter, first, last, 27231, "epsg", 27231,
        "NZGD49 / North Taieri Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.86151336111111 +lon_0=170.2825891");
    add_proj4text (p, 1,
        "111111 +k=0.99996 +x_0=300000 +y_0=700000 +ellps=intl +t");
    add_proj4text (p, 2,
        "owgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / North Taieri Circuit\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-45.8615133611111],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",170.282589111111],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.99996],PARAMETER[\"false_easting\",300000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",700000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"27231\"]]");
    p = add_epsg_def_ex (filter, first, last, 27232, "epsg", 27232,
        "NZGD49 / Bluff Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-46.60000961111111 +lon_0=168.342872 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=300002.66 +y_0=699999.58 +ellps=intl +towgs84=");
    add_proj4text (p, 2,
        "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Bluff Circuit\",GEOGCS[\"NZGD49\",DATU");
    add_srs_wkt (p, 1,
        "M[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-46.6000096111111],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",168.342872],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",300002.66],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",699999.58],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27232\"]]");
    p = add_epsg_def_ex (filter, first, last, 27258, "epsg", 27258,
        "NZGD49 / UTM zone 58S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 58S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "65],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"27258\"]]");
    p = add_epsg_def_ex (filter, first, last, 27259, "epsg", 27259,
        "NZGD49 / UTM zone 59S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 59S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "71],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"27259\"]]");
    p = add_epsg_def_ex (filter, first, last, 27260, "epsg", 27260,
        "NZGD49 / UTM zone 60S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 60S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "77],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"27260\"]]");
    p = add_epsg_def_ex (filter, first, last, 27291, "epsg", 27291,
        "NZGD49 / North Island Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "British yard (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39 +lon_0=175.5 +k=1 +x_0=274319.524");
    add_proj4text (p, 1,
        "3848086 +y_0=365759.3658464114 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +to_meter=0.91439");
    add_proj4text (p, 3,
        "84146160287 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / North Island Grid\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-39],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",175.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",300000],PARAMETER[\"false_northing\",40000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"British yard (Sears 1922)\",0.914398414616029,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9040\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"27291\"]]");
    p = add_epsg_def_ex (filter, first, last, 27292, "epsg", 27292,
        "NZGD49 / South Island Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "British yard (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44 +lon_0=171.5 +k=1 +x_0=457199.207");
    add_proj4text (p, 1,
        "3080143 +y_0=457199.2073080143 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +to_meter=0.91439");
    add_proj4text (p, 3,
        "84146160287 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / South Island Grid\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-44],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",171.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",50000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"British yard (Sears 1922)\",0.914398414616029,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9040\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"27292\"]]");
    p = add_epsg_def_ex (filter, first, last, 27391, "epsg", 27391,
        "NGO 1948 (Oslo) / NGO zone I", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=-4.666666666666667 +k=1 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=");
    add_proj4text (p, 2,
        "278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone I\",GEOGCS[\"NGO 194");
    add_srs_wkt (p, 1,
        "8 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mod");
    add_srs_wkt (p, 2,
        "ified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "5\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7");
    add_srs_wkt (p, 4,
        "229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-4.66666666666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27391\"]]");
    p = add_epsg_def_ex (filter, first, last, 27392, "epsg", 27392,
        "NGO 1948 (Oslo) / NGO zone II", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=-2.333333333333333 +k=1 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=");
    add_proj4text (p, 2,
        "278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone II\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.");
    add_srs_wkt (p, 4,
        "7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-2.33333333333333],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27392\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

