/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Mon Jan 25 12:52:11 2021

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_44 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 8788, "epsg", 8788,
        "NAD83 / Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=37.6666666666667 +lon_0=-78.5 +lat_1=39");
    add_proj4text (p, 1,
        ".2 +lat_2=38.0333333333333 +x_0=3500000.0001016 +y_0=200");
    add_proj4text (p, 2,
        "0000.0001016 +datum=NAD83 +units=us-ft +vunits=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Virginia North (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / Virginia North (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",37.6666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-78.5],PARAMETER[\"stand");
    add_srs_wkt (p, 10,
        "ard_parallel_1\",39.2],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 11,
        ",38.0333333333333],PARAMETER[\"false_easting\",11482916.");
    add_srs_wkt (p, 12,
        "667],PARAMETER[\"false_northing\",6561666.667],UNIT[\"US");
    add_srs_wkt (p, 13,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"2283\"]],VERT_CS[\"NAVD88 height (ft");
    add_srs_wkt (p, 16,
        "US)\",VERT_DATUM[\"North American Vertical Datum 1988\",");
    add_srs_wkt (p, 17,
        "2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot");
    add_srs_wkt (p, 18,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 19,
        "\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"6360");
    add_srs_wkt (p, 20,
        "\"]],AUTHORITY[\"EPSG\",\"8788\"]]");
    p = add_epsg_def_ex (filter, first, last, 8789, "epsg", 8789,
        "NAD83 / Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=36.3333333333333 +lon_0=-78.5 +lat_1=37");
    add_proj4text (p, 1,
        ".9666666666667 +lat_2=36.7666666666667 +x_0=3500000.0001");
    add_proj4text (p, 2,
        "016 +y_0=999999.9998984 +datum=NAD83 +units=us-ft +vunit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Virginia South (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / Virginia South (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",36.3333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-78.5],PARAMETER[\"stand");
    add_srs_wkt (p, 10,
        "ard_parallel_1\",37.9666666666667],PARAMETER[\"standard_");
    add_srs_wkt (p, 11,
        "parallel_2\",36.7666666666667],PARAMETER[\"false_easting");
    add_srs_wkt (p, 12,
        "\",11482916.667],PARAMETER[\"false_northing\",3280833.33");
    add_srs_wkt (p, 13,
        "3],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 15,
        "\",NORTH],AUTHORITY[\"EPSG\",\"2284\"]],VERT_CS[\"NAVD88");
    add_srs_wkt (p, 16,
        " height (ftUS)\",VERT_DATUM[\"North American Vertical Da");
    add_srs_wkt (p, 17,
        "tum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US ");
    add_srs_wkt (p, 18,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 19,
        "3\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EP");
    add_srs_wkt (p, 20,
        "SG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8789\"]]");
    p = add_epsg_def_ex (filter, first, last, 8790, "epsg", 8790,
        "NAD83 / Washington North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=47 +lon_0=-120.833333333333 +lat_1=48.7");
    add_proj4text (p, 1,
        "333333333333 +lat_2=47.5 +x_0=500000.0001016 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Washington North (ftUS) + NAVD88 heig");
    add_srs_wkt (p, 1,
        "ht (ftUS)\",PROJCS[\"NAD83 / Washington North (ftUS)\",G");
    add_srs_wkt (p, 2,
        "EOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHE");
    add_srs_wkt (p, 3,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 5,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_2SP\"],PARAMETER[\"latitude_of_origin\",47],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-120.833333333333],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_1\",48.7333333333333],PARAMETER[\"stand");
    add_srs_wkt (p, 11,
        "ard_parallel_2\",47.5],PARAMETER[\"false_easting\",16404");
    add_srs_wkt (p, 12,
        "16.667],PARAMETER[\"false_northing\",0],UNIT[\"US survey");
    add_srs_wkt (p, 13,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 14,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"2285\"]],VERT_CS[\"NAVD88 height (ftUS)\",V");
    add_srs_wkt (p, 16,
        "ERT_DATUM[\"North American Vertical Datum 1988\",2005,AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 18,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 19,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AU");
    add_srs_wkt (p, 20,
        "THORITY[\"EPSG\",\"8790\"]]");
    p = add_epsg_def_ex (filter, first, last, 8791, "epsg", 8791,
        "NAD83 / Washington South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=45.3333333333333 +lon_0=-120.5 +lat_1=4");
    add_proj4text (p, 1,
        "7.3333333333333 +lat_2=45.8333333333333 +x_0=500000.0001");
    add_proj4text (p, 2,
        "016 +y_0=0 +datum=NAD83 +units=us-ft +vunits=us-ft +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Washington South (ftUS) + NAVD88 heig");
    add_srs_wkt (p, 1,
        "ht (ftUS)\",PROJCS[\"NAD83 / Washington South (ftUS)\",G");
    add_srs_wkt (p, 2,
        "EOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHE");
    add_srs_wkt (p, 3,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 5,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_2SP\"],PARAMETER[\"latitude_of_origin\",45.33333333");
    add_srs_wkt (p, 9,
        "33333],PARAMETER[\"central_meridian\",-120.5],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_1\",47.3333333333333],PARAMETER[\"st");
    add_srs_wkt (p, 11,
        "andard_parallel_2\",45.8333333333333],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "easting\",1640416.667],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 13,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 15,
        "NORTH],AUTHORITY[\"EPSG\",\"2286\"]],VERT_CS[\"NAVD88 he");
    add_srs_wkt (p, 16,
        "ight (ftUS)\",VERT_DATUM[\"North American Vertical Datum");
    add_srs_wkt (p, 17,
        " 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US sur");
    add_srs_wkt (p, 18,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 19,
        "]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",\"6360\"]],AUTHORITY[\"EPSG\",\"8791\"]]");
    p = add_epsg_def_ex (filter, first, last, 8792, "epsg", 8792,
        "NAD83 / West Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=38.5 +lon_0=-79.5 +lat_1=40.25 +lat_2=3");
    add_proj4text (p, 1,
        "9 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +vunits=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / West Virginia North (ftUS) + NAVD88 h");
    add_srs_wkt (p, 1,
        "eight (ftUS)\",PROJCS[\"NAD83 / West Virginia North (ftU");
    add_srs_wkt (p, 2,
        "S)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",38.5],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-79.5],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_1\",40.25],PARAMETER[\"standard_parallel_2\",3");
    add_srs_wkt (p, 11,
        "9],PARAMETER[\"false_easting\",1968500],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 13,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26853\"]],V");
    add_srs_wkt (p, 15,
        "ERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North Ameri");
    add_srs_wkt (p, 16,
        "can Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103");
    add_srs_wkt (p, 17,
        "\"]],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY");
    add_srs_wkt (p, 18,
        "[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related height\",UP]");
    add_srs_wkt (p, 19,
        ",AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8792");
    add_srs_wkt (p, 20,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 8793, "epsg", 8793,
        "NAD83 / West Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=37 +lon_0=-81 +lat_1=38.8833333333333 +");
    add_proj4text (p, 1,
        "lat_2=37.4833333333333 +x_0=600000 +y_0=0 +datum=NAD83 +");
    add_proj4text (p, 2,
        "units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / West Virginia South (ftUS) + NAVD88 h");
    add_srs_wkt (p, 1,
        "eight (ftUS)\",PROJCS[\"NAD83 / West Virginia South (ftU");
    add_srs_wkt (p, 2,
        "S)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",37],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-81],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_1\",38.8833333333333],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 11,
        "l_2\",37.4833333333333],PARAMETER[\"false_easting\",1968");
    add_srs_wkt (p, 12,
        "500],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 13,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 14,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"26854\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT");
    add_srs_wkt (p, 16,
        "_DATUM[\"North American Vertical Datum 1988\",2005,AUTHO");
    add_srs_wkt (p, 17,
        "RITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 18,
        "0609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-");
    add_srs_wkt (p, 19,
        "related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHO");
    add_srs_wkt (p, 20,
        "RITY[\"EPSG\",\"8793\"]]");
    p = add_epsg_def_ex (filter, first, last, 8794, "epsg", 8794,
        "NAD83 / Wisconsin North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=45.1666666666667 +lon_0=-90 +lat_1=46.7");
    add_proj4text (p, 1,
        "666666666667 +lat_2=45.5666666666667 +x_0=600000 +y_0=0 ");
    add_proj4text (p, 2,
        "+datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wisconsin North (ftUS) + NAVD88 heigh");
    add_srs_wkt (p, 1,
        "t (ftUS)\",PROJCS[\"NAD83 / Wisconsin North (ftUS)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",45.1666666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"central_meridian\",-90],PARAMETER[\"sta");
    add_srs_wkt (p, 10,
        "ndard_parallel_1\",46.7666666666667],PARAMETER[\"standar");
    add_srs_wkt (p, 11,
        "d_parallel_2\",45.5666666666667],PARAMETER[\"false_easti");
    add_srs_wkt (p, 12,
        "ng\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 13,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 14,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 15,
        "THORITY[\"EPSG\",\"2287\"]],VERT_CS[\"NAVD88 height (ftU");
    add_srs_wkt (p, 16,
        "S)\",VERT_DATUM[\"North American Vertical Datum 1988\",2");
    add_srs_wkt (p, 17,
        "005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 18,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 19,
        "Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"");
    add_srs_wkt (p, 20,
        "]],AUTHORITY[\"EPSG\",\"8794\"]]");
    p = add_epsg_def_ex (filter, first, last, 8795, "epsg", 8795,
        "NAD83 / Wisconsin Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=43.8333333333333 +lon_0=-90 +lat_1=45.5");
    add_proj4text (p, 1,
        " +lat_2=44.25 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-");
    add_proj4text (p, 2,
        "ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wisconsin Central (ftUS) + NAVD88 hei");
    add_srs_wkt (p, 1,
        "ght (ftUS)\",PROJCS[\"NAD83 / Wisconsin Central (ftUS)\"");
    add_srs_wkt (p, 2,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 3,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",43.833333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"central_meridian\",-90],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_1\",45.5],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 11,
        "l_2\",44.25],PARAMETER[\"false_easting\",1968500],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 13,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 14,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 15,
        "288\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"No");
    add_srs_wkt (p, 16,
        "rth American Vertical Datum 1988\",2005,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 17,
        "\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 18,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related hei");
    add_srs_wkt (p, 19,
        "ght\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 20,
        "\",\"8795\"]]");
    p = add_epsg_def_ex (filter, first, last, 8796, "epsg", 8796,
        "NAD83 / Wisconsin South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=42 +lon_0=-90 +lat_1=44.0666666666667 +");
    add_proj4text (p, 1,
        "lat_2=42.7333333333333 +x_0=600000 +y_0=0 +datum=NAD83 +");
    add_proj4text (p, 2,
        "units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wisconsin South (ftUS) + NAVD88 heigh");
    add_srs_wkt (p, 1,
        "t (ftUS)\",PROJCS[\"NAD83 / Wisconsin South (ftUS)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",42],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-90],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 10,
        "_1\",44.0666666666667],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 11,
        ",42.7333333333333],PARAMETER[\"false_easting\",1968500],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"E");
    add_srs_wkt (p, 14,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"2289\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATU");
    add_srs_wkt (p, 16,
        "M[\"North American Vertical Datum 1988\",2005,AUTHORITY[");
    add_srs_wkt (p, 17,
        "\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 18,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-relat");
    add_srs_wkt (p, 19,
        "ed height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[");
    add_srs_wkt (p, 20,
        "\"EPSG\",\"8796\"]]");
    p = add_epsg_def_ex (filter, first, last, 8797, "epsg", 8797,
        "NAD83 / Wyoming East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-105.166666666667 +k=0.99");
    add_proj4text (p, 1,
        "99375 +x_0=200000.00001016 +y_0=0 +datum=NAD83 +units=us");
    add_proj4text (p, 2,
        "-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wyoming East (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Wyoming East (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",40.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-105.166666666667],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9999375],PARAMETER[\"false_easting\",656166.6667],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "3736\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"N");
    add_srs_wkt (p, 15,
        "orth American Vertical Datum 1988\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 17,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related he");
    add_srs_wkt (p, 18,
        "ight\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 19,
        "G\",\"8797\"]]");
    p = add_epsg_def_ex (filter, first, last, 8798, "epsg", 8798,
        "NAD83 / Wyoming East Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-107.333333333333 +k=0.99");
    add_proj4text (p, 1,
        "99375 +x_0=399999.99998984 +y_0=99999.99998984 +datum=NA");
    add_proj4text (p, 2,
        "D83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wyoming East Central (ftUS) + NAVD88 ");
    add_srs_wkt (p, 1,
        "height (ftUS)\",PROJCS[\"NAD83 / Wyoming East Central (f");
    add_srs_wkt (p, 2,
        "tUS)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_198");
    add_srs_wkt (p, 3,
        "3\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-107.333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.9999375],PARAMETER[\"false_easting\",13");
    add_srs_wkt (p, 11,
        "12333.3333],PARAMETER[\"false_northing\",328083.3333],UN");
    add_srs_wkt (p, 12,
        "IT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"3737\"]],VERT_CS[\"NAVD88 hei");
    add_srs_wkt (p, 15,
        "ght (ftUS)\",VERT_DATUM[\"North American Vertical Datum ");
    add_srs_wkt (p, 16,
        "1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US surv");
    add_srs_wkt (p, 17,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 18,
        "],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 19,
        ",\"6360\"]],AUTHORITY[\"EPSG\",\"8798\"]]");
    p = add_epsg_def_ex (filter, first, last, 8799, "epsg", 8799,
        "NAD83 / Wyoming West Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +datum=NAD83 +units=us-ft +vunits=us-ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wyoming West Central (ftUS) + NAVD88 ");
    add_srs_wkt (p, 1,
        "height (ftUS)\",PROJCS[\"NAD83 / Wyoming West Central (f");
    add_srs_wkt (p, 2,
        "tUS)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_198");
    add_srs_wkt (p, 3,
        "3\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-108.75],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9999375],PARAMETER[\"false_easting\",1968500],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"3738\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[");
    add_srs_wkt (p, 15,
        "\"North American Vertical Datum 1988\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 17,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related");
    add_srs_wkt (p, 18,
        " height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"");
    add_srs_wkt (p, 19,
        "EPSG\",\"8799\"]]");
    p = add_epsg_def_ex (filter, first, last, 8800, "epsg", 8800,
        "NAD83 / Wyoming West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-110.083333333333 +k=0.99");
    add_proj4text (p, 1,
        "99375 +x_0=800000.00001016 +y_0=99999.99998984 +datum=NA");
    add_proj4text (p, 2,
        "D83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wyoming West (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Wyoming West (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",40.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-110.083333333333],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9999375],PARAMETER[\"false_easting\",2624666.6667],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",328083.3333],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"3739\"]],VERT_CS[\"NAVD88 height (ftUS)\",VE");
    add_srs_wkt (p, 15,
        "RT_DATUM[\"North American Vertical Datum 1988\",2005,AUT");
    add_srs_wkt (p, 16,
        "HORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 17,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravit");
    add_srs_wkt (p, 18,
        "y-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUT");
    add_srs_wkt (p, 19,
        "HORITY[\"EPSG\",\"8800\"]]");
    p = add_epsg_def_ex (filter, first, last, 8801, "epsg", 8801,
        "NAD83 / Alabama East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-85.8333333333333 +k=0.99");
    add_proj4text (p, 1,
        "996 +x_0=200000 +y_0=0 +datum=NAD83 +units=m +vunits=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alabama East + NAVD88 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"NAD83 / Alabama East\",GEOGCS[\"NAD83\",DATUM[\"North");
    add_srs_wkt (p, 2,
        "_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",30.5],PARAMETER[\"central_meridian\",-85.8333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"scale_factor\",0.99996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",200000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"26929\"]],VERT_CS[\"NAVD88 height\",VERT_DATUM[\"Nort");
    add_srs_wkt (p, 14,
        "h American Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 16,
        "]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"5703\"]],AUTHORITY[\"EPSG\",\"8801\"]]");
    p = add_epsg_def_ex (filter, first, last, 8802, "epsg", 8802,
        "NAD83 / Alabama West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=6");
    add_proj4text (p, 1,
        "00000 +y_0=0 +datum=NAD83 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alabama West + NAVD88 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"NAD83 / Alabama West\",GEOGCS[\"NAD83\",DATUM[\"North");
    add_srs_wkt (p, 2,
        "_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",30],PARAMETER[\"central_meridian\",-87.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",0.999933333],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",600000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26930\"");
    add_srs_wkt (p, 13,
        "]],VERT_CS[\"NAVD88 height\",VERT_DATUM[\"North American");
    add_srs_wkt (p, 14,
        " Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]");
    add_srs_wkt (p, 15,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 16,
        "Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"5703\"");
    add_srs_wkt (p, 17,
        "]],AUTHORITY[\"EPSG\",\"8802\"]]");
    p = add_epsg_def_ex (filter, first, last, 8803, "epsg", 8803,
        "NAD83 / Alaska zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Hotine_Oblique_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +no_uoff +lat_0=57 +lonc=-133.666666666667 +");
    add_proj4text (p, 1,
        "alpha=323.130102361111 +gamma=323.130102361111 +k=0.9999");
    add_proj4text (p, 2,
        " +x_0=5000000 +y_0=-5000000 +datum=NAD83 +units=m +vunit");
    add_proj4text (p, 3,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 1 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 1\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_center\",57],PARAMETER[\"longitude_of_center\",-133");
    add_srs_wkt (p, 9,
        ".666666666667],PARAMETER[\"azimuth\",323.130102361111],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"rectified_grid_angle\",323.130102361111],PARA");
    add_srs_wkt (p, 11,
        "METER[\"scale_factor\",0.9999],PARAMETER[\"false_easting");
    add_srs_wkt (p, 12,
        "\",5000000],PARAMETER[\"false_northing\",-5000000],UNIT[");
    add_srs_wkt (p, 13,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 14,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 15,
        "6931\"]],VERT_CS[\"NAVD88 height\",VERT_DATUM[\"North Am");
    add_srs_wkt (p, 16,
        "erican Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 17,
        "103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 18,
        "XIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 19,
        "5703\"]],AUTHORITY[\"EPSG\",\"8803\"]]");
    p = add_epsg_def_ex (filter, first, last, 8804, "epsg", 8804,
        "NAD83 / Alaska zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 2 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 2\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",54],PARAMETER[\"central_meridian\",-142],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26932\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"NAVD88 height\",VERT_DATUM[\"North American Ver");
    add_srs_wkt (p, 14,
        "tical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"8804\"]]");
    p = add_epsg_def_ex (filter, first, last, 8805, "epsg", 8805,
        "NAD83 / Alaska zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 3 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 3\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",54],PARAMETER[\"central_meridian\",-146],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26933\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"NAVD88 height\",VERT_DATUM[\"North American Ver");
    add_srs_wkt (p, 14,
        "tical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"8805\"]]");
    p = add_epsg_def_ex (filter, first, last, 8806, "epsg", 8806,
        "NAD83 / Alaska zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 4 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 4\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",54],PARAMETER[\"central_meridian\",-150],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26934\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"NAVD88 height\",VERT_DATUM[\"North American Ver");
    add_srs_wkt (p, 14,
        "tical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"8806\"]]");
    p = add_epsg_def_ex (filter, first, last, 8807, "epsg", 8807,
        "NAD83 / Alaska zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 5 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 5\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",54],PARAMETER[\"central_meridian\",-154],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26935\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"NAVD88 height\",VERT_DATUM[\"North American Ver");
    add_srs_wkt (p, 14,
        "tical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"8807\"]]");
    p = add_epsg_def_ex (filter, first, last, 8808, "epsg", 8808,
        "NAD83 / Alaska zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 6 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 6\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",54],PARAMETER[\"central_meridian\",-158],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26936\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"NAVD88 height\",VERT_DATUM[\"North American Ver");
    add_srs_wkt (p, 14,
        "tical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"8808\"]]");
    p = add_epsg_def_ex (filter, first, last, 8809, "epsg", 8809,
        "NAD83 / Alaska zone 7", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 7 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 7\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",54],PARAMETER[\"central_meridian\",-162],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26937\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"NAVD88 height\",VERT_DATUM[\"North American Ver");
    add_srs_wkt (p, 14,
        "tical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"8809\"]]");
    p = add_epsg_def_ex (filter, first, last, 8810, "epsg", 8810,
        "NAD83 / Alaska zone 8", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 8 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 8\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",54],PARAMETER[\"central_meridian\",-166],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26938\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"NAVD88 height\",VERT_DATUM[\"North American Ver");
    add_srs_wkt (p, 14,
        "tical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"8810\"]]");
    p = add_epsg_def_ex (filter, first, last, 8811, "epsg", 8811,
        "NAD83 / Alaska zone 9", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 9 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 9\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",54],PARAMETER[\"central_meridian\",-170],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26939\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"NAVD88 height\",VERT_DATUM[\"North American Ver");
    add_srs_wkt (p, 14,
        "tical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"8811\"]]");
    p = add_epsg_def_ex (filter, first, last, 8812, "epsg", 8812,
        "NAD83 / Alaska zone 10", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=51 +lon_0=-176 +lat_1=53.8333333333333 ");
    add_proj4text (p, 1,
        "+lat_2=51.8333333333333 +x_0=1000000 +y_0=0 +datum=NAD83");
    add_proj4text (p, 2,
        " +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 10 + NAVD88 height\",PROJ");
    add_srs_wkt (p, 1,
        "CS[\"NAD83 / Alaska zone 10\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 2,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",51],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 9,
        "76],PARAMETER[\"standard_parallel_1\",53.8333333333333],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"standard_parallel_2\",51.8333333333333],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_easting\",1000000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"26940\"]],VERT_CS[\"NAVD88 height\",VERT_DA");
    add_srs_wkt (p, 15,
        "TUM[\"North American Vertical Datum 1988\",2005,AUTHORIT");
    add_srs_wkt (p, 16,
        "Y[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 18,
        "Y[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8812\"]]");
    p = add_epsg_def_ex (filter, first, last, 8813, "epsg", 8813,
        "NAD83 / Missouri East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.8333333333333 +lon_0=-90.5 +k=0.99");
    add_proj4text (p, 1,
        "9933333 +x_0=250000 +y_0=0 +datum=NAD83 +units=m +vunits");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Missouri East + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Missouri East\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",35.8333333333333],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-90.5],PARAMETER[\"scale_factor\",0.999933333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"26996\"]],VERT_CS[\"NAVD88 height\",VERT_DATUM[");
    add_srs_wkt (p, 14,
        "\"North American Vertical Datum 1988\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 16,
        "9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 17,
        "EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8813\"]]");
    p = add_epsg_def_ex (filter, first, last, 8814, "epsg", 8814,
        "NAD83 / Missouri Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.8333333333333 +lon_0=-92.5 +k=0.99");
    add_proj4text (p, 1,
        "9933333 +x_0=500000 +y_0=0 +datum=NAD83 +units=m +vunits");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Missouri Central + NAVD88 height\",PR");
    add_srs_wkt (p, 1,
        "OJCS[\"NAD83 / Missouri Central\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 2,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",35.8333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-92.5],PARAMETER[\"scale_factor\",0.999933333],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"26997\"]],VERT_CS[\"NAVD88 height\",VERT");
    add_srs_wkt (p, 14,
        "_DATUM[\"North American Vertical Datum 1988\",2005,AUTHO");
    add_srs_wkt (p, 15,
        "RITY[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 16,
        "SG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTH");
    add_srs_wkt (p, 17,
        "ORITY[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8814\"]]");
    p = add_epsg_def_ex (filter, first, last, 8815, "epsg", 8815,
        "NAD83 / Missouri West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.1666666666667 +lon_0=-94.5 +k=0.99");
    add_proj4text (p, 1,
        "9941177 +x_0=850000 +y_0=0 +datum=NAD83 +units=m +vunits");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Missouri West + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Missouri West\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",36.1666666666667],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-94.5],PARAMETER[\"scale_factor\",0.999941177],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",850000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"26998\"]],VERT_CS[\"NAVD88 height\",VERT_DATUM[");
    add_srs_wkt (p, 14,
        "\"North American Vertical Datum 1988\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 16,
        "9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 17,
        "EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8815\"]]");
    p = add_epsg_def_ex (filter, first, last, 8817, "epsg", 8817,
        "MTRF-2000", 1, 1,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"MTRF-2000\",DATUM[\"MOMRA Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e Frame 2000\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Saudi Arabia - onshore and offshore.\"],BBOX[16.29,34");
    add_srs_wkt (p, 10,
        ".44,32.16,55.67]],ID[\"EPSG\",8817]]");
    p = add_epsg_def_ex (filter, first, last, 8818, "epsg", 8818,
        "MTRF-2000", 1, 1,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MTRF-2000\",DATUM[\"MOMRA_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_Frame_2000\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"121");
    add_srs_wkt (p, 3,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"8818\"]]");
    p = add_epsg_def_ex (filter, first, last, 8826, "epsg", 8826,
        "NAD83 / Idaho Transverse Mercator", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42 +lon_0=-114 +k=0.9996 +x_0=2500000");
    add_proj4text (p, 1,
        " +y_0=1200000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho Transverse Mercator\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",42],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-114],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",2500000],PARAMETER[\"false_northing\",12");
    add_srs_wkt (p, 10,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"8826\"]]");
    p = add_epsg_def_ex (filter, first, last, 8836, "epsg", 8836,
        "MTRF-2000 / UTM zone 36N", 0, 0,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MTRF-2000 / UTM zone 36N\",GEOGCS[\"MTRF-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MOMRA_Terrestrial_Reference_Frame_2000\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1218\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"8818\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",33],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"8836\"]]");
    p = add_epsg_def_ex (filter, first, last, 8837, "epsg", 8837,
        "MTRF-2000 / UTM zone 37N", 0, 0,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MTRF-2000 / UTM zone 37N\",GEOGCS[\"MTRF-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MOMRA_Terrestrial_Reference_Frame_2000\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1218\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"8818\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",39],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"8837\"]]");
    p = add_epsg_def_ex (filter, first, last, 8838, "epsg", 8838,
        "MTRF-2000 / UTM zone 38N", 0, 0,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MTRF-2000 / UTM zone 38N\",GEOGCS[\"MTRF-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MOMRA_Terrestrial_Reference_Frame_2000\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1218\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"8818\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",45],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"8838\"]]");
    p = add_epsg_def_ex (filter, first, last, 8839, "epsg", 8839,
        "MTRF-2000 / UTM zone 39N", 0, 0,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MTRF-2000 / UTM zone 39N\",GEOGCS[\"MTRF-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MOMRA_Terrestrial_Reference_Frame_2000\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1218\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"8818\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",51],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"8839\"]]");
    p = add_epsg_def_ex (filter, first, last, 8840, "epsg", 8840,
        "MTRF-2000 / UTM zone 40N", 0, 0,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MTRF-2000 / UTM zone 40N\",GEOGCS[\"MTRF-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MOMRA_Terrestrial_Reference_Frame_2000\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1218\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"8818\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",57],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"8840\"]]");
    p = add_epsg_def_ex (filter, first, last, 8860, "epsg", 8860,
        "NAD83(FBN)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Federal_Base_Network", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(FBN)\",DATUM[\"NAD83_Federal_Base_Network");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1211\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"8860\"]]");
    p = add_epsg_def_ex (filter, first, last, 8888, "epsg", 8888,
        "WGS 84 (Transit)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_Transit", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 84 (Transit)\",DATUM[\"World_Geodetic_Syste");
    add_srs_wkt (p, 1,
        "m_1984_Transit\",SPHEROID[\"WGS 84\",6378137,298.2572235");
    add_srs_wkt (p, 2,
        "63,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 3,
        "66\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"8888\"]]");
    p = add_epsg_def_ex (filter, first, last, 8899, "epsg", 8899,
        "RGWF96", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Wallis_et_Futuna_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGWF96\",DATUM[\"Reseau Geodesique de Wallis e");
    add_srs_wkt (p, 1,
        "t Futuna 1996\",ELLIPSOID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "2101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,AN");
    add_srs_wkt (p, 3,
        "GLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3");
    add_srs_wkt (p, 4,
        "],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEU");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic long");
    add_srs_wkt (p, 6,
        "itude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 7,
        "32925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3");
    add_srs_wkt (p, 8,
        "],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy; air, l");
    add_srs_wkt (p, 9,
        "and and sea navigation and safety of life purposes.\"],A");
    add_srs_wkt (p, 10,
        "REA[\"Wallis and Futuna - onshore and offshore - Uvea, F");
    add_srs_wkt (p, 11,
        "utuna, and Alofi.\"],BBOX[-15.94,179.49,-9.84,-174.27]],");
    add_srs_wkt (p, 12,
        "ID[\"EPSG\",8899]]");
    p = add_epsg_def_ex (filter, first, last, 8900, "epsg", 8900,
        "RGWF96", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Wallis_et_Futuna_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGWF96\",DATUM[\"Reseau_Geodesique_de_Wallis_et");
    add_srs_wkt (p, 1,
        "_Futuna_1996\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"12");
    add_srs_wkt (p, 3,
        "23\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"8900\"]]");
    p = add_epsg_def_ex (filter, first, last, 8901, "epsg", 8901,
        "RGWF96 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Wallis_et_Futuna_1996", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGWF96 (lon-lat)\",DATUM[\"Reseau Geodesique d");
    add_srs_wkt (p, 1,
        "e Wallis et Futuna 1996\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic longitude (Lon)\",east,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic latitude (Lat)\",north,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"GIS.\"");
    add_srs_wkt (p, 9,
        "],AREA[\"Wallis and Futuna - onshore and offshore - Uvea");
    add_srs_wkt (p, 10,
        ", Futuna, and Alofi.\"],BBOX[-15.94,179.49,-9.84,-174.27");
    add_srs_wkt (p, 11,
        "]],ID[\"EPSG\",8901]]");
    p = add_epsg_def_ex (filter, first, last, 8902, "epsg", 8902,
        "RGWF96 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Wallis_et_Futuna_1996", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGWF96 (lon-lat)\",DATUM[\"Reseau_Geodesique_de");
    add_srs_wkt (p, 1,
        "_Wallis_et_Futuna_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1223\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Longitude\",EAST],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AUTHORITY[\"EPSG\",\"8902\"]]");
    p = add_epsg_def_ex (filter, first, last, 8903, "epsg", 8903,
        "RGWF96 / UTM zone 1S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Wallis_et_Futuna_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGWF96 / UTM zone 1S\",GEOGCS[\"RGWF96\",DATUM[");
    add_srs_wkt (p, 1,
        "\"Reseau_Geodesique_de_Wallis_et_Futuna_1996\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"1223\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"8900\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-177],PARAMETER[\"scale_factor\",0.9996],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"8903\"]]");
    p = add_epsg_def_ex (filter, first, last, 8906, "epsg", 8906,
        "CR-SIRGAS", 1, 1,
        "GRS 1980", "Greenwich",
        "CR-SIRGAS", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"CR-SIRGAS\",DATUM[\"CR-SIRGAS\",ELLIPSOID[\"GR");
    add_srs_wkt (p, 1,
        "S 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]]");
    add_srs_wkt (p, 2,
        ",PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 3,
        "5199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (La");
    add_srs_wkt (p, 4,
        "t)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],AN");
    add_srs_wkt (p, 6,
        "GLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoid");
    add_srs_wkt (p, 7,
        "al height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USA");
    add_srs_wkt (p, 8,
        "GE[SCOPE[\"Geodesy.\"],AREA[\"Costa Rica - onshore and o");
    add_srs_wkt (p, 9,
        "ffshore.\"],BBOX[2.15,-90.45,11.77,-81.43]],ID[\"EPSG\",");
    add_srs_wkt (p, 10,
        "8906]]");
    p = add_epsg_def_ex (filter, first, last, 8907, "epsg", 8907,
        "CR-SIRGAS", 1, 1,
        "GRS 1980", "Greenwich",
        "CR-SIRGAS", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CR-SIRGAS\",DATUM[\"CR-SIRGAS\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 1,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"1225\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"89");
    add_srs_wkt (p, 6,
        "07\"]]");
    p = add_epsg_def_ex (filter, first, last, 8908, "epsg", 8908,
        "CR-SIRGAS / CRTM05", 0, 0,
        "GRS 1980", "Greenwich",
        "CR-SIRGAS", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CR-SIRGAS / CRTM05\",GEOGCS[\"CR-SIRGAS\",DATUM");
    add_srs_wkt (p, 1,
        "[\"CR-SIRGAS\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"12");
    add_srs_wkt (p, 3,
        "25\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"8907\"]],PROJECTION[\"T");
    add_srs_wkt (p, 6,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",-84],PARAMETER[\"scale_");
    add_srs_wkt (p, 8,
        "factor\",0.9999],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 10,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 11,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"8908\"]]");
    p = add_epsg_def_ex (filter, first, last, 8909, "epsg", 8909,
        "CR-SIRGAS / UTM zone 16N", 0, 0,
        "GRS 1980", "Greenwich",
        "CR-SIRGAS", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CR-SIRGAS / UTM zone 16N\",GEOGCS[\"CR-SIRGAS\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"CR-SIRGAS\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1225\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"8907\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",-87],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"8909\"]]");
    p = add_epsg_def_ex (filter, first, last, 8910, "epsg", 8910,
        "CR-SIRGAS / UTM zone 17N", 0, 0,
        "GRS 1980", "Greenwich",
        "CR-SIRGAS", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CR-SIRGAS / UTM zone 17N\",GEOGCS[\"CR-SIRGAS\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"CR-SIRGAS\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1225\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"8907\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",-81],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"8910\"]]");
    p = add_epsg_def_ex (filter, first, last, 8912, "epsg", 8912,
        "CR-SIRGAS / CRTM05", 0, 0,
        "GRS 1980", "Greenwich",
        "CR-SIRGAS", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"CR-SIRGAS / CRTM05 + DACR52 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "CR-SIRGAS / CRTM05\",GEOGCS[\"CR-SIRGAS\",DATUM[\"CR-SIR");
    add_srs_wkt (p, 2,
        "GAS\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1225\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"8907\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-84],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9999],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"8908\"]],VERT_CS[\"DACR52 height");
    add_srs_wkt (p, 13,
        "\",VERT_DATUM[\"Datum Altimetrico de Costa Rica 1952\",2");
    add_srs_wkt (p, 14,
        "005,AUTHORITY[\"EPSG\",\"1226\"]],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 15,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\"");
    add_srs_wkt (p, 16,
        ",UP],AUTHORITY[\"EPSG\",\"8911\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "8912\"]]");
    p = add_epsg_def_ex (filter, first, last, 8916, "epsg", 8916,
        "SIRGAS-CON DGF00P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF00P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON DGF00P01\",DYNAMIC[FRAMEEPOCH[2000.");
    add_srs_wkt (p, 1,
        "4]],DATUM[\"SIRGAS Continuously Operating Network DGF00P");
    add_srs_wkt (p, 2,
        "01\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTH");
    add_srs_wkt (p, 3,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"ge");
    add_srs_wkt (p, 5,
        "odetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)");
    add_srs_wkt (p, 7,
        "\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 8,
        "]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNI");
    add_srs_wkt (p, 9,
        "T[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin A");
    add_srs_wkt (p, 10,
        "merica - Central America and South America, onshore and ");
    add_srs_wkt (p, 11,
        "offshore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPS");
    add_srs_wkt (p, 12,
        "G\",8916]]");
    p = add_epsg_def_ex (filter, first, last, 8918, "epsg", 8918,
        "SIRGAS-CON DGF01P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF01P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON DGF01P01\",DYNAMIC[FRAMEEPOCH[2000]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network DGF01P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8918]]");
    p = add_epsg_def_ex (filter, first, last, 8920, "epsg", 8920,
        "SIRGAS-CON DGF01P02", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF01P02", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON DGF01P02\",DYNAMIC[FRAMEEPOCH[1998.");
    add_srs_wkt (p, 1,
        "4]],DATUM[\"SIRGAS Continuously Operating Network DGF01P");
    add_srs_wkt (p, 2,
        "02\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTH");
    add_srs_wkt (p, 3,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"ge");
    add_srs_wkt (p, 5,
        "odetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)");
    add_srs_wkt (p, 7,
        "\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 8,
        "]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNI");
    add_srs_wkt (p, 9,
        "T[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin A");
    add_srs_wkt (p, 10,
        "merica - Central America and South America, onshore and ");
    add_srs_wkt (p, 11,
        "offshore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPS");
    add_srs_wkt (p, 12,
        "G\",8920]]");
    p = add_epsg_def_ex (filter, first, last, 8922, "epsg", 8922,
        "SIRGAS-CON DGF02P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF02P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON DGF02P01\",DYNAMIC[FRAMEEPOCH[2000]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network DGF02P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8922]]");
    p = add_epsg_def_ex (filter, first, last, 8924, "epsg", 8924,
        "SIRGAS-CON DGF04P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF04P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON DGF04P01\",DYNAMIC[FRAMEEPOCH[2003]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network DGF04P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8924]]");
    p = add_epsg_def_ex (filter, first, last, 8926, "epsg", 8926,
        "SIRGAS-CON DGF05P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF05P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON DGF05P01\",DYNAMIC[FRAMEEPOCH[2004]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network DGF05P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8926]]");
    p = add_epsg_def_ex (filter, first, last, 8928, "epsg", 8928,
        "SIRGAS-CON DGF06P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF06P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON DGF06P01\",DYNAMIC[FRAMEEPOCH[2004]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network DGF06P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8928]]");
    p = add_epsg_def_ex (filter, first, last, 8930, "epsg", 8930,
        "SIRGAS-CON DGF07P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF07P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON DGF07P01\",DYNAMIC[FRAMEEPOCH[2004.");
    add_srs_wkt (p, 1,
        "5]],DATUM[\"SIRGAS Continuously Operating Network DGF07P");
    add_srs_wkt (p, 2,
        "01\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTH");
    add_srs_wkt (p, 3,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"ge");
    add_srs_wkt (p, 5,
        "odetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)");
    add_srs_wkt (p, 7,
        "\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 8,
        "]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNI");
    add_srs_wkt (p, 9,
        "T[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin A");
    add_srs_wkt (p, 10,
        "merica - Central America and South America, onshore and ");
    add_srs_wkt (p, 11,
        "offshore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPS");
    add_srs_wkt (p, 12,
        "G\",8930]]");
    p = add_epsg_def_ex (filter, first, last, 8932, "epsg", 8932,
        "SIRGAS-CON DGF08P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF08P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON DGF08P01\",DYNAMIC[FRAMEEPOCH[2004.");
    add_srs_wkt (p, 1,
        "5]],DATUM[\"SIRGAS Continuously Operating Network DGF08P");
    add_srs_wkt (p, 2,
        "01\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTH");
    add_srs_wkt (p, 3,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"ge");
    add_srs_wkt (p, 5,
        "odetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)");
    add_srs_wkt (p, 7,
        "\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 8,
        "]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNI");
    add_srs_wkt (p, 9,
        "T[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin A");
    add_srs_wkt (p, 10,
        "merica - Central America and South America, onshore and ");
    add_srs_wkt (p, 11,
        "offshore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPS");
    add_srs_wkt (p, 12,
        "G\",8932]]");
    p = add_epsg_def_ex (filter, first, last, 8934, "epsg", 8934,
        "SIRGAS-CON SIR09P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR09P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON SIR09P01\",DYNAMIC[FRAMEEPOCH[2005]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network SIR09P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8934]]");
    p = add_epsg_def_ex (filter, first, last, 8936, "epsg", 8936,
        "SIRGAS-CON SIR10P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR10P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON SIR10P01\",DYNAMIC[FRAMEEPOCH[2005]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network SIR10P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8936]]");
    p = add_epsg_def_ex (filter, first, last, 8938, "epsg", 8938,
        "SIRGAS-CON SIR11P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR11P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON SIR11P01\",DYNAMIC[FRAMEEPOCH[2005]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network SIR11P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8938]]");
    p = add_epsg_def_ex (filter, first, last, 8940, "epsg", 8940,
        "SIRGAS-CON SIR13P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR13P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON SIR13P01\",DYNAMIC[FRAMEEPOCH[2012]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network SIR13P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8940]]");
    p = add_epsg_def_ex (filter, first, last, 8942, "epsg", 8942,
        "SIRGAS-CON SIR14P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR14P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON SIR14P01\",DYNAMIC[FRAMEEPOCH[2013]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network SIR14P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8942]]");
    p = add_epsg_def_ex (filter, first, last, 8944, "epsg", 8944,
        "SIRGAS-CON SIR15P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR15P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON SIR15P01\",DYNAMIC[FRAMEEPOCH[2013]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network SIR15P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8944]]");
    p = add_epsg_def_ex (filter, first, last, 8946, "epsg", 8946,
        "SIRGAS-CON SIR17P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR17P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-CON SIR17P01\",DYNAMIC[FRAMEEPOCH[2015]");
    add_srs_wkt (p, 1,
        "],DATUM[\"SIRGAS Continuously Operating Network SIR17P01");
    add_srs_wkt (p, 2,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 3,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 4,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 5,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 7,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 8,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Latin Ameri");
    add_srs_wkt (p, 10,
        "ca - Central America and South America, onshore and offs");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "8946]]");
    p = add_epsg_def_ex (filter, first, last, 8948, "epsg", 8948,
        "SIRGAS-Chile 2010", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_2_epoch_2010", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-Chile 2010\",DATUM[\"SIRGAS-Chile reali");
    add_srs_wkt (p, 1,
        "zation 2 epoch 2010\",ELLIPSOID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 4,
        "dal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],A");
    add_srs_wkt (p, 5,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic");
    add_srs_wkt (p, 6,
        " longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.");
    add_srs_wkt (p, 7,
        "0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,OR");
    add_srs_wkt (p, 8,
        "DER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"");
    add_srs_wkt (p, 9,
        "],AREA[\"Chile - onshore and offshore. Includes Easter I");
    add_srs_wkt (p, 10,
        "sland, Juan Fernandez Islands, San Felix, and Sala y Gom");
    add_srs_wkt (p, 11,
        "ez.\"],BBOX[-59.87,-113.21,-17.5,-65.72]],ID[\"EPSG\",89");
    add_srs_wkt (p, 12,
        "48]]");
    p = add_epsg_def_ex (filter, first, last, 8949, "epsg", 8949,
        "SIRGAS-Chile 2010", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_2_epoch_2010", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-Chile 2010\",DATUM[\"SIRGAS-Chile_realiz");
    add_srs_wkt (p, 1,
        "ation_2_epoch_2010\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1243\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"8949\"]]");
    p = add_epsg_def_ex (filter, first, last, 8950, "epsg", 8950,
        "SIRGAS-Chile 2010 / UTM zone 18S", 0, 0,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_2_epoch_2010", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-Chile 2010 / UTM zone 18S\",GEOGCS[\"SIR");
    add_srs_wkt (p, 1,
        "GAS-Chile 2010\",DATUM[\"SIRGAS-Chile_realization_2_epoc");
    add_srs_wkt (p, 2,
        "h_2010\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1243\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"8949\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-75],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"8950\"]]");
    p = add_epsg_def_ex (filter, first, last, 8951, "epsg", 8951,
        "SIRGAS-Chile 2010 / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_2_epoch_2010", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-Chile 2010 / UTM zone 19S\",GEOGCS[\"SIR");
    add_srs_wkt (p, 1,
        "GAS-Chile 2010\",DATUM[\"SIRGAS-Chile_realization_2_epoc");
    add_srs_wkt (p, 2,
        "h_2010\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1243\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"8949\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-69],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"8951\"]]");
    p = add_epsg_def_ex (filter, first, last, 8972, "epsg", 8972,
        "SIRGAS-CON DGF00P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF00P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON DGF00P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_DGF00P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1227\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8972\"]]");
    p = add_epsg_def_ex (filter, first, last, 8973, "epsg", 8973,
        "SIRGAS-CON DGF01P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF01P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON DGF01P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_DGF01P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1228\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8973\"]]");
    p = add_epsg_def_ex (filter, first, last, 8974, "epsg", 8974,
        "SIRGAS-CON DGF01P02", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF01P02", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON DGF01P02\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_DGF01P02\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1229\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8974\"]]");
    p = add_epsg_def_ex (filter, first, last, 8975, "epsg", 8975,
        "SIRGAS-CON DGF02P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF02P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON DGF02P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_DGF02P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8975\"]]");
    p = add_epsg_def_ex (filter, first, last, 8976, "epsg", 8976,
        "SIRGAS-CON DGF04P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF04P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON DGF04P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_DGF04P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1231\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8976\"]]");
    p = add_epsg_def_ex (filter, first, last, 8977, "epsg", 8977,
        "SIRGAS-CON DGF05P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF05P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON DGF05P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_DGF05P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1232\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8977\"]]");
    p = add_epsg_def_ex (filter, first, last, 8978, "epsg", 8978,
        "SIRGAS-CON DGF06P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF06P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON DGF06P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_DGF06P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1233\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8978\"]]");
    p = add_epsg_def_ex (filter, first, last, 8979, "epsg", 8979,
        "SIRGAS-CON DGF07P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF07P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON DGF07P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_DGF07P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1234\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8979\"]]");
    p = add_epsg_def_ex (filter, first, last, 8980, "epsg", 8980,
        "SIRGAS-CON DGF08P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_DGF08P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON DGF08P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_DGF08P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1235\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8980\"]]");
    p = add_epsg_def_ex (filter, first, last, 8981, "epsg", 8981,
        "SIRGAS-CON SIR09P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR09P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON SIR09P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_SIR09P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1236\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8981\"]]");
    p = add_epsg_def_ex (filter, first, last, 8982, "epsg", 8982,
        "SIRGAS-CON SIR10P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR10P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON SIR10P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_SIR10P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1237\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8982\"]]");
    p = add_epsg_def_ex (filter, first, last, 8983, "epsg", 8983,
        "SIRGAS-CON SIR11P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR11P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON SIR11P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_SIR11P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1238\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8983\"]]");
    p = add_epsg_def_ex (filter, first, last, 8984, "epsg", 8984,
        "SIRGAS-CON SIR13P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR13P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON SIR13P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_SIR13P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1239\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8984\"]]");
    p = add_epsg_def_ex (filter, first, last, 8985, "epsg", 8985,
        "SIRGAS-CON SIR14P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR14P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON SIR14P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_SIR14P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1240\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8985\"]]");
    p = add_epsg_def_ex (filter, first, last, 8986, "epsg", 8986,
        "SIRGAS-CON SIR15P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR15P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON SIR15P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_SIR15P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1241\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8986\"]]");
    p = add_epsg_def_ex (filter, first, last, 8987, "epsg", 8987,
        "SIRGAS-CON SIR17P01", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Continuously_Operating_Network_SIR17P01", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-CON SIR17P01\",DATUM[\"SIRGAS_Continuous");
    add_srs_wkt (p, 1,
        "ly_Operating_Network_SIR17P01\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1242\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8987\"]]");
    p = add_epsg_def_ex (filter, first, last, 8988, "epsg", 8988,
        "ITRF88", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1988", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF88\",DATUM[\"International_Terrestrial_Refe");
    add_srs_wkt (p, 1,
        "rence_Frame_1988\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6647\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"8988\"]]");
    p = add_epsg_def_ex (filter, first, last, 8989, "epsg", 8989,
        "ITRF89", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1989", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF89\",DATUM[\"International_Terrestrial_Refe");
    add_srs_wkt (p, 1,
        "rence_Frame_1989\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6648\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"8989\"]]");
    p = add_epsg_def_ex (filter, first, last, 8990, "epsg", 8990,
        "ITRF90", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1990", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF90\",DATUM[\"International_Terrestrial_Refe");
    add_srs_wkt (p, 1,
        "rence_Frame_1990\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6649\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"8990\"]]");
    p = add_epsg_def_ex (filter, first, last, 8991, "epsg", 8991,
        "ITRF91", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF91\",DATUM[\"International_Terrestrial_Refe");
    add_srs_wkt (p, 1,
        "rence_Frame_1991\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6650\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"8991\"]]");
    p = add_epsg_def_ex (filter, first, last, 8992, "epsg", 8992,
        "ITRF92", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF92\",DATUM[\"International_Terrestrial_Refe");
    add_srs_wkt (p, 1,
        "rence_Frame_1992\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6651\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"8992\"]]");
    p = add_epsg_def_ex (filter, first, last, 8993, "epsg", 8993,
        "ITRF93", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF93\",DATUM[\"International_Terrestrial_Refe");
    add_srs_wkt (p, 1,
        "rence_Frame_1993\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6652\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"8993\"]]");
    p = add_epsg_def_ex (filter, first, last, 8994, "epsg", 8994,
        "ITRF94", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF94\",DATUM[\"International_Terrestrial_Refe");
    add_srs_wkt (p, 1,
        "rence_Frame_1994\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6653\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"8994\"]]");
    p = add_epsg_def_ex (filter, first, last, 8995, "epsg", 8995,
        "ITRF96", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF96\",DATUM[\"International_Terrestrial_Refe");
    add_srs_wkt (p, 1,
        "rence_Frame_1996\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6654\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"8995\"]]");
    p = add_epsg_def_ex (filter, first, last, 8996, "epsg", 8996,
        "ITRF97", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF97\",DATUM[\"International_Terrestrial_Refe");
    add_srs_wkt (p, 1,
        "rence_Frame_1997\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6655\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"8996\"]]");
    p = add_epsg_def_ex (filter, first, last, 8997, "epsg", 8997,
        "ITRF2000", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF2000\",DATUM[\"International_Terrestrial_Re");
    add_srs_wkt (p, 1,
        "ference_Frame_2000\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6656\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"8997\"]]");
    p = add_epsg_def_ex (filter, first, last, 8998, "epsg", 8998,
        "ITRF2005", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF2005\",DATUM[\"International_Terrestrial_Re");
    add_srs_wkt (p, 1,
        "ference_Frame_2005\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6896\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"8998\"]]");
    p = add_epsg_def_ex (filter, first, last, 8999, "epsg", 8999,
        "ITRF2008", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_2008", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF2008\",DATUM[\"International_Terrestrial_Re");
    add_srs_wkt (p, 1,
        "ference_Frame_2008\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1061\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"8999\"]]");
    p = add_epsg_def_ex (filter, first, last, 9000, "epsg", 9000,
        "ITRF2014", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_2014", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ITRF2014\",DATUM[\"International_Terrestrial_Re");
    add_srs_wkt (p, 1,
        "ference_Frame_2014\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1165\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"9000\"]]");
    p = add_epsg_def_ex (filter, first, last, 9002, "epsg", 9002,
        "IGS97", 1, 1,
        "GRS 1980", "Greenwich",
        "IGS97", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGS97\",DYNAMIC[FRAMEEPOCH[1997]],DATUM[\"IGS9");
    add_srs_wkt (p, 1,
        "7\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHU");
    add_srs_wkt (p, 2,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 3,
        "gree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geo");
    add_srs_wkt (p, 4,
        "detic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\"");
    add_srs_wkt (p, 6,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[");
    add_srs_wkt (p, 8,
        "\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"]");
    add_srs_wkt (p, 9,
        ",BBOX[-90,-180,90,180]],ID[\"EPSG\",9002]]");
    p = add_epsg_def_ex (filter, first, last, 9003, "epsg", 9003,
        "IGS97", 1, 1,
        "GRS 1980", "Greenwich",
        "IGS97", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGS97\",DATUM[\"IGS97\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 1,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"1244\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 5,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"9003\"]]");
    p = add_epsg_def_ex (filter, first, last, 9005, "epsg", 9005,
        "IGS00", 1, 1,
        "GRS 1980", "Greenwich",
        "IGS00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGS00\",DYNAMIC[FRAMEEPOCH[1998]],DATUM[\"IGS0");
    add_srs_wkt (p, 1,
        "0\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHU");
    add_srs_wkt (p, 2,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 3,
        "gree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geo");
    add_srs_wkt (p, 4,
        "detic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\"");
    add_srs_wkt (p, 6,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[");
    add_srs_wkt (p, 8,
        "\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"]");
    add_srs_wkt (p, 9,
        ",BBOX[-90,-180,90,180]],ID[\"EPSG\",9005]]");
}

#endif /* full EPSG initialization enabled/disabled */

