1.1 Live-Coding

# Live-Coding

Mit Sonic Pi kannst Du etwas sehr aufregendes tun: Du kannst Musik
aus Code live schreiben und *verändern, während sie spielt*. Fast so,
als wenn Du mit einer Gitarre Musik machst. Mit anderen Worten: Du
kannst Sonic Pi mit auf die Bühne nehmen und jammen!

## Mach mal kurz den Kopf frei

Wir werden in diesem Tutorial in die Details von Sonic Pi
eintauchen. Jetzt möchte ich Dir aber erst einmal zeigen, wie das ist,
live Musik zu coden. Keine Sorge, Du wirst vielleicht nicht sofort
alles verstehen. Aber das macht nichts. Genieße kurz diesen Einblick.

## Eine Live-Loop

Lass uns loslegen. Kopiere den folgenden Code nach oben in einen leeren
Buffer:

```
live_loop :flibble do
  sample :bd_haus, rate: 1
  sleep 0.5
end
```

Jetzt drücke den `Ausführen`-Button und Du wirst eine schöne Bass-Drum
hören, die schnell vor sich hin hämmert. Mit einem Druck auf den
`Stopp`-Button hört die Musik wieder auf. Aber drücke bitte noch nicht
darauf... sondern probiere die folgenden Veränderungen aus:

1. Lass den Beat der Bass-Drum weiter laufen.
2. Verändere die Zahl hinter `sleep` von `0.5` auf einen höheren Wert, etwa `1`. 
3. Drücke wieder den `Ausführen`-Button.
4. Gemerkt? Die Geschwindigkeit der Bass-Drum hat sich verändert.
5. *Merke Dir diesen Moment.* Du hast mit Sonic Pi zum ersten Mal live
   Code geschrieben. Wahrscheinlich wird es nicht das letzte Mal
   sein...

Ok, das war einfach. Verändern wir also die Zutaten ein wenig. Vor
`sample :bd_haus` kannst Du die Zeile `sample :ambi_choir, rate: 0.3`
einfügen. Dein Code müsste dann so aussehen:

```
live_loop :flibble do
  sample :ambi_choir, rate: 0.3
  sample :bd_haus, rate: 1
  sleep 1
end
```

So, jetzt spiele damit herum. Verändere die Werte für `rate:` - was
passiert, wenn Du hohe, kleine oder negative Zahlen einträgst? Hast
Du gemerkt, wie sich eine sehr kleine Änderung des `rate:`-Wertes
für das `:ambi_choir`-Sample auswirkt (z.B. 0.29)? Was passiert bei
einem wirklich kleinen `sleep`-Wert? Kannst Du eine Fehlermeldung
Deines Computers auslösen, wenn Du den Wert immer kleiner werden lässt?
(Wenn das geschieht, nimm einfach wieder einen größeren Wert für `sleep`
und drücke auf `Ausführen`.)

Kommentiere eine Code-Zeile aus, indem Du ein `#` an ihren Anfang
schreibst:

```
live_loop :flibble do
  sample :ambi_choir, rate: 0.3
#  sample :bd_haus, rate: 1
  sleep 1
end
```

Siehst Du? Jetzt ignoriert der Computer diese Zeile und wir hören den
Befehl nicht mehr. Was hinter einem `#` steht ist ein Kommentar. Wir
können dieses Zeichen benutzen, um Code schnell zu entfernen und später
wieder einzufügen.

Zum Abschluss möchte ich Dir etwas zum Spielen geben. Nimm den Code 
unten und kopiere ihn in einen freien Buffer. Macht nix, Du musst noch 
nicht alles davon durchschauen, aber Du siehst, dass da zwei Loops sind 
- zwei Schleifen, die gleichzeitig laufen und sich endlos wiederholen. 
Jetzt tue, was Du am besten kannst: Experimentiere und spiele herum. 
Hier sind ein paar Vorschläge:

* Ändere die blauen Werte hinter `rate:` und höre zu, wie sich das
  Sample verändert.
* Ändere die Zeitwerte von `sleep` und beobachte, wie die beiden
  Schleifen in unterschiedlicher Weise aneinander vorbei laufen.
* Hole die auskommentierte Sample-Zeile wieder hervor und genieße
  den Sound einer umgekehrt abgespielten Gitarre.
* Probiere, die blauen Werte von `mix:` auf Werte zwischen `0`
  (nicht im Mix) und `1` (voll im Mix) zu ändern.

Vergiss nicht, `Ausführen` zu drücken, dann hörst Du sofort beim
nächsten Durchlauf der Loops Deine Änderungen. Wenn irgendwas schiefgeht
- macht nichts! Drücke `Stopp`, lösche den kaputten Code und fang mit dem 
ursprünglichen Code noch einmal von vorn an. Denn am besten lernt man
beim Fehlermachen...


```
live_loop :guit do
  with_fx :echo, mix: 0.3, phase: 0.25 do
    sample :guit_em9, rate: 0.5
  end
#  sample :guit_em9, rate: -0.5
  sleep 8
end

live_loop :boom do
  with_fx :reverb, room: 1 do
    sample :bd_boom, amp: 10, rate: 1
  end
  sleep 8
end
```

Spiele also herum und experimentiere, bis Deine Neugierde einsetzt und
Du Dich fragst, wie das hier alles eigentlich wirklich funktioniert und
was man noch so alles damit anstellen kann. Jetzt bist Du bereit für
den Rest dieses Tutorials.

Worauf wartest Du...?
