5.3 条件文

# 条件文

やってみたいと思うことのひとつに、ランダムに音を出すこと（前章参照）だけでなく、いくつかのコードをランダムに決め、それを選択していくというアイデアも出てくると思います。例えば、ドラムとシンバルをランダムに鳴らしたい場合、`if`という言葉を使うとこれを実現できるようになります。

## コイントス

それではコインをトス（投げる）してみましょう。もしもコインが表であればドラムを鳴らし、裏であればシンバルを鳴らします。簡単ですね。コイントスの機能は `one_in` という機能（ランダムのセクションで紹介しています）によって実現されます。2つのうちの1つというように条件を細かく指定するときには `one_in(2)`と記述すると、ドラムを鳴らすコードとシンバルを鳴らす2つのコードどちらかを決められるようになります。

```
loop do

 if one_in(2)
   sample :drum_heavy_kick
 else
   sample :drum_cymbal_closed
 end
  sleep 0.5
 end
```

if文は3つのパートを持っていることに注目してみましょう。

* 条件付け
* はじめの選択によって実行されるコード（条件が正しかった場合）
* 次の選択によって実行されるコード（条件が間違っていた場合）

典型的なプログラム言語では、概ね、真（正しいという意味）を`true`で表現し、偽（正しくない場合）は`false`と表記します。そのため、 `one_in` 対する明確な回答として、`true`か`false`かを選択できる質問が必要となります。

はじめの選択では `if` と `else` の間に挟まれたプログラムが実行され、そして2番目の選択では`else` と `end`の間が実行されるということに注目しましょう。それは複数行のコードをまとめる*do/end*ブロックにとても似ていますね。例えば、

```
loop do

 if one_in(2)
   sample :drum_heavy_kick
   sleep 0.5
 else
   sample :drum_cymbal_closed
   sleep 0.25
 end

end
```

`sleep 0.5`や`sleep 0.25`など、異なる休符時間を持つ場合、そのどちらかに応じることになります。

## Simple if

時には、任意のコードを1行だけ実行したいときがあるでしょう。これもifとその後ろに条件を記述することで可能です。例えば、

```
use_synth :dsaw

loop do
 play 50, amp: 0.3, release: 2
 play 53, amp: 0.3, release: 2 if one_in(2)
 play 57, amp: 0.3, release: 2 if one_in(3)
 play 60, amp: 0.3, release: 2 if one_in(4)
 sleep 1.5
end
```

上のコードでは、それぞれの音符が持つ別の確率によって、異なる数のコード(和音)を奏でるでしょう。
