3.6 External Samples

# External Samples

Whilst the built-in samples can get you up and started quickly, you
might wish to experiment with other recorded sounds in your music. Sonic
Pi totally supports this. First though, let's have a quick discussion on
the portability of your piece.

## Portability

When you compose your piece purely with built-in synths and samples, the
code is all you need to faithfully reproduce your music. Think about
that for a moment - that's amazing! A simple piece of text you can email
around or stick in a [Gist](https://gist.github.com) represents
everything you need to reproduce your sounds. That makes it *really easy
to share* with your friends as they just need to get hold of the code.

However, if you start using your own pre-recorded samples, you lose this
portability. This is because to reproduce your music other people not
only need your code, they need your samples too. This limits the ability
for others to manipulate, mash-up and experiment with your work. Of
course this shouldn't stop you from using your own samples, it's just
something to consider.

## Local Samples

So how do you play any arbitrary WAV, AIFF or FLAC file on your computer?
All you need to do is pass the path of that file to `sample`:

```
# Raspberry Pi, Mac, Linux
sample "/Users/sam/Desktop/my-sound.wav"
# Windows
sample "C:/Users/sam/Desktop/my-sound.wav"
```

Sonic Pi will automatically load and play the sample. You can also pass
all the standard params you're used to passing `sample`:

```
# Raspberry Pi, Mac, Linux
sample "/Users/sam/Desktop/my-sound.wav", rate: 0.5, amp: 0.3
# Windows
sample "C:/Users/sam/Desktop/my-sound.wav", rate: 0.5, amp: 0.3
```

