3.3 Samples dehnen

# Samples dehnen

Jetzt können wir schon eine ganze Menge Synths und Samples spielen, um 
damit Musik zu machen. Es wird Zeit zu lernen, wie wir diese Synths und 
Samples verändern können. Das macht unsere Musik einzigartiger und 
spannender. Als erstes sehen wir uns an, wie wir Samples *strecken* und 
*stauchen* können.

## Wie Samples Klänge darstellen

Samples sind aufgenommene Klänge und werden als eine Zahlenreihe von
Messwerten (deshalb "Sample") gespeichert. Diese Zahlen sagen der
Lautsprechermembran, wie sie sich bewegen muss, um den Klang
wiederzugeben. Die Lautsprechermembran kann sich nach innen und nach
außen bewegen und die Zahlen geben deshalb an, wie weit sich die
Membran zu jedem Zeitpunkt nach innen oder außen bewegen soll.
Um einen Klang als Aufnahme wirklichkeitsgetreu wiederzugeben,
muss das Sample je Sekunde viele tausend Zahlen speichern. Sonic Pi
nimmt diese Zahlenreihe und gibt sie in der richtigen Samplerate
[^7] an den Lautsprecher in Deinem Computer, so dass der Klang richtig
wiedergegeben wird. Es macht aber auch Spaß, die Samplerate zu
beeinflussen, denn das verändert den Klang.

## Die Samplerate ändern

Lass uns mit einem der Ambient-Klänge spielen: `ambi_choir`. Um diesen 
mit Standard-Samplerate wiederzugeben, kannst Du dem `sample` das 
Argument[^8] `rate:` übergeben:

```
sample :ambi_choir, rate: 1
```

Das Sample wird unverändert mit der normalen Samplerate (1) abgespielt,
also nichts Besonderes. Aber wir können die Zahl jederzeit verändern.
Was passiert bei `0.5`?

```
sample :ambi_choir, rate: 0.5
```

Wow! Was ist denn jetzt los? Also, hier passieren zwei Dinge. Erstens 
braucht das Sample doppelt so lange und zweitens klingt er eine Oktave 
niedriger. Sehen wir uns das mal genauer an.

## Lasst uns stretchen

Mit dem Amen-Break-Sample macht das strecken und zusammenstauchen 
besonders viel Spass. Mit der normalen Samplerate passt das Sample
gut in einen *Drum 'n' Bass*-Track:

```
sample :loop_amen
```

Wenn wir die Samplerate ändern, dann können wir die Stilrichtungen 
wechseln. Versuche es mal mit halber Samplerate für *Hip-Hop der alten 
Schule*:

```
sample :loop_amen, rate: 0.5
```

Wenn wir es beschleunigen, betreten wir das *Jungle*-Territorium:

```
sample :loop_amen, rate: 1.5
```

Und als letzten Trick - sehen wir mal, was passiert, wenn wir eine 
negative Rate angeben:

```
sample :loop_amen, rate: -1
```

Boah! Er wird *rückwärts* gespielt! Jetzt probiere mit vielen 
unterschiedlichen Samples und unterschiedlichen Sampleraten herum.
Versuch es mit sehr hohen oder mit verrückt langsamen. Finde heraus, 
welche spannenden Klänge Du damit produzieren kannst.

## Eine einfache Erklärung der Samplerate

Man kann sich Samples gut als Sprungfedern vorstellen. Wenn man die 
Samplerate verändert, ist das so, als ob man die Feder zusammendrückt 
oder auseinanderzieht. Wenn Du ein Sample mit der doppelten Samplerate 
abspielst, dann drückst Du die Feder zusammen, bis sie nur noch die 
Hälfte ihrer normalen Länge hat. Das Sample braucht also auch nur die 
Hälfte der Abspielzeit. Wenn Du das Sample mit halber Samplerate 
spielst, dann ziehst Du die Feder auf ihre doppelte Länge auseinander. 
Das Sample dauert also nun doppelt so lange. Je mehr Du zusammendrückst 
(höhere Rate), desto kürzer das Sample, je mehr Du auseinanderziehst 
(geringere Rate), desto länger dauert das Sample.

Wenn man eine Feder zusammendrückt, dann erhöht man ihre Dichtheit (die 
Anzahl der Windungen je Zentimeter) - das ist so ähnlich wie bei einem 
Sample, der *höher klingt*. Wenn man die Feder auseinanderzieht, dann 
verringert sich ihre Dichtheit, vergleichbar einem Klang, der tiefer 
klingt.

## Die Mathematik hinter der Samplerate

(Dieser Abschnitt ist für diejenigen, die es genauer wissen möchten. 
Wenn nicht, könnt Ihr den gerne überspringen...)

Wie wir oben gesehen haben, wird ein Sample durch eine lange Liste von 
Zahlen dargestellt, die der Lautsprechermembran sagen, wo sie zu welchem 
Zeitpunkt sein soll. Wir können diese Zahlenliste nehmen und eine Kurve 
zeichnen, die ungefähr so aussieht:

![sample graph](../images/tutorial/sample.png)

Vielleicht hast Du Bilder wie dieses schon einmal gesehen. Das ist die 
*Kurvenform* eines Sample. Es ist bloß eine Kurve, die aus Zahlen 
gebildet ist. Typischerweise wird eine solche Kurve aus 44100 
Datenpunkten je Sekunde gebildet (das hat mit dem 
Nyquist-Shannon-Abtasttheorem zu tun). Wenn also das Sample 2 Sekunden 
dauert, dann wird die Kurve aus 88200 Zahlen gebildet, die wir an den 
Lautsprecher mit einer Datenrate von 44100 Datenpunkten pro Sekunde 
senden. Natürlich könnten wir es mit der doppelten Datenrate senden, 
also 88200 Datenpunkten pro Sekunde. Dann würde das Sample nur eine 
Sekunde lang dauern. Wir können es auch mit der halben Datenrate 
abspielen; das wären dann 22050 Datenpunkte pro Sekunde und würde 4 
Sekunden dauern.

Die Dauer des Sample ist also abhängig von der Datenrate:

* Wird die Abtastrate verdoppelt, halbiert das die Abspielzeit,
* wird die Abtastrate halbiert, dann verdoppelt sich die Abspielzeit.
* Verwendest Du eine Abtastrate von einem Viertel, dann vervierfachst Du die Abspielzeit,
* verwendest Du eine Abtastrate von 1/10, dann dauert die Abspielzeit 10mal länger.

Wir können das in einer Formel zusammenfassen:

```
neue_sample_dauer = (1 / rate) * sample_dauer
```

Eine Veränderung der Samplerate beeinflusst auch die Tonhöhen des
Samples. Die Frequenz oder Tonhöhe einer Kurve wird dadurch 
bestimmt, wie schnell sie hoch und runter geht. Unsere Gehirne machen 
aus schnellen Bewegungen einer Lautsprechermembran hohe Töne und aus 
langsamen tiefe. Deshalb kannst Du manchmal sogar sehen, wie sich ein 
großer Basslautsprecher bewegt, wenn ein sehr tiefer Ton rauskommt. Er 
bewegt sich dann wesentlich langsamer als ein Lautsprecher, der hohe 
Töne wiedergibt.

Wenn Du eine Kurve nimmst und sie zusammendrückst, wird sie je 
Sekunde öfter hoch und runter gehen als vorher. Der Ton wird dann auch 
höher sein. Wenn man die Auf- und Abbewegungen je Sekunde verdoppelt 
(Oszillationen), dann wird die Frequenz, die Tonhöhe, verdoppelt. Also, 
*wenn Du Dein Sample mit doppelter Samplerate abspielst, wird es 
auch doppelt so hoch klingen*; andererseits: *eine Halbierung der 
Samplerate wird auch die Frequenz halbieren*. Andere Sampleraten werden 
dementsprechend die Tonhöhe beinflussen.

[^7]: Die Samplerate heißt auch Samplingrate oder Abtastrate; *rate* 
    steht für die Frequenz, mit der Sonic Pi die Zahlen, die im Sample
    den Klang darstellen, an die Lautsprechermembran sendet.

[^8]: *Argument* ist ein anderer Begriff für *Parameter*; an dieser 
    Stelle bedeuten beide Begriffe dasselbe.
