#!/usr/bin/env python
"""Installs SimpleParse using distutils

Run:
	python setup.py install
to install the packages from the source archive.
"""
from distutils.command.install_data import install_data
from distutils.core import Extension
from distutils.sysconfig import *
from distutils.core import setup
import os, sys, string

def isPackage( filename ):
	return os.path.isdir(filename) and os.path.isfile( os.path.join(filename,'__init__.py'))
def packagesFor( filename, basePackage="" ):
	"""Find all packages in filename"""
	set = {}
	for item in os.listdir(filename):
		dir = os.path.join(filename, item)
		if string.lower(item) != 'cvs' and isPackage( dir ):
			if basePackage:
				moduleName = basePackage+'.'+item
			else:
				moduleName = item
			set[ moduleName] = dir
			set.update( packagesFor( dir, moduleName))
	return set
def npFilesFor( dirname, baseDirectory=None ):
	"""Return all non-python-file filenames in dir"""
	result = []
	allResults = []
	badExtensions = (
		'.py','.pyc','.pyo', '.scc','.exe','.zip','.gz', '.def','.so',
		'.c','.h','.pkg','.in',
	)
	for name in os.listdir(dirname):
		path = os.path.join( dirname, name )
		if os.path.isfile( path) and string.lower(os.path.splitext( name )[1]) not in badExtensions:
			result.append( path )
		elif os.path.isdir( path ) and name.lower() !='cvs':
			allResults.extend( npFilesFor(path,baseDirectory))
	if result:
		if baseDirectory is not None:
			dirname = os.path.join( baseDirectory, dirname )
		allResults.append( (dirname, result))
	return allResults

##############
## Following is from Pete Shinners,
## apparently it will work around the reported bug on
## some unix machines where the data files are copied
## to weird locations if the user's configuration options
## were entered during the wrong phase of the moon :) .
from distutils.command.install_data import install_data
class smart_install_data(install_data):
	def run(self):
		#need to change self.install_dir to the library dir
		install_cmd = self.get_finalized_command('install')
		self.install_dir = getattr(install_cmd, 'install_lib')
		return install_data.run(self)
##############

packages = packagesFor( ".", 'simpleparse' )
packages.update( {'simpleparse':'.'} )

dataFiles = (
	# XXX ick this is messy!
	npFilesFor( 'doc','simpleparse' ) + 
	npFilesFor( 'stt','simpleparse' )
)
if __name__ == "__main__":
	from sys import hexversion
	if hexversion >= 0x2030000:
		# work around distutils complaints under Python 2.2.x
		extraArguments = {
			'classifiers': [
				"""Programming Language :: Python""",
				"""Topic :: Software Development :: Libraries :: Python Modules""",
				"""Intended Audience :: Developers""",
			],
			'keywords': 'parse,parser,parsing,text,ebnf,grammar,generator',
			'long_description' : """A Parser Generator for Python (w/mxTextTools derivative)

Provides a moderately fast parser generator for use with Python,
includes a forked version of the mxTextTools text-processing library
modified to eliminate recursive operation and fix a number of 
undesirable behaviours.

Converts EBNF grammars directly to single-pass parsers for many
largely deterministic grammars.
""",
			'platforms': ['Any'],
		}
	else:
		extraArguments = {
		}
	setup (
		name = "SimpleParse",
		version = "2.1.0a1",
		description = "A Parser Generator for Python (w/mxTextTools derivative)",
		author = "Mike C. Fletcher",
		author_email = "mcfletch@users.sourceforge.net",
		url = "http://simpleparse.sourceforge.net/",

		package_dir = packages,

		packages = packages.keys(),
		data_files = dataFiles,
		cmdclass = {'install_data':smart_install_data},
		ext_modules=[
			Extension(
				"simpleparse.stt.TextTools.mxTextTools.mxTextTools", 
				[
					'stt/TextTools/mxTextTools/mxTextTools.c',
					'stt/TextTools/mxTextTools/mxte.c',
					'stt/TextTools/mxTextTools/mxbmse.c',
				],
				include_dirs=['stt/TextTools/mxTextTools']
			),
		],
		**extraArguments
	)
