// Copyright (c) Signal Estimator authors
// Licensed under MIT

// Generated by generate_pcm.py. DO NOT EDIT!

#pragma once

#include "io/AlsaConstants.hpp"
#include "io/PcmFormat.hpp"

#include <cstddef>
#include <cstdint>
#include <optional>
#include <string>
#include <vector>

#if __BYTE_ORDER__ == __ORDER_BIG_ENDIAN__
// Big-endian CPU
#define PCM_BIG_ENDIAN
#else
// Little-endian CPU
#define PCM_LITTLE_ENDIAN
#endif

namespace signal_estimator {

// SInt8 value range
const int8_t pcm_sint8_min = -127 - 1;
const int8_t pcm_sint8_max = 127;

// UInt8 value range
const uint8_t pcm_uint8_min = 0u;
const uint8_t pcm_uint8_max = 255u;

// SInt16 value range
const int16_t pcm_sint16_min = -32767 - 1;
const int16_t pcm_sint16_max = 32767;

// UInt16 value range
const uint16_t pcm_uint16_min = 0u;
const uint16_t pcm_uint16_max = 65535u;

// SInt18_3B value range
const int32_t pcm_sint18_3b_min = -131071 - 1;
const int32_t pcm_sint18_3b_max = 131071;

// UInt18_3B value range
const uint32_t pcm_uint18_3b_min = 0u;
const uint32_t pcm_uint18_3b_max = 262143u;

// SInt20_3B value range
const int32_t pcm_sint20_3b_min = -524287 - 1;
const int32_t pcm_sint20_3b_max = 524287;

// UInt20_3B value range
const uint32_t pcm_uint20_3b_min = 0u;
const uint32_t pcm_uint20_3b_max = 1048575u;

// SInt20_4B value range
const int32_t pcm_sint20_4b_min = -524287 - 1;
const int32_t pcm_sint20_4b_max = 524287;

// UInt20_4B value range
const uint32_t pcm_uint20_4b_min = 0u;
const uint32_t pcm_uint20_4b_max = 1048575u;

// SInt24_3B value range
const int32_t pcm_sint24_3b_min = -8388607 - 1;
const int32_t pcm_sint24_3b_max = 8388607;

// UInt24_3B value range
const uint32_t pcm_uint24_3b_min = 0u;
const uint32_t pcm_uint24_3b_max = 16777215u;

// SInt24_4B value range
const int32_t pcm_sint24_4b_min = -8388607 - 1;
const int32_t pcm_sint24_4b_max = 8388607;

// UInt24_4B value range
const uint32_t pcm_uint24_4b_min = 0u;
const uint32_t pcm_uint24_4b_max = 16777215u;

// SInt32 value range
const int32_t pcm_sint32_min = -2147483647l - 1;
const int32_t pcm_sint32_max = 2147483647l;

// UInt32 value range
const uint32_t pcm_uint32_min = 0ul;
const uint32_t pcm_uint32_max = 4294967295ul;

// Convert between signed and unsigned samples
template <PcmEncoding>
struct pcm_sign_converter;

// Convert SInt8 from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::SInt8> {
    // SInt8 from unsigned value
    static inline int8_t from_unsigned(uint8_t arg) {
        if (arg < uint8_t(pcm_sint8_max) + 1) {
            return int8_t(arg) - pcm_sint8_max - 1;
        }
        return int8_t(arg - uint8_t(pcm_sint8_max) - 1);
    }

    // SInt8 to unsigned value
    static inline uint8_t to_unsigned(int8_t arg) {
        if (arg >= 0) {
            return uint8_t(arg) + pcm_sint8_max + 1;
        }
        return uint8_t(arg + pcm_sint8_max + 1);
    }
};

// Convert UInt8 from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::UInt8> {
    // UInt8 from signed value
    static inline uint8_t from_signed(int8_t arg) {
        if (arg >= 0) {
            return uint8_t(arg) + pcm_sint8_max + 1;
        }
        return uint8_t(arg + pcm_sint8_max + 1);
    }

    // UInt8 to signed value
    static inline int8_t to_signed(uint8_t arg) {
        if (arg >= uint8_t(pcm_sint8_max) + 1) {
            return int8_t(arg - uint8_t(pcm_sint8_max) - 1);
        }
        return int8_t(arg - uint8_t(pcm_sint8_max) - 1);
    }
};

// Convert SInt16 from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::SInt16> {
    // SInt16 from unsigned value
    static inline int16_t from_unsigned(uint16_t arg) {
        if (arg < uint16_t(pcm_sint16_max) + 1) {
            return int16_t(arg) - pcm_sint16_max - 1;
        }
        return int16_t(arg - uint16_t(pcm_sint16_max) - 1);
    }

    // SInt16 to unsigned value
    static inline uint16_t to_unsigned(int16_t arg) {
        if (arg >= 0) {
            return uint16_t(arg) + pcm_sint16_max + 1;
        }
        return uint16_t(arg + pcm_sint16_max + 1);
    }
};

// Convert UInt16 from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::UInt16> {
    // UInt16 from signed value
    static inline uint16_t from_signed(int16_t arg) {
        if (arg >= 0) {
            return uint16_t(arg) + pcm_sint16_max + 1;
        }
        return uint16_t(arg + pcm_sint16_max + 1);
    }

    // UInt16 to signed value
    static inline int16_t to_signed(uint16_t arg) {
        if (arg >= uint16_t(pcm_sint16_max) + 1) {
            return int16_t(arg - uint16_t(pcm_sint16_max) - 1);
        }
        return int16_t(arg - uint16_t(pcm_sint16_max) - 1);
    }
};

// Convert SInt18_3B from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::SInt18_3B> {
    // SInt18_3B from unsigned value
    static inline int32_t from_unsigned(uint32_t arg) {
        if (arg < uint32_t(pcm_sint18_3b_max) + 1) {
            return int32_t(arg) - pcm_sint18_3b_max - 1;
        }
        return int32_t(arg - uint32_t(pcm_sint18_3b_max) - 1);
    }

    // SInt18_3B to unsigned value
    static inline uint32_t to_unsigned(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint18_3b_max + 1;
        }
        return uint32_t(arg + pcm_sint18_3b_max + 1);
    }
};

// Convert UInt18_3B from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::UInt18_3B> {
    // UInt18_3B from signed value
    static inline uint32_t from_signed(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint18_3b_max + 1;
        }
        return uint32_t(arg + pcm_sint18_3b_max + 1);
    }

    // UInt18_3B to signed value
    static inline int32_t to_signed(uint32_t arg) {
        if (arg >= uint32_t(pcm_sint18_3b_max) + 1) {
            return int32_t(arg - uint32_t(pcm_sint18_3b_max) - 1);
        }
        return int32_t(arg - uint32_t(pcm_sint18_3b_max) - 1);
    }
};

// Convert SInt20_3B from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::SInt20_3B> {
    // SInt20_3B from unsigned value
    static inline int32_t from_unsigned(uint32_t arg) {
        if (arg < uint32_t(pcm_sint20_3b_max) + 1) {
            return int32_t(arg) - pcm_sint20_3b_max - 1;
        }
        return int32_t(arg - uint32_t(pcm_sint20_3b_max) - 1);
    }

    // SInt20_3B to unsigned value
    static inline uint32_t to_unsigned(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint20_3b_max + 1;
        }
        return uint32_t(arg + pcm_sint20_3b_max + 1);
    }
};

// Convert UInt20_3B from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::UInt20_3B> {
    // UInt20_3B from signed value
    static inline uint32_t from_signed(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint20_3b_max + 1;
        }
        return uint32_t(arg + pcm_sint20_3b_max + 1);
    }

    // UInt20_3B to signed value
    static inline int32_t to_signed(uint32_t arg) {
        if (arg >= uint32_t(pcm_sint20_3b_max) + 1) {
            return int32_t(arg - uint32_t(pcm_sint20_3b_max) - 1);
        }
        return int32_t(arg - uint32_t(pcm_sint20_3b_max) - 1);
    }
};

// Convert SInt20_4B from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::SInt20_4B> {
    // SInt20_4B from unsigned value
    static inline int32_t from_unsigned(uint32_t arg) {
        if (arg < uint32_t(pcm_sint20_4b_max) + 1) {
            return int32_t(arg) - pcm_sint20_4b_max - 1;
        }
        return int32_t(arg - uint32_t(pcm_sint20_4b_max) - 1);
    }

    // SInt20_4B to unsigned value
    static inline uint32_t to_unsigned(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint20_4b_max + 1;
        }
        return uint32_t(arg + pcm_sint20_4b_max + 1);
    }
};

// Convert UInt20_4B from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::UInt20_4B> {
    // UInt20_4B from signed value
    static inline uint32_t from_signed(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint20_4b_max + 1;
        }
        return uint32_t(arg + pcm_sint20_4b_max + 1);
    }

    // UInt20_4B to signed value
    static inline int32_t to_signed(uint32_t arg) {
        if (arg >= uint32_t(pcm_sint20_4b_max) + 1) {
            return int32_t(arg - uint32_t(pcm_sint20_4b_max) - 1);
        }
        return int32_t(arg - uint32_t(pcm_sint20_4b_max) - 1);
    }
};

// Convert SInt24_3B from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::SInt24_3B> {
    // SInt24_3B from unsigned value
    static inline int32_t from_unsigned(uint32_t arg) {
        if (arg < uint32_t(pcm_sint24_3b_max) + 1) {
            return int32_t(arg) - pcm_sint24_3b_max - 1;
        }
        return int32_t(arg - uint32_t(pcm_sint24_3b_max) - 1);
    }

    // SInt24_3B to unsigned value
    static inline uint32_t to_unsigned(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint24_3b_max + 1;
        }
        return uint32_t(arg + pcm_sint24_3b_max + 1);
    }
};

// Convert UInt24_3B from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::UInt24_3B> {
    // UInt24_3B from signed value
    static inline uint32_t from_signed(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint24_3b_max + 1;
        }
        return uint32_t(arg + pcm_sint24_3b_max + 1);
    }

    // UInt24_3B to signed value
    static inline int32_t to_signed(uint32_t arg) {
        if (arg >= uint32_t(pcm_sint24_3b_max) + 1) {
            return int32_t(arg - uint32_t(pcm_sint24_3b_max) - 1);
        }
        return int32_t(arg - uint32_t(pcm_sint24_3b_max) - 1);
    }
};

// Convert SInt24_4B from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::SInt24_4B> {
    // SInt24_4B from unsigned value
    static inline int32_t from_unsigned(uint32_t arg) {
        if (arg < uint32_t(pcm_sint24_4b_max) + 1) {
            return int32_t(arg) - pcm_sint24_4b_max - 1;
        }
        return int32_t(arg - uint32_t(pcm_sint24_4b_max) - 1);
    }

    // SInt24_4B to unsigned value
    static inline uint32_t to_unsigned(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint24_4b_max + 1;
        }
        return uint32_t(arg + pcm_sint24_4b_max + 1);
    }
};

// Convert UInt24_4B from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::UInt24_4B> {
    // UInt24_4B from signed value
    static inline uint32_t from_signed(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint24_4b_max + 1;
        }
        return uint32_t(arg + pcm_sint24_4b_max + 1);
    }

    // UInt24_4B to signed value
    static inline int32_t to_signed(uint32_t arg) {
        if (arg >= uint32_t(pcm_sint24_4b_max) + 1) {
            return int32_t(arg - uint32_t(pcm_sint24_4b_max) - 1);
        }
        return int32_t(arg - uint32_t(pcm_sint24_4b_max) - 1);
    }
};

// Convert SInt32 from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::SInt32> {
    // SInt32 from unsigned value
    static inline int32_t from_unsigned(uint32_t arg) {
        if (arg < uint32_t(pcm_sint32_max) + 1) {
            return int32_t(arg) - pcm_sint32_max - 1;
        }
        return int32_t(arg - uint32_t(pcm_sint32_max) - 1);
    }

    // SInt32 to unsigned value
    static inline uint32_t to_unsigned(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint32_max + 1;
        }
        return uint32_t(arg + pcm_sint32_max + 1);
    }
};

// Convert UInt32 from/to signed/unsigned
template <>
struct pcm_sign_converter<PcmEncoding::UInt32> {
    // UInt32 from signed value
    static inline uint32_t from_signed(int32_t arg) {
        if (arg >= 0) {
            return uint32_t(arg) + pcm_sint32_max + 1;
        }
        return uint32_t(arg + pcm_sint32_max + 1);
    }

    // UInt32 to signed value
    static inline int32_t to_signed(uint32_t arg) {
        if (arg >= uint32_t(pcm_sint32_max) + 1) {
            return int32_t(arg - uint32_t(pcm_sint32_max) - 1);
        }
        return int32_t(arg - uint32_t(pcm_sint32_max) - 1);
    }
};

// Convert between unpacked encodings
template <PcmEncoding InEnc, PcmEncoding OutEnc>
struct pcm_encoding_converter;

// Convert SInt16 to SInt8
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::SInt8> {
    static inline int8_t convert(int16_t arg) {
        int16_t in = arg;

        int8_t out;
        // downscale signed integer
        if (in > int16_t(pcm_sint16_max - (int16_t(1) << 7))) {
            // clip
            out = pcm_sint8_max;
        } else {
            out = int8_t(uint16_t(in + (int16_t(1) << 7)) >> 8);
        }

        return out;
    }
};

// Convert SInt16 to UInt8
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::UInt8> {
    static inline uint8_t convert(int16_t arg) {
        int16_t in = arg;

        int8_t out;
        // downscale signed integer
        if (in > int16_t(pcm_sint16_max - (int16_t(1) << 7))) {
            // clip
            out = pcm_sint8_max;
        } else {
            out = int8_t(uint16_t(in + (int16_t(1) << 7)) >> 8);
        }

        // convert to unsigned
        return pcm_sign_converter<PcmEncoding::UInt8>::from_signed(out);
    }
};

// Convert SInt8 to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::SInt8, PcmEncoding::SInt16> {
    static inline int16_t convert(int8_t arg) {
        int8_t in = arg;

        int16_t out;
        // upscale signed integer
        out = int16_t(uint16_t(in) << 8);

        return out;
    }
};

// Convert UInt8 to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::UInt8, PcmEncoding::SInt16> {
    static inline int16_t convert(uint8_t arg) {
        // convert to signed
        int8_t in = pcm_sign_converter<PcmEncoding::UInt8>::to_signed(arg);

        int16_t out;
        // upscale signed integer
        out = int16_t(uint16_t(in) << 8);

        return out;
    }
};

// Convert SInt16 to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::SInt16> {
    static inline int16_t convert(int16_t arg) {
        return arg;
    }
};

// Convert UInt16 to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::UInt16, PcmEncoding::SInt16> {
    static inline int16_t convert(uint16_t arg) {
        // convert to signed
        int16_t in = pcm_sign_converter<PcmEncoding::UInt16>::to_signed(arg);

        int16_t out;
        out = in;

        return out;
    }
};

// Convert SInt18_3B to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::SInt18_3B, PcmEncoding::SInt16> {
    static inline int16_t convert(int32_t arg) {
        int32_t in = arg;

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint18_3b_max - (int32_t(1) << 1))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 1)) >> 2);
        }

        return out;
    }
};

// Convert UInt18_3B to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::UInt18_3B, PcmEncoding::SInt16> {
    static inline int16_t convert(uint32_t arg) {
        // convert to signed
        int32_t in = pcm_sign_converter<PcmEncoding::UInt18_3B>::to_signed(arg);

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint18_3b_max - (int32_t(1) << 1))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 1)) >> 2);
        }

        return out;
    }
};

// Convert SInt20_3B to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::SInt20_3B, PcmEncoding::SInt16> {
    static inline int16_t convert(int32_t arg) {
        int32_t in = arg;

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint20_3b_max - (int32_t(1) << 3))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 3)) >> 4);
        }

        return out;
    }
};

// Convert UInt20_3B to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::UInt20_3B, PcmEncoding::SInt16> {
    static inline int16_t convert(uint32_t arg) {
        // convert to signed
        int32_t in = pcm_sign_converter<PcmEncoding::UInt20_3B>::to_signed(arg);

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint20_3b_max - (int32_t(1) << 3))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 3)) >> 4);
        }

        return out;
    }
};

// Convert SInt20_4B to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::SInt20_4B, PcmEncoding::SInt16> {
    static inline int16_t convert(int32_t arg) {
        int32_t in = arg;

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint20_4b_max - (int32_t(1) << 3))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 3)) >> 4);
        }

        return out;
    }
};

// Convert UInt20_4B to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::UInt20_4B, PcmEncoding::SInt16> {
    static inline int16_t convert(uint32_t arg) {
        // convert to signed
        int32_t in = pcm_sign_converter<PcmEncoding::UInt20_4B>::to_signed(arg);

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint20_4b_max - (int32_t(1) << 3))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 3)) >> 4);
        }

        return out;
    }
};

// Convert SInt24_3B to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::SInt24_3B, PcmEncoding::SInt16> {
    static inline int16_t convert(int32_t arg) {
        int32_t in = arg;

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint24_3b_max - (int32_t(1) << 7))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 7)) >> 8);
        }

        return out;
    }
};

// Convert UInt24_3B to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::UInt24_3B, PcmEncoding::SInt16> {
    static inline int16_t convert(uint32_t arg) {
        // convert to signed
        int32_t in = pcm_sign_converter<PcmEncoding::UInt24_3B>::to_signed(arg);

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint24_3b_max - (int32_t(1) << 7))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 7)) >> 8);
        }

        return out;
    }
};

// Convert SInt24_4B to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::SInt24_4B, PcmEncoding::SInt16> {
    static inline int16_t convert(int32_t arg) {
        int32_t in = arg;

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint24_4b_max - (int32_t(1) << 7))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 7)) >> 8);
        }

        return out;
    }
};

// Convert UInt24_4B to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::UInt24_4B, PcmEncoding::SInt16> {
    static inline int16_t convert(uint32_t arg) {
        // convert to signed
        int32_t in = pcm_sign_converter<PcmEncoding::UInt24_4B>::to_signed(arg);

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint24_4b_max - (int32_t(1) << 7))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 7)) >> 8);
        }

        return out;
    }
};

// Convert SInt32 to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::SInt32, PcmEncoding::SInt16> {
    static inline int16_t convert(int32_t arg) {
        int32_t in = arg;

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint32_max - (int32_t(1) << 15))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 15)) >> 16);
        }

        return out;
    }
};

// Convert UInt32 to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::UInt32, PcmEncoding::SInt16> {
    static inline int16_t convert(uint32_t arg) {
        // convert to signed
        int32_t in = pcm_sign_converter<PcmEncoding::UInt32>::to_signed(arg);

        int16_t out;
        // downscale signed integer
        if (in > int32_t(pcm_sint32_max - (int32_t(1) << 15))) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(uint32_t(in + (int32_t(1) << 15)) >> 16);
        }

        return out;
    }
};

// Convert Float32 to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::Float32, PcmEncoding::SInt16> {
    static inline int16_t convert(float arg) {
        float in = arg;

        int16_t out;
        // float to integer
        const double d = double(in) * ((double)pcm_sint16_max + 1.0);
        if (d < pcm_sint16_min) {
            // clip
            out = pcm_sint16_min;
        } else if (d >= (double)pcm_sint16_max + 1.0) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(d);
        }

        return out;
    }
};

// Convert Float64 to SInt16
template <>
struct pcm_encoding_converter<PcmEncoding::Float64, PcmEncoding::SInt16> {
    static inline int16_t convert(double arg) {
        double in = arg;

        int16_t out;
        // float to integer
        const double d = double(in) * ((double)pcm_sint16_max + 1.0);
        if (d < pcm_sint16_min) {
            // clip
            out = pcm_sint16_min;
        } else if (d >= (double)pcm_sint16_max + 1.0) {
            // clip
            out = pcm_sint16_max;
        } else {
            out = int16_t(d);
        }

        return out;
    }
};

// Convert SInt16 to UInt16
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::UInt16> {
    static inline uint16_t convert(int16_t arg) {
        int16_t in = arg;

        int16_t out;
        out = in;

        // convert to unsigned
        return pcm_sign_converter<PcmEncoding::UInt16>::from_signed(out);
    }
};

// Convert SInt16 to SInt18_3B
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::SInt18_3B> {
    static inline int32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 2);

        return out;
    }
};

// Convert SInt16 to UInt18_3B
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::UInt18_3B> {
    static inline uint32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 2);

        // convert to unsigned
        return pcm_sign_converter<PcmEncoding::UInt18_3B>::from_signed(out);
    }
};

// Convert SInt16 to SInt20_3B
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::SInt20_3B> {
    static inline int32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 4);

        return out;
    }
};

// Convert SInt16 to UInt20_3B
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::UInt20_3B> {
    static inline uint32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 4);

        // convert to unsigned
        return pcm_sign_converter<PcmEncoding::UInt20_3B>::from_signed(out);
    }
};

// Convert SInt16 to SInt20_4B
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::SInt20_4B> {
    static inline int32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 4);

        return out;
    }
};

// Convert SInt16 to UInt20_4B
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::UInt20_4B> {
    static inline uint32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 4);

        // convert to unsigned
        return pcm_sign_converter<PcmEncoding::UInt20_4B>::from_signed(out);
    }
};

// Convert SInt16 to SInt24_3B
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::SInt24_3B> {
    static inline int32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 8);

        return out;
    }
};

// Convert SInt16 to UInt24_3B
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::UInt24_3B> {
    static inline uint32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 8);

        // convert to unsigned
        return pcm_sign_converter<PcmEncoding::UInt24_3B>::from_signed(out);
    }
};

// Convert SInt16 to SInt24_4B
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::SInt24_4B> {
    static inline int32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 8);

        return out;
    }
};

// Convert SInt16 to UInt24_4B
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::UInt24_4B> {
    static inline uint32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 8);

        // convert to unsigned
        return pcm_sign_converter<PcmEncoding::UInt24_4B>::from_signed(out);
    }
};

// Convert SInt16 to SInt32
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::SInt32> {
    static inline int32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 16);

        return out;
    }
};

// Convert SInt16 to UInt32
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::UInt32> {
    static inline uint32_t convert(int16_t arg) {
        int16_t in = arg;

        int32_t out;
        // upscale signed integer
        out = int32_t(uint32_t(in) << 16);

        // convert to unsigned
        return pcm_sign_converter<PcmEncoding::UInt32>::from_signed(out);
    }
};

// Convert SInt16 to Float32
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::Float32> {
    static inline float convert(int16_t arg) {
        int16_t in = arg;

        float out;
        // integer to float
        out = float(in * (1.0 / ((double)pcm_sint16_max + 1.0)));

        return out;
    }
};

// Convert SInt16 to Float64
template <>
struct pcm_encoding_converter<PcmEncoding::SInt16, PcmEncoding::Float64> {
    static inline double convert(int16_t arg) {
        int16_t in = arg;

        double out;
        // integer to float
        out = double(in * (1.0 / ((double)pcm_sint16_max + 1.0)));

        return out;
    }
};

// N-byte native-endian packed octet array
template <size_t N>
struct pcm_octets;

// 1-byte native-endian packed octet array
template <>
struct pcm_octets<1> {
#ifdef PCM_BIG_ENDIAN
    uint8_t octet0;
#else
    uint8_t octet0;
#endif
};

// 2-byte native-endian packed octet array
template <>
struct pcm_octets<2> {
#ifdef PCM_BIG_ENDIAN
    uint8_t octet1;
    uint8_t octet0;
#else
    uint8_t octet0;
    uint8_t octet1;
#endif
};

// 4-byte native-endian packed octet array
template <>
struct pcm_octets<4> {
#ifdef PCM_BIG_ENDIAN
    uint8_t octet3;
    uint8_t octet2;
    uint8_t octet1;
    uint8_t octet0;
#else
    uint8_t octet0;
    uint8_t octet1;
    uint8_t octet2;
    uint8_t octet3;
#endif
};

// 8-byte native-endian packed octet array
template <>
struct pcm_octets<8> {
#ifdef PCM_BIG_ENDIAN
    uint8_t octet7;
    uint8_t octet6;
    uint8_t octet5;
    uint8_t octet4;
    uint8_t octet3;
    uint8_t octet2;
    uint8_t octet1;
    uint8_t octet0;
#else
    uint8_t octet0;
    uint8_t octet1;
    uint8_t octet2;
    uint8_t octet3;
    uint8_t octet4;
    uint8_t octet5;
    uint8_t octet6;
    uint8_t octet7;
#endif
};

// N-byte native-endian sample
template <class T>
struct pcm_sample;

// int8_t native-endian sample
template <>
struct pcm_sample<int8_t> {
    union {
        int8_t value;
        pcm_octets<1> octets;
    };
};

// uint8_t native-endian sample
template <>
struct pcm_sample<uint8_t> {
    union {
        uint8_t value;
        pcm_octets<1> octets;
    };
};

// int16_t native-endian sample
template <>
struct pcm_sample<int16_t> {
    union {
        int16_t value;
        pcm_octets<2> octets;
    };
};

// uint16_t native-endian sample
template <>
struct pcm_sample<uint16_t> {
    union {
        uint16_t value;
        pcm_octets<2> octets;
    };
};

// int32_t native-endian sample
template <>
struct pcm_sample<int32_t> {
    union {
        int32_t value;
        pcm_octets<4> octets;
    };
};

// uint32_t native-endian sample
template <>
struct pcm_sample<uint32_t> {
    union {
        uint32_t value;
        pcm_octets<4> octets;
    };
};

// int64_t native-endian sample
template <>
struct pcm_sample<int64_t> {
    union {
        int64_t value;
        pcm_octets<8> octets;
    };
};

// uint64_t native-endian sample
template <>
struct pcm_sample<uint64_t> {
    union {
        uint64_t value;
        pcm_octets<8> octets;
    };
};

// float native-endian sample
template <>
struct pcm_sample<float> {
    union {
        float value;
        pcm_octets<4> octets;
    };
};

// double native-endian sample
template <>
struct pcm_sample<double> {
    union {
        double value;
        pcm_octets<8> octets;
    };
};


// Sample packer / unpacker
template <PcmEncoding, PcmEndian>
struct pcm_packer;

// SInt8 Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt8, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int8_t arg) {
        // native-endian view of octets
        pcm_sample<int8_t> p;
        p.value = arg;

        // write in big-endian order
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline int8_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int8_t> p;

        // read in big-endian order
        p.octets.octet0 = *(buffer++);

        return p.value;
    }
};

// SInt8 Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt8, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int8_t arg) {
        // native-endian view of octets
        pcm_sample<int8_t> p;
        p.value = arg;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline int8_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int8_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);

        return p.value;
    }
};

// UInt8 Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt8, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint8_t arg) {
        // native-endian view of octets
        pcm_sample<uint8_t> p;
        p.value = arg;

        // write in big-endian order
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline uint8_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint8_t> p;

        // read in big-endian order
        p.octets.octet0 = *(buffer++);

        return p.value;
    }
};

// UInt8 Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt8, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint8_t arg) {
        // native-endian view of octets
        pcm_sample<uint8_t> p;
        p.value = arg;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline uint8_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint8_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);

        return p.value;
    }
};

// SInt16 Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt16, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int16_t arg) {
        // native-endian view of octets
        pcm_sample<int16_t> p;
        p.value = arg;

        // write in big-endian order
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline int16_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int16_t> p;

        // read in big-endian order
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        return p.value;
    }
};

// SInt16 Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt16, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int16_t arg) {
        // native-endian view of octets
        pcm_sample<int16_t> p;
        p.value = arg;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
    }

    // Unpack next sample from buffer
    static inline int16_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int16_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);

        return p.value;
    }
};

// UInt16 Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt16, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint16_t arg) {
        // native-endian view of octets
        pcm_sample<uint16_t> p;
        p.value = arg;

        // write in big-endian order
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline uint16_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint16_t> p;

        // read in big-endian order
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        return p.value;
    }
};

// UInt16 Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt16, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint16_t arg) {
        // native-endian view of octets
        pcm_sample<uint16_t> p;
        p.value = arg;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
    }

    // Unpack next sample from buffer
    static inline uint16_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint16_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);

        return p.value;
    }
};

// SInt18_3B Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt18_3B, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0x3ffff;

        // write in big-endian order
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in big-endian order
        p.octets.octet3 = 0;
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        // zeroise padding bits
        p.value &= 0x3ffff;

        if (p.value & 0x20000) {
            // sign extension
            p.value |= (int32_t)0xfffc0000;
        }

        return p.value;
    }
};

// SInt18_3B Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt18_3B, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0x3ffff;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = 0;

        // zeroise padding bits
        p.value &= 0x3ffff;

        if (p.value & 0x20000) {
            // sign extension
            p.value |= (int32_t)0xfffc0000;
        }

        return p.value;
    }
};

// UInt18_3B Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt18_3B, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0x3ffffu;

        // write in big-endian order
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in big-endian order
        p.octets.octet3 = 0;
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        // zeroise padding bits
        p.value &= 0x3ffffu;

        return p.value;
    }
};

// UInt18_3B Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt18_3B, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0x3ffffu;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = 0;

        // zeroise padding bits
        p.value &= 0x3ffffu;

        return p.value;
    }
};

// SInt20_3B Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt20_3B, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xfffff;

        // write in big-endian order
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in big-endian order
        p.octets.octet3 = 0;
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        // zeroise padding bits
        p.value &= 0xfffff;

        if (p.value & 0x80000) {
            // sign extension
            p.value |= (int32_t)0xfff00000;
        }

        return p.value;
    }
};

// SInt20_3B Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt20_3B, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xfffff;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = 0;

        // zeroise padding bits
        p.value &= 0xfffff;

        if (p.value & 0x80000) {
            // sign extension
            p.value |= (int32_t)0xfff00000;
        }

        return p.value;
    }
};

// UInt20_3B Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt20_3B, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xfffffu;

        // write in big-endian order
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in big-endian order
        p.octets.octet3 = 0;
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        // zeroise padding bits
        p.value &= 0xfffffu;

        return p.value;
    }
};

// UInt20_3B Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt20_3B, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xfffffu;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = 0;

        // zeroise padding bits
        p.value &= 0xfffffu;

        return p.value;
    }
};

// SInt20_4B Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt20_4B, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xfffff;

        // write in big-endian order
        *(buffer++) = p.octets.octet3;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in big-endian order
        p.octets.octet3 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        // zeroise padding bits
        p.value &= 0xfffff;

        if (p.value & 0x80000) {
            // sign extension
            p.value |= (int32_t)0xfff00000;
        }

        return p.value;
    }
};

// SInt20_4B Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt20_4B, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xfffff;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet3;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = *(buffer++);

        // zeroise padding bits
        p.value &= 0xfffff;

        if (p.value & 0x80000) {
            // sign extension
            p.value |= (int32_t)0xfff00000;
        }

        return p.value;
    }
};

// UInt20_4B Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt20_4B, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xfffffu;

        // write in big-endian order
        *(buffer++) = p.octets.octet3;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in big-endian order
        p.octets.octet3 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        // zeroise padding bits
        p.value &= 0xfffffu;

        return p.value;
    }
};

// UInt20_4B Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt20_4B, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xfffffu;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet3;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = *(buffer++);

        // zeroise padding bits
        p.value &= 0xfffffu;

        return p.value;
    }
};

// SInt24_3B Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt24_3B, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // write in big-endian order
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in big-endian order
        p.octets.octet3 = 0;
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        if (p.value & 0x800000) {
            // sign extension
            p.value |= (int32_t)0xff000000;
        }

        return p.value;
    }
};

// SInt24_3B Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt24_3B, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = 0;

        if (p.value & 0x800000) {
            // sign extension
            p.value |= (int32_t)0xff000000;
        }

        return p.value;
    }
};

// UInt24_3B Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt24_3B, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // write in big-endian order
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in big-endian order
        p.octets.octet3 = 0;
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        return p.value;
    }
};

// UInt24_3B Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt24_3B, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = 0;

        return p.value;
    }
};

// SInt24_4B Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt24_4B, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xffffff;

        // write in big-endian order
        *(buffer++) = p.octets.octet3;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in big-endian order
        p.octets.octet3 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        // zeroise padding bits
        p.value &= 0xffffff;

        if (p.value & 0x800000) {
            // sign extension
            p.value |= (int32_t)0xff000000;
        }

        return p.value;
    }
};

// SInt24_4B Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt24_4B, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xffffff;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet3;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = *(buffer++);

        // zeroise padding bits
        p.value &= 0xffffff;

        if (p.value & 0x800000) {
            // sign extension
            p.value |= (int32_t)0xff000000;
        }

        return p.value;
    }
};

// UInt24_4B Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt24_4B, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xffffffu;

        // write in big-endian order
        *(buffer++) = p.octets.octet3;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in big-endian order
        p.octets.octet3 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        // zeroise padding bits
        p.value &= 0xffffffu;

        return p.value;
    }
};

// UInt24_4B Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt24_4B, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // zeroise padding bits
        p.value &= 0xffffffu;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet3;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = *(buffer++);

        // zeroise padding bits
        p.value &= 0xffffffu;

        return p.value;
    }
};

// SInt32 Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt32, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // write in big-endian order
        *(buffer++) = p.octets.octet3;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in big-endian order
        p.octets.octet3 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        return p.value;
    }
};

// SInt32 Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::SInt32, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, int32_t arg) {
        // native-endian view of octets
        pcm_sample<int32_t> p;
        p.value = arg;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet3;
    }

    // Unpack next sample from buffer
    static inline int32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<int32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = *(buffer++);

        return p.value;
    }
};

// UInt32 Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt32, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // write in big-endian order
        *(buffer++) = p.octets.octet3;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in big-endian order
        p.octets.octet3 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        return p.value;
    }
};

// UInt32 Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::UInt32, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, uint32_t arg) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;
        p.value = arg;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet3;
    }

    // Unpack next sample from buffer
    static inline uint32_t unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<uint32_t> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = *(buffer++);

        return p.value;
    }
};

// Float32 Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::Float32, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, float arg) {
        // native-endian view of octets
        pcm_sample<float> p;
        p.value = arg;

        // write in big-endian order
        *(buffer++) = p.octets.octet3;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline float unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<float> p;

        // read in big-endian order
        p.octets.octet3 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        return p.value;
    }
};

// Float32 Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::Float32, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, float arg) {
        // native-endian view of octets
        pcm_sample<float> p;
        p.value = arg;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet3;
    }

    // Unpack next sample from buffer
    static inline float unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<float> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = *(buffer++);

        return p.value;
    }
};

// Float64 Big-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::Float64, PcmEndian::Big> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, double arg) {
        // native-endian view of octets
        pcm_sample<double> p;
        p.value = arg;

        // write in big-endian order
        *(buffer++) = p.octets.octet7;
        *(buffer++) = p.octets.octet6;
        *(buffer++) = p.octets.octet5;
        *(buffer++) = p.octets.octet4;
        *(buffer++) = p.octets.octet3;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet0;
    }

    // Unpack next sample from buffer
    static inline double unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<double> p;

        // read in big-endian order
        p.octets.octet7 = *(buffer++);
        p.octets.octet6 = *(buffer++);
        p.octets.octet5 = *(buffer++);
        p.octets.octet4 = *(buffer++);
        p.octets.octet3 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet0 = *(buffer++);

        return p.value;
    }
};

// Float64 Little-Endian packer / unpacker
template <>
struct pcm_packer<PcmEncoding::Float64, PcmEndian::Little> {
    // Pack next sample to buffer
    static inline void pack(uint8_t* buffer, double arg) {
        // native-endian view of octets
        pcm_sample<double> p;
        p.value = arg;

        // write in little-endian order
        *(buffer++) = p.octets.octet0;
        *(buffer++) = p.octets.octet1;
        *(buffer++) = p.octets.octet2;
        *(buffer++) = p.octets.octet3;
        *(buffer++) = p.octets.octet4;
        *(buffer++) = p.octets.octet5;
        *(buffer++) = p.octets.octet6;
        *(buffer++) = p.octets.octet7;
    }

    // Unpack next sample from buffer
    static inline double unpack(const uint8_t* buffer) {
        // native-endian view of octets
        pcm_sample<double> p;

        // read in little-endian order
        p.octets.octet0 = *(buffer++);
        p.octets.octet1 = *(buffer++);
        p.octets.octet2 = *(buffer++);
        p.octets.octet3 = *(buffer++);
        p.octets.octet4 = *(buffer++);
        p.octets.octet5 = *(buffer++);
        p.octets.octet6 = *(buffer++);
        p.octets.octet7 = *(buffer++);

        return p.value;
    }
};

// Map encoding and endian of samples
template <PcmEncoding InEnc, PcmEncoding OutEnc, PcmEndian InEnd, PcmEndian OutEnd>
struct pcm_mapper {
    static inline void map(const uint8_t* in_sample, uint8_t* out_sample) {
        pcm_packer<OutEnc, OutEnd>::pack(out_sample,
            pcm_encoding_converter<InEnc, OutEnc>::convert(
                pcm_packer<InEnc, InEnd>::unpack(in_sample)));
    }
};

// Sample mapping function
typedef void (*pcm_mapper_func_t)(const uint8_t* in_data, uint8_t* out_data);

// Select mapper function
template <PcmEncoding InEnc, PcmEncoding OutEnc, PcmEndian InEnd, PcmEndian OutEnd>
pcm_mapper_func_t pcm_mapper_func() {
    return &pcm_mapper<InEnc, OutEnc, InEnd, OutEnd>::map;
}

// Select mapper function
template <PcmEncoding InEnc, PcmEncoding OutEnc>
pcm_mapper_func_t pcm_mapper_func(PcmEndian in_endian, PcmEndian out_endian) {
    switch (in_endian) {
    case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
        return pcm_mapper_func<InEnc, OutEnc>(PcmEndian::Big, out_endian);
#else
        return pcm_mapper_func<InEnc, OutEnc>(PcmEndian::Little, out_endian);
#endif
    case PcmEndian::Big:
        switch (out_endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return pcm_mapper_func<InEnc, OutEnc>(in_endian, PcmEndian::Big);
#else
            return pcm_mapper_func<InEnc, OutEnc>(in_endian, PcmEndian::Little);
#endif
        case PcmEndian::Big:
            return pcm_mapper_func<InEnc, OutEnc, PcmEndian::Big, PcmEndian::Big>();
        case PcmEndian::Little:
            return pcm_mapper_func<InEnc, OutEnc, PcmEndian::Big, PcmEndian::Little>();
        }
        break;
    case PcmEndian::Little:
        switch (out_endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return pcm_mapper_func<InEnc, OutEnc>(in_endian, PcmEndian::Big);
#else
            return pcm_mapper_func<InEnc, OutEnc>(in_endian, PcmEndian::Little);
#endif
        case PcmEndian::Big:
            return pcm_mapper_func<InEnc, OutEnc, PcmEndian::Little, PcmEndian::Big>();
        case PcmEndian::Little:
            return pcm_mapper_func<InEnc, OutEnc, PcmEndian::Little, PcmEndian::Little>();
        }
        break;
    }

    return nullptr;
}

// Select mapper function
inline pcm_mapper_func_t pcm_mapper_func(PcmEncoding in_encoding,
    PcmEncoding out_encoding, PcmEndian in_endian, PcmEndian out_endian) {
    if (in_encoding == PcmEncoding::SInt16) {
        switch (out_encoding) {
        case PcmEncoding::SInt8:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::SInt8>(
                in_endian, out_endian);
        case PcmEncoding::UInt8:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::UInt8>(
                in_endian, out_endian);
        case PcmEncoding::SInt16:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::UInt16:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::UInt16>(
                in_endian, out_endian);
        case PcmEncoding::SInt18_3B:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::SInt18_3B>(
                in_endian, out_endian);
        case PcmEncoding::UInt18_3B:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::UInt18_3B>(
                in_endian, out_endian);
        case PcmEncoding::SInt20_3B:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::SInt20_3B>(
                in_endian, out_endian);
        case PcmEncoding::UInt20_3B:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::UInt20_3B>(
                in_endian, out_endian);
        case PcmEncoding::SInt20_4B:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::SInt20_4B>(
                in_endian, out_endian);
        case PcmEncoding::UInt20_4B:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::UInt20_4B>(
                in_endian, out_endian);
        case PcmEncoding::SInt24_3B:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::SInt24_3B>(
                in_endian, out_endian);
        case PcmEncoding::UInt24_3B:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::UInt24_3B>(
                in_endian, out_endian);
        case PcmEncoding::SInt24_4B:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::SInt24_4B>(
                in_endian, out_endian);
        case PcmEncoding::UInt24_4B:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::UInt24_4B>(
                in_endian, out_endian);
        case PcmEncoding::SInt32:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::SInt32>(
                in_endian, out_endian);
        case PcmEncoding::UInt32:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::UInt32>(
                in_endian, out_endian);
        case PcmEncoding::Float32:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::Float32>(
                in_endian, out_endian);
        case PcmEncoding::Float64:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::Float64>(
                in_endian, out_endian);
        }
    }

    if (out_encoding == PcmEncoding::SInt16) {
        switch (in_encoding) {
        case PcmEncoding::SInt8:
            return pcm_mapper_func<PcmEncoding::SInt8, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::UInt8:
            return pcm_mapper_func<PcmEncoding::UInt8, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::SInt16:
            return pcm_mapper_func<PcmEncoding::SInt16, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::UInt16:
            return pcm_mapper_func<PcmEncoding::UInt16, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::SInt18_3B:
            return pcm_mapper_func<PcmEncoding::SInt18_3B, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::UInt18_3B:
            return pcm_mapper_func<PcmEncoding::UInt18_3B, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::SInt20_3B:
            return pcm_mapper_func<PcmEncoding::SInt20_3B, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::UInt20_3B:
            return pcm_mapper_func<PcmEncoding::UInt20_3B, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::SInt20_4B:
            return pcm_mapper_func<PcmEncoding::SInt20_4B, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::UInt20_4B:
            return pcm_mapper_func<PcmEncoding::UInt20_4B, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::SInt24_3B:
            return pcm_mapper_func<PcmEncoding::SInt24_3B, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::UInt24_3B:
            return pcm_mapper_func<PcmEncoding::UInt24_3B, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::SInt24_4B:
            return pcm_mapper_func<PcmEncoding::SInt24_4B, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::UInt24_4B:
            return pcm_mapper_func<PcmEncoding::UInt24_4B, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::SInt32:
            return pcm_mapper_func<PcmEncoding::SInt32, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::UInt32:
            return pcm_mapper_func<PcmEncoding::UInt32, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::Float32:
            return pcm_mapper_func<PcmEncoding::Float32, PcmEncoding::SInt16>(
                in_endian, out_endian);
        case PcmEncoding::Float64:
            return pcm_mapper_func<PcmEncoding::Float64, PcmEncoding::SInt16>(
                in_endian, out_endian);
        }
    }

    return nullptr;
}

// Get number of bits per sample in packed format
inline size_t pcm_sample_bits(PcmEncoding encoding) {
    switch (encoding) {
    case PcmEncoding::SInt8:
        return 8;
    case PcmEncoding::UInt8:
        return 8;
    case PcmEncoding::SInt16:
        return 16;
    case PcmEncoding::UInt16:
        return 16;
    case PcmEncoding::SInt18_3B:
        return 18;
    case PcmEncoding::UInt18_3B:
        return 18;
    case PcmEncoding::SInt20_3B:
        return 20;
    case PcmEncoding::UInt20_3B:
        return 20;
    case PcmEncoding::SInt20_4B:
        return 20;
    case PcmEncoding::UInt20_4B:
        return 20;
    case PcmEncoding::SInt24_3B:
        return 24;
    case PcmEncoding::UInt24_3B:
        return 24;
    case PcmEncoding::SInt24_4B:
        return 24;
    case PcmEncoding::UInt24_4B:
        return 24;
    case PcmEncoding::SInt32:
        return 32;
    case PcmEncoding::UInt32:
        return 32;
    case PcmEncoding::Float32:
        return 32;
    case PcmEncoding::Float64:
        return 64;
    }
    return 0;
}

// Get number of bits per sample in packed format
inline size_t pcm_sample_bytes(PcmEncoding encoding) {
    switch (encoding) {
    case PcmEncoding::SInt8:
        return 1;
    case PcmEncoding::UInt8:
        return 1;
    case PcmEncoding::SInt16:
        return 2;
    case PcmEncoding::UInt16:
        return 2;
    case PcmEncoding::SInt18_3B:
        return 3;
    case PcmEncoding::UInt18_3B:
        return 3;
    case PcmEncoding::SInt20_3B:
        return 3;
    case PcmEncoding::UInt20_3B:
        return 3;
    case PcmEncoding::SInt20_4B:
        return 4;
    case PcmEncoding::UInt20_4B:
        return 4;
    case PcmEncoding::SInt24_3B:
        return 3;
    case PcmEncoding::UInt24_3B:
        return 3;
    case PcmEncoding::SInt24_4B:
        return 4;
    case PcmEncoding::UInt24_4B:
        return 4;
    case PcmEncoding::SInt32:
        return 4;
    case PcmEncoding::UInt32:
        return 4;
    case PcmEncoding::Float32:
        return 4;
    case PcmEncoding::Float64:
        return 8;
    }
    return 0;
}

// List of all formats
inline std::vector<PcmFormat> pcm_supported_formats() {
    return {
        PcmFormat{ PcmEncoding::SInt8, PcmEndian::Native },
        PcmFormat{ PcmEncoding::UInt8, PcmEndian::Native },
        PcmFormat{ PcmEncoding::SInt16, PcmEndian::Native },
        PcmFormat{ PcmEncoding::SInt16, PcmEndian::Big },
        PcmFormat{ PcmEncoding::SInt16, PcmEndian::Little },
        PcmFormat{ PcmEncoding::UInt16, PcmEndian::Native },
        PcmFormat{ PcmEncoding::UInt16, PcmEndian::Big },
        PcmFormat{ PcmEncoding::UInt16, PcmEndian::Little },
        PcmFormat{ PcmEncoding::SInt18_3B, PcmEndian::Native },
        PcmFormat{ PcmEncoding::SInt18_3B, PcmEndian::Big },
        PcmFormat{ PcmEncoding::SInt18_3B, PcmEndian::Little },
        PcmFormat{ PcmEncoding::UInt18_3B, PcmEndian::Native },
        PcmFormat{ PcmEncoding::UInt18_3B, PcmEndian::Big },
        PcmFormat{ PcmEncoding::UInt18_3B, PcmEndian::Little },
        PcmFormat{ PcmEncoding::SInt20_3B, PcmEndian::Native },
        PcmFormat{ PcmEncoding::SInt20_3B, PcmEndian::Big },
        PcmFormat{ PcmEncoding::SInt20_3B, PcmEndian::Little },
        PcmFormat{ PcmEncoding::UInt20_3B, PcmEndian::Native },
        PcmFormat{ PcmEncoding::UInt20_3B, PcmEndian::Big },
        PcmFormat{ PcmEncoding::UInt20_3B, PcmEndian::Little },
        PcmFormat{ PcmEncoding::SInt20_4B, PcmEndian::Native },
        PcmFormat{ PcmEncoding::SInt20_4B, PcmEndian::Big },
        PcmFormat{ PcmEncoding::SInt20_4B, PcmEndian::Little },
        PcmFormat{ PcmEncoding::UInt20_4B, PcmEndian::Native },
        PcmFormat{ PcmEncoding::UInt20_4B, PcmEndian::Big },
        PcmFormat{ PcmEncoding::UInt20_4B, PcmEndian::Little },
        PcmFormat{ PcmEncoding::SInt24_3B, PcmEndian::Native },
        PcmFormat{ PcmEncoding::SInt24_3B, PcmEndian::Big },
        PcmFormat{ PcmEncoding::SInt24_3B, PcmEndian::Little },
        PcmFormat{ PcmEncoding::UInt24_3B, PcmEndian::Native },
        PcmFormat{ PcmEncoding::UInt24_3B, PcmEndian::Big },
        PcmFormat{ PcmEncoding::UInt24_3B, PcmEndian::Little },
        PcmFormat{ PcmEncoding::SInt24_4B, PcmEndian::Native },
        PcmFormat{ PcmEncoding::SInt24_4B, PcmEndian::Big },
        PcmFormat{ PcmEncoding::SInt24_4B, PcmEndian::Little },
        PcmFormat{ PcmEncoding::UInt24_4B, PcmEndian::Native },
        PcmFormat{ PcmEncoding::UInt24_4B, PcmEndian::Big },
        PcmFormat{ PcmEncoding::UInt24_4B, PcmEndian::Little },
        PcmFormat{ PcmEncoding::SInt32, PcmEndian::Native },
        PcmFormat{ PcmEncoding::SInt32, PcmEndian::Big },
        PcmFormat{ PcmEncoding::SInt32, PcmEndian::Little },
        PcmFormat{ PcmEncoding::UInt32, PcmEndian::Native },
        PcmFormat{ PcmEncoding::UInt32, PcmEndian::Big },
        PcmFormat{ PcmEncoding::UInt32, PcmEndian::Little },
        PcmFormat{ PcmEncoding::Float32, PcmEndian::Native },
        PcmFormat{ PcmEncoding::Float32, PcmEndian::Big },
        PcmFormat{ PcmEncoding::Float32, PcmEndian::Little },
        PcmFormat{ PcmEncoding::Float64, PcmEndian::Native },
        PcmFormat{ PcmEncoding::Float64, PcmEndian::Big },
        PcmFormat{ PcmEncoding::Float64, PcmEndian::Little },
    };
}

// Format from string
inline std::optional<PcmFormat> pcm_format_from_string(const std::string& str) {
    if (str == "s8") {
        return PcmFormat{ PcmEncoding::SInt8, PcmEndian::Native };
    }
    if (str == "s8_be") {
        return PcmFormat{ PcmEncoding::SInt8, PcmEndian::Big };
    }
    if (str == "s8_le") {
        return PcmFormat{ PcmEncoding::SInt8, PcmEndian::Little };
    }
    if (str == "u8") {
        return PcmFormat{ PcmEncoding::UInt8, PcmEndian::Native };
    }
    if (str == "u8_be") {
        return PcmFormat{ PcmEncoding::UInt8, PcmEndian::Big };
    }
    if (str == "u8_le") {
        return PcmFormat{ PcmEncoding::UInt8, PcmEndian::Little };
    }
    if (str == "s16") {
        return PcmFormat{ PcmEncoding::SInt16, PcmEndian::Native };
    }
    if (str == "s16_be") {
        return PcmFormat{ PcmEncoding::SInt16, PcmEndian::Big };
    }
    if (str == "s16_le") {
        return PcmFormat{ PcmEncoding::SInt16, PcmEndian::Little };
    }
    if (str == "u16") {
        return PcmFormat{ PcmEncoding::UInt16, PcmEndian::Native };
    }
    if (str == "u16_be") {
        return PcmFormat{ PcmEncoding::UInt16, PcmEndian::Big };
    }
    if (str == "u16_le") {
        return PcmFormat{ PcmEncoding::UInt16, PcmEndian::Little };
    }
    if (str == "s18_3") {
        return PcmFormat{ PcmEncoding::SInt18_3B, PcmEndian::Native };
    }
    if (str == "s18_3be") {
        return PcmFormat{ PcmEncoding::SInt18_3B, PcmEndian::Big };
    }
    if (str == "s18_3le") {
        return PcmFormat{ PcmEncoding::SInt18_3B, PcmEndian::Little };
    }
    if (str == "u18_3") {
        return PcmFormat{ PcmEncoding::UInt18_3B, PcmEndian::Native };
    }
    if (str == "u18_3be") {
        return PcmFormat{ PcmEncoding::UInt18_3B, PcmEndian::Big };
    }
    if (str == "u18_3le") {
        return PcmFormat{ PcmEncoding::UInt18_3B, PcmEndian::Little };
    }
    if (str == "s20_3") {
        return PcmFormat{ PcmEncoding::SInt20_3B, PcmEndian::Native };
    }
    if (str == "s20_3be") {
        return PcmFormat{ PcmEncoding::SInt20_3B, PcmEndian::Big };
    }
    if (str == "s20_3le") {
        return PcmFormat{ PcmEncoding::SInt20_3B, PcmEndian::Little };
    }
    if (str == "u20_3") {
        return PcmFormat{ PcmEncoding::UInt20_3B, PcmEndian::Native };
    }
    if (str == "u20_3be") {
        return PcmFormat{ PcmEncoding::UInt20_3B, PcmEndian::Big };
    }
    if (str == "u20_3le") {
        return PcmFormat{ PcmEncoding::UInt20_3B, PcmEndian::Little };
    }
    if (str == "s20") {
        return PcmFormat{ PcmEncoding::SInt20_4B, PcmEndian::Native };
    }
    if (str == "s20_be") {
        return PcmFormat{ PcmEncoding::SInt20_4B, PcmEndian::Big };
    }
    if (str == "s20_le") {
        return PcmFormat{ PcmEncoding::SInt20_4B, PcmEndian::Little };
    }
    if (str == "u20") {
        return PcmFormat{ PcmEncoding::UInt20_4B, PcmEndian::Native };
    }
    if (str == "u20_be") {
        return PcmFormat{ PcmEncoding::UInt20_4B, PcmEndian::Big };
    }
    if (str == "u20_le") {
        return PcmFormat{ PcmEncoding::UInt20_4B, PcmEndian::Little };
    }
    if (str == "s24_3") {
        return PcmFormat{ PcmEncoding::SInt24_3B, PcmEndian::Native };
    }
    if (str == "s24_3be") {
        return PcmFormat{ PcmEncoding::SInt24_3B, PcmEndian::Big };
    }
    if (str == "s24_3le") {
        return PcmFormat{ PcmEncoding::SInt24_3B, PcmEndian::Little };
    }
    if (str == "u24_3") {
        return PcmFormat{ PcmEncoding::UInt24_3B, PcmEndian::Native };
    }
    if (str == "u24_3be") {
        return PcmFormat{ PcmEncoding::UInt24_3B, PcmEndian::Big };
    }
    if (str == "u24_3le") {
        return PcmFormat{ PcmEncoding::UInt24_3B, PcmEndian::Little };
    }
    if (str == "s24") {
        return PcmFormat{ PcmEncoding::SInt24_4B, PcmEndian::Native };
    }
    if (str == "s24_be") {
        return PcmFormat{ PcmEncoding::SInt24_4B, PcmEndian::Big };
    }
    if (str == "s24_le") {
        return PcmFormat{ PcmEncoding::SInt24_4B, PcmEndian::Little };
    }
    if (str == "u24") {
        return PcmFormat{ PcmEncoding::UInt24_4B, PcmEndian::Native };
    }
    if (str == "u24_be") {
        return PcmFormat{ PcmEncoding::UInt24_4B, PcmEndian::Big };
    }
    if (str == "u24_le") {
        return PcmFormat{ PcmEncoding::UInt24_4B, PcmEndian::Little };
    }
    if (str == "s32") {
        return PcmFormat{ PcmEncoding::SInt32, PcmEndian::Native };
    }
    if (str == "s32_be") {
        return PcmFormat{ PcmEncoding::SInt32, PcmEndian::Big };
    }
    if (str == "s32_le") {
        return PcmFormat{ PcmEncoding::SInt32, PcmEndian::Little };
    }
    if (str == "u32") {
        return PcmFormat{ PcmEncoding::UInt32, PcmEndian::Native };
    }
    if (str == "u32_be") {
        return PcmFormat{ PcmEncoding::UInt32, PcmEndian::Big };
    }
    if (str == "u32_le") {
        return PcmFormat{ PcmEncoding::UInt32, PcmEndian::Little };
    }
    if (str == "float") {
        return PcmFormat{ PcmEncoding::Float32, PcmEndian::Native };
    }
    if (str == "float_be") {
        return PcmFormat{ PcmEncoding::Float32, PcmEndian::Big };
    }
    if (str == "float_le") {
        return PcmFormat{ PcmEncoding::Float32, PcmEndian::Little };
    }
    if (str == "float64") {
        return PcmFormat{ PcmEncoding::Float64, PcmEndian::Native };
    }
    if (str == "float64_be") {
        return PcmFormat{ PcmEncoding::Float64, PcmEndian::Big };
    }
    if (str == "float64_le") {
        return PcmFormat{ PcmEncoding::Float64, PcmEndian::Little };
    }
    return {};
}

// Format to string
inline std::string pcm_format_to_string(const PcmFormat& format) {
    switch (format.encoding) {
    case PcmEncoding::SInt8:
        switch (format.endian) {
        case PcmEndian::Native:
            return "s8";
        case PcmEndian::Big:
            return "s8_be";
        case PcmEndian::Little:
            return "s8_le";
        }
        break;
    case PcmEncoding::UInt8:
        switch (format.endian) {
        case PcmEndian::Native:
            return "u8";
        case PcmEndian::Big:
            return "u8_be";
        case PcmEndian::Little:
            return "u8_le";
        }
        break;
    case PcmEncoding::SInt16:
        switch (format.endian) {
        case PcmEndian::Native:
            return "s16";
        case PcmEndian::Big:
            return "s16_be";
        case PcmEndian::Little:
            return "s16_le";
        }
        break;
    case PcmEncoding::UInt16:
        switch (format.endian) {
        case PcmEndian::Native:
            return "u16";
        case PcmEndian::Big:
            return "u16_be";
        case PcmEndian::Little:
            return "u16_le";
        }
        break;
    case PcmEncoding::SInt18_3B:
        switch (format.endian) {
        case PcmEndian::Native:
            return "s18_3";
        case PcmEndian::Big:
            return "s18_3be";
        case PcmEndian::Little:
            return "s18_3le";
        }
        break;
    case PcmEncoding::UInt18_3B:
        switch (format.endian) {
        case PcmEndian::Native:
            return "u18_3";
        case PcmEndian::Big:
            return "u18_3be";
        case PcmEndian::Little:
            return "u18_3le";
        }
        break;
    case PcmEncoding::SInt20_3B:
        switch (format.endian) {
        case PcmEndian::Native:
            return "s20_3";
        case PcmEndian::Big:
            return "s20_3be";
        case PcmEndian::Little:
            return "s20_3le";
        }
        break;
    case PcmEncoding::UInt20_3B:
        switch (format.endian) {
        case PcmEndian::Native:
            return "u20_3";
        case PcmEndian::Big:
            return "u20_3be";
        case PcmEndian::Little:
            return "u20_3le";
        }
        break;
    case PcmEncoding::SInt20_4B:
        switch (format.endian) {
        case PcmEndian::Native:
            return "s20";
        case PcmEndian::Big:
            return "s20_be";
        case PcmEndian::Little:
            return "s20_le";
        }
        break;
    case PcmEncoding::UInt20_4B:
        switch (format.endian) {
        case PcmEndian::Native:
            return "u20";
        case PcmEndian::Big:
            return "u20_be";
        case PcmEndian::Little:
            return "u20_le";
        }
        break;
    case PcmEncoding::SInt24_3B:
        switch (format.endian) {
        case PcmEndian::Native:
            return "s24_3";
        case PcmEndian::Big:
            return "s24_3be";
        case PcmEndian::Little:
            return "s24_3le";
        }
        break;
    case PcmEncoding::UInt24_3B:
        switch (format.endian) {
        case PcmEndian::Native:
            return "u24_3";
        case PcmEndian::Big:
            return "u24_3be";
        case PcmEndian::Little:
            return "u24_3le";
        }
        break;
    case PcmEncoding::SInt24_4B:
        switch (format.endian) {
        case PcmEndian::Native:
            return "s24";
        case PcmEndian::Big:
            return "s24_be";
        case PcmEndian::Little:
            return "s24_le";
        }
        break;
    case PcmEncoding::UInt24_4B:
        switch (format.endian) {
        case PcmEndian::Native:
            return "u24";
        case PcmEndian::Big:
            return "u24_be";
        case PcmEndian::Little:
            return "u24_le";
        }
        break;
    case PcmEncoding::SInt32:
        switch (format.endian) {
        case PcmEndian::Native:
            return "s32";
        case PcmEndian::Big:
            return "s32_be";
        case PcmEndian::Little:
            return "s32_le";
        }
        break;
    case PcmEncoding::UInt32:
        switch (format.endian) {
        case PcmEndian::Native:
            return "u32";
        case PcmEndian::Big:
            return "u32_be";
        case PcmEndian::Little:
            return "u32_le";
        }
        break;
    case PcmEncoding::Float32:
        switch (format.endian) {
        case PcmEndian::Native:
            return "float";
        case PcmEndian::Big:
            return "float_be";
        case PcmEndian::Little:
            return "float_le";
        }
        break;
    case PcmEncoding::Float64:
        switch (format.endian) {
        case PcmEndian::Native:
            return "float64";
        case PcmEndian::Big:
            return "float64_be";
        case PcmEndian::Little:
            return "float64_le";
        }
        break;
    }
    return "";
}

// Format from ALSA
inline PcmFormat pcm_format_from_alsa(int format) {
    switch (format) {
    case SND_PCM_FORMAT_S8:
#ifdef PCM_BIG_ENDIAN
        return PcmFormat{ PcmEncoding::SInt8, PcmEndian::Big };
#else
        return PcmFormat{ PcmEncoding::SInt8, PcmEndian::Little };
#endif
    case SND_PCM_FORMAT_U8:
#ifdef PCM_BIG_ENDIAN
        return PcmFormat{ PcmEncoding::UInt8, PcmEndian::Big };
#else
        return PcmFormat{ PcmEncoding::UInt8, PcmEndian::Little };
#endif
    case SND_PCM_FORMAT_S16_BE:
        return PcmFormat{ PcmEncoding::SInt16, PcmEndian::Big };
    case SND_PCM_FORMAT_S16_LE:
        return PcmFormat{ PcmEncoding::SInt16, PcmEndian::Little };
    case SND_PCM_FORMAT_U16_BE:
        return PcmFormat{ PcmEncoding::UInt16, PcmEndian::Big };
    case SND_PCM_FORMAT_U16_LE:
        return PcmFormat{ PcmEncoding::UInt16, PcmEndian::Little };
    case SND_PCM_FORMAT_S18_3BE:
        return PcmFormat{ PcmEncoding::SInt18_3B, PcmEndian::Big };
    case SND_PCM_FORMAT_S18_3LE:
        return PcmFormat{ PcmEncoding::SInt18_3B, PcmEndian::Little };
    case SND_PCM_FORMAT_U18_3BE:
        return PcmFormat{ PcmEncoding::UInt18_3B, PcmEndian::Big };
    case SND_PCM_FORMAT_U18_3LE:
        return PcmFormat{ PcmEncoding::UInt18_3B, PcmEndian::Little };
    case SND_PCM_FORMAT_S20_3BE:
        return PcmFormat{ PcmEncoding::SInt20_3B, PcmEndian::Big };
    case SND_PCM_FORMAT_S20_3LE:
        return PcmFormat{ PcmEncoding::SInt20_3B, PcmEndian::Little };
    case SND_PCM_FORMAT_U20_3BE:
        return PcmFormat{ PcmEncoding::UInt20_3B, PcmEndian::Big };
    case SND_PCM_FORMAT_U20_3LE:
        return PcmFormat{ PcmEncoding::UInt20_3B, PcmEndian::Little };
    case SND_PCM_FORMAT_S20_BE:
        return PcmFormat{ PcmEncoding::SInt20_4B, PcmEndian::Big };
    case SND_PCM_FORMAT_S20_LE:
        return PcmFormat{ PcmEncoding::SInt20_4B, PcmEndian::Little };
    case SND_PCM_FORMAT_U20_BE:
        return PcmFormat{ PcmEncoding::UInt20_4B, PcmEndian::Big };
    case SND_PCM_FORMAT_U20_LE:
        return PcmFormat{ PcmEncoding::UInt20_4B, PcmEndian::Little };
    case SND_PCM_FORMAT_S24_3BE:
        return PcmFormat{ PcmEncoding::SInt24_3B, PcmEndian::Big };
    case SND_PCM_FORMAT_S24_3LE:
        return PcmFormat{ PcmEncoding::SInt24_3B, PcmEndian::Little };
    case SND_PCM_FORMAT_U24_3BE:
        return PcmFormat{ PcmEncoding::UInt24_3B, PcmEndian::Big };
    case SND_PCM_FORMAT_U24_3LE:
        return PcmFormat{ PcmEncoding::UInt24_3B, PcmEndian::Little };
    case SND_PCM_FORMAT_S24_BE:
        return PcmFormat{ PcmEncoding::SInt24_4B, PcmEndian::Big };
    case SND_PCM_FORMAT_S24_LE:
        return PcmFormat{ PcmEncoding::SInt24_4B, PcmEndian::Little };
    case SND_PCM_FORMAT_U24_BE:
        return PcmFormat{ PcmEncoding::UInt24_4B, PcmEndian::Big };
    case SND_PCM_FORMAT_U24_LE:
        return PcmFormat{ PcmEncoding::UInt24_4B, PcmEndian::Little };
    case SND_PCM_FORMAT_S32_BE:
        return PcmFormat{ PcmEncoding::SInt32, PcmEndian::Big };
    case SND_PCM_FORMAT_S32_LE:
        return PcmFormat{ PcmEncoding::SInt32, PcmEndian::Little };
    case SND_PCM_FORMAT_U32_BE:
        return PcmFormat{ PcmEncoding::UInt32, PcmEndian::Big };
    case SND_PCM_FORMAT_U32_LE:
        return PcmFormat{ PcmEncoding::UInt32, PcmEndian::Little };
    case SND_PCM_FORMAT_FLOAT_BE:
        return PcmFormat{ PcmEncoding::Float32, PcmEndian::Big };
    case SND_PCM_FORMAT_FLOAT_LE:
        return PcmFormat{ PcmEncoding::Float32, PcmEndian::Little };
    case SND_PCM_FORMAT_FLOAT64_BE:
        return PcmFormat{ PcmEncoding::Float64, PcmEndian::Big };
    case SND_PCM_FORMAT_FLOAT64_LE:
        return PcmFormat{ PcmEncoding::Float64, PcmEndian::Little };
    }
    return {};
}

// Format to ALSA
inline int pcm_format_to_alsa(const PcmFormat& format) {
    switch (format.encoding) {
    case PcmEncoding::SInt8:
        switch (format.endian) {
        case PcmEndian::Native:
            return SND_PCM_FORMAT_S8;
        case PcmEndian::Big:
            return SND_PCM_FORMAT_S8;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_S8;
        }
        break;
    case PcmEncoding::UInt8:
        switch (format.endian) {
        case PcmEndian::Native:
            return SND_PCM_FORMAT_U8;
        case PcmEndian::Big:
            return SND_PCM_FORMAT_U8;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_U8;
        }
        break;
    case PcmEncoding::SInt16:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_S16_BE;
#else
            return SND_PCM_FORMAT_S16_LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_S16_BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_S16_LE;
        }
        break;
    case PcmEncoding::UInt16:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_U16_BE;
#else
            return SND_PCM_FORMAT_U16_LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_U16_BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_U16_LE;
        }
        break;
    case PcmEncoding::SInt18_3B:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_S18_3BE;
#else
            return SND_PCM_FORMAT_S18_3LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_S18_3BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_S18_3LE;
        }
        break;
    case PcmEncoding::UInt18_3B:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_U18_3BE;
#else
            return SND_PCM_FORMAT_U18_3LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_U18_3BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_U18_3LE;
        }
        break;
    case PcmEncoding::SInt20_3B:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_S20_3BE;
#else
            return SND_PCM_FORMAT_S20_3LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_S20_3BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_S20_3LE;
        }
        break;
    case PcmEncoding::UInt20_3B:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_U20_3BE;
#else
            return SND_PCM_FORMAT_U20_3LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_U20_3BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_U20_3LE;
        }
        break;
    case PcmEncoding::SInt20_4B:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_S20_BE;
#else
            return SND_PCM_FORMAT_S20_LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_S20_BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_S20_LE;
        }
        break;
    case PcmEncoding::UInt20_4B:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_U20_BE;
#else
            return SND_PCM_FORMAT_U20_LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_U20_BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_U20_LE;
        }
        break;
    case PcmEncoding::SInt24_3B:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_S24_3BE;
#else
            return SND_PCM_FORMAT_S24_3LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_S24_3BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_S24_3LE;
        }
        break;
    case PcmEncoding::UInt24_3B:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_U24_3BE;
#else
            return SND_PCM_FORMAT_U24_3LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_U24_3BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_U24_3LE;
        }
        break;
    case PcmEncoding::SInt24_4B:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_S24_BE;
#else
            return SND_PCM_FORMAT_S24_LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_S24_BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_S24_LE;
        }
        break;
    case PcmEncoding::UInt24_4B:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_U24_BE;
#else
            return SND_PCM_FORMAT_U24_LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_U24_BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_U24_LE;
        }
        break;
    case PcmEncoding::SInt32:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_S32_BE;
#else
            return SND_PCM_FORMAT_S32_LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_S32_BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_S32_LE;
        }
        break;
    case PcmEncoding::UInt32:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_U32_BE;
#else
            return SND_PCM_FORMAT_U32_LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_U32_BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_U32_LE;
        }
        break;
    case PcmEncoding::Float32:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_FLOAT_BE;
#else
            return SND_PCM_FORMAT_FLOAT_LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_FLOAT_BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_FLOAT_LE;
        }
        break;
    case PcmEncoding::Float64:
        switch (format.endian) {
        case PcmEndian::Native:
#ifdef PCM_BIG_ENDIAN
            return SND_PCM_FORMAT_FLOAT64_BE;
#else
            return SND_PCM_FORMAT_FLOAT64_LE;
#endif
        case PcmEndian::Big:
            return SND_PCM_FORMAT_FLOAT64_BE;
        case PcmEndian::Little:
            return SND_PCM_FORMAT_FLOAT64_LE;
        }
        break;
    }
    return SND_PCM_FORMAT_UNKNOWN;
}

} // namespace signal_estimator
