/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "kingdom/kingdom.h"

namespace Kingdom {

byte _finalFrameTable[] = {
	0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0,
	1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0,
	0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0,
	1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1,
	0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1,
	1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1,
	1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1,
	1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 0, 0, 0, 0, 0, 0, 1
};

const char *_rezNames[] = {
	"",
	"KMAP001.lbm",
	"KMAP002.lbm",
	"KMAP003.lbm",
	"KMAP004.lbm",
	"KMAP005.lbm",
	"KMAP006.lbm",
	"KMAP007.lbm",
	"KMAP008.lbm",
	"KMAP009.lbm",
	"KMAP010.lbm",
	"KMAP011.lbm",
	"KMAP012.lbm",
	"KMAP013.lbm",
	"KMAP014.lbm",
	"KMAP015.lbm",
	"KMAP016.lbm",
	"KMAP017.lbm",
	"KMAP018.lbm",
	"KMAP019.lbm",
	"KMAP020.lbm",
	"KMAP021.lbm",
	"KMAP022.lbm",
	"KMAP023.lbm",
	"KMAP024.lbm",
	"KMAP025.lbm",
	"KMAP026.lbm",
	"KMAP027.lbm",
	"KMAP028.lbm",
	"KMAP029.lbm",
	"KMAP030.lbm",
	"KMAP031.lbm",
	"KMAP032.lbm",
	"KMAP033.lbm",
	"KMAP034.lbm",
	"KMAP035.lbm",
	"KMAP036.lbm",
	"KMAP037.lbm",
	"KMAP038.lbm",
	"KMAP039.lbm",
	"KMAP040.lbm",
	"KMAP041.lbm",
	"KMAP042.lbm",
	"KMAP043.lbm",
	"KMAP044.lbm",
	"KMAP045.lbm",
	"KMAP046.lbm",
	"KMAP047.lbm",
	"KMAP048.lbm",
	"KMAP049.lbm",
	"KMAP050.lbm",
	"KMAP051.lbm",
	"KMAP052.lbm",
	"KMAP053.lbm",
	"KMAP054.lbm",
	"KMAP055.lbm",
	"KMAP056.lbm",
	"KMAP057.lbm",
	"KMAP058.lbm",
	"KMAP059.lbm",
	"KMAP060.lbm",
	"KMAP061.lbm",
	"KMAP062.lbm",
	"KMAP063.lbm",
	"KMAP064.lbm",
	"KMAP065.lbm",
	"KMAP066.lbm",
	"KMAP067.lbm",
	"KMAP068.lbm",
	"KMAP069.lbm",
	"KMAP070.lbm",
	"KMAP071.lbm",
	"KMAP072.lbm",
	"KMAP073.lbm",
	"KMAP074.lbm",
	"KMAP075.lbm",
	"KMAP076.lbm",
	"KMAP077.lbm",
	"KMAP078.lbm",
	"KMAP079.lbm",
	"KMAP080.lbm",
	"KMAP081.lbm",
	"KMAP082.lbm",
	"KMAP083.lbm",
	"KMAP084.lbm",
	"KMAP085.lbm",
	"KMAP086.lbm",
	"KMAP087.lbm",
	"KMAP088.lbm",
	"KMAP089.lbm",
	"KMAP090.lbm",
	"KMAP091.lbm",
	"KMAP092.lbm",
	"KMAP093.lbm",
	"KMAP094.lbm",
	"KMAP095.lbm",
	"KMAP096.lbm",
	"KMAP097.lbm",
	"KMAP098.lbm",
	"KMAP099.lbm",
	"KMAP100.lbm",
	"KMAP101.lbm",
	"KMAP102.lbm",
	"KMAP103.lbm",
	"KSndCard.lbm",
	"KBook.lbm",
	"KInterF.lbm",
	"KGamOver.lbm",
	"KPouch.lbm",
	"KForest.lbm",
	"KArtist.lbm",
	"K4.lbm",
	"K5.lbm",
	"K6.lbm",
	"KRestore.lbm",
	"KINIT.lbm",
	"KASKS1.lbm",
	"KASKS2.lbm",
	"KASKS3.lbm",
	"KIlleSgn.lbm",
	"KTSMAP.lbm",
	"KPORHELH.lbm",
	"KGSaved.lbm",
	"KDoor.lbm",
	"KLogo.lbm",
	"KEOG.lbm",
	"K8.lbm",
	"K9.lbm",
	"KPalace3.lbm",
	"KBKenter.lbm",
	"KIUNDER.lbm",
	"KISEEING.lbm",
	"KIRELESE.lbm",
	"KITRAVEL.lbm",
	"KIXTAL.lbm",
	"KICFIRE.lbm",
	"KIOSEAL.lbm",
	"KISTAFF.lbm",
	"KISWORD.lbm",
	"KISEPTER.lbm",
	"KIBOW.lbm",
	"KICOINS.lbm",
	"KICHALIC.lbm",
	"KIWHEAT.lbm",
	"KIRUNES.lbm",
	"KRMACE.lbm",
	"KRHORN.lbm",
	"KRORB.lbm",
	"K10.lbm",
	"K11.lbm",
	"KEMACE.lbm",
	"kingArt.art",
	"K12.lbm",
	"K13.lbm",
	"K14.lbm",
	"K15.lbm",
	"K16.lbm",
	"K17.lbm",
	"K18.lbm",
	"K19.lbm",
	"K20.lbm",
	"KHelp01.lbm",
	"KHelp02.lbm",
	"KHelp03.lbm",
	"KHelp04.lbm",
	"KHelp05.lbm",
	"KHelp06.lbm",
	"KHelp07.lbm",
	"KHelp08.lbm",
	"KHelp09.lbm",
	"KHelp10.lbm",
	"KHelp11.lbm",
	"KHelp12.lbm",
	"K21.lbm",
	"K22.lbm",
	"K23.lbm",
	"K24.lbm",
	"K25.lbm",
	"KTideOn.lbm",
	"KTideOff.lbm",
	"K26.lbm",
	"K27.lbm",
	"K28.lbm",
	"K29.lbm",
	"K30.lbm",
	"K31.lbm",
	"K32.lbm",
	"K33.lbm",
	"K34.lbm",
	"K35.lbm",
	"K36.lbm",
	"K37.lbm",
	"K38.lbm",
	"K39.lbm",
	"K40.lbm",
	"K41.lbm",
	"K42.lbm",
	"K43.lbm",
	"StrtDemo.lbm",
	"EndDemo.lbm",
	"TST.lbm",
	"L1.ssd",
	"L2.ssd",
	"L3.ssd",
	"L4.ssd",
	"L5.ssd",
	"L6.ssd",
	"L7.ssd",
	"L8.ssd",
	"L9.ssd",
	"L10.ssd",
	"L11.ssd",
	"L12.ssd",
	"L13.ssd",
	"L14.ssd",
	"L15.ssd",
	"L16.ssd",
	"L17.ssd",
	"L18.ssd",
	"L19.ssd",
	"L20.ssd",
	"L21.ssd",
	"L22.ssd",
	"L23.ssd",
	"L24.ssd",
	"L25.ssd",
	"L26.ssd",
	"L27.ssd",
	"L28.ssd",
	"L29.ssd",
	"L30.ssd",
	"L31.ssd",
	"L32.ssd",
	"L33.ssd",
	"L34.ssd",
	"L35.ssd",
	"L36.ssd",
	"L37.ssd",
	"L38.ssd",
	"L39.ssd",
	"L40.ssd",
	"L41.ssd",
	"L42.ssd",
	"L43.ssd",
	"L44.ssd",
	"L45.ssd",
	"L46.ssd",
	"L47.ssd",
	"L48.ssd",
	"L49.ssd",
	"L50.ssd",
	"L1.msd",
	"L2.msd",
	"L3.msd",
	"L4.msd",
	"L5.msd",
	"L6.msd",
	"L7.msd",
	"L8.msd",
	"L9.msd",
	"L10.msd",
	"L11.msd",
	"L12.msd",
	"L13.msd",
	"L14.msd",
	"L15.msd",
	"L16.msd",
	"L17.msd",
	"L18.msd",
	"L19.msd",
	"L20.msd",
	"L21.msd",
	"L22.msd",
	"L23.msd",
	"L24.msd",
	"L25.msd",
	"L26.msd",
	"L27.msd",
	"L28.msd",
	"L29.msd",
	"L30.msd",
	"L31.msd",
	"L32.msd",
	"L33.msd",
	"L34.msd",
	"L35.msd",
	"L36.msd",
	"L37.msd",
	"L38.msd",
	"L39.msd",
	"L40.msd",
	"L41.msd",
	"L42.msd",
	"L43.msd",
	"L44.msd",
	"L45.msd",
	"L46.msd",
	"L47.msd",
	"L48.msd",
	"L49.msd",
	"L50.msd",
	"KLF001.lbm",
	"KLF002.lbm",
	"KLF003.lbm",
	"KLF004.lbm",
	"KLF005.lbm",
	"KLF006.lbm",
	"KLF007.lbm",
	"KLF008.lbm",
	"KLF009.lbm",
	"KLF010.lbm",
	"KLF011.lbm",
	"KLF012.lbm",
	"KLF013.lbm",
	"KLF014.lbm",
	"KLF015.lbm",
	"KLF016.lbm",
	"KLF017.lbm",
	"KLF018.lbm",
	"KLF019.lbm",
	"KLF020.lbm",
	"KLF021.lbm",
	"KLF022.lbm",
	"KLF023.lbm",
	"KLF024.lbm",
	"KLF025.lbm",
	"KLF026.lbm",
	"KLF027.lbm",
	"KLF028.lbm",
	"KLF029.lbm",
	"KLF030.lbm",
	"KLF031.lbm",
	"KLF032.lbm",
	"KLF033.lbm",
	"KLF034.lbm",
	"KLF035.lbm",
	"KLF036.lbm",
	"KLF037.lbm",
	"KLF038.lbm",
	"KLF039.lbm",
	"KLF040.lbm",
	"KLF041.lbm",
	"KLF042.lbm",
	"KLF043.lbm",
	"KLF044.lbm",
	"KLF045.lbm",
	"KLF046.lbm",
	"KLF047.lbm",
	"KLF048.lbm",
	"KLF049.lbm",
	"KLF050.lbm",
	"KLF051.lbm",
	"KLF052.lbm",
	"KLF053.lbm",
	"KLF054.lbm",
	"KLF055.lbm",
	"KLF056.lbm",
	"KLF057.lbm",
	"KLF058.lbm",
	"KLF059.lbm",
	"KLF060.lbm",
	"KLF061.lbm",
	"KLF062.lbm",
	"KLF063.lbm",
	"KLF064.lbm",
	"KLF065.lbm",
	"KLF066.lbm",
	"KLF067.lbm",
	"KLF068.lbm",
	"KLF069.lbm",
	"KLF070.lbm",
	"KLF071.lbm",
	"KLF072.lbm",
	"KLF073.lbm",
	"KLF074.lbm",
	"KLF075.lbm",
	"KLF076.lbm",
	"KLF077.lbm",
	"KLF078.lbm",
	"KLF079.lbm",
	"KLF080.lbm",
	"KLF081.lbm",
	"KLF082.lbm",
	"KLF083.lbm",
	"KLF084.lbm",
	"KLF085.lbm",
	"KLF086.lbm",
	"KLF087.lbm",
	"KLF088.lbm",
	"KLF089.lbm",
	"KLF090.lbm",
	"KLF091.lbm",
	"KLF092.lbm",
	"KLF093.lbm",
	"KLF094.lbm",
	"KLF095.lbm",
	"KLF096.lbm",
	"KLF097.lbm",
	"KLF098.lbm",
	"KLF099.lbm",
	"KLF100.lbm",
	"KLF101.lbm",
	"KLF102.lbm",
	"KLF103.lbm",
	"KLF104.lbm",
	"KLF105.lbm",
	"KLF106.lbm",
	"KLF107.lbm",
	"KLF108.lbm",
	"KLF109.lbm",
	"KLF110.lbm",
	"KLF111.lbm",
	"KLF112.lbm",
	"KLF113.lbm",
	"KLF114.lbm",
	"KLF115.lbm",
	"KLF116.lbm",
	"KLF117.lbm",
	"KLF118.lbm",
	"KLF119.lbm",
	"KLF120.lbm",
	"KLF121.lbm",
	"KLF122.lbm",
	"KLF123.lbm",
	"KLF124.lbm",
	"KLF125.lbm",
	"KLF126.lbm",
	"KLF127.lbm",
	"KLF128.lbm",
	"KLF129.lbm",
	"KLF130.lbm",
	"KLF131.lbm",
	"KLF132.lbm",
	"KLF133.lbm",
	"KLF134.lbm",
	"KLF135.lbm",
	"KLF136.lbm",
	"KLF137.lbm",
	"KLF138.lbm",
	"KLF139.lbm",
	"KLF140.lbm",
	"KLF141.lbm",
	"KLF142.lbm",
	"KLF143.lbm",
	"KLF144.lbm",
	"KLF145.lbm",
	"KLF146.lbm",
	"KLF147.lbm",
	"KLF148.lbm",
	"KLF149.lbm",
	"KLF150.lbm",
	"KLF151.lbm",
	"KLF152.lbm",
	"KLF153.lbm",
	"KLF154.lbm",
	"KLF155.lbm",
	"KLF156.lbm",
	"KLF157.lbm",
	"KLF158.lbm",
	"KLF159.lbm",
	"KLF160.lbm",
	"KLF161.lbm",
	"KLF162.lbm",
	"KLF163.lbm",
	"KLF164.lbm",
	"KLF165.lbm",
	"KLF166.lbm",
	"KLF167.lbm",
	"KLF168.lbm",
	"KLF169.lbm",
	"KLF170.lbm",
	"KLF171.lbm",
	"KLF172.lbm",
	"KLF173.lbm",
	"KLF174.lbm",
	"KLF175.lbm",
	"KLF176.lbm",
	"KLF177.lbm",
	"KLF178.lbm",
	"KLF179.lbm",
	"KLF180.lbm",
	"KLF181.lbm",
	"KLF182.lbm",
	"KLF183.lbm",
	"KLF184.lbm",
	"KLF185.lbm",
	"KLF186.lbm",
	"KLF187.lbm",
	"KLF188.lbm",
	"KLF189.lbm",
	"KLF190.lbm",
	"KLF191.lbm",
	"KLF192.lbm",
	"KLF193.lbm",
	"KLF194.lbm",
	"KLF195.lbm",
	"KLF196.lbm",
	"KLF197.lbm",
	"KLF198.lbm",
	"KLF199.lbm",
	"KLF200.lbm",
	"KLF201.lbm",
	"KLF202.lbm",
	"KLF203.lbm",
	"KLF204.lbm",
	"KLF205.lbm",
	"KLF206.lbm",
	"KLF207.lbm",
	"KLF208.lbm",
	"KLF209.lbm",
};

int _mapExit[] = {
	100,  90,  50, 420, 550, 110,  70,  80, 180, 190,
	200, 210, 230, 240, 300, 290, 330, 360, 310, 370,
	390,  60, 570,  30,  40, 340, 640, 520, 510, 500,
	540, 320, 140, 270, 380, 580, 590, 610,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

int _emlTable[] = {
	 0,  0,  0, 65, 66, 69,  0, 59,  0, 60,
	61, 63,  0,  0, 62,  0,  0,  0, 58,  0,
	63, 67, 67,  0, 70, 75,  0, 77,  0, 72,
	33, 73, 82, 79, 76,  0, 75, 45, 81,  0,
	 0,  0, 78,  0, 83,  0,  0,  0, 78,  0,
	88, 85, 86,  0, 91, 87, 98, 84, 93, 92,
	 0,  0,  0,  0, 89,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0
};

int _zoomTable[81][9][2] = {
	// The first array is a dummy one used to fix an stupid trick on the index in the original
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x41, 0x15}, {0x1C, 0x14}, {0x0B, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x42, 0x0A}, {0x1B, 0x16}, {0x0C, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x45, 0x0A}, {0x1F, 0x17}, {0x0C, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x40, 0x0A}, {0x1A, 0x18}, {0x0B, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x3B, 0x0A}, {0x13, 0x19}, {0x0B, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x38, 0x1B}, {0x10, 0x1A}, {0x0B, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x3C, 0x0A}, {0x15, 0x1C}, {0x0B, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x3D, 0x0A}, {0x17, 0x1D}, {0x0C, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x3F, 0x1F}, {0x19, 0x1E}, {0x0B, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x3E, 0x0A}, {0x18, 0x23}, {0x0C, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x38, 0x1B}, {0x10, 0x1A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x3A, 0x0A}, {0x11, 0x24}, {0x0B, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{0x5F, 0x20}, {0x3F, 0x12}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x43, 0x26}, {0x1D, 0x25}, {0x0C, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x43, 0x26}, {0x1D, 0x25}, {0x0C, 0x0A}, {   8, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x46, 0x0A}, {0x1E, 0x27}, {0x20, 0x0A}, {0x0C, 0x0A}, {   8, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x4B, 0x0A}, {0x25, 0x28}, {0x0E, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x4D, 0x0A}, {0x27, 0x2A}, {0x0D, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x29}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x48, 0x0A}, {0x22, 0x2B}, {0x0D, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {0x21, 0x29}, {0x0D, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x49, 0x0A}, {0x23, 0x2C}, {0x0D, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x52, 0x0A}, {0x2C, 0x2D}, {0x0E, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x4F, 0x0A}, {0x29, 0x2E}, {0x0E, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x4C, 0x30}, {0x26, 0x2F}, {0x0D, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x4E, 0x0A}, {0x28, 0x36}, {0x0E, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x53, 0x0A}, {0x2D, 0x32}, {0x0D, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x51, 0x0A}, {0x2B, 0x34}, {0x0E, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{0x61, 0x35}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{0x62, 0x35}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x4E, 0x0A}, {0x28, 0x36}, {0x0E, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x53, 0x0A}, {0x2D, 0x0A}, {0x0D, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x53, 0x0A}, {0x2D, 0x32}, {0x0D, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{0x61, 0x35}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x4E, 0x0A}, {0x28, 0x36}, {0x0E, 0x0A}, {   9, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x58, 0x0A}, {0x32, 0x38}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {0x55, 0x0A}, {0x2F, 0x39}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {0x56, 0x3B}, {0x30, 0x3A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{   0, 0x0A}, {0x5B, 0x3D}, {0x35, 0x3C}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {0x57, 0x0A}, {0x31, 0x3E}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{0x62, 0x0A}, {0x57, 0x0A}, {0x31, 0x3E}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {0x54, 0x0A}, {0x2E, 0x41}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {0x5D, 0x0A}, {0x37, 0x42}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x48}, {0x5C, 0x44}, {0x36, 0x43}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{0x63, 0x0A}, {0x5A, 0x46}, {0x34, 0x45}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{0x62, 0x40}, {0x57, 0x3F}, {0x31, 0x0A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{0x62, 0x40}, {0x57, 0x3F}, {0x31, 0x0A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {0x59, 0x0A}, {0x33, 0x47}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{0x64, 0x48}, {0x5C, 0x0A}, {0x36, 0x0A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{0x64, 0x48}, {0x5C, 0x0A}, {0x36, 0x0A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{0x64, 0x48}, {0x5C, 0x0A}, {0x36, 0x0A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{0x63, 0x49}, {0x5A, 0x0A}, {0x34, 0x45}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{0x64, 0x48}, {0x5C, 0x0A}, {0x36, 0x0A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{0x64, 0x48}, {0x5C, 0x0A}, {0x36, 0x0A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{0x63, 0x49}, {0x5A, 0x0A}, {0x34, 0x0A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{0x63, 0x49}, {0x5A, 0x0A}, {0x34, 0x0A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   8, 0x0A}, {   5, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{0x64, 0x48}, {0x5C, 0x0A}, {0x36, 0x0A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}, {   0, 0x0A}},
	{{0x64, 0x48}, {0x5C, 0x0A}, {0x36, 0x0A}, {0x0F, 0x0A}, {0x0A, 0x0A}, {   7, 0x0A}, {   4, 0x0A}, {   3, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {0x3C, 0x0A}, {0x15, 0x0A}, {0x0B, 0x0A}, {   8, 0x0A}, {   5, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}},
	{{   0, 0x0A}, {0x3A, 0x0A}, {0x12, 0x24}, {0x0B, 0x0A}, {   8, 0x0A}, {   5, 0x0A}, {   4, 0x0A}, {   2, 0x0A}, {   1, 0x0A}}
};

int _iconActTable[82][7] = {
	{18, 18, 18, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18,  1, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18,  7},
	{ 3, 18,  4,  2, 18,  5, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 15, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18,  6, 18},
	{18,  4, 18, 18, 18, 18, 18},
	{ 3,  7,  2, 18,  1,  0, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18,  5,  2,  0, 18, 18},
	{ 3,  0, 18,  2, 18,  4,  1},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18,  5,  1,  2,  0, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18,  5,  0,  2,  4, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18,  9, 10},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18,  9, 18, 18, 18, 18},
	{ 3,  0, 18,  1,  2, 18, 18},
	{ 3, 18, 15,  6,  9,  2,  0},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 15,  2,  0, 13, 11,  8},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18,  2,  4,  6, 15, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18,  2,  6,  0,  1, 18},
	{ 3, 18, 12,  0, 16, 18,  2},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18,  0, 18,  2, 18,  1},
	{ 3,  2, 18,  0, 11,  1, 17},
	{ 3, 18, 18, 12, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18,  0,  1,  2, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18,  4, 18},
	{ 3, 18,  2, 16,  1, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 13,  2,  8,  0,  1},
	{ 3, 18, 18, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 10, 18,  2,  1,  0},
	{ 3,  0, 18,  1, 18,  2,  8},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3,  2, 17,  0, 18,  1, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3,  8, 10,  2, 11, 14,  0},
	{18, 18, 18, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 15,  2, 10,  1,  0},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 18, 18, 18, 18, 18},
	{18, 18, 18, 18, 18, 18, 18},
	{ 3, 18, 17,  2,  0, 18,  1},
	{ 3, 18, 18, 18, 18, 18, 18},
	{ 3, 18,  2,  4, 18,  1, 18},
	{ 3, 18, 18, 18,  0, 18, 18}
};

int _teaSeq[6][2] = {
	{138, 24},
	{139,  3},
	{138, 12},
	{140,  3},
	{138, 12},
	{141,  2}
};

int _hgaSeq[4][2] = {
	{47, 0},
	{48, 0},
	{49, 0},
	{50, 0}
};

#define INITHOTSPOT(x1, x2, y1, y2, id)  { x1, y1, x2, y2, id }
#define DUMMYHOTSPOT(id) { 0, 0, 0, 0, id }
HotSpot _mouseMapMSFull[51] = {
	INITHOTSPOT( 11,  35, 178, 197, 0x181),
	INITHOTSPOT( 38,  62, 178, 197, 0x182),
	INITHOTSPOT( 65,  89, 178, 197, 0x183),
	INITHOTSPOT( 92, 116, 178, 197, 0x184),
	INITHOTSPOT(119, 143, 178, 197, 0x185),
	INITHOTSPOT(146, 170, 178, 197, 0x186),
	INITHOTSPOT(173, 197, 178, 197, 0x187),
	INITHOTSPOT(271, 292, 124, 143, 0x44F),
	INITHOTSPOT(262, 298,  51,  80, 0x18A),
	INITHOTSPOT(243, 267, 141, 160, 0x18C),
	INITHOTSPOT(290, 314, 143, 162, 0x18D),
	INITHOTSPOT(272, 296, 170, 189, 0x457),
	DUMMYHOTSPOT(0),
	DUMMYHOTSPOT(0),
	DUMMYHOTSPOT(0),
	DUMMYHOTSPOT(0),
	INITHOTSPOT( 74,  92,  60,  75, 0x417),
	INITHOTSPOT( 74,  89,  75,  93, 0x418),
	INITHOTSPOT( 92, 105,  96, 111, 0x402),
	INITHOTSPOT( 74,  87,  50,  61, 0x415),
	INITHOTSPOT( 50,  67,  43,  52, 0x406),
	INITHOTSPOT( 29,  37,  43,  55, 0x407),
	INITHOTSPOT( 45,  56,  67,  74, 0x401),
	INITHOTSPOT( 52,  65,  80,  90, 0x400),
	INITHOTSPOT( 45,  75, 102, 112, 0x420),
	INITHOTSPOT( 25,  38,  59,  69, 0x408),
	INITHOTSPOT( 75,  85,  33,  43, 0x40A),
	INITHOTSPOT( 75,  90,  99, 112, 0x40B),
	INITHOTSPOT( 45,  88, 113, 131, 0x40C),
	INITHOTSPOT( 89, 104, 116, 131, 0x40D),
	INITHOTSPOT(160, 178, 131, 148, 0x421),
	INITHOTSPOT(135, 149, 118, 130, 0x40F),
	INITHOTSPOT(131, 142, 138, 148, 0x412),
	INITHOTSPOT(159, 171, 168, 175, 0x410),
	INITHOTSPOT(157, 168, 110, 126, 0x419),
	DUMMYHOTSPOT(0x411),
	INITHOTSPOT(106, 128, 122, 154, 0x40E),
	INITHOTSPOT(171, 283, 156, 170, 0x422),
	INITHOTSPOT(147, 171, 152, 163, 0x403),
	DUMMYHOTSPOT(0x413),
	INITHOTSPOT(186, 203,  74,  86, 0x41C),
	INITHOTSPOT(195, 207,  89, 106, 0x41B),
	INITHOTSPOT(232, 244,  81,  89, 0x41E),
	INITHOTSPOT(215, 222,  76,  95, 0x404),
	INITHOTSPOT(214, 223, 100, 110, 0x41D),
	INITHOTSPOT(182, 196,  88,  97, 0x416),
	DUMMYHOTSPOT(0x423),
	INITHOTSPOT(225, 241, 100, 110, 0x424),
	INITHOTSPOT(209, 224, 137, 155, 0x425),
	INITHOTSPOT(211, 221, 115, 126, 0x41A),
	DUMMYHOTSPOT(0)
};

HotSpot _mouseMapMSDemo[51] = {
	INITHOTSPOT( 11,  35, 178, 197, 0x181),
	INITHOTSPOT( 38,  62, 178, 197, 0x182),
	INITHOTSPOT( 65,  89, 178, 197, 0x183),
	INITHOTSPOT( 92, 116, 178, 197, 0x184),
	INITHOTSPOT(119, 143, 178, 197, 0x185),
	INITHOTSPOT(146, 170, 178, 197, 0x186),
	INITHOTSPOT(173, 197, 178, 197, 0x187),
	INITHOTSPOT(271, 292, 124, 143, 0x44F),
	INITHOTSPOT(262, 298,  51,  80, 0x18A),
	INITHOTSPOT(243, 267, 141, 160, 0x18C),
	INITHOTSPOT(290, 314, 143, 162, 0x18D),
	INITHOTSPOT(272, 296, 170, 189, 0x457),
	DUMMYHOTSPOT(0),
	DUMMYHOTSPOT(0),
	DUMMYHOTSPOT(0),
	DUMMYHOTSPOT(0),
	INITHOTSPOT( 74,  92,  60,  75, 0x417),
	INITHOTSPOT( 74,  89,  75,  93, 0x418),
	INITHOTSPOT( 92, 105,  96, 111, 0x402),
	INITHOTSPOT( 74,  87,  50,  61, 0x415),
	INITHOTSPOT( 50,  67,  43,  52, 0x406),
	INITHOTSPOT( 29,  37,  43,  55, 0x407),
	INITHOTSPOT( 45,  56,  67,  74, 0x401),
	INITHOTSPOT( 52,  65,  80,  90, 0x400),
	INITHOTSPOT( 45,  75, 102, 112, 0x420),
	INITHOTSPOT( 25,  38,  59,  69, 0x408),
	INITHOTSPOT( 75,  85,  33,  43, 0x40A),
	INITHOTSPOT( 75,  90,  99, 112, 0x40B),
	INITHOTSPOT( 45, 104, 113, 131, 0x40C),
	DUMMYHOTSPOT(0x40D),
	DUMMYHOTSPOT(0x421),
	DUMMYHOTSPOT(0x40F),
	DUMMYHOTSPOT(0x412),
	DUMMYHOTSPOT(0x410),
	DUMMYHOTSPOT(0x419),
	DUMMYHOTSPOT(0x411),
	DUMMYHOTSPOT(0x40E),
	DUMMYHOTSPOT(0x422),
	DUMMYHOTSPOT(0x403),
	DUMMYHOTSPOT(0x413),
	DUMMYHOTSPOT(0x41C),
	DUMMYHOTSPOT(0x41B),
	DUMMYHOTSPOT(0x41E),
	DUMMYHOTSPOT(0x404),
	DUMMYHOTSPOT(0x41D),
	DUMMYHOTSPOT(0x416),
	DUMMYHOTSPOT(0x423),
	DUMMYHOTSPOT(0x424),
	DUMMYHOTSPOT(0x425),
	DUMMYHOTSPOT(0x41A),
	DUMMYHOTSPOT(0)
};

int _cursorTable[96] = {
	 51,  52,  53,  54,  55,  56,  57,  58,  59,  60,
	 61,  62,  63,  64,  65,  66,  67,  68,  69,  70,
	 71,  72,  73,  74,  75,  76,  77,  78,  79,  80,
	 81,  82,  83,  84,  85,  86,  87,  88, 103, 104,
	105, 106, 107, 108, 109, 110, 111, 112, 113, 114,
	115, 116, 117, 118, 119, 120, 121, 122, 123, 124,
	125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
	134, 134, 130, 142, 131, 130, 130, 143, 144, 145,
	148, 149, 150, 151, 151, 151, 152, 153, 145,   0,
	  0,   0,   0,   0,   0,   0
};

HotSpot _mouseMapASFull[128][16] = {
	{
		INITHOTSPOT( 15, 110, 48, 62, 0x240),
		INITHOTSPOT( 61, 176, 30, 44, 0x241),
		INITHOTSPOT(121, 216, 66, 80, 0x242),
		INITHOTSPOT(121, 216, 48, 62, 0x243),
		INITHOTSPOT(121, 216, 84, 98, 0x244),
		INITHOTSPOT( 15, 110, 66, 80, 0x245),
		INITHOTSPOT( 15, 110, 84, 98, 0x246),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(119, 197,  78,  84, 0x190),
		INITHOTSPOT(119, 197,  85,  91, 0x191),
		INITHOTSPOT(119, 197,  92,  98, 0x192),
		INITHOTSPOT(119, 197,  99, 105, 0x193),
		INITHOTSPOT( 72,  96, 103, 109, 0x194),
		INITHOTSPOT( 72,  96, 110, 116, 0x195),
		INITHOTSPOT( 72,  96, 117, 123, 0x196),
		INITHOTSPOT( 72,  96, 124, 130, 0x197),
		INITHOTSPOT( 72,  96, 131, 137, 0x198),
		INITHOTSPOT(220, 242, 111, 117, 0x199),
		INITHOTSPOT(220, 242, 118, 124, 0x19A),
		INITHOTSPOT(220, 242, 125, 131, 0x19B),
		INITHOTSPOT(141, 173, 136, 142, 0x19C),
		INITHOTSPOT(141, 173, 143, 149, 0x19D),
		INITHOTSPOT(230, 280, 182, 193, 0x19E),
		INITHOTSPOT( 34,  91, 182, 193, 0x19F)
	},
	{
		INITHOTSPOT(4, 227, 17, 160, 0x260),
		DUMMYHOTSPOT(0x261),
		DUMMYHOTSPOT(0x262),
		DUMMYHOTSPOT(0x263),
		DUMMYHOTSPOT(0x264),
		DUMMYHOTSPOT(0x265),
		DUMMYHOTSPOT(0x266),
		DUMMYHOTSPOT(0x267),
		DUMMYHOTSPOT(0x268),
		DUMMYHOTSPOT(0x269),
		DUMMYHOTSPOT(0x26A),
		DUMMYHOTSPOT(0x26B),
		DUMMYHOTSPOT(0x26C),
		DUMMYHOTSPOT(0x26D),
		DUMMYHOTSPOT(0x26E),
		DUMMYHOTSPOT(0x26F)
	},
	{
		INITHOTSPOT(17, 120, 122, 132, 0x190),
		INITHOTSPOT(17, 120, 140, 150, 0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT( 69, 242, 114, 129, 0x190),
		INITHOTSPOT( 69, 242, 132, 147, 0x191),
		INITHOTSPOT( 69, 242, 150, 165, 0x192),
		INITHOTSPOT( 69, 131, 168, 183, 0x193),
		INITHOTSPOT(181, 242, 168, 183, 0x194),
		INITHOTSPOT(133, 179, 168, 183, 0x24A),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT( 73, 105, 56,  80, 0x428),
		INITHOTSPOT( 89, 131, 88, 110, 0x42A),
		INITHOTSPOT(124, 152, 56,  81, 0x42B),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT( 61,  91, 61,  87, 0x417),
		INITHOTSPOT( 92, 122, 84, 110, 0x40A),
		INITHOTSPOT(123, 154, 61,  87, 0x406),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT( 47,  80, 48, 116, 0x445),
		INITHOTSPOT(149, 182, 51, 116, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(62, 88, 76, 141, 0x42F),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(140, 170, 102, 127, 0x428),
		INITHOTSPOT( 73, 117,  65,  82, 0x429),
		INITHOTSPOT(170, 216,  96, 121, 0x42A),
		INITHOTSPOT(121, 144,  34,  62, 0x42B),
		INITHOTSPOT(160, 183,  41,  59, 0x42C),
		INITHOTSPOT( 21,  51, 125, 151, 0x42D),
		INITHOTSPOT(201, 217,  43,  76, 0x42E),
		INITHOTSPOT( 76, 114, 119, 150, 0x42F),
		INITHOTSPOT( 18,  48,  31,  61, 0x430),
		INITHOTSPOT( 57,  72,  88, 122, 0x431),
		INITHOTSPOT(182, 207, 125, 155, 0x432),
		INITHOTSPOT(176, 203,  26,  37, 0x433),
		INITHOTSPOT( 55,  75,  23,  51, 0x434),
		INITHOTSPOT(120, 166, 133, 155, 0x435),
		INITHOTSPOT( 96, 117,  93, 113, 0x436),
		INITHOTSPOT(140, 189,  68,  89, 0x437)
	},
	{
		INITHOTSPOT(84, 113, 30,  53, 0x438),
		INITHOTSPOT(21,  42, 78, 105, 0x439),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		INITHOTSPOT(4, 227, 17, 160, 0x241)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(86, 112, 27, 85, 0x453),
		INITHOTSPOT(85, 127, 29, 90, 0x453),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(128, 149, 55, 114, 0x445),
		INITHOTSPOT(180, 215, 36, 120, 0x445),
		DUMMYHOTSPOT(0x192),
		INITHOTSPOT( 69,  86, 86, 103, 0x437),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(128, 149, 55, 114, 0x445),
		INITHOTSPOT(180, 215, 36, 120, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(53, 131, 41, 159, 0x445),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(204, 227, 100, 160, 0x441),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT( 94, 106, 83, 104, 0x443),
		INITHOTSPOT(107, 127, 83, 104, 0x405),
		INITHOTSPOT( 75,  94, 98, 133, 0x409),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(67, 135, 22, 68, 0x407),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(88, 156, 102, 158, 0x418),
		INITHOTSPOT(96, 137,  20,  47, 0x415),
		INITHOTSPOT(21,  83,  18,  37, 0x406),
		INITHOTSPOT(19,  45,  76, 102, 0x401),
		INITHOTSPOT(23,  68, 134, 157, 0x400),
		INITHOTSPOT(96, 156,  47, 102, 0x443),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(68, 131, 117, 158, 0x418),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(103, 158,  18,  40, 0x417),
		INITHOTSPOT(163, 179, 127, 150, 0x402),
		INITHOTSPOT( 20,  43,  18,  43, 0x401),
		INITHOTSPOT( 28,  67,  67,  98, 0x400),
		INITHOTSPOT(  5,  53, 139, 159, 0x420),
		INITHOTSPOT( 95, 151, 124, 159, 0x40B),
		INITHOTSPOT( 53,  94, 124, 159, 0x420),
		INITHOTSPOT( 89, 158,  40, 103, 0x443),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT( 33,  99,  18,  53, 0x418),
		INITHOTSPOT( 40,  82,  69, 103, 0x40B),
		INITHOTSPOT(  5,  39,  69, 103, 0x420),
		INITHOTSPOT(  5,  82, 103, 159, 0x40C),
		INITHOTSPOT( 82, 123, 128, 159, 0x40D),
		INITHOTSPOT( 96, 120,  73,  96, 0x443),
		INITHOTSPOT(123, 184, 112, 159, 0x40E),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(113, 125,  43,  60, 0x40A),
		INITHOTSPOT( 99, 114,  60,  80, 0x409),
		INITHOTSPOT( 99, 135,  80, 104, 0x443),
		INITHOTSPOT( 99, 160, 104, 159, 0x417),
		INITHOTSPOT( 17,  56, 134, 159, 0x401),
		INITHOTSPOT(  9,  81,  65,  98, 0x406),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(161, 216, 109, 147, 0x417),
		INITHOTSPOT(161, 193,  81, 105, 0x415),
		INITHOTSPOT( 91, 110, 131, 154, 0x401),
		INITHOTSPOT( 31,  66, 128, 147, 0x408),
		INITHOTSPOT( 84, 141,  70,  96, 0x443),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(67, 85, 72, 98, 0x443),
		INITHOTSPOT(117, 182, 65, 96, 0x406),
		INITHOTSPOT(124, 147, 130, 153, 0x401),
		INITHOTSPOT(56, 89, 124, 146, 0x408),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(92, 106, 120, 130, 0x446),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(161, 209, 50, 98, 0x417),
		INITHOTSPOT(157, 209, 98, 159, 0x418),
		INITHOTSPOT(161, 191, 29, 50, 0x415),
		INITHOTSPOT(91, 139, 18, 44, 0x406),
		INITHOTSPOT(95, 128, 137, 151, 0x400),
		INITHOTSPOT(32, 61, 81, 95, 0x408),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(87, 109, 81, 105, 0x443),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(157, 214, 18, 46, 0x417),
		INITHOTSPOT(151, 214, 46, 105, 0x418),
		INITHOTSPOT(87, 108, 22, 46, 0x401),
		DUMMYHOTSPOT(0x40B), // INITHOTSPOT(58, 43, 141, 57, 0x40B), <== Invalid coordinates
		INITHOTSPOT(24, 62, 18, 37, 0x408),
		INITHOTSPOT(155, 200, 123, 157, 0x40B),
		DUMMYHOTSPOT(0x196),
		INITHOTSPOT(92, 131, 77, 97, 0x443),
		INITHOTSPOT(113, 155, 123, 157, 0x420),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(94, 129, 121, 145, 0x415),
		INITHOTSPOT(14, 79, 108, 142, 0x406),
		DUMMYHOTSPOT(0x192),
		INITHOTSPOT(102, 127, 96, 107, 0x443),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(92, 125, 62, 104, 0x443),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(5, 71, 102, 160, 0x406),
		DUMMYHOTSPOT(0x193),
		INITHOTSPOT(71, 92, 97, 146, 0x409),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		INITHOTSPOT(40, 133, 99, 158, 0x443),
		INITHOTSPOT(133, 188, 94, 145, 0x405),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(104, 122, 124, 148, 0x445),
		INITHOTSPOT(151, 165, 32, 56, 0x445),
		INITHOTSPOT(100, 118, 34, 55, 0x19F),
		INITHOTSPOT(50, 66, 35, 58, 0x445),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		INITHOTSPOT(89, 129, 58, 106, 0x19F)
	},
	{
		INITHOTSPOT(146, 195, 18, 51, 0x418),
		INITHOTSPOT(87, 130, 21, 45, 0x400),
		INITHOTSPOT(150, 204, 66, 99, 0x40B),
		INITHOTSPOT(63, 112, 80, 103, 0x443),
		INITHOTSPOT(112, 150, 66, 103, 0x443),
		INITHOTSPOT(63, 183, 103, 159, 0x40C),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(125, 182, 18, 42, 0x406),
		INITHOTSPOT(122, 148, 80, 105, 0x401),
		INITHOTSPOT(130, 175, 135, 156, 0x400),
		INITHOTSPOT(66, 85, 20, 49, 0x407),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(53, 89, 77, 95, 0x443),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(88, 144, 18, 49, 0x418),
		INITHOTSPOT(158, 178, 73, 95, 0x402),
		INITHOTSPOT(16, 69, 18, 43, 0x400),
		INITHOTSPOT(5, 52, 81, 108, 0x420),
		INITHOTSPOT(52, 88, 65, 108, 0x420),
		INITHOTSPOT(5, 134, 108, 159, 0x40C),
		INITHOTSPOT(135, 179, 124, 159, 0x40D),
		INITHOTSPOT(88, 134, 65, 108, 0x443),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		INITHOTSPOT(40, 160, 49, 148, 0x442),
		INITHOTSPOT(5, 39, 49, 159, 0x40B),
		INITHOTSPOT(210, 226, 75, 116, 0x402),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(135, 177, 68, 111, 0x443),
		INITHOTSPOT(158, 176, 17, 34, 0x402),
		INITHOTSPOT(90, 132, 17, 46, 0x40B),
		INITHOTSPOT(23, 55, 24, 91, 0x420),
		INITHOTSPOT(4, 55, 27, 124, 0x40C),
		INITHOTSPOT(55, 113, 17, 124, 0x40C),
		INITHOTSPOT(113, 154, 65, 124, 0x40C),
		INITHOTSPOT(154, 227, 81, 160, 0x40E),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(141, 213, 79, 110, 0x410),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(126, 188, 24, 54, 0x403),
		INITHOTSPOT(5, 101, 18, 90, 0x40E),
		INITHOTSPOT(5, 65, 90, 159, 0x40E),
		DUMMYHOTSPOT(0x40E), // INITHOTSPOT(65, 98, 213, 159, 0x40E), <=== Invalid coordinates
		DUMMYHOTSPOT(0x196),
		INITHOTSPOT(5, 213, 18, 159, 0x40E),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(19, 66, 18, 64, 0x40D),
		INITHOTSPOT(5, 32, 18, 73, 0x40C),
		INITHOTSPOT(155, 184, 84, 111, 0x412),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(134, 197, 18, 59, 0x40F),
		INITHOTSPOT(189, 227, 120, 159, 0x403),
		INITHOTSPOT(5, 155, 18, 132, 0x443),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(85, 132, 18, 60, 0x419),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(33, 63, 88, 117, 0x412),
		DUMMYHOTSPOT(0x193),
		INITHOTSPOT(72, 144, 130, 159, 0x403),
		DUMMYHOTSPOT(0x195),
		INITHOTSPOT(90, 156, 60, 130, 0x443),
		DUMMYHOTSPOT(0x422), // INITHOTSPOT(144, 94, 130, 159, 0x422), <=== Invalid coordinates
		INITHOTSPOT(8, 90, 18, 63, 0x40F),
		INITHOTSPOT(132, 194, 18, 159, 0x414),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(161, 215, 111, 159, 0x421),
		INITHOTSPOT(85, 153, 49, 111, 0x443),
		INITHOTSPOT(104, 131, 134, 159, 0x412),
		INITHOTSPOT(153, 201, 54, 111, 0x419),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(5, 104, 128, 159, 0x40E),
		INITHOTSPOT(5, 161, 54, 159, 0x40E),
		INITHOTSPOT(201, 227, 49, 159, 0x414),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(98, 126, 79, 106, 0x443),
		INITHOTSPOT(163, 212, 56, 108, 0x421),
		INITHOTSPOT(73, 139, 18, 56, 0x40F),
		INITHOTSPOT(156, 181, 18, 49, 0x419),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(129, 194, 121, 156, 0x403),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		INITHOTSPOT(22, 100, 18, 138, 0x40E),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(96, 135, 88, 115, 0x443),
		INITHOTSPOT(29, 96, 68, 115, 0x410),
		INITHOTSPOT(28, 80, 17, 68, 0x403),
		DUMMYHOTSPOT(0x193),
		INITHOTSPOT(80, 135, 17, 88, 0x422),
		INITHOTSPOT(135, 204, 17, 158, 0x414),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(69, 136, 71, 112, 0x443),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(136, 175, 91, 119, 0x41F),
		DUMMYHOTSPOT(0x193),
		INITHOTSPOT(131, 185, 18, 91, 0x422),
		INITHOTSPOT(185, 226, 18, 159, 0x414),
		DUMMYHOTSPOT(0x196),
		INITHOTSPOT(67, 131, 18, 71, 0x403),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(91, 133, 52, 112, 0x443),
		INITHOTSPOT(16, 84, 63, 117, 0x40F),
		INITHOTSPOT(115, 160, 114, 160, 0x421),
		INITHOTSPOT(37, 70, 139, 160, 0x412),
		INITHOTSPOT(128, 170, 36, 51, 0x416),
		INITHOTSPOT(140, 227, 17, 38, 0x416),
		INITHOTSPOT(152, 227, 38, 160, 0x414),
		INITHOTSPOT(51, 91, 118, 159, 0x40E),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(67, 150, 53, 159, 0x445),
		INITHOTSPOT(150, 226, 19, 159, 0x414),
		INITHOTSPOT(5, 67, 46, 159, 0x40F),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(59, 146, 77, 135, 0x443),
		INITHOTSPOT(146, 193, 77, 124, 0x403),
		INITHOTSPOT(129, 206, 124, 159, 0x410),
		INITHOTSPOT(94, 124, 36, 63, 0x412),
		DUMMYHOTSPOT(0x195),
		INITHOTSPOT(94, 147, 18, 77, 0x40E),
		INITHOTSPOT(5, 129, 18, 158, 0x40E),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(50, 109, 115, 159, 0x422),
		DUMMYHOTSPOT(0x413),
		INITHOTSPOT(50, 135, 46, 159, 0x414),
		INITHOTSPOT(135, 159, 113, 159, 0x414),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(93, 135, 78, 141, 0x443),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(39, 97, 17, 78, 0x421),
		INITHOTSPOT(39, 93, 78, 123, 0x403),
		INITHOTSPOT(39, 135, 123, 159, 0x410),
		INITHOTSPOT(97, 195, 17, 159, 0x414),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E)
	},
	{
		INITHOTSPOT(15, 66, 104, 141, 0x190),
		INITHOTSPOT(105, 164, 87, 155, 0x191),
		INITHOTSPOT(174, 225, 100, 154, 0x192),
		INITHOTSPOT(81, 132, 37, 78, 0x193),
		INITHOTSPOT(165, 212, 26, 78, 0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(84, 150, 79, 114, 0x443),
		INITHOTSPOT(66, 200, 127, 159, 0x410),
		INITHOTSPOT(47, 75, 38, 64, 0x412),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(100, 156, 18, 79, 0x421),
		INITHOTSPOT(150, 200, 72, 132, 0x422),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		INITHOTSPOT(156, 226, 18, 159, 0x414),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(26, 42, 48, 77, 0x404),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(112, 134, 77, 84, 0x443),
		INITHOTSPOT(97, 134, 84, 102, 0x443),
		INITHOTSPOT(55, 71, 52, 73, 0x41B),
		INITHOTSPOT(97, 123, 18, 84, 0x404),
		INITHOTSPOT(84, 97, 61, 92, 0x404),
		INITHOTSPOT(154, 178, 20, 42, 0x41E),
		INITHOTSPOT(134, 183, 72, 102, 0x424),
		INITHOTSPOT(95, 129, 123, 149, 0x41A),
		INITHOTSPOT(14, 54, 79, 159, 0x414),
		INITHOTSPOT(66, 86, 73, 82, 0x41B),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(98, 136, 84, 102, 0x443),
		INITHOTSPOT(104, 116, 101, 122, 0x41B),
		INITHOTSPOT(113, 134, 122, 130, 0x41B),
		INITHOTSPOT(78, 97, 96, 110, 0x416),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(98, 136, 84, 102, 0x443),
		INITHOTSPOT(74, 129, 26, 57, 0x41C),
		INITHOTSPOT(103, 118, 63, 85, 0x443),
		INITHOTSPOT(112, 131, 85, 95, 0x443),
		INITHOTSPOT(78, 99, 58, 70, 0x416),
		INITHOTSPOT(160, 182, 86, 112, 0x41D),
		INITHOTSPOT(146, 182, 95, 112, 0x41D),
		INITHOTSPOT(146, 170, 28, 95, 0x404),
		INITHOTSPOT(129, 146, 71, 102, 0x404),
		INITHOTSPOT(59, 98, 84, 160, 0x414),
		INITHOTSPOT(144, 177, 134, 159, 0x41A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(144, 176, 76, 110, 0x404),
		INITHOTSPOT(175, 206, 18, 110, 0x404),
		INITHOTSPOT(167, 226, 84, 159, 0x41D),
		INITHOTSPOT(4, 45, 18, 48, 0x416),
		INITHOTSPOT(71, 89, 47, 85, 0x443),
		INITHOTSPOT(77, 132, 86, 110, 0x443),
		INITHOTSPOT(4, 67, 18, 39, 0x41C),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(96, 119, 76, 93, 0x443),
		INITHOTSPOT(82, 120, 125, 153, 0x424),
		INITHOTSPOT(43, 74, 129, 150, 0x41D),
		INITHOTSPOT(44, 64, 71, 112, 0x404),
		INITHOTSPOT(32, 64, 112, 129, 0x404),
		DUMMYHOTSPOT(0x41B),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(99, 119, 69, 103, 0x443),
		INITHOTSPOT(135, 185, 123, 154, 0x424),
		INITHOTSPOT(112, 135, 129, 138, 0x41D),
		INITHOTSPOT(92, 135, 138, 154, 0x41D),
		INITHOTSPOT(53, 70, 107, 129, 0x41B),
		INITHOTSPOT(63, 81, 129, 138, 0x41B),
		INITHOTSPOT(156, 177, 76, 91, 0x41E),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(74, 124, 38, 133, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(70, 110, 121, 159, 0x441),
		INITHOTSPOT(92, 112, 33, 59, 0x445),
		INITHOTSPOT(150, 177, 24, 49, 0x446),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(129, 149, 43, 60, 0x443),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(130, 182, 17, 46, 0x41C),
		INITHOTSPOT(158, 168, 49, 69, 0x41B),
		INITHOTSPOT(164, 183, 69, 77, 0x41B),
		INITHOTSPOT(105, 166, 71, 160, 0x414),
		INITHOTSPOT(46, 80, 98, 149, 0x419),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(95, 129, 78, 86, 0x443),
		INITHOTSPOT(105, 129, 86, 99, 0x443),
		INITHOTSPOT(34, 84, 134, 159, 0x425),
		INITHOTSPOT(48, 75, 81, 109, 0x41A),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(92, 141, 76, 103, 0x443),
		INITHOTSPOT(53, 80, 125, 150, 0x41A),
		INITHOTSPOT(67, 92, 80, 87, 0x41D),
		INITHOTSPOT(54, 92, 87, 103, 0x41D),
		INITHOTSPOT(38, 54, 63, 95, 0x404),
		INITHOTSPOT(54, 78, 20, 87, 0x404),
		INITHOTSPOT(113, 131, 26, 43, 0x41E),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		INITHOTSPOT(8, 38, 58, 103, 0x41B),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		INITHOTSPOT(58, 68, 88, 103, 0x445),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(95, 133, 81, 120, 0x189),
		INITHOTSPOT(104, 133, 120, 133, 0x189),
		INITHOTSPOT(112, 123, 65, 142, 0x189),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		INITHOTSPOT(18, 65, 18, 159, 0x414),
		INITHOTSPOT(65, 143, 75, 159, 0x414),
		INITHOTSPOT(143, 157, 96, 159, 0x414),
		INITHOTSPOT(143, 150, 86, 96, 0x414),
		INITHOTSPOT(99, 120, 38, 60, 0x41A),
		INITHOTSPOT(65, 112, 58, 75, 0x414)
	},
	{
		INITHOTSPOT(107, 119, 61, 88, 0x445),
		INITHOTSPOT(91, 110, 95, 136, 0x446),
		INITHOTSPOT(181, 208, 66, 146, 0x447),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(100, 129, 74, 100, 0x443),
		INITHOTSPOT(103, 140, 29, 54, 0x41D),
		INITHOTSPOT(140, 189, 24, 54, 0x424),
		INITHOTSPOT(89, 126, 18, 41, 0x404),
		INITHOTSPOT(46, 89, 18, 41, 0x41B),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		INITHOTSPOT(95, 129, 124, 131, 0x425),
		INITHOTSPOT(95, 139, 131, 159, 0x425),
		INITHOTSPOT(139, 146, 136, 159, 0x425),
		INITHOTSPOT(5, 58, 18, 159, 0x414),
		INITHOTSPOT(58, 122, 111, 159, 0x414),
		INITHOTSPOT(129, 154, 120, 131, 0x414),
		INITHOTSPOT(139, 160, 131, 159, 0x414),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(125, 179, 49, 126, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(159, 173, 17, 32, 0x445),
		INITHOTSPOT(148, 165, 40, 61, 0x446),
		DUMMYHOTSPOT(0x192),
		INITHOTSPOT(39, 59, 35, 69, 0x447),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(56, 79, 88, 133, 0x445),
		INITHOTSPOT(103, 122, 81, 136, 0x446),
		INITHOTSPOT(161, 190, 85, 145, 0x447),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(65, 105, 87, 119, 0x438),
		INITHOTSPOT(141, 165, 55, 78, 0x40A),
		INITHOTSPOT(182, 203, 74, 95, 0x414),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(93, 127, 39, 80, 0x40A),
		INITHOTSPOT(21, 54, 92, 129, 0x41D),
		INITHOTSPOT(167, 200, 94, 134, 0x422),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(59, 95, 55, 95, 0x40A),
		INITHOTSPOT(129, 169, 82, 131, 0x41D),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(57, 92, 76, 102, 0x442),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		INITHOTSPOT(4, 44, 74, 104, 0x441),
		INITHOTSPOT(85, 143, 73, 98, 0x448),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(125, 151, 103, 125, 0x42C),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(38, 47, 151, 159, 0x42D),
		INITHOTSPOT(88, 112, 143, 154, 0x42D),
		INITHOTSPOT(79, 123, 92, 132, 0x42D),
		INITHOTSPOT(48, 64, 98, 113, 0x42D),
		INITHOTSPOT(7, 12, 97, 102, 0x42D),
		INITHOTSPOT(78, 104, 105, 114, 0x42D),
		INITHOTSPOT(103, 111, 100, 106, 0x42D),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(13, 48, 82, 112, 0x42D),
		INITHOTSPOT(45, 54, 61, 75, 0x42D),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		INITHOTSPOT(68, 188, 65, 105, 0x441)
	},
	{
		INITHOTSPOT(164, 191, 38, 109, 0x445),
		INITHOTSPOT(56, 93, 69, 83, 0x444),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(30, 44, 50, 77, 0x198),
		INITHOTSPOT(30, 44, 113, 140, 0x199),
		INITHOTSPOT(308, 319, 179, 191, 0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(4, 227, 17, 160, 0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(39, 67, 73, 118, 0x450),
		INITHOTSPOT(123, 151, 37, 76, 0x446),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(90, 130, 99, 123, 0x432),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(67, 152, 99, 139, 0x449),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(157, 194, 29, 73, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(110, 123, 82, 130, 0x431),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(104, 121, 60, 86, 0x445),
		INITHOTSPOT(78, 91, 52, 77, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(151, 190, 31, 105, 0x445),
		INITHOTSPOT(37, 65, 23, 105, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(144, 223, 48, 105, 0x441),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(11, 59, 80, 141, 0x445),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(160, 208, 80, 140, 0x446),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(74, 91, 78, 105, 0x42E),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(181, 217, 49, 128, 0x445),
		INITHOTSPOT(17, 50, 28, 131, 0x452),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(27, 199, 79, 159, 0x452),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(191, 222, 57, 84, 0x442),
		INITHOTSPOT(103, 119, 130, 141, 0x44A),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(167, 194, 115, 130, 0x433),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(73, 104, 109, 138, 0x434),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(85, 133, 47, 93, 0x452),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(39, 67, 73, 118, 0x445),
		INITHOTSPOT(123, 151, 37, 76, 0x446),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(146, 177, 61, 114, 0x445),
		INITHOTSPOT(14, 43, 69, 131, 0x446),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		INITHOTSPOT(78, 145, 55, 144, 0x456),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(133, 194, 18, 72, 0x413),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		INITHOTSPOT(159, 197, 38, 71, 0x441),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(157, 198, 42, 80, 0x404),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(197, 217, 84, 128, 0x453),
		INITHOTSPOT(26, 42, 48, 77, 0x404),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(84, 105, 77, 108, 0x435),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(176, 197, 77, 119, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(176, 277, 57, 73, 0x441),
		INITHOTSPOT(47, 119, 107, 160, 0x448),
		INITHOTSPOT(73, 98, 43, 90, 0x44B),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(176, 277, 57, 73, 0x441),
		DUMMYHOTSPOT(0x448),
		INITHOTSPOT(73, 98, 43, 90, 0x44B),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(47, 119, 107, 160, 0x451),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(92, 124, 94, 137, 0x441),
		INITHOTSPOT(67, 81, 71, 160, 0x448),
		INITHOTSPOT(15, 48, 19, 160, 0x44B),
		INITHOTSPOT(211, 227, 17, 160, 0x44C),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(181, 205, 50, 96, 0x441),
		INITHOTSPOT(107, 166, 123, 160, 0x448),
		INITHOTSPOT(4, 25, 71, 130, 0x44B),
		INITHOTSPOT(210, 227, 60, 105, 0x44C),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(95, 124, 70, 106, 0x439),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(128, 191, 43, 129, 0x441),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(17, 51, 50, 126, 0x445),
		INITHOTSPOT(179, 211, 30, 129, 0x452),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(17, 51, 50, 126, 0x445),
		INITHOTSPOT(179, 211, 30, 129, 0x452),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(117, 139, 73, 135, 0x430),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(20, 37, 88, 132, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(20, 37, 88, 132, 0x445),
		INITHOTSPOT(101, 125, 99, 141, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(4, 41, 92, 160, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(61, 78, 69, 86, 0x458),
		INITHOTSPOT(136, 142, 17, 130, 0x44D),
		INITHOTSPOT(167, 175, 17, 139, 0x44E),
		INITHOTSPOT(181, 194, 58, 136, 0x445),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(164, 192, 71, 130, 0x445),
		INITHOTSPOT(105, 141, 70, 131, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	}
};

HotSpot _mouseMapASDemo[128][16] = {
	{
		INITHOTSPOT(15, 110, 48, 62, 0x240),
		INITHOTSPOT(61, 176, 30, 44, 0x241),
		INITHOTSPOT(121, 216, 66, 80, 0x242),
		INITHOTSPOT(121, 216, 48, 62, 0x243),
		INITHOTSPOT(121, 216, 84, 98, 0x244),
		INITHOTSPOT(15, 110, 66, 80, 0x245),
		INITHOTSPOT(15, 110, 84, 98, 0x246),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(119, 197, 78, 84, 0x190),
		INITHOTSPOT(119, 197, 85, 91, 0x191),
		INITHOTSPOT(119, 197, 92, 98, 0x192),
		INITHOTSPOT(119, 197, 99, 105, 0x193),
		INITHOTSPOT(72, 96, 103, 109, 0x194),
		INITHOTSPOT(72, 96, 110, 116, 0x195),
		INITHOTSPOT(72, 96, 117, 123, 0x196),
		INITHOTSPOT(72, 96, 124, 130, 0x197),
		INITHOTSPOT(72, 96, 131, 137, 0x198),
		INITHOTSPOT(220, 242, 111, 117, 0x199),
		INITHOTSPOT(220, 242, 118, 124, 0x19A),
		INITHOTSPOT(220, 242, 125, 131, 0x19B),
		INITHOTSPOT(141, 173, 136, 142, 0x19C),
		INITHOTSPOT(141, 173, 143, 149, 0x19D),
		INITHOTSPOT(230, 280, 182, 193, 0x19E),
		INITHOTSPOT(34, 91, 182, 193, 0x19F)
	},
	{
		INITHOTSPOT(4, 227, 17, 160, 0x260),
		DUMMYHOTSPOT(0x261),
		DUMMYHOTSPOT(0x262),
		DUMMYHOTSPOT(0x263),
		DUMMYHOTSPOT(0x264),
		DUMMYHOTSPOT(0x265),
		DUMMYHOTSPOT(0x266),
		DUMMYHOTSPOT(0x267),
		DUMMYHOTSPOT(0x268),
		DUMMYHOTSPOT(0x269),
		DUMMYHOTSPOT(0x26A),
		DUMMYHOTSPOT(0x26B),
		DUMMYHOTSPOT(0x26C),
		DUMMYHOTSPOT(0x26D),
		DUMMYHOTSPOT(0x26E),
		DUMMYHOTSPOT(0x26F)
	},
	{
		INITHOTSPOT(17, 120, 122, 132, 0x190),
		INITHOTSPOT(17, 120, 140, 150, 0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(69, 242, 114, 129, 0x190),
		INITHOTSPOT(69, 242, 132, 147, 0x192),
		INITHOTSPOT(69, 131, 150, 165, 0x193),
		INITHOTSPOT(181, 242, 150, 165, 0x194),
		INITHOTSPOT(133, 179, 150, 165, 0x24A),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(73, 105, 56, 80, 0x428),
		INITHOTSPOT(89, 131, 88, 110, 0x42A),
		INITHOTSPOT(124, 152, 56, 81, 0x42B),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(61, 91, 61, 87, 0x417),
		INITHOTSPOT(92, 122, 84, 110, 0x40A),
		INITHOTSPOT(123, 154, 61, 87, 0x406),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(47, 80, 48, 116, 0x445),
		INITHOTSPOT(149, 182, 51, 116, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(62, 88, 76, 141, 0x42F),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(140, 170, 102, 127, 0x428),
		INITHOTSPOT(73, 117, 65, 82, 0x429),
		INITHOTSPOT(170, 216, 96, 121, 0x42A),
		INITHOTSPOT(121, 144, 34, 62, 0x42B),
		INITHOTSPOT(160, 183, 41, 59, 0x42C),
		INITHOTSPOT(21, 51, 125, 151, 0x42D),
		INITHOTSPOT(201, 217, 43, 76, 0x42E),
		INITHOTSPOT(76, 114, 119, 150, 0x42F),
		INITHOTSPOT(18, 48, 31, 61, 0x430),
		INITHOTSPOT(57, 72, 88, 122, 0x431),
		INITHOTSPOT(182, 207, 125, 155, 0x432),
		INITHOTSPOT(176, 203, 26, 37, 0x433),
		INITHOTSPOT(55, 75, 23, 51, 0x434),
		INITHOTSPOT(120, 166, 133, 155, 0x435),
		INITHOTSPOT(96, 117, 93, 113, 0x436),
		INITHOTSPOT(140, 189, 68, 89, 0x437)
	},
	{
		INITHOTSPOT(84, 113, 30, 53, 0x438),
		INITHOTSPOT(21, 42, 78, 105, 0x439),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		INITHOTSPOT(4, 227, 17, 160, 0x241)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(86, 112, 27, 85, 0x453),
		INITHOTSPOT(85, 127, 29, 90, 0x453),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(128, 149, 55, 114, 0x445),
		INITHOTSPOT(180, 215, 36, 120, 0x445),
		DUMMYHOTSPOT(0x192),
		INITHOTSPOT(69, 86, 86, 103, 0x437),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(128, 149, 55, 114, 0x445),
		INITHOTSPOT(180, 215, 36, 120, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(53, 131, 41, 159, 0x445),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(204, 227, 100, 160, 0x441),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(94, 106, 83, 104, 0x443),
		INITHOTSPOT(107, 127, 83, 104, 0x405),
		INITHOTSPOT(75, 94, 98, 133, 0x409),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(67, 135, 22, 68, 0x407),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(88, 156, 102, 158, 0x418),
		INITHOTSPOT(96, 137, 20, 47, 0x415),
		INITHOTSPOT(21, 83, 18, 37, 0x406),
		INITHOTSPOT(19, 45, 76, 102, 0x401),
		INITHOTSPOT(23, 68, 134, 157, 0x400),
		INITHOTSPOT(96, 156, 47, 102, 0x443),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(68, 131, 117, 158, 0x418),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(103, 158, 18, 40, 0x417),
		INITHOTSPOT(163, 179, 127, 150, 0x402),
		INITHOTSPOT(20, 43, 18, 43, 0x401),
		INITHOTSPOT(28, 67, 67, 98, 0x400),
		INITHOTSPOT(5, 53, 139, 159, 0x420),
		INITHOTSPOT(95, 151, 124, 159, 0x40B),
		INITHOTSPOT(53, 94, 124, 159, 0x420),
		INITHOTSPOT(89, 158, 40, 103, 0x443),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(33, 99, 18, 53, 0x418),
		INITHOTSPOT(40, 82, 69, 103, 0x40B),
		INITHOTSPOT(5, 39, 69, 103, 0x420),
		INITHOTSPOT(5, 82, 103, 159, 0x40C),
		INITHOTSPOT(82, 123, 128, 159, 0x40D),
		INITHOTSPOT(96, 120, 73, 96, 0x443),
		INITHOTSPOT(123, 184, 112, 159, 0x40E),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(113, 125, 43, 60, 0x40A),
		INITHOTSPOT(99, 114, 60, 80, 0x409),
		INITHOTSPOT(99, 135, 80, 104, 0x443),
		INITHOTSPOT(99, 160, 104, 159, 0x417),
		INITHOTSPOT(17, 56, 134, 159, 0x401),
		INITHOTSPOT(9, 81, 65, 98, 0x406),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(161, 216, 109, 147, 0x417),
		INITHOTSPOT(161, 193, 81, 105, 0x415),
		INITHOTSPOT(91, 110, 131, 154, 0x401),
		INITHOTSPOT(31, 66, 128, 147, 0x408),
		INITHOTSPOT(84, 141, 70, 96, 0x443),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(67, 85, 72, 98, 0x443),
		INITHOTSPOT(117, 182, 65, 96, 0x406),
		INITHOTSPOT(124, 147, 130, 153, 0x401),
		INITHOTSPOT(56, 89, 124, 146, 0x408),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(92, 106, 120, 130, 0x446),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(161, 209, 50, 98, 0x417),
		INITHOTSPOT(157, 209, 98, 159, 0x418),
		INITHOTSPOT(161, 191, 29, 50, 0x415),
		INITHOTSPOT(91, 139, 18, 44, 0x406),
		INITHOTSPOT(95, 128, 137, 151, 0x400),
		INITHOTSPOT(32, 61, 81, 95, 0x408),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(87, 109, 81, 105, 0x443),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(157, 214, 18, 46, 0x417),
		INITHOTSPOT(151, 214, 46, 105, 0x418),
		INITHOTSPOT(87, 108, 22, 46, 0x401),
		DUMMYHOTSPOT(0x40B), // INITHOTSPOT(58, 43, 141, 57, 0x40B), <=== Invalid coordinates
		INITHOTSPOT(24, 62, 18, 37, 0x408),
		INITHOTSPOT(155, 200, 123, 157, 0x40B),
		DUMMYHOTSPOT(0x196),
		INITHOTSPOT(92, 131, 77, 97, 0x443),
		INITHOTSPOT(113, 155, 123, 157, 0x420),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(94, 129, 121, 145, 0x415),
		INITHOTSPOT(14, 79, 108, 142, 0x406),
		DUMMYHOTSPOT(0x192),
		INITHOTSPOT(102, 127, 96, 107, 0x443),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(92, 125, 62, 104, 0x443),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(5, 71, 102, 160, 0x406),
		DUMMYHOTSPOT(0x193),
		INITHOTSPOT(71, 92, 97, 146, 0x409),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		INITHOTSPOT(40, 133, 99, 158, 0x443),
		INITHOTSPOT(133, 188, 94, 145, 0x405),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(104, 122, 124, 148, 0x445),
		INITHOTSPOT(151, 165, 32, 56, 0x445),
		INITHOTSPOT(100, 118, 34, 55, 0x19F),
		INITHOTSPOT(50, 66, 35, 58, 0x445),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		INITHOTSPOT(89, 129, 58, 106, 0x19F)
	},
	{
		INITHOTSPOT(146, 195, 18, 51, 0x418),
		INITHOTSPOT(87, 130, 21, 45, 0x400),
		INITHOTSPOT(150, 204, 66, 99, 0x40B),
		INITHOTSPOT(63, 112, 80, 103, 0x443),
		INITHOTSPOT(112, 150, 66, 103, 0x443),
		INITHOTSPOT(63, 183, 103, 159, 0x40C),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(125, 182, 18, 42, 0x406),
		INITHOTSPOT(122, 148, 80, 105, 0x401),
		INITHOTSPOT(130, 175, 135, 156, 0x400),
		INITHOTSPOT(66, 85, 20, 49, 0x407),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(53, 89, 77, 95, 0x443),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(88, 144, 18, 49, 0x418),
		INITHOTSPOT(158, 178, 73, 95, 0x402),
		INITHOTSPOT(16, 69, 18, 43, 0x400),
		INITHOTSPOT(5, 52, 81, 108, 0x420),
		INITHOTSPOT(52, 88, 65, 108, 0x420),
		INITHOTSPOT(5, 134, 108, 159, 0x40C),
		INITHOTSPOT(135, 179, 124, 159, 0x40D),
		INITHOTSPOT(88, 134, 65, 108, 0x443),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		INITHOTSPOT(40, 160, 49, 148, 0x442),
		INITHOTSPOT(5, 39, 49, 159, 0x40B),
		INITHOTSPOT(210, 226, 75, 116, 0x402),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(135, 177, 68, 111, 0x443),
		INITHOTSPOT(158, 176, 17, 34, 0x402),
		INITHOTSPOT(90, 132, 17, 46, 0x40B),
		INITHOTSPOT(23, 55, 24, 91, 0x420),
		INITHOTSPOT(4, 55, 27, 124, 0x40C),
		INITHOTSPOT(55, 113, 17, 124, 0x40C),
		INITHOTSPOT(113, 154, 65, 124, 0x40C),
		INITHOTSPOT(154, 227, 81, 160, 0x40E),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(141, 213, 79, 110, 0x410),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(126, 188, 24, 54, 0x403),
		INITHOTSPOT(5, 101, 18, 90, 0x40E),
		INITHOTSPOT(5, 65, 90, 159, 0x40E),
		DUMMYHOTSPOT(0x40E), // INITHOTSPOT(65, 98, 213, 159, 0x40E), <=== Invalid coordinates
		DUMMYHOTSPOT(0x196),
		INITHOTSPOT(5, 213, 18, 159, 0x40E),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(19, 66, 18, 64, 0x40D),
		INITHOTSPOT(5, 32, 18, 73, 0x40C),
		INITHOTSPOT(155, 184, 84, 111, 0x412),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(134, 197, 18, 59, 0x40F),
		INITHOTSPOT(189, 227, 120, 159, 0x403),
		INITHOTSPOT(5, 155, 18, 132, 0x443),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(85, 132, 18, 60, 0x419),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(33, 63, 88, 117, 0x412),
		DUMMYHOTSPOT(0x193),
		INITHOTSPOT(72, 144, 130, 159, 0x403),
		DUMMYHOTSPOT(0x195),
		INITHOTSPOT(90, 156, 60, 130, 0x443),
		DUMMYHOTSPOT(0x422), // INITHOTSPOT(144, 94, 130, 159, 0x422), <=== Invalid Coordinates
		INITHOTSPOT(8, 90, 18, 63, 0x40F),
		INITHOTSPOT(132, 194, 18, 159, 0x414),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(161, 215, 111, 159, 0x421),
		INITHOTSPOT(85, 153, 49, 111, 0x443),
		INITHOTSPOT(104, 131, 134, 159, 0x412),
		INITHOTSPOT(153, 201, 54, 111, 0x419),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(5, 104, 128, 159, 0x40E),
		INITHOTSPOT(5, 161, 54, 159, 0x40E),
		INITHOTSPOT(201, 227, 49, 159, 0x414),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(98, 126, 79, 106, 0x443),
		INITHOTSPOT(163, 212, 56, 108, 0x421),
		INITHOTSPOT(73, 139, 18, 56, 0x40F),
		INITHOTSPOT(156, 181, 18, 49, 0x419),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(129, 194, 121, 156, 0x403),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		INITHOTSPOT(22, 100, 18, 138, 0x40E),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(96, 135, 88, 115, 0x443),
		INITHOTSPOT(29, 96, 68, 115, 0x410),
		INITHOTSPOT(28, 80, 17, 68, 0x403),
		DUMMYHOTSPOT(0x193),
		INITHOTSPOT(80, 135, 17, 88, 0x422),
		INITHOTSPOT(135, 204, 17, 158, 0x414),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(69, 136, 71, 112, 0x443),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(136, 175, 91, 119, 0x41F),
		DUMMYHOTSPOT(0x193),
		INITHOTSPOT(131, 185, 18, 91, 0x422),
		INITHOTSPOT(185, 226, 18, 159, 0x414),
		DUMMYHOTSPOT(0x196),
		INITHOTSPOT(67, 131, 18, 71, 0x403),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(91, 133, 52, 112, 0x443),
		INITHOTSPOT(16, 84, 63, 117, 0x40F),
		INITHOTSPOT(115, 160, 114, 160, 0x421),
		INITHOTSPOT(37, 70, 139, 160, 0x412),
		INITHOTSPOT(128, 170, 36, 51, 0x416),
		INITHOTSPOT(140, 227, 17, 38, 0x416),
		INITHOTSPOT(152, 227, 38, 160, 0x414),
		INITHOTSPOT(51, 91, 118, 159, 0x40E),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(67, 150, 53, 159, 0x445),
		INITHOTSPOT(150, 226, 19, 159, 0x414),
		INITHOTSPOT(5, 67, 46, 159, 0x40F),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(59, 146, 77, 135, 0x443),
		INITHOTSPOT(146, 193, 77, 124, 0x403),
		INITHOTSPOT(129, 206, 124, 159, 0x410),
		INITHOTSPOT(94, 124, 36, 63, 0x412),
		DUMMYHOTSPOT(0x195),
		INITHOTSPOT(94, 147, 18, 77, 0x40E),
		INITHOTSPOT(5, 129, 18, 158, 0x40E),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(50, 109, 115, 159, 0x422),
		DUMMYHOTSPOT(0x413),
		INITHOTSPOT(50, 135, 46, 159, 0x414),
		INITHOTSPOT(135, 159, 113, 159, 0x414),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(93, 135, 78, 141, 0x443),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(39, 97, 17, 78, 0x421),
		INITHOTSPOT(39, 93, 78, 123, 0x403),
		INITHOTSPOT(39, 135, 123, 159, 0x410),
		INITHOTSPOT(97, 195, 17, 159, 0x414),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E)
	},
	{
		INITHOTSPOT(15, 66, 104, 141, 0x190),
		INITHOTSPOT(105, 164, 87, 155, 0x191),
		INITHOTSPOT(174, 225, 100, 154, 0x192),
		INITHOTSPOT(81, 132, 37, 78, 0x193),
		INITHOTSPOT(165, 212, 26, 78, 0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(84, 150, 79, 114, 0x443),
		INITHOTSPOT(66, 200, 127, 159, 0x410),
		INITHOTSPOT(47, 75, 38, 64, 0x412),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(100, 156, 18, 79, 0x421),
		INITHOTSPOT(150, 200, 72, 132, 0x422),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		INITHOTSPOT(156, 226, 18, 159, 0x414),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(26, 42, 48, 77, 0x404),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(112, 134, 77, 84, 0x443),
		INITHOTSPOT(97, 134, 84, 102, 0x443),
		INITHOTSPOT(55, 71, 52, 73, 0x41B),
		INITHOTSPOT(97, 123, 18, 84, 0x404),
		INITHOTSPOT(84, 97, 61, 92, 0x404),
		INITHOTSPOT(154, 178, 20, 42, 0x41E),
		INITHOTSPOT(134, 183, 72, 102, 0x424),
		INITHOTSPOT(95, 129, 123, 149, 0x41A),
		INITHOTSPOT(14, 54, 79, 159, 0x414),
		INITHOTSPOT(66, 86, 73, 82, 0x41B),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(98, 136, 84, 102, 0x443),
		INITHOTSPOT(104, 116, 101, 122, 0x41B),
		INITHOTSPOT(113, 134, 122, 130, 0x41B),
		INITHOTSPOT(78, 97, 96, 110, 0x416),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(98, 136, 84, 102, 0x443),
		INITHOTSPOT(74, 129, 26, 57, 0x41C),
		INITHOTSPOT(103, 118, 63, 85, 0x443),
		INITHOTSPOT(112, 131, 85, 95, 0x443),
		INITHOTSPOT(78, 99, 58, 70, 0x416),
		INITHOTSPOT(160, 182, 86, 112, 0x41D),
		INITHOTSPOT(146, 182, 95, 112, 0x41D),
		INITHOTSPOT(146, 170, 28, 95, 0x404),
		INITHOTSPOT(129, 146, 71, 102, 0x404),
		INITHOTSPOT(59, 98, 84, 160, 0x414),
		INITHOTSPOT(144, 177, 134, 159, 0x41A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(144, 176, 76, 110, 0x404),
		INITHOTSPOT(175, 206, 18, 110, 0x404),
		INITHOTSPOT(167, 226, 84, 159, 0x41D),
		INITHOTSPOT(4, 45, 18, 48, 0x416),
		INITHOTSPOT(71, 89, 47, 85, 0x443),
		INITHOTSPOT(77, 132, 86, 110, 0x443),
		INITHOTSPOT(4, 67, 18, 39, 0x41C),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(96, 119, 76, 93, 0x443),
		INITHOTSPOT(82, 120, 125, 153, 0x424),
		INITHOTSPOT(43, 74, 129, 150, 0x41D),
		INITHOTSPOT(44, 64, 71, 112, 0x404),
		INITHOTSPOT(32, 64, 112, 129, 0x404),
		DUMMYHOTSPOT(0x41B),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(99, 119, 69, 103, 0x443),
		INITHOTSPOT(135, 185, 123, 154, 0x424),
		INITHOTSPOT(112, 135, 129, 138, 0x41D),
		INITHOTSPOT(92, 135, 138, 154, 0x41D),
		INITHOTSPOT(53, 70, 107, 129, 0x41B),
		INITHOTSPOT(63, 81, 129, 138, 0x41B),
		INITHOTSPOT(156, 177, 76, 91, 0x41E),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(74, 124, 38, 133, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(70, 110, 121, 159, 0x441),
		INITHOTSPOT(92, 112, 33, 59, 0x445),
		INITHOTSPOT(150, 177, 24, 49, 0x446),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(129, 149, 43, 60, 0x443),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(130, 182, 17, 46, 0x41C),
		INITHOTSPOT(158, 168, 49, 69, 0x41B),
		INITHOTSPOT(164, 183, 69, 77, 0x41B),
		INITHOTSPOT(105, 166, 71, 160, 0x414),
		INITHOTSPOT(46, 80, 98, 149, 0x419),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(95, 129, 78, 86, 0x443),
		INITHOTSPOT(105, 129, 86, 99, 0x443),
		INITHOTSPOT(34, 84, 134, 159, 0x425),
		INITHOTSPOT(48, 75, 81, 109, 0x41A),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(92, 141, 76, 103, 0x443),
		INITHOTSPOT(53, 80, 125, 150, 0x41A),
		INITHOTSPOT(67, 92, 80, 87, 0x41D),
		INITHOTSPOT(54, 92, 87, 103, 0x41D),
		INITHOTSPOT(38, 54, 63, 95, 0x404),
		INITHOTSPOT(54, 78, 20, 87, 0x404),
		INITHOTSPOT(113, 131, 26, 43, 0x41E),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		INITHOTSPOT(8, 38, 58, 103, 0x41B),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		INITHOTSPOT(58, 68, 88, 103, 0x445),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(95, 133, 81, 120, 0x189),
		INITHOTSPOT(104, 133, 120, 133, 0x189),
		INITHOTSPOT(112, 123, 65, 142, 0x189),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		INITHOTSPOT(18, 65, 18, 159, 0x414),
		INITHOTSPOT(65, 143, 75, 159, 0x414),
		INITHOTSPOT(143, 157, 96, 159, 0x414),
		INITHOTSPOT(143, 150, 86, 96, 0x414),
		INITHOTSPOT(99, 120, 38, 60, 0x41A),
		INITHOTSPOT(65, 112, 58, 75, 0x414)
	},
	{
		INITHOTSPOT(107, 119, 61, 88, 0x445),
		INITHOTSPOT(91, 110, 95, 136, 0x446),
		INITHOTSPOT(181, 208, 66, 146, 0x447),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(100, 129, 74, 100, 0x443),
		INITHOTSPOT(103, 140, 29, 54, 0x41D),
		INITHOTSPOT(140, 189, 24, 54, 0x424),
		INITHOTSPOT(89, 126, 18, 41, 0x404),
		INITHOTSPOT(46, 89, 18, 41, 0x41B),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		INITHOTSPOT(95, 129, 124, 131, 0x425),
		INITHOTSPOT(95, 139, 131, 159, 0x425),
		INITHOTSPOT(139, 146, 136, 159, 0x425),
		INITHOTSPOT(5, 58, 18, 159, 0x414),
		INITHOTSPOT(58, 122, 111, 159, 0x414),
		INITHOTSPOT(129, 154, 120, 131, 0x414),
		INITHOTSPOT(139, 160, 131, 159, 0x414),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(125, 179, 49, 126, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(159, 173, 17, 32, 0x445),
		INITHOTSPOT(148, 165, 40, 61, 0x446),
		DUMMYHOTSPOT(0x192),
		INITHOTSPOT(39, 59, 35, 69, 0x447),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(56, 79, 88, 133, 0x445),
		INITHOTSPOT(103, 122, 81, 136, 0x446),
		INITHOTSPOT(161, 190, 85, 145, 0x447),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(65, 105, 87, 119, 0x438),
		INITHOTSPOT(141, 165, 55, 78, 0x40A),
		INITHOTSPOT(182, 203, 74, 95, 0x414),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(93, 127, 39, 80, 0x40A),
		INITHOTSPOT(21, 54, 92, 129, 0x41D),
		INITHOTSPOT(167, 200, 94, 134, 0x422),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(59, 95, 55, 95, 0x40A),
		INITHOTSPOT(129, 169, 82, 131, 0x41D),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(57, 92, 76, 102, 0x442),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		INITHOTSPOT(4, 44, 74, 104, 0x441),
		INITHOTSPOT(85, 143, 73, 98, 0x448),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(125, 151, 103, 125, 0x42C),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(38, 47, 151, 159, 0x42D),
		INITHOTSPOT(88, 112, 143, 154, 0x42D),
		INITHOTSPOT(79, 123, 92, 132, 0x42D),
		INITHOTSPOT(48, 64, 98, 113, 0x42D),
		INITHOTSPOT(7, 12, 97, 102, 0x42D),
		INITHOTSPOT(78, 104, 105, 114, 0x42D),
		INITHOTSPOT(103, 111, 100, 106, 0x42D),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		INITHOTSPOT(13, 48, 82, 112, 0x42D),
		INITHOTSPOT(45, 54, 61, 75, 0x42D),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		INITHOTSPOT(68, 188, 65, 105, 0x441)
	},
	{
		INITHOTSPOT(164, 191, 38, 109, 0x445),
		INITHOTSPOT(56, 93, 69, 83, 0x444),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(30, 44, 50, 77, 0x198),
		INITHOTSPOT(30, 44, 113, 140, 0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(4, 227, 17, 160, 0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(39, 67, 73, 118, 0x450),
		INITHOTSPOT(123, 151, 37, 76, 0x446),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(90, 130, 99, 123, 0x432),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(67, 152, 99, 139, 0x449),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(157, 194, 29, 73, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(110, 123, 82, 130, 0x431),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(104, 121, 60, 86, 0x445),
		INITHOTSPOT(78, 91, 52, 77, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(151, 190, 31, 105, 0x445),
		INITHOTSPOT(37, 65, 23, 105, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(144, 223, 48, 105, 0x441),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(11, 59, 80, 141, 0x445),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(160, 208, 80, 140, 0x446),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(74, 91, 78, 105, 0x42E),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(181, 217, 49, 128, 0x445),
		INITHOTSPOT(17, 50, 28, 131, 0x452),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(27, 199, 79, 159, 0x452),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(191, 222, 57, 84, 0x442),
		INITHOTSPOT(103, 119, 130, 141, 0x44A),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(167, 194, 115, 130, 0x433),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(73, 104, 109, 138, 0x434),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(85, 133, 47, 93, 0x452),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(39, 67, 73, 118, 0x445),
		INITHOTSPOT(123, 151, 37, 76, 0x446),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		INITHOTSPOT(146, 177, 61, 114, 0x445),
		INITHOTSPOT(14, 43, 69, 131, 0x446),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		INITHOTSPOT(78, 145, 55, 144, 0x456),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		INITHOTSPOT(133, 194, 18, 72, 0x413),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		INITHOTSPOT(159, 197, 38, 71, 0x441),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(157, 198, 42, 80, 0x404),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(197, 217, 84, 128, 0x453),
		INITHOTSPOT(26, 42, 48, 77, 0x404),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(84, 105, 77, 108, 0x435),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(176, 197, 77, 119, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(176, 277, 57, 73, 0x441),
		INITHOTSPOT(47, 119, 107, 160, 0x448),
		INITHOTSPOT(73, 98, 43, 90, 0x44B),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(176, 277, 57, 73, 0x441),
		DUMMYHOTSPOT(0x448),
		INITHOTSPOT(73, 98, 43, 90, 0x44B),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(47, 119, 107, 160, 0x451),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(92, 124, 94, 137, 0x441),
		INITHOTSPOT(67, 81, 71, 160, 0x448),
		INITHOTSPOT(15, 48, 19, 160, 0x44B),
		INITHOTSPOT(211, 227, 17, 160, 0x44C),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(181, 205, 50, 96, 0x441),
		INITHOTSPOT(107, 166, 123, 160, 0x448),
		INITHOTSPOT(4, 25, 71, 130, 0x44B),
		INITHOTSPOT(210, 227, 60, 105, 0x44C),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(95, 124, 70, 106, 0x439),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		DUMMYHOTSPOT(0x190),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(128, 191, 43, 129, 0x441),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(17, 51, 50, 126, 0x445),
		INITHOTSPOT(179, 211, 30, 129, 0x452),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(17, 51, 50, 126, 0x445),
		INITHOTSPOT(179, 211, 30, 129, 0x452),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		INITHOTSPOT(117, 139, 73, 135, 0x430),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(20, 37, 88, 132, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(20, 37, 88, 132, 0x445),
		INITHOTSPOT(101, 125, 99, 141, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(4, 41, 92, 160, 0x445),
		DUMMYHOTSPOT(0x191),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(61, 78, 69, 86, 0x458),
		INITHOTSPOT(136, 142, 17, 130, 0x44D),
		INITHOTSPOT(167, 175, 17, 139, 0x44E),
		INITHOTSPOT(181, 194, 58, 136, 0x445),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	},
	{
		INITHOTSPOT(164, 192, 71, 130, 0x445),
		INITHOTSPOT(105, 141, 70, 131, 0x446),
		DUMMYHOTSPOT(0x192),
		DUMMYHOTSPOT(0x193),
		DUMMYHOTSPOT(0x194),
		DUMMYHOTSPOT(0x195),
		DUMMYHOTSPOT(0x196),
		DUMMYHOTSPOT(0x197),
		DUMMYHOTSPOT(0x198),
		DUMMYHOTSPOT(0x199),
		DUMMYHOTSPOT(0x19A),
		DUMMYHOTSPOT(0x19B),
		DUMMYHOTSPOT(0x19C),
		DUMMYHOTSPOT(0x19D),
		DUMMYHOTSPOT(0x19E),
		DUMMYHOTSPOT(0x19F)
	}
};

}
