static const byte kEoB2ChargenStartLevelsAmiga[60] = {
	0x07, 0x00, 0x00, 0x01, 0x06, 0x00, 0x00, 0x01,
	0x06, 0x00, 0x00, 0x01, 0x07, 0x00, 0x00, 0x01,
	0x07, 0x00, 0x00, 0x01, 0x07, 0x00, 0x00, 0x01,
	0x06, 0x06, 0x00, 0x02, 0x06, 0x06, 0x00, 0x02,
	0x06, 0x05, 0x00, 0x02, 0x05, 0x05, 0x06, 0x03,
	0x06, 0x05, 0x00, 0x02, 0x06, 0x06, 0x00, 0x02,
	0x05, 0x05, 0x05, 0x03, 0x05, 0x06, 0x00, 0x02,
	0x06, 0x05, 0x00, 0x02
};

static const ByteProvider kEoB2ChargenStartLevelsAmigaProvider = { ARRAYSIZE(kEoB2ChargenStartLevelsAmiga), kEoB2ChargenStartLevelsAmiga };

static const byte kEoB2ChargenClassMinStatsAmiga[90] = {
	0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
	0x0e, 0x0d, 0x0e, 0x00, 0x0c, 0x00, 0x0d, 0x00,
	0x09, 0x11, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x09, 0x00, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09,
	0x00, 0x09, 0x00, 0x00, 0x00, 0x09, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x00, 0x00,
	0x09, 0x09, 0x09, 0x00, 0x00, 0x00, 0x0d, 0x00,
	0x0e, 0x0d, 0x0e, 0x00, 0x00, 0x09, 0x09, 0x00,
	0x00, 0x00
};

static const ByteProvider kEoB2ChargenClassMinStatsAmigaProvider = { ARRAYSIZE(kEoB2ChargenClassMinStatsAmiga), kEoB2ChargenClassMinStatsAmiga };

static const byte kEoB2ChargenRaceMinStatsAmiga[36] = {
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08,
	0x03, 0x07, 0x06, 0x08, 0x03, 0x04, 0x03, 0x06,
	0x06, 0x03, 0x08, 0x03, 0x03, 0x03, 0x0c, 0x02,
	0x06, 0x07, 0x02, 0x03, 0x08, 0x03, 0x07, 0x06,
	0x03, 0x08, 0x0a, 0x06
};

static const ByteProvider kEoB2ChargenRaceMinStatsAmigaProvider = { ARRAYSIZE(kEoB2ChargenRaceMinStatsAmiga), kEoB2ChargenRaceMinStatsAmiga };

static const uint16 kEoB2ChargenRaceMaxStatsAmiga[36] = {
	0x6412, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x6412, 0x0012,
	0x0012, 0x0013, 0x0011, 0x0012, 0x6412, 0x0012, 0x0012, 0x0012,
	0x0012, 0x0012, 0x6412, 0x0012, 0x0012, 0x0011, 0x0013, 0x0010,
	0x6412, 0x0013, 0x0011, 0x0012, 0x0012, 0x0012, 0x0011, 0x0012,
	0x0011, 0x0013, 0x0012, 0x0012
};

static const Uint16Provider kEoB2ChargenRaceMaxStatsAmigaProvider = { ARRAYSIZE(kEoB2ChargenRaceMaxStatsAmiga), kEoB2ChargenRaceMaxStatsAmiga };

static const byte kEoB2SaveThrowTable1Amiga[50] = {
	0x10, 0x0E, 0x0D, 0x0B, 0x0A, 0x08, 0x07, 0x05,
	0x04, 0x03, 0x12, 0x10, 0x0F, 0x0D, 0x0C, 0x0A,
	0x09, 0x07, 0x06, 0x05, 0x11, 0x0F, 0x0E, 0x0C,
	0x0B, 0x09, 0x08, 0x06, 0x05, 0x04, 0x14, 0x11,
	0x10, 0x0D, 0x0C, 0x09, 0x08, 0x05, 0x04, 0x04,
	0x13, 0x11, 0x10, 0x0E, 0x0D, 0x0B, 0x0A, 0x08,
	0x07, 0x06
};

static const ByteProvider kEoB2SaveThrowTable1AmigaProvider = { ARRAYSIZE(kEoB2SaveThrowTable1Amiga), kEoB2SaveThrowTable1Amiga };

static const byte kEoB2SaveThrowTable2Amiga[25] = {
	0x0e, 0x0d, 0x0b, 0x0a, 0x08, 0x0b, 0x09, 0x07,
	0x05, 0x03, 0x0d, 0x0b, 0x09, 0x07, 0x05, 0x0f,
	0x0d, 0x0b, 0x09, 0x07, 0x0c, 0x0a, 0x08, 0x06,
	0x04
};

static const ByteProvider kEoB2SaveThrowTable2AmigaProvider = { ARRAYSIZE(kEoB2SaveThrowTable2Amiga), kEoB2SaveThrowTable2Amiga };

static const byte kEoB2SaveThrowTable3Amiga[35] = {
	0x0a, 0x09, 0x07, 0x06, 0x05, 0x04, 0x02, 0x0e,
	0x0d, 0x0b, 0x0a, 0x09, 0x08, 0x06, 0x0d, 0x0c,
	0x0a, 0x09, 0x08, 0x07, 0x05, 0x10, 0x0f, 0x0d,
	0x0c, 0x0b, 0x0a, 0x08, 0x0f, 0x0e, 0x0c, 0x0b,
	0x0a, 0x09, 0x07
};

static const ByteProvider kEoB2SaveThrowTable3AmigaProvider = { ARRAYSIZE(kEoB2SaveThrowTable3Amiga), kEoB2SaveThrowTable3Amiga };

static const byte kEoB2SaveThrowTable4Amiga[30] = {
	0x0d, 0x0c, 0x0b, 0x0a, 0x09, 0x08, 0x0e, 0x0c,
	0x0a, 0x08, 0x06, 0x07, 0x0c, 0x0b, 0x0a, 0x09,
	0x08, 0x04, 0x10, 0x0f, 0x0e, 0x0d, 0x0c, 0x0b,
	0x0f, 0x0d, 0x0b, 0x09, 0x07, 0x05
};

static const ByteProvider kEoB2SaveThrowTable4AmigaProvider = { ARRAYSIZE(kEoB2SaveThrowTable4Amiga), kEoB2SaveThrowTable4Amiga };

static const byte kEoB2SaveThrwLvlIndexAmiga[6] = {
	0x11, 0x15, 0x13, 0x15, 0x11, 0x11
};

static const ByteProvider kEoB2SaveThrwLvlIndexAmigaProvider = { ARRAYSIZE(kEoB2SaveThrwLvlIndexAmiga), kEoB2SaveThrwLvlIndexAmiga };

static const byte kEoB2SaveThrwModDivAmiga[6] = {
	0x02, 0x05, 0x03, 0x04, 0x02, 0x02
};

static const ByteProvider kEoB2SaveThrwModDivAmigaProvider = { ARRAYSIZE(kEoB2SaveThrwModDivAmiga), kEoB2SaveThrwModDivAmiga };

static const byte kEoB2SaveThrwModExtAmiga[6] = {
	0x0A, 0x05, 0x07, 0x06, 0x0A, 0x0A
};

static const ByteProvider kEoB2SaveThrwModExtAmigaProvider = { ARRAYSIZE(kEoB2SaveThrwModExtAmiga), kEoB2SaveThrwModExtAmiga };

static const char *const kEoB2EnchantedStringAmiga[1] = {
	"+%d %s"
};

static const StringListProvider kEoB2EnchantedStringAmigaProvider = { ARRAYSIZE(kEoB2EnchantedStringAmiga), kEoB2EnchantedStringAmiga };

static const char *const kEoB2MenuStringsSpellNoAmiga[3] = {
	"6",
	"7",
	"8"
};

static const StringListProvider kEoB2MenuStringsSpellNoAmigaProvider = { ARRAYSIZE(kEoB2MenuStringsSpellNoAmiga), kEoB2MenuStringsSpellNoAmiga };

static const byte kEoB2SpellLevelsMageAmiga[35] = {
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x05, 0x06, 0x06, 0x06, 0x06, 0x07, 0x07, 0x08,
	0x00, 0x01, 0x01
};

static const ByteProvider kEoB2SpellLevelsMageAmigaProvider = { ARRAYSIZE(kEoB2SpellLevelsMageAmiga), kEoB2SpellLevelsMageAmiga };

static const byte kEoB2SpellLevelsClericAmiga[29] = {
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
	0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04,
	0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x06,
	0x06, 0x06, 0x08, 0x08, 0x00
};

static const ByteProvider kEoB2SpellLevelsClericAmigaProvider = { ARRAYSIZE(kEoB2SpellLevelsClericAmiga), kEoB2SpellLevelsClericAmiga };

static const byte kEoB2NumSpellsClericAmiga[136] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00,
	0x04, 0x04, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00,
	0x05, 0x04, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00,
	0x06, 0x05, 0x05, 0x03, 0x02, 0x02, 0x00, 0x00,
	0x06, 0x06, 0x06, 0x04, 0x02, 0x02, 0x00, 0x00,
	0x06, 0x06, 0x06, 0x05, 0x03, 0x02, 0x01, 0x00,
	0x06, 0x06, 0x06, 0x06, 0x04, 0x02, 0x01, 0x00,
	0x07, 0x07, 0x07, 0x06, 0x04, 0x03, 0x01, 0x00,
	0x07, 0x07, 0x07, 0x07, 0x05, 0x03, 0x02, 0x00
};

static const ByteProvider kEoB2NumSpellsClericAmigaProvider = { ARRAYSIZE(kEoB2NumSpellsClericAmiga), kEoB2NumSpellsClericAmiga };

static const byte kEoB2NumSpellsWisAdjAmiga[64] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2NumSpellsWisAdjAmigaProvider = { ARRAYSIZE(kEoB2NumSpellsWisAdjAmiga), kEoB2NumSpellsWisAdjAmiga };

static const byte kEoB2NumSpellsPalAmiga[136] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2NumSpellsPalAmigaProvider = { ARRAYSIZE(kEoB2NumSpellsPalAmiga), kEoB2NumSpellsPalAmiga };

static const byte kEoB2NumSpellsMageAmiga[136] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00,
	0x04, 0x04, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00,
	0x04, 0x04, 0x04, 0x03, 0x03, 0x00, 0x00, 0x00,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x01, 0x00, 0x00,
	0x05, 0x05, 0x05, 0x04, 0x04, 0x02, 0x00, 0x00,
	0x05, 0x05, 0x05, 0x04, 0x04, 0x02, 0x01, 0x00,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x02, 0x01, 0x00,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x02, 0x01,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x03, 0x02
};

static const ByteProvider kEoB2NumSpellsMageAmigaProvider = { ARRAYSIZE(kEoB2NumSpellsMageAmiga), kEoB2NumSpellsMageAmiga };

static const uint32 kEoB2ExperienceTable0Amiga[14] = {
	0x00000000, 0x000007D0, 0x00000FA0, 0x00001F40, 0x00003E80, 0x00007D00, 0x0000FA00, 0x0001E848,
	0x0003D090, 0x0007A120, 0x000B71B0, 0x000F4240, 0x001312D0, 0xFFFFFFFF
};

static const Uint32Provider kEoB2ExperienceTable0AmigaProvider = { ARRAYSIZE(kEoB2ExperienceTable0Amiga), kEoB2ExperienceTable0Amiga };

static const uint32 kEoB2ExperienceTable1Amiga[14] = {
	0x00000000, 0x000009C4, 0x00001388, 0x00002710, 0x00004E20, 0x00009C40, 0x0000EA60, 0x00015F90,
	0x00020F58, 0x0003D090, 0x0005B8D8, 0x000B71B0, 0x00112A88, 0xFFFFFFFF
};

static const Uint32Provider kEoB2ExperienceTable1AmigaProvider = { ARRAYSIZE(kEoB2ExperienceTable1Amiga), kEoB2ExperienceTable1Amiga };

static const uint32 kEoB2ExperienceTable2Amiga[14] = {
	0x00000000, 0x000005DC, 0x00000BB8, 0x00001770, 0x000032C8, 0x00006B6C, 0x0000D6D8, 0x0001ADB0,
	0x00036EE8, 0x0006DDD0, 0x000A4CB8, 0x000DBBA0, 0x00112A88, 0xFFFFFFFF
};

static const Uint32Provider kEoB2ExperienceTable2AmigaProvider = { ARRAYSIZE(kEoB2ExperienceTable2Amiga), kEoB2ExperienceTable2Amiga };

static const uint32 kEoB2ExperienceTable3Amiga[14] = {
	0x00000000, 0x000004E2, 0x000009C4, 0x00001388, 0x00002710, 0x00004E20, 0x00009C40, 0x00011170,
	0x0001ADB0, 0x00027100, 0x00035B60, 0x0006B6C0, 0x000A1220, 0xFFFFFFFF
};

static const Uint32Provider kEoB2ExperienceTable3AmigaProvider = { ARRAYSIZE(kEoB2ExperienceTable3Amiga), kEoB2ExperienceTable3Amiga };

static const uint32 kEoB2ExperienceTable4Amiga[14] = {
	0x00000000, 0x000008CA, 0x00001194, 0x00002328, 0x00004650, 0x00008CA0, 0x000124F8, 0x000249F0,
	0x000493E0, 0x000927C0, 0x000DBBA0, 0x00124F80, 0x0016E360, 0xFFFFFFFF
};

static const Uint32Provider kEoB2ExperienceTable4AmigaProvider = { ARRAYSIZE(kEoB2ExperienceTable4Amiga), kEoB2ExperienceTable4Amiga };

static const byte kEoB2ExpObjectTlModeAmiga[18] = {
	0x00, 0x00, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x02, 0x00
};

static const ByteProvider kEoB2ExpObjectTlModeAmigaProvider = { ARRAYSIZE(kEoB2ExpObjectTlModeAmiga), kEoB2ExpObjectTlModeAmiga };

static const byte kEoB2ExpObjectTblIndexAmiga[14] = {
	0x02, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2ExpObjectTblIndexAmigaProvider = { ARRAYSIZE(kEoB2ExpObjectTblIndexAmiga), kEoB2ExpObjectTblIndexAmiga };

static const byte kEoB2ExpObjectShpStartAmiga[4] = {
	0x07, 0x0C, 0x0F, 0x12
};

static const ByteProvider kEoB2ExpObjectShpStartAmigaProvider = { ARRAYSIZE(kEoB2ExpObjectShpStartAmiga), kEoB2ExpObjectShpStartAmiga };

static const byte kEoB2ExpObjectTbl1Amiga[13] = {
	0x1f, 0x17, 0x1f, 0x17, 0x18, 0x17, 0x18, 0x19,
	0x18, 0x19, 0x18, 0x19, 0x00
};

static const ByteProvider kEoB2ExpObjectTbl1AmigaProvider = { ARRAYSIZE(kEoB2ExpObjectTbl1Amiga), kEoB2ExpObjectTbl1Amiga };

static const byte kEoB2ExpObjectTbl2Amiga[10] = {
	0x1f, 0x1c, 0x1f, 0x1c, 0x1d, 0x1d, 0x1e, 0x1d,
	0x1e, 0x00
};

static const ByteProvider kEoB2ExpObjectTbl2AmigaProvider = { ARRAYSIZE(kEoB2ExpObjectTbl2Amiga), kEoB2ExpObjectTbl2Amiga };

static const byte kEoB2ExpObjectTbl3Amiga[11] = {
	0x17, 0x1b, 0x17, 0x1b, 0x08, 0x1b, 0x08, 0x1e,
	0x08, 0x1e, 0x00
};

static const ByteProvider kEoB2ExpObjectTbl3AmigaProvider = { ARRAYSIZE(kEoB2ExpObjectTbl3Amiga), kEoB2ExpObjectTbl3Amiga };

static const byte kEoB2ExpObjectYAmiga[4] = {
	0x77, 0x67, 0x4F, 0x3F
};

static const ByteProvider kEoB2ExpObjectYAmigaProvider = { ARRAYSIZE(kEoB2ExpObjectYAmiga), kEoB2ExpObjectYAmiga };

static const byte kEoB2SparkDefStepsAmiga[8] = {
	0x40, 0x90, 0xE4, 0xB9, 0x6E, 0x1B, 0x06, 0x01
};

static const ByteProvider kEoB2SparkDefStepsAmigaProvider = { ARRAYSIZE(kEoB2SparkDefStepsAmiga), kEoB2SparkDefStepsAmiga };

static const byte kEoB2SparkDefSubStepsAmiga[4] = {
	0xC0, 0x30, 0x0C, 0x03
};

static const ByteProvider kEoB2SparkDefSubStepsAmigaProvider = { ARRAYSIZE(kEoB2SparkDefSubStepsAmiga), kEoB2SparkDefSubStepsAmiga };

static const byte kEoB2SparkDefShiftAmiga[4] = {
	0x06, 0x04, 0x02, 0x00
};

static const ByteProvider kEoB2SparkDefShiftAmigaProvider = { ARRAYSIZE(kEoB2SparkDefShiftAmiga), kEoB2SparkDefShiftAmiga };

static const byte kEoB2SparkDefAddAmiga[8] = {
	0x08, 0x06, 0x1C, 0x14, 0x0D, 0x18, 0x0D, 0x0F
};

static const ByteProvider kEoB2SparkDefAddAmigaProvider = { ARRAYSIZE(kEoB2SparkDefAddAmiga), kEoB2SparkDefAddAmiga };

static const byte kEoB2SparkDefXAmiga[6] = {
	0x17, 0x20, 0x17, 0x20, 0x17, 0x20
};

static const ByteProvider kEoB2SparkDefXAmigaProvider = { ARRAYSIZE(kEoB2SparkDefXAmiga), kEoB2SparkDefXAmiga };

static const byte kEoB2SparkDefYAmiga[6] = {
	0x02, 0x02, 0x34, 0x34, 0x66, 0x66
};

static const ByteProvider kEoB2SparkDefYAmigaProvider = { ARRAYSIZE(kEoB2SparkDefYAmiga), kEoB2SparkDefYAmiga };

static const uint32 kEoB2SparkOfFlags1Amiga[11] = {
	0x40000000, 0x95000000, 0xEA550000, 0xBFAA5400, 0x6AFFA954, 0x15AAFEA9, 0x0055ABFE, 0x000056AB,
	0x00000156, 0x00000001, 0x00000000
};

static const Uint32Provider kEoB2SparkOfFlags1AmigaProvider = { ARRAYSIZE(kEoB2SparkOfFlags1Amiga), kEoB2SparkOfFlags1Amiga };

static const uint32 kEoB2SparkOfFlags2Amiga[16] = {
	0xC0000000, 0x30000000, 0x0C000000, 0x03000000, 0x00C00000, 0x00300000, 0x000C0000, 0x00030000,
	0x0000C000, 0x00003000, 0x00000C00, 0x00000300, 0x000000C0, 0x00000030, 0x0000000C, 0x00000003
};

static const Uint32Provider kEoB2SparkOfFlags2AmigaProvider = { ARRAYSIZE(kEoB2SparkOfFlags2Amiga), kEoB2SparkOfFlags2Amiga };

static const byte kEoB2SparkOfShiftAmiga[16] = {
	0x1E, 0x1C, 0x1A, 0x18, 0x16, 0x14, 0x12, 0x10,
	0x0E, 0x0C, 0x0A, 0x08, 0x06, 0x04, 0x02, 0x00
};

static const ByteProvider kEoB2SparkOfShiftAmigaProvider = { ARRAYSIZE(kEoB2SparkOfShiftAmiga), kEoB2SparkOfShiftAmiga };

static const byte kEoB2SparkOfXAmiga[16] = {
	0x50, 0x70, 0x30, 0x68, 0x20, 0x60, 0x38, 0x78,
	0x80, 0x48, 0x58, 0x28, 0x60, 0x40, 0x70, 0x48
};

static const ByteProvider kEoB2SparkOfXAmigaProvider = { ARRAYSIZE(kEoB2SparkOfXAmiga), kEoB2SparkOfXAmiga };

static const byte kEoB2SparkOfYAmiga[16] = {
	0x31, 0x2B, 0x48, 0x17, 0x16, 0x48, 0x35, 0x1B,
	0x43, 0x2E, 0x24, 0x28, 0x38, 0x1C, 0x16, 0x44
};

static const ByteProvider kEoB2SparkOfYAmigaProvider = { ARRAYSIZE(kEoB2SparkOfYAmiga), kEoB2SparkOfYAmiga };

static const byte kEoB2SpellPropertiesAmiga[1820] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x0b, 0xc6, 0x00, 0x01,
	0xb6, 0xbe, 0x00, 0x33, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x0b, 0xcc,
	0x00, 0x01, 0xb7, 0x2a, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x03,
	0x0b, 0xda, 0x00, 0x01, 0xb8, 0x52, 0x00, 0x4c,
	0x00, 0x03, 0x0b, 0x3e, 0x00, 0x01, 0xb8, 0x78,
	0x5f, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x03, 0x0b, 0xe8, 0x00, 0x01, 0xb8, 0x9e,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0xb8, 0xd6, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x03, 0x0b, 0xf6, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x8b, 0x00, 0x03, 0x0b, 0x46,
	0x00, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00,
	0x00, 0x08, 0x00, 0x00, 0x00, 0x03, 0x0b, 0xfe,
	0x00, 0x01, 0xb9, 0x16, 0x04, 0x88, 0x00, 0x03,
	0x0b, 0x4e, 0x00, 0x01, 0xb9, 0xe2, 0x58, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03,
	0x0c, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x89,
	0x00, 0x03, 0x0b, 0x56, 0x00, 0x00, 0x00, 0x00,
	0x4b, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
	0x00, 0x03, 0x0c, 0x14, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x4c, 0x00, 0x03, 0x0b, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x03, 0x0c, 0x28, 0x00, 0x01,
	0xb6, 0x74, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x03, 0x0c, 0x3a,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x00,
	0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x03,
	0x0c, 0x48, 0x00, 0x01, 0xba, 0x44, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xba, 0x82,
	0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11,
	0x00, 0x03, 0x0c, 0x5a, 0x00, 0x01, 0xb6, 0x18,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x0c, 0x68, 0x00, 0x01,
	0xba, 0xc4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0xbb, 0x02, 0x63, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x21, 0x00, 0x03, 0x0c, 0x72,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x48, 0x00, 0x03,
	0x0b, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x0c, 0x78, 0x00, 0x01, 0xbb, 0x3e, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xbb, 0x7c,
	0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0c, 0x84, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x40,
	0x00, 0x00, 0x00, 0x03, 0x0c, 0x9c, 0x00, 0x01,
	0xbc, 0x7e, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0xbc, 0xbc, 0x47, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x0c, 0xac,
	0x00, 0x01, 0xbc, 0xf8, 0x04, 0x88, 0x00, 0x03,
	0x0b, 0x6e, 0x00, 0x01, 0xbd, 0xc6, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x03,
	0x0c, 0xbc, 0x00, 0x01, 0xbd, 0xf2, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0c, 0xc2, 0x00, 0x01, 0xbe, 0x54,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0xbe, 0x92, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x41, 0x00, 0x03, 0x0c, 0xcc, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x29, 0x00, 0x03, 0x0b, 0x76,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0c, 0xe2,
	0x00, 0x01, 0xbf, 0x18, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x0c, 0xf0, 0x00, 0x01, 0xbf, 0x96, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41,
	0x00, 0x03, 0x0c, 0xfe, 0x00, 0x01, 0xc0, 0x82,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0xc0, 0xc0, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x0d, 0x0c, 0x00, 0x01,
	0xc2, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4a, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x1a,
	0x00, 0x01, 0xc3, 0x58, 0x11, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x03,
	0x0d, 0x28, 0x00, 0x01, 0xc3, 0xce, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x03, 0x0d, 0x38, 0x00, 0x01, 0xc4, 0x48,
	0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x0d, 0x48, 0x00, 0x01,
	0xc4, 0x78, 0x00, 0x4c, 0x00, 0x03, 0x0b, 0x7e,
	0x00, 0x01, 0xc4, 0x92, 0x49, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x54,
	0x00, 0x01, 0xc4, 0xac, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x03,
	0x0d, 0x64, 0x00, 0x01, 0xc5, 0x22, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0d, 0x74, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x8a,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x03,
	0x0b, 0x86, 0x00, 0x00, 0x00, 0x00, 0x5b, 0x00,
	0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x0d, 0x90, 0x00, 0x01, 0xc5, 0x7c, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x03, 0x0d, 0xa4, 0x00, 0x01, 0xc5, 0x9a,
	0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x0d, 0xb6, 0x00, 0x01,
	0xb8, 0x52, 0x00, 0x4c, 0x00, 0x03, 0x0b, 0x3e,
	0x00, 0x01, 0xb8, 0x78, 0x5f, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x0d, 0xc4,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x00, 0x03,
	0x0b, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x00,
	0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x0d, 0xda, 0x00, 0x01, 0xc5, 0xda, 0x00, 0x39,
	0x00, 0x03, 0x0b, 0x96, 0x00, 0x01, 0xc6, 0xbc,
	0x5b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0d, 0xde, 0x00, 0x01, 0xc6, 0xe4,
	0x24, 0x08, 0x00, 0x03, 0x0b, 0x9e, 0x00, 0x01,
	0xb9, 0xe2, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x21, 0x00, 0x03, 0x0d, 0xea, 0x00, 0x01,
	0xbb, 0x3e, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0xbb, 0x7c, 0x65, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0xf6,
	0x00, 0x01, 0xc7, 0x9e, 0x00, 0x28, 0x00, 0x03,
	0x0b, 0xa6, 0x00, 0x01, 0xc8, 0x14, 0x6f, 0x00,
	0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x0e, 0x02, 0x00, 0x01, 0xc8, 0x2e, 0x00, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0e, 0x0e, 0x00, 0x01, 0xb6, 0x18,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x0e, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x99, 0x00, 0x03, 0x0b, 0xae,
	0x00, 0x00, 0x00, 0x00, 0x71, 0x00, 0x00, 0x00,
	0x40, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0e, 0x2e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x03,
	0x0b, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x5b, 0x00,
	0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x0e, 0x36, 0x00, 0x01, 0xc8, 0x6e, 0x00, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0e, 0x48, 0x00, 0x01, 0xc9, 0x02,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x03, 0x0e, 0x5e, 0x00, 0x01,
	0xc8, 0xbc, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0e, 0x72,
	0x00, 0x01, 0xc9, 0x26, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x0e, 0x84, 0x00, 0x00, 0x00, 0x00, 0x02, 0x48,
	0x00, 0x03, 0x0b, 0x8e, 0x00, 0x00, 0x00, 0x00,
	0x6e, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0e, 0xa4, 0x00, 0x01, 0xc9, 0x5a,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x03, 0x0e, 0xba, 0x00, 0x01,
	0xc9, 0x78, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x6a, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0e, 0xd0,
	0x00, 0x01, 0xc9, 0xb8, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0xc9, 0xf6, 0x62, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x03,
	0x0e, 0xde, 0x00, 0x01, 0xca, 0x26, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0e, 0xea, 0x00, 0x01, 0xc4, 0xac,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x03, 0x0e, 0xf6, 0x00, 0x01,
	0xc4, 0x78, 0x00, 0x4c, 0x00, 0x03, 0x0b, 0x7e,
	0x00, 0x01, 0xc4, 0x92, 0x49, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x02,
	0x00, 0x01, 0xca, 0x6a, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x03,
	0x0f, 0x08, 0x00, 0x01, 0xca, 0x86, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0f, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x0f, 0x1c, 0x00, 0x01,
	0xcd, 0xf6, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x5b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x2a,
	0x00, 0x01, 0xca, 0xea, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x0f, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xce, 0x30,
	0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0f, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x4c, 0x00, 0x03, 0x0b, 0xbe, 0x00, 0x00,
	0x00, 0x00, 0x5b, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x0f, 0x48, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0xce, 0x9a, 0x62, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x4a,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0xcc, 0x7e, 0x65, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x0f, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xcb, 0xfa,
	0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0f, 0x4e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0xcd, 0x0c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x0f, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0xcd, 0x7e, 0x65, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2SpellPropertiesAmigaProvider = { ARRAYSIZE(kEoB2SpellPropertiesAmiga), kEoB2SpellPropertiesAmiga };

static const byte kEoB2MagicFlightPropsAmiga[56] = {
	0x04, 0xff, 0x41, 0x0c, 0x0b, 0xff, 0x04, 0x06,
	0x0d, 0xff, 0x7a, 0x09, 0x0f, 0xff, 0x4a, 0x08,
	0x11, 0x06, 0x38, 0x0a, 0x14, 0x06, 0x7a, 0x0b,
	0x18, 0xff, 0x4a, 0x08, 0x36, 0xff, 0x4b, 0x09,
	0x3f, 0xff, 0x4b, 0x09, 0x41, 0x06, 0x4b, 0x09,
	0x42, 0x06, 0x4b, 0x08, 0x43, 0x06, 0x4b, 0x08,
	0x44, 0x06, 0x4b, 0x08, 0x45, 0x06, 0x4b, 0x08
};

static const ByteProvider kEoB2MagicFlightPropsAmigaProvider = { ARRAYSIZE(kEoB2MagicFlightPropsAmiga), kEoB2MagicFlightPropsAmiga };

static const byte kEoB2TurnUndeadEffectAmiga[140] = {
	0x0a, 0x07, 0x04, 0x00, 0x00, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0d, 0x0a,
	0x07, 0x04, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x10, 0x0d, 0x0a, 0x07,
	0x04, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x13, 0x10, 0x0d, 0x0a, 0x07, 0x04,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x14, 0x13, 0x10, 0x0d, 0x0a, 0x07, 0x04, 0x00,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x63, 0x14,
	0x13, 0x10, 0x0d, 0x0a, 0x07, 0x04, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x00, 0x63, 0x63, 0x14, 0x13,
	0x10, 0x0d, 0x0a, 0x07, 0x04, 0x00, 0x00, 0x00,
	0x00, 0xff, 0x63, 0x63, 0x63, 0x14, 0x13, 0x10,
	0x0d, 0x0a, 0x07, 0x04, 0x04, 0x00, 0x00, 0x00,
	0x63, 0x63, 0x63, 0x63, 0x14, 0x13, 0x10, 0x0d,
	0x0a, 0x07, 0x07, 0x04, 0x04, 0x00, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x14, 0x13, 0x10, 0x0d, 0x0a,
	0x0a, 0x07, 0x07, 0x04
};

static const ByteProvider kEoB2TurnUndeadEffectAmigaProvider = { ARRAYSIZE(kEoB2TurnUndeadEffectAmiga), kEoB2TurnUndeadEffectAmiga };

static const byte kEoB2BurningHandsDestAmiga[32] = {
	0x02, 0x03, 0x04, 0x01, 0x02, 0x05, 0x00, 0x00,
	0x00, 0x02, 0x04, 0x01, 0x03, 0x05, 0x00, 0x00,
	0x00, 0x01, 0x04, 0x02, 0x03, 0x05, 0x00, 0x00,
	0x01, 0x03, 0x04, 0x00, 0x02, 0x05, 0x00, 0x00
};

static const ByteProvider kEoB2BurningHandsDestAmigaProvider = { ARRAYSIZE(kEoB2BurningHandsDestAmiga), kEoB2BurningHandsDestAmiga };

static const byte kEoB2ConeOfColdDest1Amiga[7] = {
	0xE0, 0xC0, 0xC1, 0xBF, 0xA0, 0x9F, 0xA1
};

static const ByteProvider kEoB2ConeOfColdDest1AmigaProvider = { ARRAYSIZE(kEoB2ConeOfColdDest1Amiga), kEoB2ConeOfColdDest1Amiga };

static const byte kEoB2ConeOfColdDest2Amiga[7] = {
	0x01, 0x02, 0xE2, 0x22, 0x03, 0xE3, 0x23
};

static const ByteProvider kEoB2ConeOfColdDest2AmigaProvider = { ARRAYSIZE(kEoB2ConeOfColdDest2Amiga), kEoB2ConeOfColdDest2Amiga };

static const byte kEoB2ConeOfColdDest3Amiga[7] = {
	0x20, 0x40, 0x3F, 0x41, 0x60, 0x5F, 0x61
};

static const ByteProvider kEoB2ConeOfColdDest3AmigaProvider = { ARRAYSIZE(kEoB2ConeOfColdDest3Amiga), kEoB2ConeOfColdDest3Amiga };

static const byte kEoB2ConeOfColdDest4Amiga[7] = {
	0xFF, 0xFE, 0x1E, 0xDE, 0xFD, 0x1D, 0xDD
};

static const ByteProvider kEoB2ConeOfColdDest4AmigaProvider = { ARRAYSIZE(kEoB2ConeOfColdDest4Amiga), kEoB2ConeOfColdDest4Amiga };

static const byte kEoB2ConeOfColdGfxTblAmiga[8] = {
	0x1f, 0x1c, 0x1f, 0x1c, 0x1d, 0x1d, 0x1d, 0x00
};

static const ByteProvider kEoB2ConeOfColdGfxTblAmigaProvider = { ARRAYSIZE(kEoB2ConeOfColdGfxTblAmiga), kEoB2ConeOfColdGfxTblAmiga };

static const byte kEoB2DscDoorShapeIndexAmiga[53] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01
};

static const ByteProvider kEoB2DscDoorShapeIndexAmigaProvider = { ARRAYSIZE(kEoB2DscDoorShapeIndexAmiga), kEoB2DscDoorShapeIndexAmiga };

static const byte kEoB2WllFlagPresetAmiga[25] = {
	0x07, 0x00, 0x40, 0xA8, 0x88, 0x88, 0x88, 0x9F,
	0xA8, 0x88, 0x88, 0x88, 0x9F, 0xA8, 0x88, 0x88,
	0x88, 0x9F, 0xA8, 0x88, 0x88, 0x88, 0x9F, 0x03,
	0x03
};

static const ByteProvider kEoB2WllFlagPresetAmigaProvider = { ARRAYSIZE(kEoB2WllFlagPresetAmiga), kEoB2WllFlagPresetAmiga };

static const uint16 kEoB2DscShapeCoordsAmiga[180] = {
	0xff91, 0xffc1, 0xffa1, 0xffc1, 0xff75, 0xffc5, 0xff8b, 0xffc5,
	0xff88, 0xffc3, 0xffb4, 0xffc1, 0xffc4, 0xffc1, 0xffa1, 0xffc5,
	0xffb6, 0xffc5, 0xffb0, 0xffc3, 0xffd5, 0xffc1, 0xffe5, 0xffc1,
	0xffcb, 0xffc5, 0xffe1, 0xffc5, 0xffd8, 0xffc3, 0xfff8, 0xffc1,
	0x0008, 0xffc1, 0xfff6, 0xffc5, 0x000a, 0xffc5, 0x0000, 0xffc3,
	0x001b, 0xffc1, 0x002b, 0xffc1, 0x001f, 0xffc5, 0x0035, 0xffc5,
	0x0028, 0xffc3, 0x003c, 0xffc1, 0x004c, 0xffc1, 0x004a, 0xffc5,
	0x005f, 0xffc5, 0x0050, 0xffc3, 0x005f, 0xffc1, 0x006f, 0xffc1,
	0x0075, 0xffc5, 0x008b, 0xffc5, 0x0078, 0xffc3, 0xff8a, 0xffcb,
	0xffa4, 0xffcb, 0xff68, 0xffd3, 0xff88, 0xffd3, 0xff8a, 0xffce,
	0xffbe, 0xffcb, 0xffd8, 0xffcb, 0xffac, 0xffd3, 0xffcd, 0xffd3,
	0xffc5, 0xffce, 0xfff3, 0xffcb, 0x000d, 0xffcb, 0xfff0, 0xffd3,
	0x0010, 0xffd3, 0x0000, 0xffce, 0x0028, 0xffcb, 0x0042, 0xffcb,
	0x0033, 0xffd3, 0x0054, 0xffd3, 0x003b, 0xffce, 0x005c, 0xffcb,
	0x0076, 0xffcb, 0x0078, 0xffd3, 0x0098, 0xffd3, 0x0076, 0xffce,
	0xff92, 0xffdd, 0xffbd, 0xffdd, 0xff74, 0xffea, 0xffad, 0xffea,
	0xff9e, 0xffe2, 0xffea, 0xffdd, 0x0016, 0xffdd, 0xffe5, 0xffea,
	0x001b, 0xffea, 0x0000, 0xffe2, 0x0043, 0xffdd, 0x006e, 0xffdd,
	0x0053, 0xffea, 0x008c, 0xffea, 0x0062, 0xffe2, 0xff80, 0xfffc,
	0x0080, 0xfffc, 0xff80, 0xffbe, 0x0080, 0xffbe, 0x0080, 0x0000,
	0xffda, 0xfffc, 0x0026, 0xfffc, 0xffda, 0xffbe, 0x0026, 0xffbe,
	0x0000, 0x0000, 0xff80, 0xfffc, 0x0080, 0xfffc, 0xff80, 0xffbe,
	0x0080, 0xffbe, 0x0080, 0x0000
};

static const Uint16Provider kEoB2DscShapeCoordsAmigaProvider = { ARRAYSIZE(kEoB2DscShapeCoordsAmiga), kEoB2DscShapeCoordsAmiga };

static const byte kEoB2DscDoorScaleOffsAmiga[53] = {
	0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x0D, 0x0D, 0x0D,
	0x0D, 0x0D, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x33, 0x34
};

static const ByteProvider kEoB2DscDoorScaleOffsAmigaProvider = { ARRAYSIZE(kEoB2DscDoorScaleOffsAmiga), kEoB2DscDoorScaleOffsAmiga };

static const byte kEoB2DscDoorScaleMult1Amiga[4] = {
	0x08, 0x0C, 0x12, 0x00
};

static const ByteProvider kEoB2DscDoorScaleMult1AmigaProvider = { ARRAYSIZE(kEoB2DscDoorScaleMult1Amiga), kEoB2DscDoorScaleMult1Amiga };

static const byte kEoB2DscDoorScaleMult2Amiga[4] = {
	0x00, 0x02, 0x04, 0x00
};

static const ByteProvider kEoB2DscDoorScaleMult2AmigaProvider = { ARRAYSIZE(kEoB2DscDoorScaleMult2Amiga), kEoB2DscDoorScaleMult2Amiga };

static const byte kEoB2DscDoorScaleMult3Amiga[4] = {
	0x05, 0x08, 0x0C, 0x00
};

static const ByteProvider kEoB2DscDoorScaleMult3AmigaProvider = { ARRAYSIZE(kEoB2DscDoorScaleMult3Amiga), kEoB2DscDoorScaleMult3Amiga };

static const byte kEoB2DscDoorType5OffsAmiga[6] = {
	0x05, 0x03, 0x01, 0x05, 0x03, 0x01
};

static const ByteProvider kEoB2DscDoorType5OffsAmigaProvider = { ARRAYSIZE(kEoB2DscDoorType5OffsAmiga), kEoB2DscDoorType5OffsAmiga };

static const byte kEoB2DscDoorY1Amiga[4] = {
	0x3B, 0x47, 0x56, 0x00
};

static const ByteProvider kEoB2DscDoorY1AmigaProvider = { ARRAYSIZE(kEoB2DscDoorY1Amiga), kEoB2DscDoorY1Amiga };

static const byte kEoB2DscDoorY2Amiga[4] = {
	0x1F, 0x18, 0x0F, 0x00
};

static const ByteProvider kEoB2DscDoorY2AmigaProvider = { ARRAYSIZE(kEoB2DscDoorY2Amiga), kEoB2DscDoorY2Amiga };

static const byte kEoB2DscDoorFrameY1Amiga[4] = {
	0x1E, 0x18, 0x10, 0x00
};

static const ByteProvider kEoB2DscDoorFrameY1AmigaProvider = { ARRAYSIZE(kEoB2DscDoorFrameY1Amiga), kEoB2DscDoorFrameY1Amiga };

static const byte kEoB2DscDoorFrameY2Amiga[4] = {
	0x3B, 0x47, 0x56, 0x78
};

static const ByteProvider kEoB2DscDoorFrameY2AmigaProvider = { ARRAYSIZE(kEoB2DscDoorFrameY2Amiga), kEoB2DscDoorFrameY2Amiga };

static const byte kEoB2DscItemPosIndexAmiga[16] = {
	0x00, 0x01, 0x02, 0x03, 0x02, 0x00, 0x03, 0x01,
	0x03, 0x02, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02
};

static const ByteProvider kEoB2DscItemPosIndexAmigaProvider = { ARRAYSIZE(kEoB2DscItemPosIndexAmiga), kEoB2DscItemPosIndexAmiga };

static const uint16 kEoB2DscItemShpXAmiga[18] = {
	0xFFC8, 0xFFF8, 0x0028, 0x0058, 0x0088, 0x00B8, 0x00E8, 0xFFB8,
	0x0008, 0x0058, 0x00A8, 0x00F8, 0xFFD8, 0x0058, 0x00D8, 0xFFA8,
	0x0058, 0x0108
};

static const Uint16Provider kEoB2DscItemShpXAmigaProvider = { ARRAYSIZE(kEoB2DscItemShpXAmiga), kEoB2DscItemShpXAmiga };

static const byte kEoB2DscItemScaleIndexAmiga[18] = {
	0xFF, 0xFF, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0xFF, 0xFF,
	0x25, 0x00
};

static const ByteProvider kEoB2DscItemScaleIndexAmigaProvider = { ARRAYSIZE(kEoB2DscItemScaleIndexAmiga), kEoB2DscItemScaleIndexAmiga };

static const byte kEoB2DscItemTileIndexAmiga[18] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0x09, 0xFF, 0x0B,
	0x0C, 0x0D
};

static const ByteProvider kEoB2DscItemTileIndexAmigaProvider = { ARRAYSIZE(kEoB2DscItemTileIndexAmiga), kEoB2DscItemTileIndexAmiga };

static const byte kEoB2DscItemShapeMapAmiga[113] = {
	0x00, 0x00, 0x00, 0x05, 0x01, 0x02, 0x03, 0x04,
	0x03, 0x05, 0x06, 0x06, 0x12, 0x05, 0x0f, 0x12,
	0x14, 0x08, 0x13, 0x11, 0x15, 0x18, 0x07, 0x07,
	0x07, 0x1f, 0x09, 0x23, 0x09, 0x09, 0x09, 0x09,
	0x08, 0x1c, 0x1c, 0x1a, 0x1b, 0x21, 0x1d, 0x1d,
	0x22, 0x22, 0x22, 0x00, 0x16, 0x00, 0x00, 0x17,
	0x17, 0x17, 0x17, 0x17, 0x22, 0x21, 0x19, 0x23,
	0x10, 0x1e, 0x17, 0x25, 0x17, 0x26, 0x12, 0x21,
	0x17, 0x23, 0x1c, 0x00, 0x20, 0x25, 0x12, 0x18,
	0x1f, 0x07, 0x07, 0x15, 0x15, 0x0f, 0x03, 0x09,
	0x1e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b,
	0x1b, 0x17, 0x17, 0x16, 0x16, 0x21, 0x08, 0x25,
	0x25, 0x25, 0x25, 0x28, 0x03, 0x04, 0x21, 0x00,
	0x17, 0x00, 0x20, 0x24, 0x27, 0x27, 0x1c, 0x27,
	0x00
};

static const ByteProvider kEoB2DscItemShapeMapAmigaProvider = { ARRAYSIZE(kEoB2DscItemShapeMapAmiga), kEoB2DscItemShapeMapAmiga };

static const byte kEoB2DscTelptrShpCoordsAmiga[156] = {
	0x0c, 0x07, 0x1a, 0x01, 0x3e, 0x03, 0x0c, 0x1a,
	0x2a, 0x13, 0x40, 0x18, 0x02, 0x2d, 0x16, 0x25,
	0x28, 0x32, 0x36, 0x27, 0x0a, 0x3e, 0x16, 0x49,
	0x3e, 0x44, 0x06, 0x06, 0x2a, 0x04, 0x37, 0x0a,
	0x04, 0x1b, 0x1a, 0x16, 0x37, 0x1d, 0x0e, 0x2a,
	0x1b, 0x35, 0x2e, 0x28, 0x42, 0x30, 0x06, 0x47,
	0x06, 0x47, 0x2d, 0x4c, 0x0a, 0x04, 0x14, 0x00,
	0x2e, 0x01, 0x0c, 0x10, 0x1f, 0x10, 0x2f, 0x10,
	0x12, 0x18, 0x28, 0x1d, 0x01, 0x21, 0x08, 0x2a,
	0x11, 0x32, 0x2f, 0x2e, 0x1f, 0x25, 0x02, 0x02,
	0x01, 0x11, 0x01, 0x2f, 0x08, 0x1e, 0x11, 0x0e,
	0x11, 0x26, 0x1c, 0x01, 0x1e, 0x19, 0x1f, 0x33,
	0x24, 0x11, 0x26, 0x05, 0x28, 0x2b, 0x2f, 0x22,
	0x00, 0x13, 0x05, 0x01, 0x06, 0x08, 0x09, 0x0c,
	0x04, 0x1a, 0x08, 0x1f, 0x12, 0x05, 0x12, 0x15,
	0x16, 0x10, 0x1a, 0x08, 0x1a, 0x1d, 0x0a, 0x00,
	0x0a, 0x00, 0x00, 0x09, 0x00, 0x1e, 0x04, 0x11,
	0x08, 0x16, 0x08, 0x06, 0x10, 0x00, 0x11, 0x0d,
	0x12, 0x20, 0x15, 0x02, 0x14, 0x09, 0x16, 0x1b,
	0x1a, 0x14, 0x1a, 0x14
};

static const ByteProvider kEoB2DscTelptrShpCoordsAmigaProvider = { ARRAYSIZE(kEoB2DscTelptrShpCoordsAmiga), kEoB2DscTelptrShpCoordsAmiga };

static const byte kEoB2PortalSeqDataAmiga[126] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,
	0x02, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,
	0x04, 0x00, 0x03, 0x00, 0x02, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x04,
	0x00, 0x01, 0x01, 0x00, 0x02, 0x01, 0x03, 0x02,
	0x02, 0x03, 0x01, 0x04, 0x00, 0x02, 0x01, 0x03,
	0x02, 0x04, 0x03, 0x02, 0x04, 0x03, 0x03, 0x04,
	0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x05, 0x04, 0x06, 0x03, 0x07,
	0x02, 0x08, 0x02, 0x08, 0x01, 0x09, 0x01, 0x09,
	0x01, 0x09, 0x00, 0x0a, 0xff, 0xff
};

static const ByteProvider kEoB2PortalSeqDataAmigaProvider = { ARRAYSIZE(kEoB2PortalSeqDataAmiga), kEoB2PortalSeqDataAmiga };

static const byte kEoB2DscMonsterFrmOffsTbl1Amiga[32] = {
	0x04, 0xfe, 0x01, 0x03, 0x03, 0x04, 0xfe, 0x01,
	0x01, 0x03, 0x04, 0xfe, 0xfe, 0x01, 0x03, 0x04,
	0xfc, 0xfd, 0xff, 0x02, 0x02, 0xfc, 0xfd, 0xff,
	0xff, 0x02, 0xfc, 0xfd, 0xfd, 0xff, 0x02, 0xfc
};

static const ByteProvider kEoB2DscMonsterFrmOffsTbl1AmigaProvider = { ARRAYSIZE(kEoB2DscMonsterFrmOffsTbl1Amiga), kEoB2DscMonsterFrmOffsTbl1Amiga };

static const byte kEoB2DscMonsterFrmOffsTbl2Amiga[32] = {
	0x04, 0xfe, 0x01, 0x03, 0x03, 0x04, 0xfe, 0x01,
	0x01, 0x03, 0x04, 0xfe, 0xfe, 0x01, 0x03, 0x04,
	0x04, 0xfd, 0x01, 0x02, 0x02, 0x04, 0xfd, 0x01,
	0x01, 0x02, 0x04, 0xfd, 0xfd, 0x01, 0x02, 0x04
};

static const ByteProvider kEoB2DscMonsterFrmOffsTbl2AmigaProvider = { ARRAYSIZE(kEoB2DscMonsterFrmOffsTbl2Amiga), kEoB2DscMonsterFrmOffsTbl2Amiga };

static const uint16 kEoB2InvSlotXAmiga[27] = {
	0x00e6, 0x0116, 0x00b5, 0x00c7, 0x00b5, 0x00c7, 0x00b5, 0x00c7,
	0x00b5, 0x00c7, 0x00b5, 0x00c7, 0x00b5, 0x00c7, 0x00b5, 0x00c7,
	0x00e1, 0x00e0, 0x00e1, 0x012a, 0x011f, 0x0115, 0x012c, 0x012c,
	0x012c, 0x00e4, 0x00f0
};

static const Uint16Provider kEoB2InvSlotXAmigaProvider = { ARRAYSIZE(kEoB2InvSlotXAmiga), kEoB2InvSlotXAmiga };

static const byte kEoB2InvSlotYAmiga[27] = {
	0x74, 0x74, 0x28, 0x28, 0x3a, 0x3a, 0x4c, 0x4c,
	0x5e, 0x5e, 0x70, 0x70, 0x82, 0x82, 0x94, 0x94,
	0x38, 0x4c, 0x60, 0x37, 0x4b, 0x89, 0x5e, 0x70,
	0x82, 0x88, 0x88
};

static const ByteProvider kEoB2InvSlotYAmigaProvider = { ARRAYSIZE(kEoB2InvSlotYAmiga), kEoB2InvSlotYAmiga };

static const uint16 kEoB2SlotValidationFlagsAmiga[27] = {
	0x0008, 0x0008, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0x0001, 0x0002, 0x0004, 0x0020, 0x0040, 0x0010, 0xffff, 0x0080,
	0x0080, 0x0100, 0x0100
};

static const Uint16Provider kEoB2SlotValidationFlagsAmigaProvider = { ARRAYSIZE(kEoB2SlotValidationFlagsAmiga), kEoB2SlotValidationFlagsAmiga };

static const byte kEoB2ProjectileWeaponTypesAmiga[15] = {
	0xFF, 0x01, 0xFF, 0x02, 0x04, 0x03, 0x05, 0x10,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x12
};

static const ByteProvider kEoB2ProjectileWeaponTypesAmigaProvider = { ARRAYSIZE(kEoB2ProjectileWeaponTypesAmiga), kEoB2ProjectileWeaponTypesAmiga };

static const byte kEoB2WandTypesAmiga[8] = {
	0x00, 0x11, 0x17, 0x31, 0x0D, 0xFF, 0x04, 0x0C
};

static const ByteProvider kEoB2WandTypesAmigaProvider = { ARRAYSIZE(kEoB2WandTypesAmiga), kEoB2WandTypesAmiga };

static const byte kEoB2DrawObjPosIndexAmiga[20] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x02, 0x00, 0x03,
	0x01, 0x04, 0x02, 0x03, 0x00, 0x01, 0x04, 0x01,
	0x03, 0x00, 0x02, 0x04
};

static const ByteProvider kEoB2DrawObjPosIndexAmigaProvider = { ARRAYSIZE(kEoB2DrawObjPosIndexAmiga), kEoB2DrawObjPosIndexAmiga };

static const byte kEoB2FlightObjFlipIndexAmiga[16] = {
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00
};

static const ByteProvider kEoB2FlightObjFlipIndexAmigaProvider = { ARRAYSIZE(kEoB2FlightObjFlipIndexAmiga), kEoB2FlightObjFlipIndexAmiga };

static const byte kEoB2FlightObjShpMapAmiga[45] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x02,
	0xFF, 0xFF, 0x04, 0xFF, 0x06, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2FlightObjShpMapAmigaProvider = { ARRAYSIZE(kEoB2FlightObjShpMapAmiga), kEoB2FlightObjShpMapAmiga };

static const byte kEoB2FlightObjSclIndexAmiga[72] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
	0xff, 0xff, 0x03, 0x03, 0xff, 0xff, 0x03, 0x03,
	0xff, 0xff, 0x03, 0x03, 0xff, 0xff, 0x03, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x01, 0xff, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

static const ByteProvider kEoB2FlightObjSclIndexAmigaProvider = { ARRAYSIZE(kEoB2FlightObjSclIndexAmiga), kEoB2FlightObjSclIndexAmiga };

static const uint16 kEoB2TransferPortraitFramesAmiga[32] = {
	0x0004, 0x0018, 0x009d, 0x0038, 0x00a2, 0x0018, 0x013c, 0x0039,
	0x0004, 0x0040, 0x009d, 0x0060, 0x00a2, 0x0040, 0x013c, 0x0060,
	0x0004, 0x0068, 0x009d, 0x0089, 0x00a2, 0x0068, 0x013c, 0x0089,
	0x0004, 0x0094, 0x002e, 0x009e, 0x0110, 0x0094, 0x013a, 0x009e
};

static const Uint16Provider kEoB2TransferPortraitFramesAmigaProvider = { ARRAYSIZE(kEoB2TransferPortraitFramesAmiga), kEoB2TransferPortraitFramesAmiga };

static const byte kEoB2TransferConvertTableAmiga[49] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x00, 0x05, 0x06,
	0x0A, 0x00, 0x0B, 0x00, 0x0C, 0x0D, 0x00, 0x0E,
	0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x00, 0x00,
	0x17, 0x18, 0x22, 0x24, 0x23, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x31, 0x30, 0x32, 0x33, 0x00, 0x35, 0x34, 0x36,
	0x37
};

static const ByteProvider kEoB2TransferConvertTableAmigaProvider = { ARRAYSIZE(kEoB2TransferConvertTableAmiga), kEoB2TransferConvertTableAmiga };

static const byte kEoB2TransferItemTableAmiga[60] = {
	0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2TransferItemTableAmigaProvider = { ARRAYSIZE(kEoB2TransferItemTableAmiga), kEoB2TransferItemTableAmiga };

static const uint32 kEoB2TransferExpTableAmiga[6] = {
	0x000F423F, 0x000B71AF, 0x000DBB9F, 0x0006B6BF, 0x000DBB9F, 0x000DBB9F
};

static const Uint32Provider kEoB2TransferExpTableAmigaProvider = { ARRAYSIZE(kEoB2TransferExpTableAmiga), kEoB2TransferExpTableAmiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData00Amiga[5] = {
	{ 0x01,   0, 208,  16,   1,   1,   0,   0,   0,   0 },
	{ 0x01,   0, 208,  16,   1,   1,   0,   0,   0,   0 },
	{ 0x00,   0, 216,  51,   8,   0,   0,   0,   0,   0 },
	{ 0x06,   3,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData00AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData00Amiga), kEoB2IntroAnimData00Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData01Amiga[5] = {
	{ 0x01,   1, 184,   8,   1,   1,   0,   0,   0,   0 },
	{ 0x01,   1, 184,   8,   1,   1,   0,   0,   0,   0 },
	{ 0x00,   0, 216,  51,   7,   0,   0,   0,   0,   0 },
	{ 0x06,   4,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData01AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData01Amiga), kEoB2IntroAnimData01Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData02Amiga[5] = {
	{ 0x01,   2, 216,  51,   1,   0,   0,   0,   0,   0 },
	{ 0x01,   2, 216,  51,   1,   0,   0,   0,   0,   0 },
	{ 0x00,   0, 216,  51,  18,   0,   0,   0,   0,   0 },
	{ 0x06,   6,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData02AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData02Amiga), kEoB2IntroAnimData02Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData03Amiga[4] = {
	{ 0x00,   0,   0,   0,   1,   2,   0,   0,   0,   0 },
	{ 0x06,   3,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   2,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData03AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData03Amiga), kEoB2IntroAnimData03Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData04Amiga[3] = {
	{ 0x01,   0, 282,   8,   1,   0,   0,   0,   0,   0 },
	{ 0x01,   0, 282,   8,   1,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData04AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData04Amiga), kEoB2IntroAnimData04Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData05Amiga[4] = {
	{ 0x00,   0,   0,   0,   1,   1,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   1,   0,   0,   0,   0 },
	{ 0x06,   5,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData05AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData05Amiga), kEoB2IntroAnimData05Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData06Amiga[16] = {
	{ 0x01,  12, 170,  11,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 188,  38,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 203,  63,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 218,  85,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 232, 107,   2,   0,   0,   0,   0,   0 },
	{ 0x06,   9,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x01,   3, 242, 125,   1,   0,   0,   0,   0,   0 },
	{ 0x01,   4, 240, 125,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   5, 238, 124,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   6, 236, 123,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   7, 232, 121,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   8, 226, 120,   3,   0,   0,   0,   0,   0 },
	{ 0x01,   9, 220, 119,   3,   0,   0,   0,   0,   0 },
	{ 0x01,  10, 241, 115,   3,   0,   0,   0,   0,   0 },
	{ 0x01,  11, 241, 115,   3,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData06AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData06Amiga), kEoB2IntroAnimData06Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData07Amiga[5] = {
	{ 0x01,  12,  54,  17,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12,  80,  53,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 104,  87,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 130, 124,   2,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData07AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData07Amiga), kEoB2IntroAnimData07Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData08Amiga[6] = {
	{ 0x01,  12, 112,   8,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 126,  34,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 142,  60,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 170, 109,   2,   0,   0,   0,   0,   0 },
	{ 0x06,   8,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData08AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData08Amiga), kEoB2IntroAnimData08Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData09Amiga[4] = {
	{ 0x05,   0, 184,  64,   6,   0,  30,   8,   3,  16 },
	{ 0x05,   0, 184,  64,   6,   0,  33,   8,   3,  16 },
	{ 0x05,   0, 184,  64,   6,   0,  36,   8,   3,  16 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData09AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData09Amiga), kEoB2IntroAnimData09Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData10Amiga[10] = {
	{ 0x05,   0, 184,  64,   0,   0,  30,   8,   3,  16 },
	{ 0x05,   0, 128,  88,   3,   0,  30,  32,   4,  24 },
	{ 0x05,   0, 128,  88,   3,   0,  34,  32,   4,  24 },
	{ 0x05,   0, 184,  64,   0,   0,  33,   8,   3,  16 },
	{ 0x05,   0, 128,  88,   3,   0,  30,  32,   4,  24 },
	{ 0x05,   0, 128,  88,   3,   0,  34,  32,   4,  24 },
	{ 0x05,   0, 184,  64,   0,   0,  36,   8,   3,  16 },
	{ 0x05,   0, 128,  88,   3,   0,  30,  32,   4,  24 },
	{ 0x05,   0, 128,  88,   3,   0,  34,  32,   4,  24 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData10AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData10Amiga), kEoB2IntroAnimData10Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData11Amiga[10] = {
	{ 0x03,  15,  36,  48,   2,   1,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   2,   2,   0,   0,   0,   0 },
	{ 0x06,  11,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   2,   3,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,  90,   4,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   2,   3,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   2,   2,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   2,   1,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   2,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData11AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData11Amiga), kEoB2IntroAnimData11Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData12Amiga[4] = {
	{ 0x06,  10,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 104,  24,   5,   0,   0,   8,  15, 112 },
	{ 0x05,   0, 104,  24,   5,   0,  15,   8,  15, 112 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData12AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData12Amiga), kEoB2IntroAnimData12Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData13Amiga[6] = {
	{ 0x05,   0, 184,  64,   0,   0,  30,   8,   3,  16 },
	{ 0x05,   0, 104,  72,   5,   0,  10, 120,  10,  64 },
	{ 0x05,   0, 184,  64,   0,   0,  33,   8,   3,  16 },
	{ 0x05,   0, 104,  72,   5,   0,  20, 120,  10,  64 },
	{ 0x05,   0, 184,  64,   0,   0,  36,   8,   3,  16 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData13AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData13Amiga), kEoB2IntroAnimData13Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData14Amiga[4] = {
	{ 0x05,   0, 104,   0,   8,   0,   0,   0,  13, 200 },
	{ 0x05,   0, 104,   0,   8,   0,  13,   0,  13, 200 },
	{ 0x05,   0, 104,   0,   8,   0,  26,   0,  13, 200 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData14AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData14Amiga), kEoB2IntroAnimData14Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData15Amiga[11] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   6, 112,  72,   6,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   7, 112,  72,   6,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   8, 112,  72,   6,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData15AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData15Amiga), kEoB2IntroAnimData15Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData16Amiga[12] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0x06,   5,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData16AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData16Amiga), kEoB2IntroAnimData16Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData17Amiga[8] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData17AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData17Amiga), kEoB2IntroAnimData17Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData18Amiga[14] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,  10, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  11, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  12, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  13, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  10, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  13, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData18AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData18Amiga), kEoB2IntroAnimData18Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData19Amiga[14] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,  11, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  10, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  13, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  12, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  11, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  13, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData19AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData19Amiga), kEoB2IntroAnimData19Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData20Amiga[14] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,  14, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  15, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  16, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  17, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  14, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  17, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData20AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData20Amiga), kEoB2IntroAnimData20Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData21Amiga[2] = {
	{ 0x05,   0, 104,  32,   0,   0,  10,   0,  10,  96 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData21AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData21Amiga), kEoB2IntroAnimData21Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData22Amiga[2] = {
	{ 0x05,   0, 104,  32,   3,   0,  20,   0,  10,  96 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData22AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData22Amiga), kEoB2IntroAnimData22Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData23Amiga[2] = {
	{ 0x05,   0, 104,  32,   0,   0,  30,   0,  10,  96 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData23AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData23Amiga), kEoB2IntroAnimData23Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData24Amiga[2] = {
	{ 0x05,   0, 104,  32,   0,   0,   0,  96,  10,  96 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData24AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData24Amiga), kEoB2IntroAnimData24Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData25Amiga[2] = {
	{ 0x05,   0, 104,  32,   3,   0,  10,  96,  10,  96 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData25AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData25Amiga), kEoB2IntroAnimData25Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData26Amiga[2] = {
	{ 0x05,   0, 104,  32,   0,   0,  20,  96,  10,  96 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData26AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData26Amiga), kEoB2IntroAnimData26Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData27Amiga[2] = {
	{ 0x05,   0, 104,  32,   0,   0,   0,   0,  10,  96 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData27AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData27Amiga), kEoB2IntroAnimData27Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData28Amiga[2] = {
	{ 0x05,   0, 104,  32,   3,   0,   0,   0,  10,  96 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData28AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData28Amiga), kEoB2IntroAnimData28Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData29Amiga[2] = {
	{ 0x05,   0, 104,  32,   4,   0,  10,   0,  10,  96 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData29AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData29Amiga), kEoB2IntroAnimData29Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData30Amiga[2] = {
	{ 0x05,   0, 104,  32,   8,   0,  20,   0,  10,  96 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData30AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData30Amiga), kEoB2IntroAnimData30Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData31Amiga[5] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 176,  56,   3,   0,  19, 136,   2,   8 },
	{ 0x05,   0, 176,  56,   3,   0,  21, 136,   2,   8 },
	{ 0x05,   0, 176,  56,   3,   0,  23, 136,   2,   8 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData31AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData31Amiga), kEoB2IntroAnimData31Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData32Amiga[14] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 176,  56,   0,   0,  19, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   5,   0,   1, 136,   6,  40 },
	{ 0x05,   0, 176,  56,   0,   0,  21, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   3,   0,   7, 136,   6,  40 },
	{ 0x05,   0, 176,  56,   2,   0,  23, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   3,   0,  13, 136,   6,  40 },
	{ 0x05,   0, 176,  56,   0,   0,  19, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   6,   0,   1, 136,   6,  40 },
	{ 0x05,   0, 176,  56,   0,   0,  21, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   3,   0,   7, 136,   6,  40 },
	{ 0x05,   0, 176,  56,   0,   0,  23, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   3,   0,   1, 136,   6,  40 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData32AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData32Amiga), kEoB2IntroAnimData32Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData33Amiga[8] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0,  80,  64,   0,   0,   1, 136,   2,  16 },
	{ 0x05,   0, 248,  64,   3,   0,   7, 136,   2,  16 },
	{ 0x05,   0,  80,  64,   0,   0,   3, 136,   2,  16 },
	{ 0x05,   0, 248,  64,   3,   0,   9, 136,   2,  16 },
	{ 0x05,   0,  80,  64,   0,   0,   5, 136,   2,  16 },
	{ 0x05,   0, 248,  64,   3,   0,  11, 136,   2,  16 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData33AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData33Amiga), kEoB2IntroAnimData33Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData34Amiga[5] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0,  16,  48,   0,   0,   0, 152,  14,  48 },
	{ 0x05,   0, 192,  48,   4,   0,  14, 128,  13,  48 },
	{ 0x05,   0,  16,  48,   0,   0,   1,  40,  35,  48 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData34AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData34Amiga), kEoB2IntroAnimData34Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData35Amiga[6] = {
	{ 0x06,   1,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 168,  24,   3,   0,   0, 128,   2,  32 },
	{ 0x05,   0, 152,  16,   3,   0,   0,  88,   5,  40 },
	{ 0x05,   0, 128,   0,   3,   0,   0,   0,  10,  88 },
	{ 0x05,   0, 104,   0,   3,   0,  13,   0,  14,  88 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData35AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData35Amiga), kEoB2IntroAnimData35Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData36Amiga[2] = {
	{ 0x05,   0, 104,   0,   0,   0,  13,   0,  13, 200 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData36AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData36Amiga), kEoB2IntroAnimData36Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData37Amiga[25] = {
	{ 0x03,  17,  36,  48,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   2,   1,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   2,   2,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   2,   3,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   4,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   4,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,  54,   4,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   2,   3,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   2,   2,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   2,   1,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   0,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   0,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   2,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData37AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData37Amiga), kEoB2IntroAnimData37Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData38Amiga[22] = {
	{ 0x03,  22,  13,  32,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   0,   0,   0,   0,   0 },
	{ 0x03,  22,  13,  32,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   1,   0,   0,   0,   0 },
	{ 0x06,  11,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x03,  22,  13,  32,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   2,   0,   0,   0,   0 },
	{ 0x03,  22,  13,  32,   0,   4,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   3,   0,   0,   0,   0 },
	{ 0x03,  22,  13,  32,   0,   4,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,  90,   4,   0,   0,   0,   0 },
	{ 0x03,  22,  13,  32,   0,   4,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   3,   0,   0,   0,   0 },
	{ 0x03,  22,  13,  32,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   2,   0,   0,   0,   0 },
	{ 0x03,  22,  13,  32,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   1,   0,   0,   0,   0 },
	{ 0x03,  22,  13,  32,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   0,   0,   0,   0,   0 },
	{ 0x03,  22,  13,  32,   0,   0,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData38AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData38Amiga), kEoB2IntroAnimData38Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData39Amiga[3] = {
	{ 0x06,   3,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   2,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData39AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData39Amiga), kEoB2IntroAnimData39Amiga };

static const DarkMoonAnimCommand kEoB2IntroAnimData40Amiga[5] = {
	{ 0x06,   5,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData40AmigaProvider = { ARRAYSIZE(kEoB2IntroAnimData40Amiga), kEoB2IntroAnimData40Amiga };

static const DarkMoonShapeDef kEoB2IntroShapes00Amiga[15] = {
	{    0,   1, 137,   4,  43 },
	{    1,   5, 137,   4,  54 },
	{    2,   9, 140,   4,   8 },
	{    3,   1, 181,   1,   3 },
	{    4,   9, 154,   1,   3 },
	{    5,   9, 158,   2,   5 },
	{    6,   9, 164,   3,   7 },
	{    7,   9, 172,   3,  11 },
	{    8,   9, 184,   5,  13 },
	{    9,  15, 137,   6,  15 },
	{   10,  15, 153,   2,  21 },
	{   11,  17, 153,   2,  21 },
	{   12,   1, 185,   1,   4 },
	{   13,   1, 190,   1,   1 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2IntroShapes00AmigaProvider = { ARRAYSIZE(kEoB2IntroShapes00Amiga), kEoB2IntroShapes00Amiga };

static const DarkMoonShapeDef kEoB2IntroShapes01Amiga[2] = {
	{    0,   1, 137,   1,  16 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2IntroShapes01AmigaProvider = { ARRAYSIZE(kEoB2IntroShapes01Amiga), kEoB2IntroShapes01Amiga };

static const DarkMoonShapeDef kEoB2IntroShapes04Amiga[10] = {
	{   15,   2,   0,  32,  14 },
	{   16,   5,  16,   5,   8 },
	{   17,   2,  26,  32,  19 },
	{   18,   0, 140,  35,  10 },
	{   19,  21,  16,   3,   8 },
	{   20,   0,  47,  22,  10 },
	{   21,   0,  59,  31,  10 },
	{   22,   0,  71,  36,  39 },
	{   23,   0, 119,  24,  15 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2IntroShapes04AmigaProvider = { ARRAYSIZE(kEoB2IntroShapes04Amiga), kEoB2IntroShapes04Amiga };

static const DarkMoonShapeDef kEoB2IntroShapes07Amiga[18] = {
	{   -9,   1, 136,   6,  40 },
	{   -1,   7, 136,   6,  40 },
	{   -2,  13, 136,   6,  40 },
	{    3,  19, 136,   2,  16 },
	{    4,  21, 136,   2,  16 },
	{    5,  23, 136,   2,  16 },
	{    6,  19, 152,   1,   8 },
	{    7,  20, 152,   1,   8 },
	{    8,  21, 152,   1,   8 },
	{  -10,  25, 136,   2,  16 },
	{  -11,  27, 136,   2,  16 },
	{  -12,  29, 136,   2,  16 },
	{  -13,  31, 136,   2,  16 },
	{  -14,  25, 152,   2,  16 },
	{  -15,  27, 152,   2,  16 },
	{  -16,  29, 152,   2,  16 },
	{  -17,  31, 152,   2,  16 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2IntroShapes07AmigaProvider = { ARRAYSIZE(kEoB2IntroShapes07Amiga), kEoB2IntroShapes07Amiga };

static const DarkMoonShapeDef kEoB2IntroShapes13Amiga[10] = {
	{   25,   2,   0,  32,  14 },
	{   26,   5,  16,   5,   8 },
	{   27,   2,  26,  32,  19 },
	{   28,   0, 140,  35,  10 },
	{   29,  21,  16,   3,   8 },
	{   30,   0,  47,  22,  10 },
	{   31,   0,  59,  31,  10 },
	{   32,   0,  71,  36,  39 },
	{   33,   0, 119,  24,  15 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2IntroShapes13AmigaProvider = { ARRAYSIZE(kEoB2IntroShapes13Amiga), kEoB2IntroShapes13Amiga };

static const DarkMoonShapeDef kEoB2IntroShapes14Amiga[10] = {
	{   35,   2,   0,  32,  14 },
	{   36,   5,  16,   5,   8 },
	{   37,   2,  26,  32,  19 },
	{   38,   0, 140,  35,  10 },
	{   39,  21,  16,   3,   8 },
	{   40,   0,  47,  22,  10 },
	{   41,   0,  59,  31,  10 },
	{   42,   0,  71,  36,  39 },
	{   43,   0, 119,  24,  15 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2IntroShapes14AmigaProvider = { ARRAYSIZE(kEoB2IntroShapes14Amiga), kEoB2IntroShapes14Amiga };

static const DarkMoonShapeDef kEoB2IntroShapes15Amiga[10] = {
	{   45,   2,   0,  32,  14 },
	{   46,   5,  16,   5,   8 },
	{   47,   2,  26,  32,  19 },
	{   48,   0, 140,  35,  10 },
	{   49,  21,  16,   3,   8 },
	{   50,   0,  47,  22,  10 },
	{   51,   0,  59,  31,  10 },
	{   52,   0,  71,  36,  39 },
	{   53,   0, 119,  24,  15 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2IntroShapes15AmigaProvider = { ARRAYSIZE(kEoB2IntroShapes15Amiga), kEoB2IntroShapes15Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData00Amiga[11] = {
	{ 0x06,   4,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 136,   8,   8,   0,   5, 136,  11,  48 },
	{ 0x02,   1, 136,   8,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0,  80,   8,   0,   0,   0, 136,   5,  40 },
	{ 0x06,   5,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 232,  88,   4,   0,   0,  88,   8,  48 },
	{ 0x02,   3,  80,   8,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 232,  88,   4,   0,   8,  88,   8,  48 },
	{ 0x05,   0, 232,  88,   4,   0,  16,  88,   8,  48 },
	{ 0x02,   2, 232,  88,   4,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData00AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData00Amiga), kEoB2FinaleAnimData00Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData01Amiga[9] = {
	{ 0x06,   4,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 136,   8,  12,   0,   5, 136,  11,  48 },
	{ 0x02,   1, 136,   8,   0,   0,   0,   0,   0,   0 },
	{ 0x06,   5,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 232,  88,   6,   0,   0,  88,   8,  48 },
	{ 0x05,   0, 232,  88,   6,   0,   8,  88,   8,  48 },
	{ 0x05,   0, 232,  88,   6,   0,  16,  88,   8,  48 },
	{ 0x02,   2, 232,  88,   6,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData01AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData01Amiga), kEoB2FinaleAnimData01Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData02Amiga[4] = {
	{ 0x05,   0, 232, 112,   6,   0,  24, 176,   3,  16 },
	{ 0x05,   0, 232, 112,   6,   0,  27, 176,   3,  16 },
	{ 0x05,   0, 232, 112,   6,   0,  30, 176,   3,  16 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData02AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData02Amiga), kEoB2FinaleAnimData02Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData03Amiga[6] = {
	{ 0x05,   0,  80,   8,   0,   0,   0, 136,   5,  40 },
	{ 0x05,   0, 232, 112,   3,   0,  24, 176,   3,  16 },
	{ 0x02,   3,  80,   8,   3,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 232, 112,   3,   0,  27, 176,   3,  16 },
	{ 0x05,   0, 232, 112,   3,   0,  30, 176,   3,  16 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData03AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData03Amiga), kEoB2FinaleAnimData03Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData04Amiga[8] = {
	{ 0x06,   6,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 104,  40,   3,   0,  32,  88,   8,  88 },
	{ 0x05,   0, 104,  40,   3,   0,  32,   0,   8,  88 },
	{ 0x05,   0, 104,  40,   3,   0,  24,   0,   8,  88 },
	{ 0x05,   0, 104,  40,   3,   0,  16,   0,   8,  88 },
	{ 0x05,   0, 104,  40,   3,   0,   0,   0,   8,  88 },
	{ 0x05,   0, 104,  40,   3,   0,  24,  88,   8,  88 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData04AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData04Amiga), kEoB2FinaleAnimData04Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData05Amiga[7] = {
	{ 0x05,   0, 232, 112,   0,   0,  24, 176,   3,  16 },
	{ 0x05,   0, 128,  40,   4,   0,  33, 176,   2,  16 },
	{ 0x05,   0, 232, 112,   0,   0,  27, 176,   3,  16 },
	{ 0x05,   0, 128,  40,   4,   0,  35, 176,   2,  16 },
	{ 0x05,   0, 232, 112,   0,   0,  30, 176,   3,  16 },
	{ 0x05,   0, 128,  40,   4,   0,  37, 176,   2,  16 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData05AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData05Amiga), kEoB2FinaleAnimData05Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData06Amiga[2] = {
	{ 0x05,   0, 104,  40,   0,   0,  16, 136,   8,  48 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData06AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData06Amiga), kEoB2FinaleAnimData06Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData07Amiga[6] = {
	{ 0x05,   0, 208,  80,   4,   0,   0, 128,   6,  56 },
	{ 0x05,   0, 208,  80,   4,   0,   6, 128,   6,  56 },
	{ 0x05,   0, 208,  80,   4,   0,  12, 128,   6,  56 },
	{ 0x05,   0, 208,  80,   4,   0,  18, 128,   6,  56 },
	{ 0x05,   0, 208,  80,   4,   0,  24, 128,   6,  56 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData07AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData07Amiga), kEoB2FinaleAnimData07Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData08Amiga[3] = {
	{ 0x05,   0, 224,  56,   3,   0,   0, 184,   4,  16 },
	{ 0x05,   0, 224,  56,   0,   0,   4, 184,   4,  16 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData08AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData08Amiga), kEoB2FinaleAnimData08Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData09Amiga[8] = {
	{ 0x01,   1, -10,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   1,   0,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   1,  10,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   1,  20,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   1,  30,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   1,  40,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x02,   2,  48,  40,   2,   0,   0,   0,   0,   0 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData09AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData09Amiga), kEoB2FinaleAnimData09Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData10Amiga[14] = {
	{ 0x05,   1,   8,  40,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  24, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  12,  80,   1,  16 },
	{ 0x05,   1,   8,  40,   0,   0,  32,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  28, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  13,  80,   1,  16 },
	{ 0x05,   1,   8,  40,   0,   0,  24,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  32, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  14,  80,   1,  16 },
	{ 0x06,   8,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  12, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 128,  12,  24 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData10AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData10Amiga), kEoB2FinaleAnimData10Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData11Amiga[18] = {
	{ 0x05,   1,  40,  32,   0,   0,  16,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  18, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   0,   0,   0, 152,  12,  24 },
	{ 0x05,   1,   8,  40,   0,   0,  24,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  32, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   0,   0,  14,  80,   1,  16 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x05,   1,   8,  40,   0,   0,  24,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  32, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  14,  80,   1,  16 },
	{ 0x05,   1,   8,  40,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  24, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  12,  80,   1,  16 },
	{ 0x05,   1,   8,  40,   0,   0,  16,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  36, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  15,  80,   1,  16 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData11AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData11Amiga), kEoB2FinaleAnimData11Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData12Amiga[23] = {
	{ 0x05,   1,  40,  32,   0,   0,  16,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  18, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   0,   0,   0, 152,  12,  24 },
	{ 0x05,   1,   8,  40,   0,   0,  24,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  32, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   0,   0,  14,  80,   1,  16 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,   8,  40,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  24, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  12,  80,   1,  16 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,   8,  40,   0,   0,  16,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  36, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  15,  80,   1,  16 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData12AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData12Amiga), kEoB2FinaleAnimData12Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData13Amiga[23] = {
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x06,   9,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   0, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0,  80,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,  16,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   6, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 104,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  12, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 128,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData13AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData13Amiga), kEoB2FinaleAnimData13Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData14Amiga[24] = {
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x06,   9,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   0, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0,  80,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,  16,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   6, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 104,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x06,   9,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  12, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 128,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData14AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData14Amiga), kEoB2FinaleAnimData14Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData15Amiga[19] = {
	{ 0x05,   1,  40,  32,   0,   0,   0,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   0, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0,  80,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,  16,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   6, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 104,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,   9,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  12, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 128,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData15AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData15Amiga), kEoB2FinaleAnimData15Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData16Amiga[13] = {
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 168,  16,   3,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 168,  16,   3,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 168,  16,   3,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData16AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData16Amiga), kEoB2FinaleAnimData16Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData17Amiga[20] = {
	{ 0x05,   0, 168,  16,   1,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x06,  10,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 168,  16,   3,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,   0,  16,  80 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData17AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData17Amiga), kEoB2FinaleAnimData17Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData18Amiga[28] = {
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   0,   0,  16,  80,  16,  80 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData18AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData18Amiga), kEoB2FinaleAnimData18Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData19Amiga[7] = {
	{ 0x05,   0,  80,  80,   4,   0,   0, 128,   6,  56 },
	{ 0x05,   0,  80,  80,   4,   0,   6, 128,   6,  56 },
	{ 0x05,   0,  80,  80,   4,   0,  12, 128,   6,  56 },
	{ 0x05,   0,  80,  80,   4,   0,  18, 128,   6,  56 },
	{ 0x05,   0,  80,  80,   4,   0,  24, 128,   6,  56 },
	{ 0x05,   0,  80,  80,   4,   0,  30, 128,   6,  56 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData19AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData19Amiga), kEoB2FinaleAnimData19Amiga };

static const DarkMoonAnimCommand kEoB2FinaleAnimData20Amiga[3] = {
	{ 0x05,   0,  96,  56,   3,   0,   0, 184,   4,  16 },
	{ 0x05,   0,  96,  56,   0,   0,   4, 184,   4,  16 },
	{ 0xff,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData20AmigaProvider = { ARRAYSIZE(kEoB2FinaleAnimData20Amiga), kEoB2FinaleAnimData20Amiga };

static const DarkMoonShapeDef kEoB2FinaleShapes00Amiga[4] = {
	{   -1,  16,   0,  11,  48 },
	{   -2,  28,  80,   8,  48 },
	{   -3,   9,   0,   5,  40 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2FinaleShapes00AmigaProvider = { ARRAYSIZE(kEoB2FinaleShapes00Amiga), kEoB2FinaleShapes00Amiga };

static const DarkMoonShapeDef kEoB2FinaleShapes03Amiga[3] = {
	{   -1,  30,   0,   8,  96 },
	{   -2,  30, 104,  10,  96 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2FinaleShapes03AmigaProvider = { ARRAYSIZE(kEoB2FinaleShapes03Amiga), kEoB2FinaleShapes03Amiga };

static const DarkMoonShapeDef kEoB2FinaleShapes07Amiga[4] = {
	{    1,   0,   0,  16,  72 },
	{    2,  16,   0,  16,  72 },
	{    3,   0,  72,  16,  72 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2FinaleShapes07AmigaProvider = { ARRAYSIZE(kEoB2FinaleShapes07Amiga), kEoB2FinaleShapes07Amiga };

static const DarkMoonShapeDef kEoB2FinaleShapes09Amiga[9] = {
	{    0,   0,   0,  32,  16 },
	{    2,   0,  36,  35,  41 },
	{    3,   0,  77,  24,  17 },
	{    4,   0,  94,  15,  33 },
	{    5,  24,  77,  10,  17 },
	{    6,  16,  99,  23,  69 },
	{  -10,   0, 136,   8,  64 },
	{  -11,   8, 136,   8,  64 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2FinaleShapes09AmigaProvider = { ARRAYSIZE(kEoB2FinaleShapes09Amiga), kEoB2FinaleShapes09Amiga };

static const DarkMoonShapeDef kEoB2FinaleShapes10Amiga[4] = {
	{    1,   0,   0,  40,  30 },
	{   15,   9,  37,  21,  48 },
	{   16,  16,  88,   6,  56 },
	{    0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2FinaleShapes10AmigaProvider = { ARRAYSIZE(kEoB2FinaleShapes10Amiga), kEoB2FinaleShapes10Amiga };

static const byte kEoB2NpcShapeDataAmiga[24] = {
	0x00, 0x00, 0x00, 0x05, 0x39, 0x00, 0x00, 0xff,
	0x00, 0x00, 0x64, 0x05, 0x4f, 0x00, 0x00, 0xff,
	0x00, 0x00, 0x39, 0x06, 0x2b, 0x00, 0x00, 0xff
};

static const ByteProvider kEoB2NpcShapeDataAmigaProvider = { ARRAYSIZE(kEoB2NpcShapeDataAmiga), kEoB2NpcShapeDataAmiga };

static const byte kEoB2ClassModifierFlagsAmiga[15] = {
	0x01, 0x20, 0x10, 0x02, 0x04, 0x08, 0x05, 0x09,
	0x03, 0x0B, 0x0A, 0x0C, 0x07, 0x05, 0x06
};

static const ByteProvider kEoB2ClassModifierFlagsAmigaProvider = { ARRAYSIZE(kEoB2ClassModifierFlagsAmiga), kEoB2ClassModifierFlagsAmiga };

static const byte kEoB2MonsterStepTable02Amiga[8] = {
	0xE0, 0xE1, 0x01, 0x21, 0x20, 0x1F, 0xFF, 0xDF
};

static const ByteProvider kEoB2MonsterStepTable02AmigaProvider = { ARRAYSIZE(kEoB2MonsterStepTable02Amiga), kEoB2MonsterStepTable02Amiga };

static const byte kEoB2MonsterStepTable1Amiga[16] = {
	0x01, 0xE0, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00,
	0x00, 0x00, 0xFF, 0x20, 0xFF, 0x00, 0x00, 0xE0
};

static const ByteProvider kEoB2MonsterStepTable1AmigaProvider = { ARRAYSIZE(kEoB2MonsterStepTable1Amiga), kEoB2MonsterStepTable1Amiga };

static const byte kEoB2MonsterStepTable2Amiga[8] = {
	0x07, 0xFA, 0x05, 0xFC, 0x03, 0xFE, 0x01, 0x00
};

static const ByteProvider kEoB2MonsterStepTable2AmigaProvider = { ARRAYSIZE(kEoB2MonsterStepTable2Amiga), kEoB2MonsterStepTable2Amiga };

static const byte kEoB2MonsterStepTable3Amiga[8] = {
	0xF9, 0x06, 0xFB, 0x04, 0xFD, 0x02, 0xFF, 0x00
};

static const ByteProvider kEoB2MonsterStepTable3AmigaProvider = { ARRAYSIZE(kEoB2MonsterStepTable3Amiga), kEoB2MonsterStepTable3Amiga };

static const byte kEoB2MonsterCloseAttPosTable1Amiga[4] = {
	0x00, 0x01, 0x03, 0x02
};

static const ByteProvider kEoB2MonsterCloseAttPosTable1AmigaProvider = { ARRAYSIZE(kEoB2MonsterCloseAttPosTable1Amiga), kEoB2MonsterCloseAttPosTable1Amiga };

static const byte kEoB2MonsterCloseAttPosTable22Amiga[16] = {
	0x00, 0x01, 0x02, 0x03, 0x00, 0x02, 0x01, 0x03,
	0x00, 0x01, 0x02, 0x03, 0x03, 0x01, 0x02, 0x00
};

static const ByteProvider kEoB2MonsterCloseAttPosTable22AmigaProvider = { ARRAYSIZE(kEoB2MonsterCloseAttPosTable22Amiga), kEoB2MonsterCloseAttPosTable22Amiga };

static const byte kEoB2MonsterCloseAttUnkTableAmiga[10] = {
	0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x00
};

static const ByteProvider kEoB2MonsterCloseAttUnkTableAmigaProvider = { ARRAYSIZE(kEoB2MonsterCloseAttUnkTableAmiga), kEoB2MonsterCloseAttUnkTableAmiga };

static const byte kEoB2MonsterCloseAttChkTable1Amiga[16] = {
	0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00
};

static const ByteProvider kEoB2MonsterCloseAttChkTable1AmigaProvider = { ARRAYSIZE(kEoB2MonsterCloseAttChkTable1Amiga), kEoB2MonsterCloseAttChkTable1Amiga };

static const byte kEoB2MonsterCloseAttChkTable2Amiga[16] = {
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00
};

static const ByteProvider kEoB2MonsterCloseAttChkTable2AmigaProvider = { ARRAYSIZE(kEoB2MonsterCloseAttChkTable2Amiga), kEoB2MonsterCloseAttChkTable2Amiga };

static const byte kEoB2MonsterCloseAttDstTable1Amiga[16] = {
	0x02, 0x03, 0x00, 0x01, 0x01, 0x02, 0x03, 0x00,
	0x00, 0x01, 0x02, 0x03, 0x03, 0x00, 0x01, 0x02
};

static const ByteProvider kEoB2MonsterCloseAttDstTable1AmigaProvider = { ARRAYSIZE(kEoB2MonsterCloseAttDstTable1Amiga), kEoB2MonsterCloseAttDstTable1Amiga };

static const byte kEoB2MonsterCloseAttDstTable2Amiga[48] = {
	0x01, 0x00, 0x03, 0x02, 0x05, 0x04, 0x00, 0x01,
	0x02, 0x03, 0x04, 0x05, 0x05, 0x03, 0x01, 0x04,
	0x02, 0x00, 0x01, 0x03, 0x05, 0x00, 0x02, 0x04,
	0x04, 0x05, 0x02, 0x03, 0x00, 0x01, 0x05, 0x04,
	0x03, 0x02, 0x01, 0x00, 0x00, 0x02, 0x04, 0x01,
	0x03, 0x05, 0x04, 0x02, 0x00, 0x05, 0x03, 0x01
};

static const ByteProvider kEoB2MonsterCloseAttDstTable2AmigaProvider = { ARRAYSIZE(kEoB2MonsterCloseAttDstTable2Amiga), kEoB2MonsterCloseAttDstTable2Amiga };

static const byte kEoB2MonsterProximityTableAmiga[32] = {
	0x02, 0x03, 0x00, 0x01, 0x03, 0x02, 0x01, 0x00,
	0x00, 0x02, 0x01, 0x03, 0x02, 0x00, 0x03, 0x01,
	0x01, 0x00, 0x03, 0x02, 0x00, 0x01, 0x02, 0x03,
	0x03, 0x01, 0x00, 0x02, 0x01, 0x03, 0x02, 0x00
};

static const ByteProvider kEoB2MonsterProximityTableAmigaProvider = { ARRAYSIZE(kEoB2MonsterProximityTableAmiga), kEoB2MonsterProximityTableAmiga };

static const byte kEoB2FindBlockMonstersTableAmiga[64] = {
	0x04, 0x02, 0x01, 0x03, 0x04, 0x03, 0x00, 0x02,
	0x04, 0x00, 0x03, 0x01, 0x04, 0x01, 0x02, 0x00,
	0x04, 0x01, 0x02, 0x03, 0x04, 0x00, 0x03, 0x02,
	0x04, 0x03, 0x00, 0x01, 0x04, 0x02, 0x01, 0x00,
	0x04, 0x02, 0x01, 0x03, 0x04, 0x03, 0x00, 0x02,
	0x04, 0x00, 0x03, 0x01, 0x04, 0x01, 0x02, 0x00,
	0x04, 0x01, 0x02, 0x03, 0x04, 0x00, 0x03, 0x02,
	0x04, 0x03, 0x00, 0x01, 0x04, 0x02, 0x01, 0x00
};

static const ByteProvider kEoB2FindBlockMonstersTableAmigaProvider = { ARRAYSIZE(kEoB2FindBlockMonstersTableAmiga), kEoB2FindBlockMonstersTableAmiga };

static const byte kEoB2MonsterDirChangeTableAmiga[16] = {
	0xff, 0x06, 0x02, 0xff, 0x00, 0x07, 0x01, 0xff,
	0x04, 0x05, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff
};

static const ByteProvider kEoB2MonsterDirChangeTableAmigaProvider = { ARRAYSIZE(kEoB2MonsterDirChangeTableAmiga), kEoB2MonsterDirChangeTableAmiga };

static const uint16 kEoB2EncodeMonsterDefsAmiga[72] = {
	0x0000, 0x0000, 0x0007, 0x0060, 0x0007, 0x0028, 0x000c, 0x0038,
	0x0013, 0x0028, 0x000c, 0x0038, 0x001f, 0x0000, 0x0007, 0x0060,
	0x0000, 0x0060, 0x0007, 0x0060, 0x0007, 0x0060, 0x0007, 0x0060,
	0x0000, 0x0000, 0x0007, 0x0060, 0x0007, 0x0000, 0x0007, 0x0060,
	0x000e, 0x0000, 0x0007, 0x0060, 0x0015, 0x0000, 0x0007, 0x0060,
	0x001c, 0x0000, 0x0007, 0x0060, 0x0000, 0x0060, 0x0007, 0x0060,
	0x0000, 0x0000, 0x000a, 0x0058, 0x000a, 0x0000, 0x000a, 0x0058,
	0x0014, 0x0000, 0x000a, 0x0058, 0x001e, 0x0000, 0x000a, 0x0058,
	0x0000, 0x0058, 0x000a, 0x0058, 0x000a, 0x0058, 0x000a, 0x0058
};

static const Uint16Provider kEoB2EncodeMonsterDefsAmigaProvider = { ARRAYSIZE(kEoB2EncodeMonsterDefsAmiga), kEoB2EncodeMonsterDefsAmiga };

static const EoBCharacter kEoB2NpcPresetsAmiga[6] = {
	{ 0x00, 0x01, "Insal",
	  15, 15,  0,  0, 13, 13, 11, 11, 17, 17, 16, 16,  9,  9,
	     3,   39, 10, 0, 10, 5, 5, -1, 8, { 6, 0, 0 },
	  { 0x00006ADA, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Calandra",
	  18, 18, 36, 36, 13, 13,  8,  8, 15, 15, 16, 16, 14, 14,
	     4,   76, 10, 0, 1, 0, 2, -2, 12, { 9, 0, 0 },
	  { 0x0003DF35, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Shorn",
	  15, 15,  0,  0, 14, 14, 13, 13, 14, 14, 13, 13, 16, 16,
	    40,   40, 10, 0, 6, 4, 3, -3, 100, { 8, 0, 0 },
	  { 0x00021730, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "San-raal",
	  11, 11,  0,  0, 18, 18, 13, 13, 14, 14, 16, 16,  9,  9,
	    28,   28, 10, 0, 2, 3, 5, -4, 100, { 8, 0, 0 },
	  { 0x00017AF0, 0x00000000, 0x00000000 }, 0x096B4566,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Tanglor",
	  16, 16,  0,  0, 13, 13, 16, 16, 15, 15, 11, 11, 12, 12,
	    53,   53,  9, 0, 4, 6, 1, -5, 100, { 7, 7, 0 },
	  { 0x00010FC2, 0x00010FC2, 0x00000000 }, 0xFFFFFFFF,
	  { 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0024, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Amber",
	  14, 14,  0,  0, 17, 17, 12, 12, 18, 18,  9,  9, 17, 17,
	    36,   36, 10, 0, 3, 10, 1, -6, 100, { 7, 7, 0 },
	  { 0x0000FAE6, 0x0000FAE6, 0x00000000 }, 0x00294566,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } }
};

static const EoBCharacterProvider kEoB2NpcPresetsAmigaProvider = { ARRAYSIZE(kEoB2NpcPresetsAmiga), kEoB2NpcPresetsAmiga };

static const byte kEoB2DreamStepsAmiga[14] = {
	0x01, 0x02, 0x03, 0x02, 0x01, 0x00, 0x01, 0x02,
	0x03, 0x03, 0x02, 0x01, 0x00, 0xFF
};

static const ByteProvider kEoB2DreamStepsAmigaProvider = { ARRAYSIZE(kEoB2DreamStepsAmiga), kEoB2DreamStepsAmiga };

static const byte kEoB2HornSoundsAmiga[4] = {
	0x40, 0x41, 0x42, 0x43
};

static const ByteProvider kEoB2HornSoundsAmigaProvider = { ARRAYSIZE(kEoB2HornSoundsAmiga), kEoB2HornSoundsAmiga };

static const uint16 kEoB2WallOfForceDsXAmiga[18] = {
	0xFFCC, 0xFFF4, 0x001C, 0x0044, 0x006C, 0x0094, 0x00BC, 0xFFB8,
	0xFFF8, 0x0038, 0x0078, 0x00B8, 0xFFC8, 0x0028, 0x0088, 0x0000,
	0x0000, 0x0000
};

static const Uint16Provider kEoB2WallOfForceDsXAmigaProvider = { ARRAYSIZE(kEoB2WallOfForceDsXAmiga), kEoB2WallOfForceDsXAmiga };

static const byte kEoB2WallOfForceDsYAmiga[3] = {
	0x20, 0x18, 0x10
};

static const ByteProvider kEoB2WallOfForceDsYAmigaProvider = { ARRAYSIZE(kEoB2WallOfForceDsYAmiga), kEoB2WallOfForceDsYAmiga };

static const byte kEoB2WallOfForceNumWAmiga[3] = {
	0x01, 0x02, 0x03
};

static const ByteProvider kEoB2WallOfForceNumWAmigaProvider = { ARRAYSIZE(kEoB2WallOfForceNumWAmiga), kEoB2WallOfForceNumWAmiga };

static const byte kEoB2WallOfForceNumHAmiga[3] = {
	0x02, 0x06, 0x09
};

static const ByteProvider kEoB2WallOfForceNumHAmigaProvider = { ARRAYSIZE(kEoB2WallOfForceNumHAmiga), kEoB2WallOfForceNumHAmiga };

static const byte kEoB2WallOfForceShpIdAmiga[3] = {
	0x04, 0x02, 0x00
};

static const ByteProvider kEoB2WallOfForceShpIdAmigaProvider = { ARRAYSIZE(kEoB2WallOfForceShpIdAmiga), kEoB2WallOfForceShpIdAmiga };

static const byte kEoB2DscShapeIndexAmiga[36] = {
	0x01, 0x01, 0x04, 0x0A, 0x04, 0x08, 0x04, 0x01,
	0x04, 0xF8, 0x04, 0xF6, 0x00, 0x00, 0x03, 0x09,
	0x03, 0x07, 0x03, 0x01, 0x03, 0xF9, 0x03, 0xF7,
	0x02, 0x06, 0x02, 0x01, 0x02, 0xFA, 0x01, 0x05,
	0x01, 0x01, 0x01, 0xFB
};

static const ByteProvider kEoB2DscShapeIndexAmigaProvider = { ARRAYSIZE(kEoB2DscShapeIndexAmiga), kEoB2DscShapeIndexAmiga };

static const uint16 kEoB2DscXAmiga[18] = {
	0xFF70, 0xFFA0, 0xFFD0, 0x0000, 0x0030, 0x0060, 0x0090, 0xFF60,
	0xFFB0, 0x0000, 0x0050, 0x00A0, 0xFF80, 0x0000, 0x0080, 0x0000,
	0x0000, 0x0000
};

static const Uint16Provider kEoB2DscXAmigaProvider = { ARRAYSIZE(kEoB2DscXAmiga), kEoB2DscXAmiga };

static const byte kEoB2DscTileIndexAmiga[18] = {
	0x00, 0x06, 0x01, 0x05, 0x02, 0x04, 0x03, 0x07,
	0x0B, 0x08, 0x0A, 0x09, 0x0C, 0x0E, 0x0D, 0x0F,
	0x11, 0x10
};

static const ByteProvider kEoB2DscTileIndexAmigaProvider = { ARRAYSIZE(kEoB2DscTileIndexAmiga), kEoB2DscTileIndexAmiga };

static const byte kEoB2DscDimData1Amiga[324] = {
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd8, 0xd7, 0xd8, 0xd8, 0x02, 0xd8, 0xd8, 0xd8,
	0xd8, 0xfe, 0xd7, 0xd8, 0xd8, 0xd8, 0xd7, 0x03,
	0xd8, 0xfd, 0xd8, 0xd8, 0xd8, 0xfe, 0xd8, 0x08,
	0xd8, 0xd8, 0xd8, 0xfe, 0xd7, 0x06, 0xd8, 0xd8,
	0xfa, 0x03, 0xd8, 0xfd, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xfa, 0xd7,
	0x10, 0xd8, 0xfd, 0xd7, 0x13, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xf2, 0xd8, 0x14, 0xd8, 0xd8,
	0xd8, 0xf0, 0xd7, 0x14, 0xd8, 0xed, 0x10, 0xd8,
	0xd8, 0x13, 0xd8, 0xd8, 0xd8, 0xd8, 0xec, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd7, 0x14, 0xd8, 0xed,
	0xd7, 0xd8, 0xd8, 0x13, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd8, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd8, 0xd7,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0x06, 0xd8, 0xd8, 0xfa, 0x03, 0xd8, 0xfd,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xfa, 0xd8, 0x10, 0xd8, 0xfd, 0xd7,
	0x13, 0xfd, 0xd8, 0x13, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xf0, 0xd8, 0xd8,
	0xd8, 0xed, 0x10, 0xd8, 0xd8, 0x13, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd8, 0xd7,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0x03, 0xd8, 0xfd,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xfd, 0xd8,
	0x13, 0xfd, 0xd8, 0x13, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xed, 0xd8, 0xd8, 0xd8, 0x13, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8
};

static const ByteProvider kEoB2DscDimData1AmigaProvider = { ARRAYSIZE(kEoB2DscDimData1Amiga), kEoB2DscDimData1Amiga };

static const byte kEoB2DscDimData2Amiga[648] = {
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x00, 0x16, 0x16, 0x00, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x02, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x02, 0x16, 0x00, 0x04, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x16, 0x00, 0x00, 0x03,
	0x00, 0x16, 0x03, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x02, 0x16, 0x00, 0x16, 0x00, 0x08,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x02,
	0x16, 0x00, 0x00, 0x06, 0x00, 0x16, 0x00, 0x16,
	0x06, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x06, 0x16, 0x08, 0x0e,
	0x00, 0x10, 0x00, 0x16, 0x03, 0x16, 0x06, 0x10,
	0x00, 0x13, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x0e, 0x16,
	0x00, 0x16, 0x00, 0x14, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x10, 0x16, 0x16, 0x00, 0x00, 0x14,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x10, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x14, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x12, 0x16, 0x14, 0x16, 0x00, 0x16, 0x13, 0x16,
	0x16, 0x00, 0x00, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x00, 0x16, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x06, 0x00, 0x16, 0x00, 0x16,
	0x06, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x06, 0x16, 0x00, 0x16,
	0x00, 0x10, 0x00, 0x16, 0x03, 0x16, 0x07, 0x0f,
	0x00, 0x13, 0x03, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x10, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x10, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x03, 0x16, 0x00, 0x16,
	0x00, 0x13, 0x03, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16
};

static const ByteProvider kEoB2DscDimData2AmigaProvider = { ARRAYSIZE(kEoB2DscDimData2Amiga), kEoB2DscDimData2Amiga };

static const byte kEoB2DscBlockMapAmiga[12] = {
	0x02, 0x03, 0x00, 0x01, 0x01, 0x02, 0x03, 0x00,
	0x03, 0x00, 0x01, 0x02
};

static const ByteProvider kEoB2DscBlockMapAmigaProvider = { ARRAYSIZE(kEoB2DscBlockMapAmiga), kEoB2DscBlockMapAmiga };

static const byte kEoB2DscDimMapAmiga[18] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03,
	0x03, 0x03
};

static const ByteProvider kEoB2DscDimMapAmigaProvider = { ARRAYSIZE(kEoB2DscDimMapAmiga), kEoB2DscDimMapAmiga };

static const byte kEoB2DscBlockIndexAmiga[72] = {
	0x9d, 0x9e, 0x9f, 0xa0, 0xa1, 0xa2, 0xa3, 0xbe,
	0xbf, 0xc0, 0xc1, 0xc2, 0xdf, 0xe0, 0xe1, 0xff,
	0x00, 0x01, 0xa3, 0xc3, 0xe3, 0x03, 0x23, 0x43,
	0x63, 0xc2, 0xe2, 0x02, 0x22, 0x42, 0xe1, 0x01,
	0x21, 0xe0, 0x00, 0x20, 0x63, 0x62, 0x61, 0x60,
	0x5f, 0x5e, 0x5d, 0x42, 0x41, 0x40, 0x3f, 0x3e,
	0x21, 0x20, 0x1f, 0x01, 0x00, 0xff, 0x5d, 0x3d,
	0x1d, 0xfd, 0xdd, 0xbd, 0x9d, 0x3e, 0x1e, 0xfe,
	0xde, 0xbe, 0x1f, 0xff, 0xdf, 0x20, 0x00, 0xe0
};

static const ByteProvider kEoB2DscBlockIndexAmigaProvider = { ARRAYSIZE(kEoB2DscBlockIndexAmiga), kEoB2DscBlockIndexAmiga };

static const char *const kEoB2SoundMapAmiga[120] = {
	"",
	"button",
	"",
	"door",
	"door",
	"slam",
	"button",
	"button",
	"",
	"eat",
	"magica",
	"throw",
	"plate",
	"passage",
	"unlock",
	"teleport",
	"undead",
	"pit",
	"itemland",
	"",
	"",
	"playhit",
	"death",
	"text",
	"electric",
	"transmute",
	"dart",
	"",
	"",
	"bump",
	"",
	"electric",
	"playswing",
	"",
	"panel",
	"explode",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"magicb",
	"magicb",
	"magicb",
	"magicb",
	"magicb",
	"magicb",
	"magicb",
	"magicb",
	"button",
	"",
	"drop",
	"text",
	"magicb",
	"lock",
	"",
	"magicb",
	"magicb",
	"Missile",
	"",
	"burnhands",
	"electric",
	"fireball",
	"",
	"magica",
	"magica",
	"magica",
	"magicb",
	"magicb",
	"acid",
	"magicb",
	"fireball",
	"acid",
	"magica",
	"magicb",
	"magicb",
	"undead",
	"magica",
	"magica",
	"magica",
	"magicb",
	"cause",
	"magicb",
	"magicb",
	"magica",
	"magicb",
	"magica",
	"magica",
	"magica",
	"magica",
	"cause",
	"fireball",
	"magica"
};

static const StringListProvider kEoB2SoundMapAmigaProvider = { ARRAYSIZE(kEoB2SoundMapAmiga), kEoB2SoundMapAmiga };

static const char *const kEoB2SoundMapExtraAmiga[63] = {
	"",
	"2Guards",
	"Calandra",
	"Dream",
	"Dwarf",
	"GrdInsal",
	"Insal",
	"x",
	"Kheban",
	"",
	"OldLady",
	"MagicMth",
	"Castle1",
	"BdrTrick",
	"",
	"2Cleric",
	"Calandra",
	"1Cleric",
	"MagicMth",
	"MagicMth",
	"2Clerics",
	"4WindDr",
	"x",
	"BloodDr",
	"",
	"Beholder",
	"BdrTrick",
	"MagicMth",
	"DranSilv",
	"MagicMth",
	"1Cleric",
	"Mantis2",
	"Priest",
	"Kheban",
	"Tanglor1",
	"Tanglor2",
	"",
	"MagicMth",
	"MagicMth",
	"Dran1Azr",
	"x",
	"x",
	"FrostGt",
	"FrostDed",
	"Dran2Azr",
	"Dran3Azr",
	"BdrTrick",
	"x",
	"MagicMth",
	"",
	"Dran1Crm",
	"Dran2Crm",
	"Dran3Crm",
	"Dran4Crm",
	"DranDrag",
	"EndTheme",
	"DyingMan",
	"Insal",
	"Ojel",
	"StoneGt",
	"Implode",
	"x",
	""
};

static const StringListProvider kEoB2SoundMapExtraAmigaProvider = { ARRAYSIZE(kEoB2SoundMapExtraAmiga), kEoB2SoundMapExtraAmiga };

static const byte kEoB2SoundIndex1Amiga[98] = {
	0xff, 0x01, 0xfd, 0x07, 0xfd, 0x04, 0xfe, 0x0a,
	0xfe, 0xff, 0x01, 0xfd, 0x07, 0x08, 0xff, 0x03,
	0x05, 0x09, 0x0b, 0x04, 0xfe, 0x0a, 0xfe, 0xff,
	0x00, 0xfd, 0x0c, 0xfd, 0xff, 0x01, 0xfd, 0x0d,
	0xfd, 0xff, 0x01, 0xfd, 0x08, 0xfd, 0xff, 0x06,
	0xfe, 0x07, 0xfe, 0x05, 0xfe, 0x0e, 0xfe, 0xff,
	0x05, 0xfe, 0x0f, 0xfe, 0xff, 0xfe, 0xfe, 0x0d,
	0xfe, 0xff, 0xff, 0x00, 0xfd, 0x0d, 0x0c, 0x00,
	0xfe, 0x0b, 0xfe, 0xff, 0x00, 0xfe, 0x0b, 0xfe,
	0xff, 0xfe, 0x01, 0x0b, 0x0d, 0xff, 0x02, 0xfd,
	0x10, 0xfd, 0xff, 0x00, 0x01, 0x11, 0xfe, 0xff,
	0x00, 0x01, 0x0e, 0x12, 0x02, 0x01, 0x11, 0xfe,
	0xff, 0x00
};

static const ByteProvider kEoB2SoundIndex1AmigaProvider = { ARRAYSIZE(kEoB2SoundIndex1Amiga), kEoB2SoundIndex1Amiga };

static const byte kEoB2SoundIndex2Amiga[17] = {
	0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x03,
	0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05,
	0x05
};

static const ByteProvider kEoB2SoundIndex2AmigaProvider = { ARRAYSIZE(kEoB2SoundIndex2Amiga), kEoB2SoundIndex2Amiga };

static const char *const kEoB2SoundFilesIngame2Amiga[6] = {
	"DUNG.OUT",
	"FOREST.OUT",
	"MEZZ.OUT",
	"SILVER.OUT",
	"AZURE.OUT",
	"CRIMSON.OUT"
};

static const StringListProvider kEoB2SoundFilesIngame2AmigaProvider = { ARRAYSIZE(kEoB2SoundFilesIngame2Amiga), kEoB2SoundFilesIngame2Amiga };

static const char *const kEoB2LevelSoundFiles1Amiga[19] = {
	"Move",
	"Move2",
	"Move3",
	"LeechMov",
	"SpiderMov",
	"Flap",
	"MantisMov",
	"Blade",
	"FlindAtk",
	"Rustatk",
	"SloshSuck",
	"Claw",
	"BeastAtk",
	"Magick",
	"Spear",
	"Growl",
	"Punch",
	"HoundAtk",
	"FlayerAtk"
};

static const StringListProvider kEoB2LevelSoundFiles1AmigaProvider = { ARRAYSIZE(kEoB2LevelSoundFiles1Amiga), kEoB2LevelSoundFiles1Amiga };

static const char *const kEoB2LevelSoundFiles2Amiga[19] = {
	"Walk1m",
	"Walk2m",
	"Walk3m",
	"Leechm",
	"Spiderm",
	"Flapm",
	"Mantism",
	"Blade",
	"Flind",
	"Rust",
	"Slosh",
	"Claw",
	"Beast",
	"Magick",
	"Spear",
	"Growl",
	"Punch",
	"Hound",
	"Flayer"
};

static const StringListProvider kEoB2LevelSoundFiles2AmigaProvider = { ARRAYSIZE(kEoB2LevelSoundFiles2Amiga), kEoB2LevelSoundFiles2Amiga };

static const char *const kEoB2SoundFilesIntroAmiga[10] = {
	"TELEPORT.CPS",
	"BIGPIPE3A.CPS",
	"PANFLUTE5.CPS",
	"OUTTAKES1.CPS",
	"OUTTAKES2.CPS",
	"FIN.SAM",
	"INTRO.SAM",
	"FLUTE3C.CPS",
	"CHARGEN2.CPS",
	"CHARGEN3.CPS"
};

static const StringListProvider kEoB2SoundFilesIntroAmigaProvider = { ARRAYSIZE(kEoB2SoundFilesIntroAmiga), kEoB2SoundFilesIntroAmiga };

static const char *const kEoB2SoundFilesIngameAmiga[7] = {
	"OUTTAKES1.CPS",
	"OUTTAKES2.CPS",
	"SFX1.CPS",
	"SFX2.CPS",
	"SFX3.CPS",
	"SFX4.CPS",
	"OUTTAKES3.CPS"
};

static const StringListProvider kEoB2SoundFilesIngameAmigaProvider = { ARRAYSIZE(kEoB2SoundFilesIngameAmiga), kEoB2SoundFilesIngameAmiga };

static const char *const kEoB2SoundFilesFinaleAmiga[5] = {
	"BIGPIPE3A.CPS",
	"OUTTAKES1.CPS",
	"OUTTAKES2.CPS",
	"FIN.SAM",
	"FINALE.SAM"
};

static const StringListProvider kEoB2SoundFilesFinaleAmigaProvider = { ARRAYSIZE(kEoB2SoundFilesFinaleAmiga), kEoB2SoundFilesFinaleAmiga };

static const byte kEoB2MonsterSoundPatchDataAmiga[60] = {
	0x61, 0x27, 0x24, 0x22, 0x27, 0x25, 0x32, 0x27, 0x25,
	0x87, 0x27, 0x25, 0xa7, 0x27, 0x25, 0x97, 0x27, 0x25,
	0xb7, 0x27, 0x25, 0x08, 0x27, 0x25, 0x28, 0x27, 0x25,
	0x48, 0x27, 0x25, 0x68, 0x27, 0x25, 0x0a, 0x27, 0x25,
	0x1a, 0x27, 0x25, 0x0c, 0x27, 0x25, 0x4e, 0x27, 0x25,
	0x6e, 0x27, 0x25, 0x8e, 0x27, 0x25, 0xae, 0x27, 0x25,
	0x0f, 0x27, 0x25, 0x1f, 0x27, 0x25
};

static const ByteProvider kEoB2MonsterSoundPatchDataAmigaProvider = { ARRAYSIZE(kEoB2MonsterSoundPatchDataAmiga), kEoB2MonsterSoundPatchDataAmiga };
