"""
This file contains physical properties of various materials,
organized as a dictionary of dictionaries. The keys in the
outer dict are the materials, while the keys in the inner
dicts correspond to physical properties.
"""

materials = {

"Acetone [C3H6O] (20 C)": {
   "Melting Point (C)":                     -94.85,
   "Viscosity (Pa*s)":                      0.000389,
   "Thermal Conductivity (W/m*K)":          0.161,
   "Density (kg/m^3)":                      0.7899E+3,
   "Boiling Point (C)":                     56.05,
},
"Acetone [C3H6O] (25 C)": {
   "Sound Velocity (m/s)":                  1174.0,
   "-dV/dt (m/s*C)":                        4.5,
},
"Air (0 C, dry)": {
   "Boiling Point (C)":                     -195.0,
   "Density (kg/m^3)":                      0.00129E+3,
   "-dV/dt (m/s*C)":                        -0.59,
   "Kinematic Viscosity (m2/s)":            1.33e-05,
   "Viscosity (Pa*s)":                      1.71e-05,
   "Sound Velocity (m/s)":                  331.4,
},
"Air (25 C, dry)": {
   "Kinematic Viscosity (m2/s)":            1.46e-05,
   "Viscosity (Pa*s)":                      1.79e-05,
   "Sound Velocity (m/s)":                  346.3,
   "Density (kg/m^3)":                      0.001184E+3,
   "-dV/dt (m/s*C)":                        -0.59,
},
"Alcohol; Ethanol [C2H5OH] (20 C)": {
   "Boiling Point (C)":                     78.29,
   "Viscosity (Pa*s)":                      0.00177,
   "Density (kg/m^3)":                      0.789E+3,
   "Kinematic Viscosity (m2/s)":            2.2e-06,
   "Melting Point (C)":                     -114.2,
   "Bulk Modulus (GPa)":                    0.823,
   "Thermal Conductivity (W/m*K)":          0.169,
},
"Alcohol; Ethanol [C2H5OH] (25 C)": {
   "Sound Velocity (m/s)":                  1207.0,
   "-dV/dt (m/s*C)":                        4.0,
},
"Alcohol; Methanol [CH3OH] (20 C)": {
   "Boiling Point (C)":                     64.55,
   "Viscosity (Pa*s)":                      0.000817,
   "Density (kg/m^3)":                      0.792E+3,
   "Kinematic Viscosity (m2/s)":            1.01e-06,
   "Melting Point (C)":                     -97.68,
   "Bulk Modulus (GPa)":                    0.902,
   "Thermal Conductivity (W/m*K)":          0.2,
},
"Alcohol; Methanol [CH3OH] (25 C)": {
   "Sound Velocity (m/s)":                  1103.0,
   "-dV/dt (m/s*C)":                        3.2,
},
"Aluminum Alloy": {
   "Electric Resistivity (W*m)":            50.0E-9,
   "Ultimate Stress (MPa)":                 [100.0, 550.0],
   "Poisson's Ratio":                       0.33,
   "Shear Modulus (GPa)":                   [26.0, 30.0],
   "Density (kg/m^3)":                      [2.64E+3, 2.8E+3],
   "Melting Point (C)":                     [565.0, 660.0],
   "Thermal Expansion Coefficient (1/C)":   23.0E-6,
   "Elongation (%)":                        [1.0, 45.0],
   "Elastic Modulus (GPa)":                 [70.0, 79.0],
   "Yield Stress (MPa)":                    [35.0, 500.0],
},
"Aluminum Alloy 6082": {
   "Density (kg/m^3)":                      2.7E+3,
   "Thermal Expansion Coefficient (1/C)":   2.5E-5,
   "Thermal Conductivity (W/m*K)":          200.0,
   "Specific Heat (J/kg*C)":                900,
},
"Aluminum [Al]": {
   "Boiling Point (C)":                     2519.0,
   "Electric Resistivity (W*m)":            27.0E-9,
   "Ultimate Stress (MPa)":                 70.0,
   "Poisson's Ratio":                       0.33,
   "Shear Modulus (GPa)":                   26.0,
   "Density (kg/m^3)":                      2.71E+3,
   "Melting Point (C)":                     660.3,
   "Thermal Expansion Coefficient (1/C)":   23.0E-6,
   "Elongation (%)":                        60.0,
   "Thermal Conductivity (W/m*K)":          237.0,
   "Elastic Modulus (GPa)":                 70.0,
   "Yield Stress (MPa)":                    20.0,
},
"Aluminum [Al] (Rolled)": {
   "Shear Wave Velocity (m/s)":             3040.0,
   "Longitudinal Wave Velocity (m/s)":      6420.0,
   "Bar Velocity (m/s)":                    5000.0,
},
"Ammonia [H3N] (0 C)": {
   "Sound Velocity (m/s)":                  415.0,
},
"Argon [Ar] (0 C)": {
   "Melting Point (C)":                     -189.3,
   "Density (kg/m^3)":                      0.001784E+3,
   "Boiling Point (C)":                     -185.8,
},
"Argon [Ar] (20 C)": {
   "Sound Velocity (m/s)":                  319.0,
   "-dV/dt (m/s*C)":                        -0.56,
},
"Brass": {
   "Longitudinal Wave Velocity (m/s)":      4700.0,
   "Electric Resistivity (W*m)":            [20.0E-9, 61.0E-9],
   "Ultimate Stress (MPa)":                 [200.0, 620.0],
   "Poisson's Ratio":                       0.34,
   "Shear Modulus (GPa)":                   [36.0, 41.0],
   "Density (kg/m^3)":                      [8.4E+3, 8.75E+3],
   "Melting Point (C)":                     930.0,
   "Shear Wave Velocity (m/s)":             2110.0,
   "Thermal Expansion Coefficient (1/C)":   [19.1E-6, 21.2E-6],
   "Elongation (%)":                        [4.0, 60.0],
   "Elastic Modulus (GPa)":                 [96.0, 110.0],
   "Bar Velocity (m/s)":                    3480.0,
   "Yield Stress (MPa)":                    [70.0, 550.0],
},
"Brass; Noval": {
   "Ultimate Stress (MPa)":                 [410.0, 590.0],
   "Poisson's Ratio":                       0.34,
   "Shear Modulus (GPa)":                   39.0,
   "Density (kg/m^3)":                      8.4E+3,
   "Thermal Expansion Coefficient (1/C)":   21.1E-6,
   "Elongation (%)":                        [15.0, 50.0],
   "Elastic Modulus (GPa)":                 100.0,
   "Yield Stress (MPa)":                    [170.0, 410.0],
},
"Brass; Red (80% Cu, 20% Zn)": {
   "Ultimate Stress (MPa)":                 [300.0, 590.0],
   "Poisson's Ratio":                       0.34,
   "Shear Modulus (GPa)":                   39.0,
   "Density (kg/m^3)":                      8.75E+3,
   "Melting Point (C)":                     1000.0,
   "Thermal Expansion Coefficient (1/C)":   19.1E-6,
   "Elongation (%)":                        [4.0, 50.0],
   "Elastic Modulus (GPa)":                 100.0,
   "Yield Stress (MPa)":                    [90.0, 470.0],
},
"Brick": {
   "Bar Velocity (m/s)":                    3650.0,
   "Thermal Expansion Coefficient (1/C)":   [5.0E-6, 7.0E-6],
   "Density (kg/m^3)":                      [1.8E+3, 2.4E+3],
   "Ultimate Stress (MPa)":                 [7.0, 70.0],
},
"Brick (Compression)": {
   "Elastic Modulus (GPa)":                 [10.0, 24.0],
},
"Bronze; Manganese": {
   "Ultimate Stress (MPa)":                 [450.0, 620.0],
   "Poisson's Ratio":                       0.34,
   "Shear Modulus (GPa)":                   39.0,
   "Density (kg/m^3)":                      8.3E+3,
   "Thermal Expansion Coefficient (1/C)":   20.0E-6,
   "Elongation (%)":                        [10.0, 35.0],
   "Elastic Modulus (GPa)":                 100.0,
   "Yield Stress (MPa)":                    [170.0, 450.0],
},
"Bronze; Regular": {
   "Ultimate Stress (MPa)":                 [200.0, 830.0],
   "Poisson's Ratio":                       0.34,
   "Shear Modulus (GPa)":                   [36.0, 44.0],
   "Density (kg/m^3)":                      [7.8E+3, 8.8E+3],
   "Melting Point (C)":                     1050.0,
   "Thermal Expansion Coefficient (1/C)":   [18.0E-6, 21.0E-6],
   "Elongation (%)":                        [5.0, 60.0],
   "Elastic Modulus (GPa)":                 [96.0, 120.0],
   "Yield Stress (MPa)":                    [82.0, 690.0],
},
"Carbon Dioxide [CO2] (0 C)": {
   "Melting Point (C)":                     -56.57,
   "Viscosity (Pa*s)":                      1.38e-05,
},
"Carbon Dioxide [CO2] (25 C)": {
   "Sound Velocity (m/s)":                  259.0,
   "-dV/dt (m/s*C)":                        -0.4,
},
"Carbon Monoxide [CO] (25 C)": {
   "Sound Velocity (m/s)":                  338.0,
   "-dV/dt (m/s*C)":                        -0.6,
},
"Carbon [C]": {
   "Melting Point (C)":                     4492.0,
   "Elastic Modulus (GPa)":                 6.9,
   "Electric Resistivity (W*m)":            14100.0E-9,
   "Density (kg/m^3)":                      2.25E+3,
   "Boiling Point (C)":                     3642.0,
},
"Ceramic": {
   "Melting Point (C)":                     3870.0,
   "Elastic Modulus (GPa)":                 [300.0, 400.0],
   "Density (kg/m^3)":                      [2.0E+3, 3.0E+3],
},
"Concrete": {
   "Poisson's Ratio":                       [0.1, 0.2],
   "Elastic Modulus (GPa)":                 [18.0, 30.0],
   "Density (kg/m^3)":                      [2.3E+3, 2.4E+3],
   "Thermal Expansion Coefficient (1/C)":   [7.0E-6, 14.0E-6],
},
"Concrete (Compression)": {
   "Ultimate Stress (MPa)":                 [10.0, 70.0],
},
"Copper Alloy": {
   "Electric Resistivity (W*m)":            [17.0E-9, 490.0E-9],
   "Ultimate Stress (MPa)":                 830.0,
   "Shear Modulus (GPa)":                   47.0,
   "Density (kg/m^3)":                      8.23E+3,
   "Melting Point (C)":                     925.0,
   "Thermal Expansion Coefficient (1/C)":   17.0E-6,
   "Elongation (%)":                        4.0,
   "Elastic Modulus (GPa)":                 120.0,
   "Yield Stress (MPa)":                    760.0,
},
"Copper [Cu]": {
   "Boiling Point (C)":                     2562.0,
   "Electric Resistivity (W*m)":            17.0E-9,
   "Ultimate Stress (MPa)":                 [230.0, 380.0],
   "Poisson's Ratio":                       [0.33, 0.36],
   "Shear Modulus (GPa)":                   [40.0, 47.0],
   "Density (kg/m^3)":                      8.94E+3,
   "Melting Point (C)":                     1085.0,
   "Thermal Expansion Coefficient (1/C)":   [16.6E-6, 17.6E-6],
   "Elongation (%)":                        [10.0, 50.0],
   "Thermal Conductivity (W/m*K)":          410.0,
   "Elastic Modulus (GPa)":                 [110.0, 120.0],
   "Yield Stress (MPa)":                    [55.0, 330.0],
},
"Copper [Cu] (Annealed/Rolled)": {
   "Shear Wave Velocity (m/s)":              2325 / 2270,
   "Longitudinal Wave Velocity (m/s)":       4760 / 5010,
   "Bar Velocity (m/s)":                     3810 / 3750,
},
"Cork": {
   "Poisson's Ratio":                       0.0,
   "Bar Velocity (m/s)":                    500.0,
   "Density (kg/m^3)":                      [0.15E+3, 0.2E+3],
},
"Glass": {
   "Longitudinal Wave Velocity (m/s)":      [3980.0, 5640.0],
   "Ultimate Stress (MPa)":                 [30.0, 1000.0],
   "Poisson's Ratio":                       [0.2, 0.27],
   "Shear Modulus (GPa)":                   [19.0, 34.0],
   "Density (kg/m^3)":                      [2.4E+3, 2.8E+3],
   "Shear Wave Velocity (m/s)":             [2380.0, 3280.0],
   "Thermal Expansion Coefficient (1/C)":   [5.0E-6, 11.0E-6],
   "Bar Velocity (m/s)":                    [3720.0, 5170.0],
   "Elastic Modulus (GPa)":                 [48.0, 83.0],
},
"Gold [Au]": {
   "Boiling Point (C)":                     2856.0,
   "Electric Resistivity (W*m)":            24.0E-9,
   "Poisson's Ratio":                       0.44,
   "Density (kg/m^3)":                      19.32E+3,
   "Melting Point (C)":                     1064.0,
   "Thermal Conductivity (W/m*K)":          317.0,
   "Elastic Modulus (GPa)":                 83.0,
},
"Gold [Au] (Hard-drawn)": {
   "Shear Wave Velocity (m/s)":             1200.0,
   "Longitudinal Wave Velocity (m/s)":      3240.0,
   "Bar Velocity (m/s)":                    2030.0,
},
"Helium [He] (0 C)": {
   "Boiling Point (C)":                     -268.9,
   "Density (kg/m^3)":                      0.0001785E+3,
   "Viscosity (Pa*s)":                      1.86e-05,
},
"Helium [He] (25 C)": {
   "Sound Velocity (m/s)":                  965.0,
   "-dV/dt (m/s*C)":                        -0.8,
},
"Hydrogen [H2] (0 C)": {
   "Melting Point (C)":                     -259.3,
   "Viscosity (Pa*s)":                      8.4e-06,
   "Density (kg/m^3)":                      8.99E+3,
   "Boiling Point (C)":                     -252.9,
},
"Hydrogen [H2] (25 C)": {
   "Sound Velocity (m/s)":                  1284.0,
   "-dV/dt (m/s*C)":                        -2.2,
},
"Iron (Cast)": {
   "Ultimate Stress (MPa)":                 [69.0, 480.0],
   "Poisson's Ratio":                       [0.2, 0.3],
   "Shear Modulus (GPa)":                   [32.0, 69.0],
   "Density (kg/m^3)":                      [7.0E+3, 7.4E+3],
   "Thermal Expansion Coefficient (1/C)":   [9.9E-6, 12.0E-6],
   "Elongation (%)":                        [0.0, 1.0],
   "Elastic Modulus (GPa)":                 [83.0, 170.0],
   "Yield Stress (MPa)":                    [120.0, 290.0],
},
"Iron (Wrought)": {
   "Ultimate Stress (MPa)":                 340.0,
   "Poisson's Ratio":                       0.3,
   "Shear Modulus (GPa)":                   75.0,
   "Density (kg/m^3)":                      [7.4E+3, 7.8E+3],
   "Thermal Expansion Coefficient (1/C)":   12.0E-6,
   "Elongation (%)":                        35.0,
   "Elastic Modulus (GPa)":                 190.0,
   "Yield Stress (MPa)":                    210.0,
},
"Iron [Fe]": {
   "Melting Point (C)":                     1538.0,
   "Thermal Conductivity (W/m*K)":          80.2,
   "Electric Resistivity (W*m)":            97.0E-9,
   "Density (kg/m^3)":                      7.87E+3,
   "Boiling Point (C)":                     2861.0,
},
"Iron [Fe] (Electrolytic/Armco)": {
   "Shear Wave Velocity (m/s)":              3240 / 3240,
   "Longitudinal Wave Velocity (m/s)":       5950 / 5960,
   "Bar Velocity (m/s)":                     5120 / 5200,
},
"Lead [Pb]": {
   "Melting Point (C)":                     327.5,
   "Thermal Conductivity (W/m*K)":          35.3,
   "Electric Resistivity (W*m)":            210.0E-9,
   "Density (kg/m^3)":                      11.3E+3,
   "Boiling Point (C)":                     1749.0,
},
"Lead [Pb] (Annealed/Rolled)": {
   "Shear Wave Velocity (m/s)":              700.0 / 690.0,
   "Longitudinal Wave Velocity (m/s)":       2160 / 1960,
   "Bar Velocity (m/s)":                     1190 / 1210,
},
"Magnesium Alloy": {
   "Boiling Point (C)":                     2061.0,
   "Ultimate Stress (MPa)":                 [140.0, 340.0],
   "Poisson's Ratio":                       0.35,
   "Shear Modulus (GPa)":                   17.0,
   "Density (kg/m^3)":                      1.77E+3,
   "Melting Point (C)":                     1246.0,
   "Thermal Expansion Coefficient (1/C)":   [26.1E-6, 28.8E-6],
   "Elongation (%)":                        [2.0, 20.0],
   "Elastic Modulus (GPa)":                 45.0,
   "Yield Stress (MPa)":                    [80.0, 280.0],
},
"Magnesium [Mg]": {
   "Boiling Point (C)":                     1090.0,
   "Electric Resistivity (W*m)":            45.0E-9,
   "Ultimate Stress (MPa)":                 [100.0, 170.0],
   "Poisson's Ratio":                       0.35,
   "Shear Modulus (GPa)":                   15.0,
   "Density (kg/m^3)":                      1.74E+3,
   "Melting Point (C)":                     650.0,
   "Thermal Expansion Coefficient (1/C)":   25.2E-6,
   "Elongation (%)":                        [5.0, 15.0],
   "Thermal Conductivity (W/m*K)":          156.0,
   "Elastic Modulus (GPa)":                 41.0,
   "Yield Stress (MPa)":                    [20.0, 70.0],
},
"Magnesium [Mg] (Drawn)": {
   "Shear Wave Velocity (m/s)":             3050.0,
   "Longitudinal Wave Velocity (m/s)":      5770.0,
   "Bar Velocity (m/s)":                    4940.0,
},
"Mercury [Hg] (20 C)": {
   "Boiling Point (C)":                     356.7,
   "Electric Resistivity (W*m)":            960.0E-9,
   "Viscosity (Pa*s)":                      0.00155,
   "Density (kg/m^3)":                      13.57904E+3,
   "Kinematic Viscosity (m2/s)":            1.14e-07,
   "Melting Point (C)":                     -38.83,
   "Bulk Modulus (GPa)":                    25.3,
   "Thermal Conductivity (W/m*K)":          8.25,
   "Thermal Expansion Coefficient (E-6/C)": 182.0,
},
"Mercury [Hg] (25 C)": {
   "Sound Velocity (m/s)":                  1450.0,
},
"Methane [CH4] (25 C)": {
   "Sound Velocity (m/s)":                  430.0,
},
"Monel (67% Ni, 30% Cu)": {
   "Longitudinal Wave Velocity (m/s)":      5350.0,
   "Ultimate Stress (MPa)":                 [450.0, 1200.0],
   "Poisson's Ratio":                       0.32,
   "Shear Modulus (GPa)":                   66.0,
   "Density (kg/m^3)":                      8.84E+3,
   "Melting Point (C)":                     1330.0,
   "Shear Wave Velocity (m/s)":             5720.0,
   "Thermal Expansion Coefficient (1/C)":   14.0E-6,
   "Elongation (%)":                        [2.0, 50.0],
   "Elastic Modulus (GPa)":                 170.0,
   "Bar Velocity (m/s)":                    4400.0,
   "Yield Stress (MPa)":                    [170.0, 1100.0],
},
"Neon [Ne] (0 C)": {
   "Melting Point (C)":                     -248.6,
   "Density (kg/m^3)":                      0.0008999E+3,
   "Boiling Point (C)":                     -246.1,
},
"Neon [Ne] (25 C)": {
   "Sound Velocity (m/s)":                  435.0,
   "-dV/dt (m/s*C)":                        -0.8,
},
"Nickel [Ni]": {
   "Boiling Point (C)":                     2913.0,
   "Longitudinal Wave Velocity (m/s)":      6040.0,
   "Electric Resistivity (W*m)":            70.0E-9,
   "Ultimate Stress (MPa)":                 [310.0, 760.0],
   "Poisson's Ratio":                       0.31,
   "Shear Modulus (GPa)":                   80.0,
   "Density (kg/m^3)":                      8.89E+3,
   "Melting Point (C)":                     1455.0,
   "Shear Wave Velocity (m/s)":             3000.0,
   "Thermal Expansion Coefficient (1/C)":   13.0E-6,
   "Elongation (%)":                        [2.0, 50.0],
   "Thermal Conductivity (W/m*K)":          90.7,
   "Elastic Modulus (GPa)":                 210.0,
   "Bar Velocity (m/s)":                    4900.0,
   "Yield Stress (MPa)":                    [140.0, 620.0],
},
"Nitrogen [N2] (0 C)": {
   "Melting Point (C)":                     -210.0,
   "Viscosity (Pa*s)":                      1.66e-05,
   "Density (kg/m^3)":                      0.00125E+3,
   "Boiling Point (C)":                     -195.8,
},
"Nitrogen [N2] (25 C)": {
   "Sound Velocity (m/s)":                  334.0,
   "-dV/dt (m/s*C)":                        -0.6,
},
"Nylon; Polyamide": {
   "Longitudinal Wave Velocity (m/s)":      2620.0,
   "Ultimate Stress (MPa)":                 [40.0, 70.0],
   "Poisson's Ratio":                       0.4,
   "Density (kg/m^3)":                      1.1E+3,
   "Shear Wave Velocity (m/s)":             1070.0,
   "Thermal Expansion Coefficient (1/C)":   [75.0E-6, 100.0E-6],
   "Elongation (%)":                        50.0,
   "Elastic Modulus (GPa)":                 [2.1, 2.8],
   "Bar Velocity (m/s)":                    1800.0,
},
"Oil; Lubricating (20 C)": {
   "Kinematic Viscosity (m2/s)":            0.0009,
   "Viscosity (Pa*s)":                      0.799,
},
"Oil; Mineral": {
   "Density (kg/m^3)":                      0.92E+3,
},
"Oil; Olive": {
   "Melting Point (C)":                     -6.0,
   "Density (kg/m^3)":                      0.92E+3,
},
"Oil; Petroleum": {
   "Density (kg/m^3)":                      0.82E+3,
},
"Oxygen [O2] (0 C)": {
   "Melting Point (C)":                     -218.8,
   "Viscosity (Pa*s)":                      1.92e-05,
   "Density (kg/m^3)":                      0.001429E+3,
   "Boiling Point (C)":                     -182.9,
},
"Oxygen [O2] (25 C)": {
   "Sound Velocity (m/s)":                  316.0,
   "-dV/dt (m/s*C)":                        -0.56,
},
"Platinum [Pt]": {
   "Boiling Point (C)":                     3825.0,
   "Longitudinal Wave Velocity (m/s)":      3260.0,
   "Electric Resistivity (W*m)":            110.0E-9,
   "Poisson's Ratio":                       0.38,
   "Density (kg/m^3)":                      21.4E+3,
   "Melting Point (C)":                     1768.0,
   "Shear Wave Velocity (m/s)":             1730.0,
   "Bar Velocity (m/s)":                    2800.0,
   "Thermal Conductivity (W/m*K)":          71.6,
   "Elastic Modulus (GPa)":                 145.0,
},
"Rubber": {
   "Longitudinal Wave Velocity (m/s)":      [1550.0, 1830.0],
   "Ultimate Stress (MPa)":                 [7.0, 20.0],
   "Poisson's Ratio":                       [0.45, 0.5],
   "Shear Modulus (GPa)":                   [0.0002, 0.001],
   "Density (kg/m^3)":                      [0.96E+3, 1.3E+3],
   "Thermal Expansion Coefficient (1/C)":   [130.0E-6, 200.0E-6],
   "Elongation (%)":                        [100.0, 800.0],
   "Elastic Modulus (GPa)":                 [0.0007, 0.004],
   "Yield Stress (MPa)":                    [1.0, 7.0],
},
"Silicon [Si]": {
   "Melting Point (C)":                     1382.0,
   "Thermal Conductivity (W/m*K)":          148.0,
   "Electric Resistivity (W*m)":            100.0E-9,
   "Density (kg/m^3)":                      2.33E+3,
},
"Silver [Ag]": {
   "Boiling Point (C)":                     2162.0,
   "Longitudinal Wave Velocity (m/s)":      3650.0,
   "Electric Resistivity (W*m)":            16.0E-9,
   "Density (kg/m^3)":                      10.49E+3,
   "Melting Point (C)":                     961.8,
   "Shear Wave Velocity (m/s)":             1610.0,
   "Bar Velocity (m/s)":                    2680.0,
   "Thermal Conductivity (W/m*K)":          429.0,
   "Elastic Modulus (GPa)":                 76.0,
},
"Solder; Tin-Lead": {
   "Electric Resistivity (W*m)":            [130.0E-9, 210.0E-9],
   "Ultimate Stress (MPa)":                 [12.0, 54.0],
   "Density (kg/m^3)":                      [8.17E+3, 11.34E+3],
   "Melting Point (C)":                     215.0,
   "Elongation (%)":                        [55.0, 30.0],
   "Thermal Conductivity (W/m*K)":          [30.0, 49.8],
   "Elastic Modulus (GPa)":                 [18.0, 35.0],
},
"Steel": {
   "Longitudinal Wave Velocity (m/s)":      5960.0,
   "Electric Resistivity (W*m)":            [120.0E-9, 1700.0E-9],
   "Ultimate Stress (MPa)":                 [340.0, 1900.0],
   "Poisson's Ratio":                       [0.27, 0.3],
   "Shear Modulus (GPa)":                   [75.0, 80.0],
   "Density (kg/m^3)":                      7.85E+3,
   "Melting Point (C)":                     1425.0,
   "Shear Wave Velocity (m/s)":             3235.0,
   "Thermal Expansion Coefficient (1/C)":   [10.0E-6, 18.0E-6],
   "Elongation (%)":                        [3.0, 40.0],
   "Elastic Modulus (GPa)":                 [190.0, 210.0],
   "Bar Velocity (m/s)":                    5200.0,
   "Yield Stress (MPa)":                    [280.0, 1600.0],
   "Specific Heat (J/kg*C)":                900,
},
"Stone; Granite": {
   "Density (kg/m^3)":                      2.6E+3,
},
"Stone; Granite (Compression)": {
   "Poisson's Ratio":                       [0.2, 0.3],
   "Elastic Modulus (GPa)":                 [40.0, 70.0],
   "Ultimate Stress (MPa)":                 [70.0, 280.0],
},
"Stone; Limestone": {
   "Density (kg/m^3)":                      [2.0E+3, 2.9E+3],
},
"Stone; Limestone (Compression)": {
   "Poisson's Ratio":                       [0.2, 0.3],
   "Elastic Modulus (GPa)":                 [20.0, 70.0],
   "Ultimate Stress (MPa)":                 [20.0, 200.0],
},
"Stone; Marble": {
   "Bar Velocity (m/s)":                    3810.0,
   "Density (kg/m^3)":                      [2.6E+3, 2.9E+3],
},
"Stone; Marble (Compression)": {
   "Poisson's Ratio":                       [0.2, 0.3],
   "Elastic Modulus (GPa)":                 [50.0, 100.0],
   "Ultimate Stress (MPa)":                 [50.0, 180.0],
},
"Stone; Quartz": {
   "Density (kg/m^3)":                      2.6E+3,
},
"Tin [Sn]": {
   "Boiling Point (C)":                     2602.0,
   "Longitudinal Wave Velocity (m/s)":      3320.0,
   "Electric Resistivity (W*m)":            110.0E-9,
   "Poisson's Ratio":                       0.36,
   "Density (kg/m^3)":                      7.3E+3,
   "Melting Point (C)":                     231.9,
   "Shear Wave Velocity (m/s)":             1670.0,
   "Bar Velocity (m/s)":                    2730.0,
   "Thermal Conductivity (W/m*K)":          66.6,
   "Elastic Modulus (GPa)":                 41.0,
},
"Titanium Alloy": {
   "Ultimate Stress (MPa)":                 [900.0, 970.0],
   "Poisson's Ratio":                       0.33,
   "Shear Modulus (GPa)":                   [39.0, 44.0],
   "Density (kg/m^3)":                      4.51E+3,
   "Thermal Expansion Coefficient (1/C)":   [8.0E-6, 10.0E-6],
   "Elongation (%)":                        10.0,
   "Elastic Modulus (GPa)":                 [110.0, 120.0],
},
"Titanium [Ti]": {
   "Boiling Point (C)":                     3287.0,
   "Longitudinal Wave Velocity (m/s)":      6070.0,
   "Electric Resistivity (W*m)":            430.0E-9,
   "Ultimate Stress (MPa)":                 500.0,
   "Poisson's Ratio":                       0.33,
   "Shear Modulus (GPa)":                   [40.0, 40.0],
   "Density (kg/m^3)":                      4.54E+3,
   "Melting Point (C)":                     1668.0,
   "Shear Wave Velocity (m/s)":             3125.0,
   "Elongation (%)":                        25.0,
   "Thermal Conductivity (W/m*K)":          21.9,
   "Elastic Modulus (GPa)":                 110.0,
   "Bar Velocity (m/s)":                    5080.0,
},
"Tungsten [W]": {
   "Boiling Point (C)":                     5555.0,
   "Electric Resistivity (W*m)":            56.0E-9,
   "Ultimate Stress (MPa)":                 [1400.0, 4000.0],
   "Density (kg/m^3)":                      19.3E+3,
   "Melting Point (C)":                     3422.0,
   "Thermal Expansion Coefficient (1/C)":   4.3E-6,
   "Elongation (%)":                        [0.0, 4.0],
   "Thermal Conductivity (W/m*K)":          174.0,
},
"Tungsten [W] (Annealed/Drawn)": {
   "Shear Wave Velocity (m/s)":              2890 / 2640,
   "Longitudinal Wave Velocity (m/s)":       5220 / 5410,
   "Bar Velocity (m/s)":                     4620 / 4320,
},
"Water; Distilled [H2O] (20 C)": {
   "Boiling Point (C)":                     100.0,
   "Viscosity (Pa*s)":                      0.001,
   "Density (kg/m^3)":                      0.998E+3,
   "Kinematic Viscosity (m2/s)":            1e-06,
   "Melting Point (C)":                     0.0,
   "Sound Velocity (m/s)":                  1481.0,
   "Bulk Modulus (GPa)":                    2.18,
   "Thermal Expansion Coefficient (E-6/C)": 207.0,
},
"Water; Distilled [H2O] (25 C)": {
   "Boiling Point (C)":                     100.0,
   "Density (kg/m^3)":                      0.997E+3,
   "-dV/dt (m/s*C)":                        -2.4,
   "Melting Point (C)":                     0.0,
   "Sound Velocity (m/s)":                  1497.0,
   "Thermal Conductivity (W/m*K)":          0.607,
},
"Water; Distilled [H2O] (4 C)": {
   "Kinematic Viscosity (m2/s)":            1.57e-06,
   "Melting Point (C)":                     0.0,
   "Viscosity (Pa*s)":                      0.00157,
   "Density (kg/m^3)":                      1.0E+3,
   "Boiling Point (C)":                     100.0,
},
"Water; Sea (13 C)": {
   "Bulk Modulus (GPa)":                    2.28,
   "Sound Velocity (m/s)":                  1500.0,
   "Density (kg/m^3)":                      1.024E+3,
   "-dV/dt (m/s*C)":                        -2.4,
},
"Water; Steam [H2O] (100 C)": {
   "Sound Velocity (m/s)":                  404.8,
   "Density (kg/m^3)":                      0.6E+3,
},
"Wood; Ash": {
   "Density (kg/m^3)":                      [0.56E+3, 0.64E+3],
},
"Wood; Ash (Along fiber/ring)": {
   "Bar Velocity (m/s)":                     4670 / 1260,
},
"Wood; Ash (Bending)": {
   "Elastic Modulus (GPa)":                 [10.0, 11.0],
   "Yield Stress (MPa)":                    [40.0, 70.0],
   "Ultimate Stress (MPa)":                 [50.0, 100.0],
},
"Wood; Douglas Fir": {
   "Density (kg/m^3)":                      [0.48E+3, 0.56E+3],
},
"Wood; Douglas Fir (Bending)": {
   "Elastic Modulus (GPa)":                 [11.0, 13.0],
   "Yield Stress (MPa)":                    [30.0, 50.0],
   "Ultimate Stress (MPa)":                 [50.0, 80.0],
},
"Wood; Oak": {
   "Density (kg/m^3)":                      [0.64E+3, 0.72E+3],
},
"Wood; Oak (Along fiber)": {
   "Bar Velocity (m/s)":                    3850.0,
},
"Wood; Oak (Bending)": {
   "Elastic Modulus (GPa)":                 [11.0, 12.0],
   "Yield Stress (MPa)":                    [40.0, 60.0],
   "Ultimate Stress (MPa)":                 [50.0, 100.0],
},
"Wood; Southern Pine": {
   "Density (kg/m^3)":                      [0.55E+3, 0.64E+3],
},
"Wood; Southern Pine (Bending)": {
   "Elastic Modulus (GPa)":                 [11.0, 14.0],
   "Yield Stress (MPa)":                    [40.0, 60.0],
   "Ultimate Stress (MPa)":                 [50.0, 100.0],
},
"Zinc [Zn]": {
   "Boiling Point (C)":                     907.0,
   "Electric Resistivity (W*m)":            59.0E-9,
   "Poisson's Ratio":                       0.25,
   "Density (kg/m^3)":                      7.14E+3,
   "Melting Point (C)":                     419.5,
   "Thermal Expansion Coefficient (1/C)":   30.2E-6,
   "Thermal Conductivity (W/m*K)":          116.0,
},
"Zinc [Zn] (Rolled)": {
   "Shear Wave Velocity (m/s)":             2440.0,
   "Longitudinal Wave Velocity (m/s)":      4210.0,
   "Bar Velocity (m/s)":                    3850.0,
},
}
