/* The following code was generated by JFlex 1.6.1 */

//CHECKSTYLE:OFF

package org.scilab.modules.scinotes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.scilab.modules.commons.ScilabCommonsUtils;

@javax.annotation.Generated("JFlex")
@SuppressWarnings("fallthrough")


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>modules/scinotes/src/java/jflex/scilab.jflex</tt>
 */
public final class ScilabLexer extends ScilabLexerConstants {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int QSTRING = 2;
  public static final int COMMENT = 4;
  public static final int BLOCKCOMMENT = 6;
  public static final int FIELD = 8;
  public static final int COMMANDS = 10;
  public static final int COMMANDSWHITE = 12;
  public static final int BREAKSTRING = 14;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7, 7
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\111\1\1\1\124\1\121\1\114\22\0\1\72\1\117\1\10"+
    "\1\115\1\112\1\11\1\51\1\7\1\3\1\4\1\6\1\43\1\120"+
    "\1\44\1\40\1\5\12\116\1\113\1\125\1\47\1\45\1\50\1\115"+
    "\1\53\1\101\1\102\1\26\1\36\1\34\1\15\1\104\1\31\1\27"+
    "\1\105\1\110\1\76\1\33\1\73\1\32\1\35\1\123\1\37\1\25"+
    "\1\13\1\77\1\106\1\30\1\123\1\100\1\74\1\2\1\41\1\4"+
    "\1\42\1\122\1\0\1\24\1\65\1\55\1\57\1\16\1\14\1\103"+
    "\1\60\1\20\1\107\1\66\1\63\1\70\1\21\1\56\1\17\1\67"+
    "\1\61\1\23\1\12\1\54\1\75\1\62\1\71\1\64\1\22\1\2"+
    "\1\52\1\4\1\46\6\0\1\124\u1fa2\0\1\124\1\124\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\udfe6\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\4\0\1\1\1\0\1\2\1\3\1\4"+
    "\2\5\1\6\1\7\14\10\1\11\7\5\7\10\1\12"+
    "\1\13\2\14\1\15\1\2\1\1\1\16\1\17\1\1"+
    "\1\20\1\21\14\22\1\23\6\22\1\24\2\22\1\25"+
    "\1\26\1\27\1\25\1\30\1\31\1\32\2\1\1\12"+
    "\1\13\2\16\1\33\1\34\1\5\1\35\1\0\2\36"+
    "\1\10\1\36\12\10\1\37\5\10\2\5\1\14\1\15"+
    "\1\0\2\5\3\10\1\40\3\10\1\0\1\35\2\0"+
    "\1\35\1\15\1\0\1\41\37\0\1\42\1\43\2\0"+
    "\1\1\1\44\3\0\6\10\1\45\6\10\1\36\1\10"+
    "\1\15\2\35\10\10\2\15\1\0\1\41\34\0\1\42"+
    "\1\0\3\10\1\46\1\47\13\10\1\41\16\0\1\50"+
    "\14\0\1\42\11\10\26\0\1\10\1\46\3\10\26\0"+
    "\2\10\1\51\25\0\1\52\16\0\1\53\272\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[565];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\126\0\254\0\u0102\0\u0158\0\u01ae\0\u0204\0\u025a"+
    "\0\u02b0\0\u02b0\0\u02b0\0\u0306\0\u035c\0\u03b2\0\u03b2\0\u0408"+
    "\0\u045e\0\u04b4\0\u050a\0\u0560\0\u05b6\0\u060c\0\u0662\0\u06b8"+
    "\0\u070e\0\u0764\0\u07ba\0\u0810\0\u0866\0\u08bc\0\u0912\0\u0968"+
    "\0\u09be\0\u0a14\0\u0a6a\0\u0ac0\0\u0b16\0\u0b6c\0\u0bc2\0\u0c18"+
    "\0\u0c6e\0\u0cc4\0\u0d1a\0\u0d70\0\u0560\0\u0866\0\u0dc6\0\u0866"+
    "\0\u0e1c\0\u02b0\0\u0e72\0\u0ec8\0\u02b0\0\u02b0\0\u02b0\0\u0f1e"+
    "\0\u0f74\0\u0fca\0\u1020\0\u1076\0\u10cc\0\u1122\0\u1178\0\u11ce"+
    "\0\u1224\0\u127a\0\u02b0\0\u12d0\0\u1326\0\u137c\0\u13d2\0\u1428"+
    "\0\u147e\0\u02b0\0\u14d4\0\u152a\0\u02b0\0\u02b0\0\u1580\0\u1580"+
    "\0\u02b0\0\u15d6\0\u15d6\0\u162c\0\u1682\0\u02b0\0\u02b0\0\u16d8"+
    "\0\u172e\0\u02b0\0\u1784\0\u02b0\0\u02b0\0\u17da\0\u0560\0\u1830"+
    "\0\u1886\0\u18dc\0\u1932\0\u1988\0\u19de\0\u1a34\0\u1a8a\0\u1ae0"+
    "\0\u1b36\0\u1b8c\0\u1be2\0\u1c38\0\u0560\0\u1c8e\0\u1ce4\0\u1d3a"+
    "\0\u1d90\0\u1de6\0\u1e3c\0\u1e92\0\u1ee8\0\u1f3e\0\u1f94\0\u1fea"+
    "\0\u2040\0\u2096\0\u20ec\0\u2142\0\u0560\0\u2198\0\u21ee\0\u2244"+
    "\0\u229a\0\u22f0\0\u0866\0\u0d70\0\u2346\0\u239c\0\u0e72\0\u23f2"+
    "\0\u2448\0\u249e\0\u24f4\0\u254a\0\u25a0\0\u25f6\0\u264c\0\u26a2"+
    "\0\u26f8\0\u274e\0\u27a4\0\u27fa\0\u2850\0\u28a6\0\u28fc\0\u2952"+
    "\0\u29a8\0\u29fe\0\u2a54\0\u1224\0\u2aaa\0\u2b00\0\u2b56\0\u2bac"+
    "\0\u2c02\0\u2c58\0\u2cae\0\u2d04\0\u2d5a\0\u14d4\0\u2db0\0\u02b0"+
    "\0\u02b0\0\u152a\0\u15d6\0\u2e06\0\u172e\0\u2e5c\0\u2eb2\0\u2f08"+
    "\0\u2f5e\0\u2fb4\0\u300a\0\u3060\0\u30b6\0\u310c\0\u3162\0\u31b8"+
    "\0\u320e\0\u3264\0\u32ba\0\u3310\0\u3366\0\u33bc\0\u3412\0\u3468"+
    "\0\u1fea\0\u2040\0\u34be\0\u3514\0\u356a\0\u35c0\0\u3616\0\u366c"+
    "\0\u36c2\0\u3718\0\u376e\0\u37c4\0\u381a\0\u3870\0\u38c6\0\u391c"+
    "\0\u3972\0\u39c8\0\u3a1e\0\u3a74\0\u3aca\0\u3b20\0\u3b76\0\u3bcc"+
    "\0\u3c22\0\u3c78\0\u3cce\0\u3d24\0\u3d7a\0\u3dd0\0\u3e26\0\u3e7c"+
    "\0\u3ed2\0\u3f28\0\u3f7e\0\u3fd4\0\u402a\0\u4080\0\u40d6\0\u412c"+
    "\0\u4182\0\u41d8\0\u14d4\0\u422e\0\u4284\0\u42da\0\u4330\0\u4386"+
    "\0\u0560\0\u43dc\0\u4432\0\u4488\0\u44de\0\u4534\0\u458a\0\u45e0"+
    "\0\u4636\0\u468c\0\u46e2\0\u4738\0\u02b0\0\u478e\0\u47e4\0\u483a"+
    "\0\u4890\0\u48e6\0\u493c\0\u4992\0\u49e8\0\u4a3e\0\u4a94\0\u4aea"+
    "\0\u4b40\0\u4b96\0\u4bec\0\u02b0\0\u4c42\0\u4c98\0\u4cee\0\u4d44"+
    "\0\u4d9a\0\u4df0\0\u4e46\0\u4e9c\0\u4ef2\0\u4f48\0\u4f9e\0\u4ff4"+
    "\0\u2e5c\0\u504a\0\u50a0\0\u50f6\0\u514c\0\u51a2\0\u51f8\0\u524e"+
    "\0\u52a4\0\u52fa\0\u5350\0\u53a6\0\u53fc\0\u5452\0\u54a8\0\u54fe"+
    "\0\u5554\0\u55aa\0\u5600\0\u5656\0\u56ac\0\u5702\0\u5758\0\u57ae"+
    "\0\u5804\0\u585a\0\u58b0\0\u5906\0\u595c\0\u59b2\0\u5a08\0\u5a5e"+
    "\0\u5ab4\0\u0560\0\u5b0a\0\u5b60\0\u5bb6\0\u5c0c\0\u5c62\0\u5cb8"+
    "\0\u5d0e\0\u5d64\0\u5dba\0\u5e10\0\u5e66\0\u5ebc\0\u5f12\0\u5f68"+
    "\0\u5fbe\0\u6014\0\u606a\0\u60c0\0\u6116\0\u616c\0\u61c2\0\u6218"+
    "\0\u626e\0\u62c4\0\u631a\0\u6370\0\u63c6\0\u5c0c\0\u641c\0\u6472"+
    "\0\u64c8\0\u651e\0\u6574\0\u65ca\0\u6620\0\u6676\0\u66cc\0\u6722"+
    "\0\u6778\0\u67ce\0\u6824\0\u687a\0\u68d0\0\u6926\0\u697c\0\u69d2"+
    "\0\u6a28\0\u6a7e\0\u6ad4\0\u0560\0\u6b2a\0\u6b80\0\u6bd6\0\u6c2c"+
    "\0\u6c82\0\u6cd8\0\u6d2e\0\u6d84\0\u6dda\0\u6e30\0\u6e86\0\u6edc"+
    "\0\u6f32\0\u6f88\0\u02b0\0\u6fde\0\u7034\0\u708a\0\u70e0\0\u7136"+
    "\0\u718c\0\u71e2\0\u7238\0\u728e\0\u72e4\0\u733a\0\u7390\0\u73e6"+
    "\0\u743c\0\u7492\0\u74e8\0\u753e\0\u7594\0\u75ea\0\u7640\0\u7696"+
    "\0\u76ec\0\u7742\0\u7798\0\u77ee\0\u7844\0\u789a\0\u78f0\0\u7946"+
    "\0\u799c\0\u79f2\0\u7a48\0\u7a9e\0\u7af4\0\u7b4a\0\u7ba0\0\u7bf6"+
    "\0\u7c4c\0\u7ca2\0\u7cf8\0\u7d4e\0\u7da4\0\u7dfa\0\u7e50\0\u7ea6"+
    "\0\u7efc\0\u7f52\0\u7fa8\0\u7ffe\0\u8054\0\u80aa\0\u8100\0\u8156"+
    "\0\u81ac\0\u8202\0\u8258\0\u82ae\0\u8304\0\u835a\0\u83b0\0\u8406"+
    "\0\u845c\0\u84b2\0\u8508\0\u855e\0\u85b4\0\u860a\0\u8660\0\u86b6"+
    "\0\u870c\0\u8762\0\u87b8\0\u880e\0\u8864\0\u88ba\0\u8910\0\u8966"+
    "\0\u89bc\0\u8a12\0\u8a68\0\u8abe\0\u8b14\0\u8b6a\0\u8bc0\0\u8c16"+
    "\0\u8c6c\0\u8cc2\0\u8d18\0\u8d6e\0\u8dc4\0\u8e1a\0\u8e70\0\u8ec6"+
    "\0\u8f1c\0\u8f72\0\u8fc8\0\u901e\0\u9074\0\u90ca\0\u9120\0\u9176"+
    "\0\u91cc\0\u9222\0\u9278\0\u92ce\0\u9324\0\u937a\0\u93d0\0\u9426"+
    "\0\u947c\0\u94d2\0\u9528\0\u957e\0\u95d4\0\u962a\0\u9680\0\u96d6"+
    "\0\u972c\0\u9782\0\u97d8\0\u982e\0\u9884\0\u98da\0\u9930\0\u9986"+
    "\0\u99dc\0\u9a32\0\u9a88\0\u9ade\0\u9b34\0\u9b8a\0\u9be0\0\u9c36"+
    "\0\u9c8c\0\u9ce2\0\u9d38\0\u9d8e\0\u9de4\0\u9e3a\0\u9e90\0\u9ee6"+
    "\0\u9f3c\0\u9f92\0\u9fe8\0\ua03e\0\ua094\0\ua0ea\0\ua140\0\ua196"+
    "\0\ua1ec\0\ua242\0\ua298\0\ua2ee\0\ua344\0\ua39a\0\ua3f0\0\ua446"+
    "\0\ua49c\0\ua4f2\0\ua548\0\ua59e\0\ua5f4\0\ua64a\0\ua6a0\0\ua6f6"+
    "\0\ua74c\0\ua7a2\0\ua7f8\0\ua84e\0\ua8a4\0\ua8fa\0\ua950\0\ua9a6"+
    "\0\ua9fc\0\uaa52\0\uaaa8\0\uaafe\0\uab54\0\uabaa\0\uac00\0\uac56"+
    "\0\uacac\0\uad02\0\uad58\0\uadae\0\uae04";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[565];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\2\11\2\12\1\13\1\14\1\15\1\16\1\17\1\20"+
    "\1\21\1\22\1\23\1\24\1\25\1\26\1\27\2\24"+
    "\1\30\1\31\1\32\2\24\1\33\7\24\1\34\2\35"+
    "\1\36\1\37\2\40\1\41\1\40\1\42\1\43\1\40"+
    "\1\24\1\44\1\45\1\46\1\24\1\47\1\50\2\24"+
    "\1\51\1\24\1\52\2\24\1\53\16\24\1\54\1\55"+
    "\1\56\1\0\1\24\1\57\1\24\1\60\1\0\2\24"+
    "\1\0\1\11\1\61\1\62\5\61\2\63\27\61\1\64"+
    "\31\61\1\65\16\61\1\66\2\61\1\0\11\61\14\67"+
    "\1\70\6\67\1\71\1\67\1\72\1\73\1\74\3\67"+
    "\1\75\1\76\1\77\1\100\10\67\1\101\10\67\1\102"+
    "\11\67\1\103\1\67\1\104\3\67\1\105\1\106\1\107"+
    "\2\67\1\110\1\111\2\67\1\112\1\113\1\67\1\0"+
    "\4\67\1\0\2\67\1\0\7\67\1\114\5\67\1\70"+
    "\6\67\1\71\1\67\1\72\1\73\1\74\3\67\1\75"+
    "\1\76\1\77\1\100\10\67\1\101\10\67\1\102\11\67"+
    "\1\103\1\67\1\104\3\67\1\105\1\106\1\107\2\67"+
    "\1\110\1\111\2\67\1\112\1\113\1\67\1\0\4\67"+
    "\1\0\2\67\1\0\1\67\1\115\1\116\7\115\27\117"+
    "\14\115\16\117\1\115\16\117\1\115\1\120\1\115\1\0"+
    "\1\117\1\115\1\117\1\115\1\0\2\117\1\0\2\115"+
    "\1\116\1\115\1\121\66\115\1\122\16\115\1\123\2\115"+
    "\1\0\4\115\1\0\2\115\1\0\1\115\5\124\1\125"+
    "\64\124\1\126\16\124\1\127\6\124\1\115\4\124\1\115"+
    "\5\62\1\130\32\62\1\131\31\62\1\126\16\62\1\127"+
    "\2\62\1\0\4\62\1\0\2\62\1\0\1\62\133\0"+
    "\1\132\1\133\31\0\1\134\4\0\1\135\66\0\1\134"+
    "\36\0\1\135\172\0\1\136\25\0\4\137\1\140\1\141"+
    "\1\142\1\143\2\137\14\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\4\24\1\144\1\145\10\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\21\24\1\146"+
    "\4\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\26\24\14\0\1\147\1\24"+
    "\1\150\13\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\26\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\7\24"+
    "\1\151\16\24\14\0\7\24\1\152\5\24\1\153\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\12\24\1\154\13\24\14\0\16\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\2\24\1\155"+
    "\23\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\4\24\1\156\21\24\14\0"+
    "\6\24\1\157\7\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\26\24\14\0\11\24\1\160"+
    "\4\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\14\24\1\161\11\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\13\24\1\162\12\24\14\0\16\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\7\0\1\163\1\164"+
    "\1\134\30\0\1\165\1\163\1\134\2\0\1\135\50\0"+
    "\1\166\54\0\1\135\65\0\2\135\31\0\1\167\2\135"+
    "\2\0\1\135\65\0\2\135\31\0\1\167\2\135\2\0"+
    "\1\135\2\0\1\135\122\0\1\134\125\0\1\134\2\0"+
    "\1\134\126\0\1\170\126\0\1\171\65\0\12\24\1\172"+
    "\13\24\14\0\2\24\1\173\13\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\1\174\25\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\26\24\14\0\2\24\1\175\13\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\4\24\1\176\21\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\4\24\1\177\11\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\5\24"+
    "\1\200\10\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\26\24\14\0\1\153\15\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\74\0"+
    "\1\201\16\0\1\202\5\0\1\203\100\0\1\202\16\0"+
    "\1\204\26\0\4\205\1\206\15\205\1\206\1\205\1\206"+
    "\1\205\1\166\13\0\3\205\1\206\12\205\1\0\16\205"+
    "\1\0\1\205\2\0\1\205\1\57\1\205\2\0\2\205"+
    "\2\0\1\61\1\0\5\61\2\207\27\61\1\0\31\61"+
    "\1\0\16\61\1\0\2\61\1\0\11\61\7\0\2\61"+
    "\155\0\1\210\77\0\1\211\5\0\1\212\121\0\1\213"+
    "\53\0\1\214\53\0\1\215\1\0\1\216\43\0\1\217"+
    "\57\0\1\220\5\0\1\221\36\0\1\222\63\0\1\223"+
    "\51\0\1\224\52\0\1\225\3\0\1\226\174\0\1\227"+
    "\52\0\1\230\125\0\1\231\6\0\1\232\110\0\27\233"+
    "\3\0\1\233\7\0\16\233\1\234\16\233\1\234\4\0"+
    "\1\233\3\0\2\233\14\0\1\235\173\0\1\236\71\0"+
    "\1\237\122\0\1\240\41\0\1\241\60\0\1\242\42\0"+
    "\1\243\62\0\1\244\127\0\1\245\105\0\41\246\1\247"+
    "\50\246\1\250\13\246\5\0\1\251\1\252\131\0\26\117"+
    "\14\0\16\117\1\0\16\117\1\0\1\117\2\0\3\117"+
    "\2\0\2\117\5\0\1\121\66\0\1\253\16\0\1\253"+
    "\14\0\5\124\1\0\64\124\1\0\16\124\1\0\6\124"+
    "\1\0\4\124\1\0\5\254\1\132\64\254\1\0\33\254"+
    "\5\0\1\132\160\0\1\255\73\0\1\133\117\0\7\136"+
    "\2\256\30\136\1\257\50\136\1\260\13\136\12\0\5\24"+
    "\1\261\20\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\6\24\1\137\17\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\7\24\1\262\16\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\12\24\1\263\13\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\4\24"+
    "\1\264\21\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\10\24"+
    "\1\155\5\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\23\24\1\265\2\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\7\24\1\266\16\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\5\24\1\155\10\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\3\24"+
    "\1\267\12\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\11\24\1\270\14\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\6\24\1\271\17\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\1\272\15\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\26\24\14\0\7\24\1\273"+
    "\6\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\6\24\1\274\17\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\26\24\14\0\2\24\1\275\13\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\15\24\1\276"+
    "\10\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\14\24\1\277\11\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\42\0\1\134\73\0\1\134\31\0\1\134\125\0"+
    "\1\165\103\0\1\300\15\0\1\300\1\0\1\300\20\0"+
    "\1\300\36\0\1\166\14\0\2\135\32\0\4\135\132\0"+
    "\1\301\126\0\1\302\65\0\1\303\10\24\1\304\14\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\7\24\1\305\16\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\26\24\14\0\4\24\1\306\11\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\1\307"+
    "\10\24\1\310\14\24\14\0\16\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\6\24\1\311"+
    "\17\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\4\24\1\312\21\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\74\0\1\201\16\0\1\202\106\0\1\202\16\0"+
    "\1\202\26\0\26\205\14\0\16\205\1\0\16\205\1\0"+
    "\1\205\2\0\3\205\2\0\2\205\14\0\26\205\3\0"+
    "\2\313\7\0\16\205\1\0\16\205\1\0\1\205\2\0"+
    "\1\205\1\314\1\205\2\0\2\205\7\0\1\315\32\0"+
    "\1\210\31\0\1\316\16\0\1\316\33\0\1\317\171\0"+
    "\1\320\54\0\1\321\200\0\1\322\121\0\1\323\134\0"+
    "\1\324\120\0\1\325\121\0\1\326\131\0\1\327\60\0"+
    "\1\330\5\0\1\331\162\0\1\332\103\0\1\333\143\0"+
    "\1\334\71\0\1\335\141\0\1\336\106\0\1\337\212\0"+
    "\1\340\126\0\1\341\33\0\27\233\3\0\1\233\6\0"+
    "\1\342\16\233\1\0\16\233\5\0\1\233\3\0\2\233"+
    "\14\0\1\211\171\0\1\343\70\0\1\344\116\0\1\345"+
    "\176\0\1\346\123\0\1\347\120\0\1\350\132\0\1\351"+
    "\65\0\1\352\104\0\41\246\1\247\50\246\1\353\13\246"+
    "\5\254\1\0\64\254\1\0\33\254\7\0\2\136\115\0"+
    "\7\136\2\256\30\136\1\257\50\136\1\354\13\136\7\0"+
    "\2\250\127\0\11\24\1\137\14\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\2\24\1\137\23\24\14\0\16\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\7\24\1\137"+
    "\16\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\7\24\1\175\16\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\24\24\1\355\1\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\26\24\14\0\1\24\1\356\14\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\2\24\1\357"+
    "\23\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\4\24\1\360\21\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\1\361\25\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\11\24"+
    "\1\362\14\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\4\24\1\363\21\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\1\364\25\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\26\24\14\0\5\24\1\271\10\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\17\24\1\365"+
    "\6\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\15\24\1\137\10\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\45\0\2\313\51\0\1\313\21\0\26\24\14\0"+
    "\1\24\1\366\14\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\4\24\1\175\21\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\1\367\25\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\4\24"+
    "\1\370\21\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\1\371"+
    "\15\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\26\24\14\0\1\372\15\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\7\24\1\373\6\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\12\24\1\374\13\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\120\0\1\313\21\0\26\205\14\0\16\205"+
    "\1\0\16\205\1\0\1\205\2\0\1\205\1\314\1\205"+
    "\2\0\2\205\7\0\1\375\125\0\1\315\64\0\1\316"+
    "\16\0\1\316\37\0\1\376\67\0\1\377\30\0\1\376"+
    "\126\0\1\376\221\0\1\u0100\115\0\1\u0101\100\0\1\u0102"+
    "\144\0\1\u0103\111\0\1\u0104\64\0\1\u0105\175\0\1\u0106"+
    "\111\0\1\u0107\71\0\1\u0108\134\0\1\u0109\156\0\1\u010a"+
    "\121\0\1\u010b\77\0\1\u010c\160\0\1\u010d\64\0\1\u010e"+
    "\134\0\1\u010f\110\0\26\u0110\4\0\1\u0110\7\0\16\u0110"+
    "\1\0\16\u0110\5\0\1\u0110\4\0\1\u0110\56\0\1\u0111"+
    "\72\0\1\u0112\162\0\1\u0113\73\0\1\u0114\122\0\1\u0115"+
    "\125\0\1\u0116\162\0\1\u0117\124\0\1\u0118\50\0\7\136"+
    "\2\u0119\30\136\1\257\50\136\1\260\13\136\12\0\15\24"+
    "\1\u011a\10\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\1\u011b\25\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\26\24\14\0\1\147\15\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\6\24"+
    "\1\u011c\17\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\4\24\1\361\21\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\26\24\14\0\1\24\1\u011d\14\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\26\24\14\0\1\24\1\u011e\14\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\20\24"+
    "\1\u011f\5\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\4\24"+
    "\1\175\11\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\6\24\1\u0120\17\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\26\24\14\0\5\24\1\u0121\10\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\5\24\1\u0122\10\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\14\24"+
    "\1\362\1\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\4\24\1\155\21\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\26\24\14\0\12\24\1\361\3\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\115\0\1\377"+
    "\17\0\1\u0123\125\0\1\377\136\0\1\u0124\130\0\1\u0125"+
    "\122\0\1\u0126\127\0\1\u0127\176\0\1\u0128\52\0\1\u0129"+
    "\166\0\1\u012a\72\0\1\u010c\202\0\1\u010c\50\0\1\u012b"+
    "\117\0\1\u012c\170\0\1\u012d\56\0\1\u012e\126\0\1\u012f"+
    "\124\0\26\u0110\1\u0130\3\0\1\u0110\7\0\16\u0110\1\0"+
    "\16\u0110\5\0\1\u0110\4\0\1\u0110\63\0\1\u0131\136\0"+
    "\1\u0132\53\0\1\u0133\126\0\1\u0134\130\0\1\u0135\157\0"+
    "\1\u0136\137\0\1\u0137\53\0\1\u0138\121\0\25\24\1\137"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\6\24\1\u0139\17\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\2\24\1\u013a\23\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\1\155"+
    "\25\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\26\24\14\0\4\24\1\155"+
    "\11\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\21\24\1\u013b\4\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\7\24\1\u013c\16\24\14\0\16\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\26\24\14\0"+
    "\6\24\1\u013d\7\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\7\24\1\361\16\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\7\0\1\u013e\212\0\1\u013f\125\0\1\u0140\56\0"+
    "\1\u0141\157\0\1\u0142\62\0\1\u0143\134\0\1\u0144\122\0"+
    "\1\u0145\125\0\1\u0146\172\0\1\u0147\60\0\1\u0148\125\0"+
    "\1\u0149\143\0\1\u014a\103\0\26\u014b\4\0\1\u0110\7\0"+
    "\16\u014b\1\0\16\u014b\5\0\1\u0110\4\0\1\u014b\74\0"+
    "\1\u014c\61\0\1\u014d\120\0\1\u014e\176\0\1\u014f\114\0"+
    "\1\u0150\136\0\1\u0151\51\0\1\u0152\130\0\1\u0153\116\0"+
    "\26\24\14\0\2\24\1\u0154\13\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\22\24\1\137"+
    "\3\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\26\24\14\0\1\362\15\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\6\24\1\u0155\17\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\2\0\1\u0156"+
    "\1\0\5\u0156\2\0\61\u0156\1\0\16\u0156\1\0\2\u0156"+
    "\1\0\4\u0156\1\0\4\u0156\25\0\1\u0157\204\0\1\u0158"+
    "\33\0\1\u0159\205\0\1\u015a\51\0\1\u015b\121\0\1\u015c"+
    "\205\0\1\u015d\116\0\1\u015e\134\0\1\u015f\125\0\1\u0160"+
    "\111\0\1\u010c\101\0\1\u010c\105\0\26\u0161\1\u0130\3\0"+
    "\1\u0110\7\0\16\u0161\1\0\16\u0161\5\0\1\u0110\4\0"+
    "\1\u0161\35\0\1\u0162\124\0\1\u0163\23\0\1\u0164\65\0"+
    "\1\u0165\134\0\1\u0166\1\u0167\156\0\1\u0168\153\0\1\u0169"+
    "\112\0\1\u016a\45\0\1\u016b\125\0\7\24\1\u016c\16\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\11\24\1\304\14\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\1\u016d\1\u016e\136\0\1\u016f\54\0\1\u0170\105\0"+
    "\1\u0171\102\0\1\u0172\161\0\1\u0173\125\0\1\u0174\137\0"+
    "\1\u0175\113\0\1\u0176\140\0\1\u0177\53\0\1\u0178\42\0"+
    "\1\u0179\41\0\26\u017a\1\u0130\3\0\1\u0110\3\0\1\u017b"+
    "\3\0\16\u017a\1\u017c\16\u017a\1\u017c\4\0\1\u0110\4\0"+
    "\1\u017a\26\0\1\u017d\54\0\1\u017e\122\0\1\u017f\112\0"+
    "\1\u0180\134\0\1\u0181\53\0\1\u0182\6\0\1\u0183\130\0"+
    "\1\u0184\23\0\1\u0185\141\0\1\u0186\65\0\1\u0187\23\0"+
    "\1\u0188\104\0\1\u0189\162\0\1\u018a\51\0\1\u018b\143\0"+
    "\1\u018c\152\0\1\u018d\103\0\1\u018e\104\0\1\u018f\125\0"+
    "\1\u0190\15\0\1\u0191\127\0\1\u0192\125\0\1\u0193\121\0"+
    "\1\u0194\23\0\1\u0195\151\0\1\u0196\77\0\1\u0197\22\0"+
    "\1\u0198\52\0\1\u0199\54\0\1\u019a\50\0\1\u019b\54\0"+
    "\1\u019c\36\0\26\u019d\1\u0130\3\0\1\u0110\3\0\1\u017b"+
    "\3\0\16\u019d\1\u017c\16\u019d\1\u017c\4\0\1\u0110\4\0"+
    "\1\u019d\52\0\1\u017b\21\0\1\u017c\16\0\1\u017c\73\0"+
    "\1\u019e\104\0\1\u019f\165\0\1\u01a0\112\0\1\u01a1\76\0"+
    "\1\u01a2\161\0\1\u01a3\70\0\1\u01a4\131\0\1\u01a5\147\0"+
    "\1\u01a6\75\0\1\u01a7\111\0\1\u01a8\124\0\1\u01a9\131\0"+
    "\1\u01aa\6\0\1\u01ab\124\0\1\u01ac\47\0\1\u01ad\45\0"+
    "\1\u01ae\143\0\1\u01af\107\0\1\u01b0\143\0\1\u01b1\163\0"+
    "\1\u01b2\116\0\1\u01b3\140\0\1\u01b4\45\0\1\u01b5\15\0"+
    "\1\u01b6\115\0\1\u01b7\54\0\1\u01b8\57\0\1\u01b9\162\0"+
    "\1\u01ba\61\0\1\u01bb\54\0\1\u01bc\107\0\1\u01bd\140\0"+
    "\1\u01be\110\0\1\u01bf\103\0\1\u01c0\107\0\1\u01c1\177\0"+
    "\1\u01c2\44\0\26\u01c3\1\u0130\3\0\1\u0110\3\0\1\u017b"+
    "\3\0\16\u01c3\1\u017c\16\u01c3\1\u017c\4\0\1\u0110\4\0"+
    "\1\u01c3\22\0\1\u01c4\134\0\1\u01c5\132\0\1\u01c6\107\0"+
    "\1\u01c7\172\0\1\u01c8\12\0\1\u01c9\105\0\1\u01ca\101\0"+
    "\1\u01cb\166\0\1\u01cc\53\0\1\u01cd\160\0\1\u01ce\22\0"+
    "\1\u01cf\65\0\1\u01cc\147\0\1\u01cd\121\0\1\u01d0\76\0"+
    "\1\u01d1\131\0\1\u01d2\23\0\1\u01d3\65\0\1\u01d4\1\0"+
    "\1\u01d0\6\0\1\u01d1\4\0\1\u01d5\152\0\1\u010c\103\0"+
    "\1\u010c\111\0\1\u01d6\127\0\1\u01d7\176\0\1\u01d8\11\0"+
    "\1\u01d9\41\0\1\u01da\202\0\1\u01db\45\0\1\u01dc\177\0"+
    "\1\u01dd\127\0\1\u01de\136\0\1\u01df\53\0\1\u01e0\107\0"+
    "\1\u01e1\163\0\1\u01e2\150\0\1\u01e3\46\0\1\u01e4\134\0"+
    "\1\u01e5\114\0\1\u01e6\143\0\1\u01e7\150\0\1\u0149\104\0"+
    "\1\u014a\101\0\26\u0110\1\u0130\3\0\1\u0110\3\0\1\u017b"+
    "\3\0\16\u0110\1\u017c\16\u0110\1\u017c\4\0\1\u0110\4\0"+
    "\1\u0110\23\0\1\u01e8\177\0\1\u01e9\45\0\1\u01d7\124\0"+
    "\1\u01d6\133\0\1\u01ea\134\0\1\u01eb\117\0\1\u010c\177\0"+
    "\1\u010c\66\0\1\u01ec\107\0\1\u01ed\212\0\1\u01ee\126\0"+
    "\1\u01ef\45\0\1\u01f0\202\0\1\u01f1\123\0\1\u01f2\102\0"+
    "\1\u01f3\160\0\1\u01f4\123\0\1\u01f5\32\0\1\u01f6\126\0"+
    "\1\u01f7\130\0\1\u01f8\15\0\1\u01f9\123\0\1\u01fa\23\0"+
    "\1\u01fb\137\0\1\u01fc\70\0\1\u01fd\112\0\1\u01fe\134\0"+
    "\1\u01ff\116\0\1\u0200\134\0\1\u0201\172\0\1\u010c\53\0"+
    "\1\u010c\162\0\1\u0202\104\0\1\u0203\113\0\1\u0204\202\0"+
    "\1\u0205\101\0\1\u0206\76\0\1\u0207\117\0\1\u0208\134\0"+
    "\1\u0209\122\0\1\u020a\202\0\1\u020b\37\0\1\u010c\124\0"+
    "\1\u010c\167\0\1\u020c\150\0\1\u020d\107\0\1\u0200\103\0"+
    "\1\u0201\174\0\1\u020e\114\0\1\u020f\46\0\1\u0210\143\0"+
    "\1\u0211\107\0\1\u010c\143\0\1\u010c\150\0\1\u0212\104\0"+
    "\1\u0213\166\0\1\u0214\102\0\1\u0215\75\0\1\u0216\202\0"+
    "\1\u0217\46\0\1\u01cd\177\0\1\u01cc\110\0\1\u010c\104\0"+
    "\1\u010c\107\0\1\u01ca\134\0\1\u01cb\153\0\1\u0218\76\0"+
    "\1\u0219\157\0\1\u021a\76\0\1\u021b\140\0\1\u021c\125\0"+
    "\1\u021d\104\0\1\u010c\127\0\1\u010c\116\0\1\u021e\143\0"+
    "\1\u021f\125\0\1\u0220\107\0\1\u0221\163\0\1\u0222\150\0"+
    "\1\u0223\107\0\1\u0224\103\0\1\u0225\121\0\1\u0226\162\0"+
    "\1\u0227\116\0\1\u0228\103\0\1\u0229\146\0\1\u020a\76\0"+
    "\1\u020b\120\0\1\u022a\202\0\1\u022b\120\0\1\u022c\125\0"+
    "\1\u022d\52\0\1\u022e\177\0\1\u022f\71\0\1\u01ec\147\0"+
    "\1\u01ed\65\0\1\u01f6\177\0\1\u01f7\106\0\1\u010c\150\0"+
    "\1\u010c\127\0\1\u01af\50\0\1\u01ae\162\0\1\u01f6\103\0"+
    "\1\u01f7\151\0\1\u010c\140\0\1\u010c\105\0\1\u0230\101\0"+
    "\1\u0231\111\0\1\u0232\143\0\1\u0233\145\0\1\u0234\150\0"+
    "\1\u0235\112\0\1\u010c\141\0\1\u010c\45\0\1\u0222\134\0"+
    "\1\u0223\76\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[44634];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\1\4\0\1\1\1\0\3\11\46\1\1\11"+
    "\2\1\3\11\13\1\1\11\6\1\1\11\2\1\2\11"+
    "\2\1\1\11\4\1\2\11\2\1\1\11\1\1\2\11"+
    "\1\0\30\1\1\0\11\1\1\0\1\1\2\0\2\1"+
    "\1\0\1\1\37\0\2\11\2\0\2\1\3\0\34\1"+
    "\1\0\1\1\34\0\1\1\1\0\20\1\1\11\16\0"+
    "\1\11\14\0\12\1\26\0\5\1\26\0\3\1\25\0"+
    "\1\1\16\0\1\11\272\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[565];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
    public int start;
    public int end;
    public int beginString;
    public static Set<String> commands = new HashSet<String>();
    public static Set<String> macros = new HashSet<String>();
    public static Set<String> variables = new HashSet<String>();
    public Set<String> infile;

    private ScilabDocument doc;
    private boolean transposable;
    private Element elem;
    private boolean breakstring;
    private boolean breakcomment;
    private MatchingBlockScanner matchBlock;

    static {
	// For SciNotes colors in preferences
	commands.add("cos");
	macros.add("sind");
    }

    public ScilabLexer(ScilabDocument doc) {
	this(doc, new MatchingBlockScanner(doc), true);
    }

    public ScilabLexer(ScilabDocument doc, boolean update) {
	this(doc, new MatchingBlockScanner(doc), update);
    }

    public ScilabLexer(ScilabDocument doc, MatchingBlockScanner matchBlock, boolean update) {
        this.doc = doc;
        this.elem = doc.getDefaultRootElement();
        this.infile = doc.getFunctionsInDoc();
	this.matchBlock = matchBlock;
	if (update) {
		update();
	}
    }

    public static void update() {
       if (ScilabCommonsUtils.isScilabThread()) {
           String[] vars = ScilabKeywords.GetVariablesName();
           String[] funs = ScilabKeywords.GetFunctionsName();
           String[] macs = ScilabKeywords.GetMacrosName();
           variables.clear();
           commands.clear();
           macros.clear();
           if (vars != null) {
               variables.addAll(Arrays.asList(vars));
           }
           if (funs != null) {
               commands.addAll(Arrays.asList(funs));
           }
           if (macs != null) {
               macros.addAll(Arrays.asList(macs));
           }
	}
    }

    public void setRange(int p0, int p1) {
        start = p0;
        end = p1;
        transposable = false;
        breakstring = false;
        yyreset(new ScilabDocumentReader(doc, p0, p1));
        int currentLine = elem.getElementIndex(start);
        if (currentLine != 0) {
	   ScilabDocument.ScilabLeafElement e = (ScilabDocument.ScilabLeafElement) elem.getElement(currentLine - 1);
	   if (e.isBrokenString()) {
              yybegin(QSTRING);
	   } else if (e.isBlockComment()) {
	      yybegin(BLOCKCOMMENT);
	   }
        }
    }

    public int yychar() {
        return yychar;
    }

    public int scan() throws IOException {
        int ret = yylex();
	int lastPos = start + yychar + yylength();
        if (lastPos == end - 1) {
           ((ScilabDocument.ScilabLeafElement) elem.getElement(elem.getElementIndex(start))).setBrokenString(breakstring);
           breakstring = false;
        } else if (lastPos == end) {
	   ((ScilabDocument.ScilabLeafElement) elem.getElement(elem.getElementIndex(start))).setBlockComment(yystate() == BLOCKCOMMENT);
        }
	return ret;
    }

    public boolean isLineFinishedByBlockComment(int start, int end) {
        this.start = start;
	this.end = end;
	try {		
           yyreset(new ScilabDocumentReader(doc, start, end));
	   int tok = 0;
	   while (tok != ScilabLexerConstants.EOF) {
	      tok = yylex();
	   }
        } catch (Exception e) { }
	
	return yystate() == BLOCKCOMMENT;
    }

    public int getKeyword(int pos, boolean strict) {
        // Pre condition
        if (elem == null) {
            return ScilabLexerConstants.DEFAULT;
        }

        Element line = elem.getElement(elem.getElementIndex(pos));
        int end = line.getEndOffset();
        int tok = -1;
        start = line.getStartOffset();
        int startL = start;
        int s = -1;

        try {
           yyreset(new ScilabDocumentReader(doc, start, end));
           if (!strict) {
              pos++;
           }

           while (startL < pos && (s != startL || yystate() == BREAKSTRING)) {
               s = startL;
               tok = yylex();
               startL = start + yychar + yylength();
           }

           return tok;
        } catch (IOException e) {
           return ScilabLexerConstants.DEFAULT;
        }
     }

     public static ScilabTokens getScilabTokens(String str) {
     	 ScilabDocument doc = new ScilabDocument(false);
	 try {
	     doc.insertString(0, str, null);
         } catch (BadLocationException e) { }
	 return getScilabTokens(doc);
     }

     public static ScilabTokens getScilabTokens(ScilabDocument doc) {
     	 ScilabLexer lexer = new ScilabLexer(doc);
	 lexer.yyreset(new ScilabDocumentReader(doc, 0, doc.getLength()));
	 ScilabTokens tokens = new ScilabTokens();
	 int tok = -1;
	 try {
	    while (tok != ScilabLexerConstants.EOF) {
               tok = lexer.yylex();
    	       tokens.add(tok, lexer.yychar + lexer.yylength());
	    }
	 } catch (IOException e) { }
 
	 return tokens;
     }

     public static class ScilabTokens {
        private List<Integer> tokenType = new ArrayList<Integer>();
        private List<Integer> tokenPos = new ArrayList<Integer>();

	ScilabTokens() { }

	void add(final int type, final int pos) {
	   tokenType.add(type);
	   tokenPos.add(pos);
	}

	public final List<Integer> getTokenType() {
	   return tokenType;
	}

	public final List<Integer> getTokenPos() {
	   return tokenPos;
	}
     }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ScilabLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 230) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return ScilabLexerConstants.EOF;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return ScilabLexerConstants.STRING;
            }
          case 44: break;
          case 2: 
            { transposable = false;
                                   return ScilabLexerConstants.DEFAULT;
            }
          case 45: break;
          case 3: 
            { transposable = false;
                                   return ScilabLexerConstants.OPENCLOSE;
            }
          case 46: break;
          case 4: 
            { transposable = true;
                                   return ScilabLexerConstants.OPENCLOSE;
            }
          case 47: break;
          case 5: 
            { transposable = false;
                                   return ScilabLexerConstants.OPERATOR;
            }
          case 48: break;
          case 6: 
            { if (transposable) {
                                       return ScilabLexerConstants.TRANSP;
                                    } else {
                                       beginString = zzStartRead;
                                       yybegin(QSTRING);
                                       return ScilabLexerConstants.STRING;
                                    }
            }
          case 49: break;
          case 7: 
            { transposable = false;
                                   beginString = zzStartRead;
                                   yybegin(QSTRING);
                                   return ScilabLexerConstants.STRING;
            }
          case 50: break;
          case 8: 
            { transposable = true;
                                   String str = yytext();
                                   if (commands.contains(str)) {
                                       yybegin(COMMANDS);
                                       return ScilabLexerConstants.COMMANDS;
                                   } else if (macros.contains(str)) {
                                       yybegin(COMMANDS);
                                       return ScilabLexerConstants.MACROS;
                                   } else if (infile.contains(str)) {
                                       yybegin(COMMANDS);
                                       return ScilabLexerConstants.MACROINFILE;
                                   } else {
                                       List<String>[] arr = doc.getInOutArgs(start + yychar);
                                       if (arr != null && (arr[0].contains(str) || arr[1].contains(str))) {
                                           return ScilabLexerConstants.INPUTOUTPUTARGS;
                                       } else if (variables.contains(str)) {
                                           return ScilabLexerConstants.VARIABLES;
                                       }
                                   }
                                   return ScilabLexerConstants.ID;
            }
          case 51: break;
          case 9: 
            { transposable = false;
                                   yybegin(FIELD);
                                   return ScilabLexerConstants.OPERATOR;
            }
          case 52: break;
          case 10: 
            { return ScilabLexerConstants.WHITE;
            }
          case 53: break;
          case 11: 
            { return ScilabLexerConstants.TAB;
            }
          case 54: break;
          case 12: 
            { transposable = false;
                                   return ScilabLexerConstants.SPECIAL;
            }
          case 55: break;
          case 13: 
            { transposable = true;
                                   return ScilabLexerConstants.NUMBER;
            }
          case 56: break;
          case 14: 
            { return ScilabLexerConstants.DEFAULT;
            }
          case 57: break;
          case 15: 
            { transposable = false;
                                   yybegin(YYINITIAL);
                                   return ScilabLexerConstants.STRING;
            }
          case 58: break;
          case 16: 
            { return ScilabLexerConstants.WHITE_STRING;
            }
          case 59: break;
          case 17: 
            { return ScilabLexerConstants.TAB_STRING;
            }
          case 60: break;
          case 18: 
            { return ScilabLexerConstants.COMMENT;
            }
          case 61: break;
          case 19: 
            { return ScilabLexerConstants.WHITE_COMMENT;
            }
          case 62: break;
          case 20: 
            { return ScilabLexerConstants.TAB_COMMENT;
            }
          case 63: break;
          case 21: 
            { yypushback(1);
                                   yybegin(YYINITIAL);
            }
          case 64: break;
          case 22: 
            { 
            }
          case 65: break;
          case 23: 
            { transposable = true;
                                   return ScilabLexerConstants.FIELD;
            }
          case 66: break;
          case 24: 
            { yypushback(yylength());
                                   yybegin(YYINITIAL);
            }
          case 67: break;
          case 25: 
            { yybegin(COMMANDSWHITE);
                                   return ScilabLexerConstants.WHITE;
            }
          case 68: break;
          case 26: 
            { yybegin(COMMANDSWHITE);
                                   return ScilabLexerConstants.TAB;
            }
          case 69: break;
          case 27: 
            { transposable = false;
                                   yypushback(2);
                                   yybegin(COMMENT);
            }
          case 70: break;
          case 28: 
            { transposable = false;
                                   yypushback(2);
                                   yybegin(BLOCKCOMMENT);
            }
          case 71: break;
          case 29: 
            { return ScilabLexerConstants.ERROR;
            }
          case 72: break;
          case 30: 
            { transposable = true;
                                   return ScilabLexerConstants.CONSTANTES;
            }
          case 73: break;
          case 31: 
            { transposable = false;
                                   return ScilabLexerConstants.OSKEYWORD;
            }
          case 74: break;
          case 32: 
            { transposable = false;
                                   return ScilabLexerConstants.SKEYWORD;
            }
          case 75: break;
          case 33: 
            { yypushback(yylength());
                                   yybegin(BREAKSTRING);
                                   transposable = false;
                                   return ScilabLexerConstants.STRING;
            }
          case 76: break;
          case 34: 
            { return ScilabLexerConstants.LATEX;
            }
          case 77: break;
          case 35: 
            { yybegin(YYINITIAL);
				   return ScilabLexerConstants.COMMENT;
            }
          case 78: break;
          case 36: 
            { breakstring = true;
                                   return ScilabLexerConstants.SPECIAL;
            }
          case 79: break;
          case 37: 
            { transposable = false;
				   if (matchBlock != null) {
				      MatchingBlockScanner.MatchingPositions pos = matchBlock.getMatchingBlock(start + yychar + yylength(), false);
				      if (pos != null) {
				         try {
				      	     String match = doc.getText(pos.secondB, pos.secondE - pos.secondB);
				      	     if (match.equals("function")) {
					        return ScilabLexerConstants.FKEYWORD;
					     }
				      	 } catch (BadLocationException e) { }
				      }
				   }
                                   return ScilabLexerConstants.OSKEYWORD;
            }
          case 80: break;
          case 38: 
            { transposable = false;
                                   return ScilabLexerConstants.ELSEIF;
            }
          case 81: break;
          case 39: 
            { transposable = false;
                                   return ScilabLexerConstants.CKEYWORD;
            }
          case 82: break;
          case 40: 
            { return ScilabLexerConstants.AUTHORS;
            }
          case 83: break;
          case 41: 
            { return ScilabLexerConstants.URL;
            }
          case 84: break;
          case 42: 
            { transposable = false;
                                   return ScilabLexerConstants.FKEYWORD;
            }
          case 85: break;
          case 43: 
            { return ScilabLexerConstants.MAIL;
            }
          case 86: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
