// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Simon LIPP <simon.lipp@scilab.org>
// Copyright (C) 2010 - DIGITEO - Pierre MARECHAL
// Copyright (C) 2010-2012 - DIGITEO - Allan CORNET
//
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at
// http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.txt

// Generate a loader.sce script for the toolbox

function tbx_build_loader(name, path)

    rhs = argn(2);

    // Number of input arguments

    if and(rhs <> [1 2]) then
        error(msprintf(gettext("%s: Wrong number of input arguments: %d to %d expected.\n"), "tbx_build_loader", 1, 2));
    end

    // Input argument N°1
    // name

    if type(name) <> 10 then
        error(msprintf(gettext("%s: Wrong type for input argument #%d: A string expected.\n"), "tbx_build_loader", 1));
    end

    if size(name, "*") <> 1 then
        error(msprintf(gettext("%s: Wrong size for input argument #%d: A string expected.\n"), "tbx_build_loader", 1));
    end

    // Input argument N°2
    // path

    if rhs < 2 then
        path = pwd();
    else
        if type(path) <> 10 then
            error(msprintf(gettext("%s: Wrong type for input argument #%d: A string expected.\n"), "tbx_build_loader", 2));
        end

        if size(path,"*") <> 1 then
            error(msprintf(gettext("%s: Wrong size for input argument #%d: A string expected.\n"), "tbx_build_loader", 2));
        end

        if ~isdir(path) then
            error(msprintf(gettext("%s: The directory ''%s'' doesn''t exist or is not read accessible.\n"), "tbx_build_loader", path));
        end
    end

    // build the loader file

    mprintf(gettext("Generating loader.sce...\n"));

    loadertxt = [
    "// This file is released under the 3-clause BSD license. See COPYING-BSD.",
    "// Generated by builder.sce: Please, do not edit this file",
    "",
    "try",
    " getversion(""scilab"");",
    "catch",
    " error(""Scilab 5.0 or more is required."");",
    "end;",
    "",
    "exec(get_absolute_file_path(""loader.sce"")+""etc"+filesep()+"""+"""+name+".start"");"];

    loaderfile = pathconvert(path + "/loader.sce", %F);

    if ~mputl(loadertxt, loaderfile) then
        error(msprintf(gettext("%s: The file %s cannot been created, please check if you have write access on this file.\n"), "tbx_build_loader", loaderfile));
    end

    mprintf(gettext("Generating unloader.sce...\n"));

    unloadertxt = [
    "// This file is released under the 3-clause BSD license. See COPYING-BSD.",
    "// Generated by builder.sce: Please, do not edit this file",
    "",
    "try",
    " getversion(""scilab"");",
    "catch",
    " error(""Scilab 5.4 or more is required."");",
    "end;",
    "",
    "fileQuit = get_absolute_file_path(""unloader.sce"") + ""etc" + filesep() + """ + """ + name + ".quit"";",
    "if isfile(fileQuit) then",
    "  exec(fileQuit);",
    "end"
    ""];

    unloaderfile = pathconvert(path + "/unloader.sce", %F);

    if ~mputl(unloadertxt, unloaderfile) then
        error(msprintf(gettext("%s: The file %s cannot been created, please check if you have write access on this file.\n"), "tbx_build_loader", unloaderfile));
    end

endfunction
