/*
  ids.hh, copyright (c) 2006 by Vincent Fourmond: 
  Declares classes that will be used to represent a id (temporary),
  a function and a variable.
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

namespace SCalc {

  /** 
      A class to represent an ID. It is not striclty speaking an
      Expression, but it comes in useful not to have all the union
      stuff in 
  */
  class ID : public Expression {

    int id;
    std::string value;

  public:
    ID(Session *, const char *);
    virtual ~ID();
    /// This function should really never be called.
    virtual double evaluate(const double *, const double *) { return 0.0;};
    virtual void dump(::std::ostream & stream = ::std::cerr);

    const char * name();
    int register_id();

    virtual Expression * copy() { return new ID(session(), value.c_str());};
    virtual std::string pretty_print();

    /// This is an invalid expression
    virtual int is_valid() {return 0;};
  };

  class Var : public Expression {
    int id;			// This id number corresponds
				// to the index at which we can find
				// it in the expression
  public:
    Var(Session *, ID *);
    Var(Session *s, int i) : Expression(s) { id = i;};
    virtual ~Var() {;};
    virtual double evaluate(const double *, const double *);
    virtual void dump(::std::ostream & stream = ::std::cerr);

    const char * name() { return session()->varname(id);};
    int get_id() { return id;};
    virtual std::set<int> used_variables();

    /// Sets the corresponding value within the current session
    void set_value(double v) {session()->set_var(id, v);};

    virtual Expression * derive(int id);

    virtual Expression * copy() { return new Var(session(), id);};
    virtual std::string pretty_print() { return std::string(name());};
  };

};
