/*
  const.cc, copyright (c) 2006 by Vincent Fourmond: 
  Implementation of a few different things for const.
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

#include <calc_internals.hh>
#include <sstream>

namespace SCalc {
  void Const::dump(std::ostream & stream)
  {
    stream << "const: ";
    stream << value;
    stream << " ";
  }

  std::string Const::pretty_print()
  {
    std::ostringstream str;
    str << value;
    return str.str();
  }

  void Null::dump(std::ostream & stream)
  {
    stream << "null ";
  }

};
