% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\docType{methods}
\name{dbReadTable,MySQLConnection,character-method}
\alias{dbExistsTable,MySQLConnection,character-method}
\alias{dbListFields,MySQLConnection,character-method}
\alias{dbListTables,MySQLConnection-method}
\alias{dbReadTable,MySQLConnection,character-method}
\alias{dbRemoveTable,MySQLConnection,character-method}
\title{Convenience functions for importing/exporting DBMS tables}
\usage{
\S4method{dbReadTable}{MySQLConnection,character}(conn, name, row.names,
  check.names = TRUE, ...)

\S4method{dbListTables}{MySQLConnection}(conn, ...)

\S4method{dbExistsTable}{MySQLConnection,character}(conn, name, ...)

\S4method{dbRemoveTable}{MySQLConnection,character}(conn, name, ...)

\S4method{dbListFields}{MySQLConnection,character}(conn, name, ...)
}
\arguments{
\item{conn}{a \code{\linkS4class{MySQLConnection}} object, produced by
\code{\link[DBI]{dbConnect}}}

\item{name}{a character string specifying a table name.}

\item{row.names}{A string or an index specifying the column in the DBMS table
to use as \code{row.names} in the output data.frame. Defaults to using the
\code{row_names} column if present. Set to \code{NULL} to never use
row names.}

\item{check.names}{If \code{TRUE}, the default, column names will be
converted to valid R identifiers.}

\item{...}{Unused, needed for compatiblity with generic.}
}
\value{
A data.frame in the case of \code{dbReadTable}; otherwise a logical
indicating whether the operation was successful.
}
\description{
These functions mimic their R/S-Plus counterpart \code{get}, \code{assign},
\code{exists}, \code{remove}, and \code{objects}, except that they generate
code that gets remotely executed in a database engine.
}
\note{
Note that the data.frame returned by \code{dbReadTable} only has
primitive data, e.g., it does not coerce character data to factors.
}
\examples{
if (mysqlHasDefault()) {
con <- dbConnect(RMySQL::MySQL(), dbname = "test")

# By default, row names are written in a column to row_names, and
# automatically read back into the row.names()
dbWriteTable(con, "mtcars", mtcars[1:5, ], overwrite = TRUE)
dbReadTable(con, "mtcars")
dbReadTable(con, "mtcars", row.names = NULL)
}
}

