% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disgenet_enrichment.R
\name{disease_enrichment}
\alias{disease_enrichment}
\title{Performs an enrichment analysis on a list of genes/variants and generates an object \code{DataGeNET.DGN}}
\usage{
disease_enrichment(
  entities = entities,
  universe = "DISGENET",
  custom_universe = "",
  vocabulary = "HGNC",
  verbose = TRUE,
  database = "CURATED",
  warnings = TRUE
)
}
\arguments{
\item{entities}{Name or vector of genes (Entrez identifiers or HGNC symbols) or variants (DBSNP identifiers) to
for the enrichment}

\item{universe}{The universe to be used for the Fisher test.
The possible values are:
\code{DISGENET} - All genes in DisGeNET
\code{HUMAN} - All genes according to the NCBI
\code{HUMAN_CODING} - All protein coding genes to the NCBI
\code{CUSTOM} - A list of genes or variants submitted by the user
\code{custom_universe} a list of genes/variants as Entrez or symbols/dbSNP identifiers to be used
as universe when setting the universe="CUSTOM"}

\item{vocabulary}{The vocabulary for the genes (ENTREZ or HGNC) and for the variants (DBSNP)}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get a
on-time log from the function.}

\item{database}{Name of the database that will be queried to retrieve the gene/variant disease annotations.
The possible values are:
\code{'CTD_human'} to use Comparative Toxicogenomics Database, human data;
\code{'UNIPROT'} to use Universal Protein Resource;
\code{'CLINGEN'} to use Clinical Genome Resource;
\code{'CGI'} to use Cancer Genome Interpreter;
\code{'ORPHANET'}, to use Orphanet, the portal for rare diseases and orphan drugs;
\code{'PSYGENET'} to use PSYGENET;
\code{'GENOMICS_ENGLAND'} to use Genomics England PanelApp;
\code{'CURATED'} to use expert curated, human databases;
\code{'HPO'} to use HPO;
\code{'INFERRED'} to use inferred data from HPO, GWASDB, GWASCAT, and CLINVAR;
\code{'CTD_rat'} to use Comparative Toxicogenomics Database, rat data;
\code{'CTD_mouse'} to use Comparative Toxicogenomics Database, mouse data;
\code{'RGD'}, to use Rat Genome Database;
\code{'MGD'}, to use the Mouse Genome Database;
\code{'ANIMAL_MODELS'} to use the expert curated, animal models data;
\code{'GWASCAT'} to use the NHGRI-EBI GWAS Catalog;
\code{'GWASDB'} to use the GWAS Database GWASdb;
\code{'CLINVAR'} to use ClinVar, a public archive of relationships
among sequence variation and human phenotype;
\code{'BEFREE'} to use text mining data, generated using BeFree System;
\code{'ALL'} to use all these databases. Default \code{'CURATED'}.}

\item{warnings}{By default \code{TRUE}. Change it to \code{FALSE} to not see
the warnings.}
}
\value{
An object of class \code{DataGeNET.Dis}
}
\description{
Performs an enrichment analysis on a list of genes/variants and generates an object \code{DataGeNET.DGN}
}
\examples{
res <- disease_enrichment( entities =c("APP", "PSEN","APOE"), vocabulary = "HGNC", database = "CURATED", universe = "HUMAN_CODING")
}
