% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http_interactions.R
\name{http_interactions}
\alias{http_interactions}
\title{Get the http interactions of the current cassette}
\usage{
http_interactions()
}
\value{
object of class \code{HTTPInteractionList} if there is a current
cassette in use, or \code{NullList} if no cassette in use
}
\description{
Get the http interactions of the current cassette
}
\examples{
\dontrun{
vcr_configure(dir = tempdir())
insert_cassette("foo_bar")
webmockr::webmockr_allow_net_connect()
library(crul)
cli <- crul::HttpClient$new("https://eu.httpbin.org/get")
one <- cli$get(query = list(a = 5))
z <- http_interactions()
z
z$interactions
z$used_interactions
# on eject, request written to the cassette
eject_cassette("foo_bar")

# insert cassette again
insert_cassette("foo_bar")
# now interactions will be present 
z <- http_interactions()
z$interactions
z$used_interactions
invisible(cli$get(query = list(a = 5)))
z$used_interactions

# cleanup
unlink(file.path(tempdir(), "foo_bar.yml"))
}
}
