% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-daterange.R
\name{dateRangeInput}
\alias{dateRangeInput}
\title{Create date range input}
\usage{
dateRangeInput(inputId, label, start = NULL, end = NULL, min = NULL,
  max = NULL, format = "yyyy-mm-dd", startview = "month",
  weekstart = 0, language = "en", separator = " to ", width = NULL,
  autoclose = TRUE)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{start}{The initial start date. Either a Date object, or a string in
\code{yyyy-mm-dd} format. If NULL (the default), will use the current
date in the client's time zone.}

\item{end}{The initial end date. Either a Date object, or a string in
\code{yyyy-mm-dd} format. If NULL (the default), will use the current
date in the client's time zone.}

\item{min}{The minimum allowed date. Either a Date object, or a string in
\code{yyyy-mm-dd} format.}

\item{max}{The maximum allowed date. Either a Date object, or a string in
\code{yyyy-mm-dd} format.}

\item{format}{The format of the date to display in the browser. Defaults to
\code{"yyyy-mm-dd"}.}

\item{startview}{The date range shown when the input object is first clicked.
Can be "month" (the default), "year", or "decade".}

\item{weekstart}{Which day is the start of the week. Should be an integer
from 0 (Sunday) to 6 (Saturday).}

\item{language}{The language used for month and day names. Default is "en".
Other valid values include "ar", "az", "bg", "bs", "ca", "cs", "cy", "da",
"de", "el", "en-AU", "en-GB", "eo", "es", "et", "eu", "fa", "fi", "fo",
"fr-CH", "fr", "gl", "he", "hr", "hu", "hy", "id", "is", "it-CH", "it",
"ja", "ka", "kh", "kk", "ko", "kr", "lt", "lv", "me", "mk", "mn", "ms",
"nb", "nl-BE", "nl", "no", "pl", "pt-BR", "pt", "ro", "rs-latin", "rs",
"ru", "sk", "sl", "sq", "sr-latin", "sr", "sv", "sw", "th", "tr", "uk",
"vi", "zh-CN", and "zh-TW".}

\item{separator}{String to display between the start and end input boxes.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[=validateCssUnit]{validateCssUnit()}}.}

\item{autoclose}{Whether or not to close the datepicker immediately when a
date is selected.}
}
\description{
Creates a pair of text inputs which, when clicked on, bring up calendars that
the user can click on to select dates.
}
\details{
The date \code{format} string specifies how the date will be displayed in
the browser. It allows the following values:

\itemize{
\item \code{yy} Year without century (12)
\item \code{yyyy} Year with century (2012)
\item \code{mm} Month number, with leading zero (01-12)
\item \code{m} Month number, without leading zero (1-12)
\item \code{M} Abbreviated month name
\item \code{MM} Full month name
\item \code{dd} Day of month with leading zero
\item \code{d} Day of month without leading zero
\item \code{D} Abbreviated weekday name
\item \code{DD} Full weekday name
}
}
\section{Server value}{

A \link{Date} vector of length 2.
}

\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  dateRangeInput("daterange1", "Date range:",
                 start = "2001-01-01",
                 end   = "2010-12-31"),

  # Default start and end is the current date in the client's time zone
  dateRangeInput("daterange2", "Date range:"),

  # start and end are always specified in yyyy-mm-dd, even if the display
  # format is different
  dateRangeInput("daterange3", "Date range:",
                 start  = "2001-01-01",
                 end    = "2010-12-31",
                 min    = "2001-01-01",
                 max    = "2012-12-21",
                 format = "mm/dd/yy",
                 separator = " - "),

  # Pass in Date objects
  dateRangeInput("daterange4", "Date range:",
                 start = Sys.Date()-10,
                 end = Sys.Date()+10),

  # Use different language and different first day of week
  dateRangeInput("daterange5", "Date range:",
                 language = "de",
                 weekstart = 1),

  # Start with decade view instead of default month view
  dateRangeInput("daterange6", "Date range:",
                 startview = "decade")
)

shinyApp(ui, server = function(input, output) { })
}

}
\seealso{
\code{\link[=dateInput]{dateInput()}}, \code{\link[=updateDateRangeInput]{updateDateRangeInput()}}

Other input elements: \code{\link{actionButton}},
  \code{\link{checkboxGroupInput}},
  \code{\link{checkboxInput}}, \code{\link{dateInput}},
  \code{\link{fileInput}}, \code{\link{numericInput}},
  \code{\link{passwordInput}}, \code{\link{radioButtons}},
  \code{\link{selectInput}}, \code{\link{sliderInput}},
  \code{\link{submitButton}}, \code{\link{textAreaInput}},
  \code{\link{textInput}}, \code{\link{varSelectInput}}
}
\concept{input elements}
