% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists_users.R
\name{lists_users}
\alias{lists_users}
\title{Get all lists a specified user subscribes to, including their own.}
\usage{
lists_users(user, reverse = FALSE, token = NULL, parse = TRUE)
}
\arguments{
\item{user}{The ID of the user or screen name for whom to return results.}

\item{reverse}{optional Set this to true if you would like owned lists
to be returned first. See description above for information on
how this parameter works.}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what `create_token()`
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
`vignettes("auth", "rtweet")` or see \code{?tokens}.}

\item{parse}{Logical indicating whether to convert the response object into
an R list. Defaults to TRUE.}
}
\value{
data
}
\description{
Get all lists a specified user subscribes to, including their own.
}
\examples{
\dontrun{

## get lists subsribed to by Nate Silver
lists_users("NateSilver538")

}

}
\seealso{
Other lists: 
\code{\link{lists_members}()},
\code{\link{lists_statuses}()},
\code{\link{lists_subscribers}()},
\code{\link{lists_subscriptions}()}
}
\concept{lists}
