% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_analysis_multiarm.R
\name{getClosedConditionalDunnettTestResults}
\alias{getClosedConditionalDunnettTestResults}
\title{Get Closed Conditional Dunnett Test Results}
\usage{
getClosedConditionalDunnettTestResults(
  stageResults,
  ...,
  stage = stageResults$stage
)
}
\arguments{
\item{stageResults}{The results at given stage, obtained from \code{\link[=getStageResults]{getStageResults()}}.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and
that a warning will be displayed if unknown arguments are passed.}

\item{stage}{The stage number (optional). Default: total number of existing stages in the data input.}
}
\value{
Returns a \code{\link{ClosedCombinationTestResults}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
\item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
\item \code{\link[=print.FieldSet]{print()}} to print the object,
\item \code{\link[=summary.ParameterSet]{summary()}} to display a summary of the object,
\item \code{\link[=plot.ParameterSet]{plot()}} to plot the object,
\item \code{\link[=as.data.frame.ParameterSet]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
\item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Calculates and returns the results from the closed conditional Dunnett test.
}
\details{
For performing the conditional Dunnett test the design must be defined through the function
\code{\link[=getDesignConditionalDunnett]{getDesignConditionalDunnett()}}.\cr
See Koenig et al. (2008) and Wassmer & Brannath (2016), chapter 11 for details of the test procedure.
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of
the \code{rpact} specific implementation of the generic.
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and
to identify the object specific name of it, e.g.,
use \code{methods("plot")} to get all the methods for the \code{plot} generic.
There you can find, e.g., \code{plot.AnalysisResults} and
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
\dontrun{
# In a two-stage design a conditional Dunnett test should be performed
# where the  unconditional second stage p-values should be used for the
# test decision. 
# At the first stage the second treatment arm was dropped. The results of 
# a closed conditionsal Dunnett test are obtained as follows with the given 
# data (treatment arm 4 refers to the reference group):   
data <- getDataset(
    n1 = c(22, 23),
    n2 = c(21, NA),
    n3 = c(20, 25),
    n4 = c(25, 27),
    means1 = c(1.63, 1.51),
    means2 = c(1.4, NA),
    means3 = c(0.91, 0.95),
    means4 = c(0.83, 0.75),
    stds1 = c(1.2, 1.4),
    stds2 = c(1.3, NA),
    stds3 = c(1.1, 1.14),
    stds4 = c(1.02, 1.18))

# For getting the results of the closed test procedure, use the following commands:
design <- getDesignConditionalDunnett(secondStageConditioning = FALSE)
stageResults <- getStageResults(design, dataInput = data)  
getClosedConditionalDunnettTestResults(stageResults)
}

}
\seealso{
Other analysis functions: 
\code{\link{getAnalysisResults}()},
\code{\link{getClosedCombinationTestResults}()},
\code{\link{getConditionalPower}()},
\code{\link{getConditionalRejectionProbabilities}()},
\code{\link{getFinalConfidenceInterval}()},
\code{\link{getFinalPValue}()},
\code{\link{getRepeatedConfidenceIntervals}()},
\code{\link{getRepeatedPValues}()},
\code{\link{getStageResults}()},
\code{\link{getTestActions}()}
}
\concept{analysis functions}
