% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_simulation_survival.R
\name{getSimulationSurvival}
\alias{getSimulationSurvival}
\title{Get Simulation Survival}
\usage{
getSimulationSurvival(
  design = NULL,
  ...,
  thetaH0 = C_THETA_H0_SURVIVAL_DEFAULT,
  directionUpper = C_DIRECTION_UPPER_DEFAULT,
  pi1 = NA_real_,
  pi2 = NA_real_,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  median1 = NA_real_,
  median2 = NA_real_,
  hazardRatio = NA_real_,
  kappa = 1,
  piecewiseSurvivalTime = NA_real_,
  allocation1 = C_ALLOCATION_1_DEFAULT,
  allocation2 = C_ALLOCATION_2_DEFAULT,
  eventTime = C_EVENT_TIME_DEFAULT,
  accrualTime = C_ACCRUAL_TIME_DEFAULT,
  accrualIntensity = C_ACCRUAL_INTENSITY_DEFAULT,
  dropoutRate1 = C_DROP_OUT_RATE_1_DEFAULT,
  dropoutRate2 = C_DROP_OUT_RATE_2_DEFAULT,
  dropoutTime = C_DROP_OUT_TIME_DEFAULT,
  maxNumberOfSubjects = NA_real_,
  plannedEvents = NA_real_,
  minNumberOfEventsPerStage = NA_real_,
  maxNumberOfEventsPerStage = NA_real_,
  conditionalPower = NA_real_,
  thetaH1 = NA_real_,
  maxNumberOfIterations = C_MAX_SIMULATION_ITERATIONS_DEFAULT,
  maxNumberOfRawDatasetsPerStage = 0,
  longTimeSimulationAllowed = FALSE,
  seed = NA_real_
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used. 
   In this case, \code{alpha}, \code{beta}, \code{twoSidedPower}, 
and \code{sided} can be directly entered as argument.}

\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{thetaH0}{The null hypothesis value. The default value is \code{1}. For one-sided testing, 
a bound for testing H0: hazard ratio = thetaH0 != 1 can be specified.}

\item{directionUpper}{Specifies the direction of the alternative, only applicable 
for one-sided testing, default is \code{TRUE}.}

\item{pi1}{The assumed event rate in the treatment group, default is \code{seq(0.2,0.5,0.1)}.}

\item{pi2}{The assumed event rate in the control group, default is 0.2.}

\item{lambda1}{The assumed hazard rate in the treatment group, there is no default.
lambda1 can also be used to define piecewise exponentially distributed survival times 
(see details).}

\item{lambda2}{The assumed hazard rate in the reference group, there is no default.
lambda2 can also be used to define piecewise exponentially distributed survival times 
(see details).}

\item{median1}{The assumed median survival time in the treatment group, there is no default.}

\item{median2}{The assumed median survival time in the reference group, there is no default.}

\item{hazardRatio}{The vector of hazard ratios under consideration. 
If the event or hazard rates in both treatment groups are defined, the hazard ratio needs 
not to be specified as it is calculated.}

\item{kappa}{The scale parameter of the Weibull distribution, default is \code{1}. 
The Weibull distribution cannot be used for the piecewise
   definition of the survival time distribution.    
Note that the parameters \code{shape} and \code{scale} in \code{\link[stats]{Weibull}} 
are equivalent to \code{kappa} and \code{1 / lambda}, respectively, in rpact.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for the piecewise 
definition of the exponential survival time cumulative distribution function (see details).}

\item{allocation1}{The number how many subjects are assigned to treatment 1 in a 
subsequent order, default is \code{1}}

\item{allocation2}{The number how many subjects are assigned to treatment 2 in a 
subsequent order, default is \code{1}}

\item{eventTime}{The assumed time under which the event rates are calculated, default is \code{12}.}

\item{accrualTime}{The assumed accrual time for the study, default is \code{12} 
(see \code{\link{getAccrualTime}}).}

\item{accrualIntensity}{A vector of accrual intensities, default is the relative 
intensity \code{0.1} (see \code{\link{getAccrualTime}}).}

\item{dropoutRate1}{The assumed drop-out rate in the treatment group, default is \code{0}.}

\item{dropoutRate2}{The assumed drop-out rate in the control group, default is \code{0}.}

\item{dropoutTime}{The assumed time for drop-out rates in the control and the 
treatment group, default is \code{12}.}

\item{maxNumberOfSubjects}{\code{maxNumberOfSubjects > 0} needs to be specified.
If accrual time and accrual intensity is specified, this will be calculated.}

\item{plannedEvents}{\code{plannedEvents} is a vector of length kMax 
(the number of stages of the design) with increasing numbers
   that determines the number of cumulated (overall) events when the interim stages are planned.}

\item{minNumberOfEventsPerStage}{When performing a data driven sample size recalculation, 
   the vector with length kMax \code{minNumberOfEventsPerStage} determines the 
minimum number of events per stage (i.e., not cumulated), the first element 
is not taken into account.}

\item{maxNumberOfEventsPerStage}{When performing a data driven sample size recalculation, 
   the vector with length kMax \code{maxNumberOfEventsPerStage} determines the maximum number 
of events per stage (i.e., not cumulated), the first element is not taken into account.}

\item{conditionalPower}{The conditional power for the subsequent stage under which the sample size recalculation is performed.}

\item{thetaH1}{If specified, the value of the hazard ratio under which the conditional power calculation is performed.}

\item{maxNumberOfIterations}{The number of simulation iterations.}

\item{maxNumberOfRawDatasetsPerStage}{The number of raw datasets per stage that shall 
be extracted and saved as \code{\link[base]{data.frame}}, default is \code{0}. 
\code{\link{getRawData}} can be used to get the extracted raw data from the object.}

\item{longTimeSimulationAllowed}{Logical that indicates whether long time simulations
that consumes more than 30 seconds are allowed or not, default is \code{FALSE}.}

\item{seed}{The seed to reproduce the simulation, default is a random seed.}
}
\value{
Returns a \code{\link{SimulationResultsSurvival}} object.
}
\description{
Returns the analysis times, power, stopping probabilities, conditional power, and expected sample size 
for testing the hazard ratio in a two treatment groups survival design.
}
\details{
At given design the function simulates the power, stopping probabilities, conditional power, and expected 
sample size at given number of events, number of subjects, and parameter configuration. 
It also simulates the time when the required events are expected under the given 
assumptions (exponentially, piecewise exponentially, or Weibull distributed survival times 
and constant or non-constant piecewise accrual). 
Additionally, integers \code{allocation1} and \code{allocation2} can be specified that determine the number allocated
to treatment group 1 and treatment group 2, respectively. 
 
The formula of Kim & Tsiatis (Biometrics, 1990) 
is used to calculated the expected number of events under the alternative 
(see also Lakatos & Lan, Statistics in Medicine, 1992). These formulas are generalized 
to piecewise survival times and non-constant piecewise accrual over time.\cr

\code{piecewiseSurvivalTime} 
The first element of this vector must be equal to \code{0}. \code{piecewiseSurvivalTime} can also 
be a list that combines the definition of the time intervals and hazard rates in the reference group. 
The definition of the survival time in the treatment group is obtained by the specification 
of the hazard ratio (see examples for details).

Note that \code{numberOfSubjects}, \code{numberOfSubjects1}, and \code{numberOfSubjects2} in the output
are expected number of subjects.
}
\section{Simulation Data}{

The summary statistics "Simulated data" contains the following 
parameters: median [range]; mean +/-sd\cr

\code{$show(showStatistics = FALSE)} or \code{$setShowStatistics(FALSE)} can be used to disable 
the output of the aggregated simulated data.\cr

Example 1: \cr
\code{simulationResults <- getSimulationSurvival(maxNumberOfSubjects = 100, plannedEvents = 30)} \cr
\code{simulationResults$show(showStatistics = FALSE)}\cr

Example 2: \cr
\code{simulationResults <- getSimulationSurvival(maxNumberOfSubjects = 100, plannedEvents = 30)} \cr
\code{simulationResults$setShowStatistics(FALSE)}\cr
\code{simulationResults}\cr

\code{\link{getData}} can be used to get the aggregated simulated data from the 
object as \code{\link[base]{data.frame}}. The data frame contains the following columns:
\enumerate{
  \item \code{iterationNumber}: The number of the simulation iteration.
  \item \code{stageNumber}: The stage.
  \item \code{pi1}: The assumed or derived event rate in the treatment group.
  \item \code{pi2}: The assumed or derived event rate in the control group.
  \item \code{hazardRatio}: The hazard ratio under consideration (if available).
  \item \code{analysisTime}: The analysis time.
  \item \code{numberOfSubjects}: The number of subjects under consideration when the 
        (interim) analysis takes place.
  \item \code{eventsPerStage1}: The observed number of events per stage 
        in treatment group 1.
  \item \code{eventsPerStage2}: The observed number of events per stage 
        in treatment group 2.
  \item \code{eventsPerStage}: The observed number of events per stage 
        in both treatment groups.
  \item \code{rejectPerStage}: 1 if null hypothesis can be rejected, 0 otherwise. 
  \item \code{futilityPerStage}: 1 if study should be stopped for futility, 0 otherwise.
  \item \code{eventsNotAchieved}: 1 if number of events could not be reached with 
        observed number of subjects, 0 otherwise.
  \item \code{testStatistic}: The test statistic that is used for the test decision, 
        depends on which design was chosen (group sequential, inverse normal, 
        or Fisher combination test)'  
  \item \code{logRankStatistic}: Z-score statistic which corresponds to a one-sided 
        log-rank test at considered stage. 
  \item \code{hazardRatioEstimateLR}: The estimated hazard ratio, derived from the 
        log-rank statistic.
  \item \code{trialStop}: \code{TRUE} if study should be stopped for efficacy or futility or final stage, \code{FALSE} otherwise.  
  \item \code{conditionalPowerAchieved}: The conditional power for the subsequent stage of the trial for 
			selected sample size and effect. The effect is either estimated from the data or can be
			user defined with \code{thetaH1}.   
}
}

\section{Raw Data}{

\code{\link{getRawData}} can be used to get the simulated raw data from the 
object as \code{\link[base]{data.frame}}. Note that \code{getSimulationSurvival} 
must called before with \code{maxNumberOfRawDatasetsPerStage} > 0.
The data frame contains the following columns: 
\enumerate{
  \item \code{iterationNumber}: The number of the simulation iteration.
  \item \code{stopStage}: The stage of stopping.
  \item \code{subjectId}: The subject id (increasing number 1, 2, 3, ...)
  \item \code{accrualTime}: The accrual time, i.e., the time when the subject entered the trial.
  \item \code{treatmentGroup}: The treatment group number (1 or 2).
  \item \code{survivalTime}: The survival time of the subject.
  \item \code{dropoutTime}: The dropout time of the subject (may be \code{NA}).
  \item \code{observationTime}: The specific observation time.
  \item \code{timeUnderObservation}: The time under observation is defined as follows:\cr
        if (event == TRUE) {\cr
            timeUnderObservation <- survivalTime;\cr
        } else if (dropoutEvent == TRUE) {\cr
            timeUnderObservation <- dropoutTime;\cr
        } else {\cr
            timeUnderObservation <- observationTime - accrualTime;\cr
        }
  \item \code{event}: \code{TRUE} if an event occurred; \code{FALSE} otherwise.
  \item \code{dropoutEvent}: \code{TRUE} if an dropout event occurred; \code{FALSE} otherwise. 
}
}

\examples{

# Fixed sample size with minimum required definitions, pi1 = (0.3,0.4,0.5,0.6) and 
# pi2 = 0.3 at event time 12, and accrual time 24 
getSimulationSurvival(pi1 = seq(0.3,0.6,0.1), pi2 = 0.3, eventTime = 12, 
    accrualTime = 24, plannedEvents = 40, maxNumberOfSubjects = 200, 
    maxNumberOfIterations = 50)

\donttest{

# Increase number of simulation iterations 
getSimulationSurvival(pi1 = seq(0.3,0.6,0.1), pi2 = 0.3, eventTime = 12, 
    accrualTime = 24, plannedEvents = 40, maxNumberOfSubjects = 200, 
    maxNumberOfIterations = 50)

# Determine necessary accrual time with default settings if 200 subjects and 
# 30 subjects per time unit can be recruited 
getSimulationSurvival(plannedEvents = 40, accrualTime = 0, 
    accrualIntensity = 30, maxNumberOfSubjects = 200, maxNumberOfIterations = 50)

# Determine necessary accrual time with default settings if 200 subjects and 
# if the first 6 time units 20 subjects per time unit can be recruited, 
# then 30 subjects per time unit 
getSimulationSurvival(plannedEvents = 40, accrualTime = c(0, 6), 
    accrualIntensity = c(20, 30), maxNumberOfSubjects = 200, 
    maxNumberOfIterations = 50)

# Determine maximum number of Subjects with default settings if the first 
# 6 time units 20 subjects per time unit can be recruited, and after 
# 10 time units 30 subjects per time unit
getSimulationSurvival(plannedEvents = 40, accrualTime = c(0, 6, 10), 
    accrualIntensity = c(20, 30), maxNumberOfIterations = 50)

# Specify accrual time as a list
at <- list(
	   "0 - <6"  = 20,
	   "6 - Inf" = 30)
getSimulationSurvival(plannedEvents = 40, accrualTime = at, 
    maxNumberOfSubjects = 200, maxNumberOfIterations = 50)

# Specify accrual time as a list, if maximum number of subjects need to be calculated
at <- list(
	   "0 - <6"   = 20,
	   "6 - <=10" = 30)
getSimulationSurvival(plannedEvents = 40, accrualTime = at, maxNumberOfIterations = 50)

# Specify effect size for a two-stage group sequential design with O'Brien & Fleming boundaries.
# Effect size is based on event rates at specified event time, directionUpper = FALSE 
# needs to be specified because it should be shown that hazard ratio < 1
getSimulationSurvival(design = getDesignGroupSequential(kMax = 2), 
	   pi1 = 0.2, pi2 = 0.3, eventTime = 24, plannedEvents = c(20, 40), 
	   maxNumberOfSubjects = 200, directionUpper = FALSE, maxNumberOfIterations = 50)

# As above, but with a three-stage O'Brien and Flemming design with 
# specified information rates, note that planned events consists of integer values
d3 <- getDesignGroupSequential(informationRates = c(0.4, 0.7, 1))
getSimulationSurvival(design = d3, pi1 = 0.2, pi2 = 0.3, eventTime = 24, 
	   plannedEvents = round(d3$informationRates * 40), 
	   maxNumberOfSubjects = 200, directionUpper = FALSE, 
    maxNumberOfIterations = 50)

# Effect size is based on event rate at specified event time for the reference group and 
# hazard ratio, directionUpper = FALSE needs to be specified because it should be shown 
# that hazard ratio < 1
getSimulationSurvival(design = getDesignGroupSequential(kMax = 2), hazardRatio = 0.5, 
	   pi2 = 0.3, eventTime = 24, plannedEvents = c(20, 40), maxNumberOfSubjects = 200, 
	   directionUpper = FALSE, maxNumberOfIterations = 50)

# Effect size is based on hazard rate for the reference group and 
# hazard ratio, directionUpper = FALSE needs to be specified because 
# it should be shown that hazard ratio < 1
getSimulationSurvival(design = getDesignGroupSequential(kMax = 2), 
    hazardRatio = 0.5, lambda2 = 0.02, plannedEvents = c(20, 40), 
    maxNumberOfSubjects = 200, directionUpper = FALSE, 
    maxNumberOfIterations = 50) 

# Specification of piecewise exponential survival time and hazard ratios, 
# note that in getSimulationSurvival only on hazard ratio is used
# in the case that the survival time is piecewise expoential
getSimulationSurvival(design = getDesignGroupSequential(kMax = 2), 
	   piecewiseSurvivalTime = c(0, 5, 10), lambda2 = c(0.01, 0.02, 0.04), 
	   hazardRatio = 1.5, plannedEvents = c(20, 40), maxNumberOfSubjects = 200, 
    maxNumberOfIterations = 50)

pws <- list(
    "0 - <5"  = 0.01,	
	   "5 - <10" = 0.02,	
	   ">=10"    = 0.04)
getSimulationSurvival(design = getDesignGroupSequential(kMax = 2), 
	   piecewiseSurvivalTime = pws, hazardRatio = c(1.5, 1.8, 2), 
	   plannedEvents = c(20, 40), maxNumberOfSubjects = 200, 
    maxNumberOfIterations = 50)

# Specification of piecewise exponential survival time for both treatment arms  
getSimulationSurvival(design = getDesignGroupSequential(kMax = 2), 
	   piecewiseSurvivalTime = c(0, 5, 10), lambda2 = c(0.01, 0.02, 0.04), 
	   lambda1 = c(0.015, 0.03, 0.06), plannedEvents = c(20, 40), 
	   maxNumberOfSubjects = 200, maxNumberOfIterations = 50)

# Specification of piecewise exponential survival time as a list, 
# note that in getSimulationSurvival only on hazard ratio 
# (not a vector) can be used
pws <- list(
    "0 - <5"  = 0.01,
	   "5 - <10" = 0.02,
	   ">=10"    = 0.04)
getSimulationSurvival(design = getDesignGroupSequential(kMax = 2), 
	   piecewiseSurvivalTime = pws, hazardRatio = 1.5, 
	   plannedEvents = c(20, 40), maxNumberOfSubjects = 200, 
    maxNumberOfIterations = 50)

# Specification of piecewise exponential survival time and delayed effect 
# (response after 5 time units)  
getSimulationSurvival(design = getDesignGroupSequential(kMax = 2), 
    piecewiseSurvivalTime = c(0, 5, 10), lambda2 = c(0.01, 0.02, 0.04), 
    lambda1 = c(0.01, 0.02, 0.06), plannedEvents = c(20, 40), 
    maxNumberOfSubjects = 200, maxNumberOfIterations = 50)

# Specify effect size based on median survival times
getSimulationSurvival(median1 = 5, median2 = 3, plannedEvents = 40, 
	   maxNumberOfSubjects = 200, directionUpper = FALSE, 
    maxNumberOfIterations = 50)

# Specify effect size based on median survival 
# times of Weibull distribtion with kappa = 2
getSimulationSurvival(median1 = 5, median2 = 3, kappa = 2, 
	   plannedEvents = 40, maxNumberOfSubjects = 200, 
    directionUpper = FALSE, maxNumberOfIterations = 50)

# Perform recalculation of number of events based on conditional power for a 
# three-stage design with inverse normal combination test, where the conditional power 
# is calculated under the specified effect size thetaH1 = 1.3 and up to a four-fold 
# increase in originally planned sample size (number of events) is allowed
# Note that the first value in minNumberOfEventsPerStage and 
# maxNumberOfEventsPerStage is arbitrary, i.e., it has no effect.
dIN <- getDesignInverseNormal(informationRates = c(0.4, 0.7, 1))

resultsWithSSR1 <- getSimulationSurvival(design = dIN, 
    hazardRatio = seq(1, 1.6, 0.1), 
    pi2 = 0.3, conditionalPower = 0.8, thetaH1 = 1.3, 
    plannedEvents = c(58, 102, 146), 
	   minNumberOfEventsPerStage = c(58, 44, 44), 
    maxNumberOfEventsPerStage = 4 * c(58, 44, 44),
	   maxNumberOfSubjects = 800, maxNumberOfIterations = 50)
resultsWithSSR1

# If thetaH1 is unspecified, the observed hazard ratio estimate 
# (calculated from the log-rank statistic) is used for performing the 
# recalculation of the number of events
resultsWithSSR2 <- getSimulationSurvival(design = dIN, 
    hazardRatio = seq(1, 1.6, 0.1), 
	   pi2 = 0.3, conditionalPower = 0.8, plannedEvents = c(58, 102, 146), 
	   minNumberOfEventsPerStage = c(58, 44, 44), 
    maxNumberOfEventsPerStage = 4 * c(58, 44, 44),
	   maxNumberOfSubjects = 800, maxNumberOfIterations = 50)
resultsWithSSR2

# Compare it with design without event size recalculation
resultsWithoutSSR <- getSimulationSurvival(design = dIN, 
    hazardRatio = seq(1, 1.6, 0.1), pi2 = 0.3, 
    plannedEvents = c(58, 102, 145), maxNumberOfSubjects = 800, 
	   maxNumberOfIterations = 50)
resultsWithoutSSR$overallReject
resultsWithSSR1$overallReject
resultsWithSSR2$overallReject

# Confirm that event size racalcuation increases the Type I error rate, 
# i.e., you have to use the combination test 
dGS <- getDesignGroupSequential(informationRates = c(0.4, 0.7, 1))
resultsWithSSRGS <- getSimulationSurvival(design = dGS, hazardRatio = seq(1), 
	   pi2 = 0.3, conditionalPower = 0.8, plannedEvents = c(58, 102, 145), 
	   minNumberOfEventsPerStage = c(58, 44, 44), 
    maxNumberOfEventsPerStage = 4 * c(58, 44, 44),
	   maxNumberOfSubjects = 800, maxNumberOfIterations = 50)
resultsWithSSRGS$overallReject

# Set seed to get reproduceable results

identical(
	   getSimulationSurvival(plannedEvents = 40, maxNumberOfSubjects = 200, 
        seed = 99)$analysisTime,
	   getSimulationSurvival(plannedEvents = 40, maxNumberOfSubjects = 200, 
        seed = 99)$analysisTime
)

}

}
