% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_metadata.R
\name{group_metadata}
\alias{group_metadata}
\alias{group_data}
\alias{group_rows}
\alias{group_indices}
\alias{group_vars}
\alias{groups}
\alias{group_size}
\alias{n_groups}
\title{Grouping metadata}
\usage{
group_data(.data)

group_rows(.data)

group_indices(.data)

group_vars(x)

groups(x)

group_size(x)

n_groups(x)
}
\arguments{
\item{.data, x}{A \code{data.frame}.}
}
\description{
\itemize{
\item \code{group_data()} returns a data frame that defines the grouping structure. The columns give the values of the
grouping variables. The last column, always called \code{.rows}, is a list of integer vectors that gives the location of
the rows in each group.
}

\itemize{
\item \code{group_rows()} returns the rows which each group contains.
}

\itemize{
\item \code{group_indices()} returns an integer vector the same length as \code{.data} that gives the group that each row belongs
to.
}

\itemize{
\item \code{group_vars()} gives names of grouping variables as character vector.
}

\itemize{
\item \code{groups()} gives the names as a list of symbols.
}

\itemize{
\item \code{group_size()} gives the size of each group.
}

\itemize{
\item \code{n_groups()} gives the total number of groups.
}
}
\examples{
df <- data.frame(x = c(1,1,2,2))
group_vars(df)
group_rows(df)
group_data(df)

gf <- group_by(df, x)
group_vars(gf)
group_rows(gf)
group_data(gf)

}
\seealso{
See \link{context} for equivalent functions that return values for the current group.
}
