% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_set.R
\name{pr_set_api_spec}
\alias{pr_set_api_spec}
\title{Set the OpenAPI Specification}
\usage{
pr_set_api_spec(pr, api)
}
\arguments{
\item{pr}{A Plumber API. Note: The supplied Plumber API object will also be updated in place as well as returned by the function.}

\item{api}{This can be
\itemize{
\item an OpenAPI Specification formatted list object
\item a function that accepts the OpenAPI Specification autogenerated by \code{plumber} and returns a OpenAPI Specification formatted list object.
\item a path to an OpenAPI Specification
}

The value returned will not be validated for OAS compatibility.}
}
\value{
The Plumber router with the new OpenAPI Specification object or function.
}
\description{
Allows to modify OpenAPI Specification autogenerated by \code{plumber}.
}
\details{
Note, the returned value will be sent through \code{\link[=serializer_unboxed_json]{serializer_unboxed_json()}} which will turn all length 1 vectors into atomic values.
To force a vector to serialize to an array of size 1, be sure to call \code{\link[=as.list]{as.list()}} on your value. \code{list()} objects are always serialized to an array value.
}
\examples{
\dontrun{
# Set the API Spec to a function to use the auto-generated OAS object
pr() \%>\%
  pr_set_api_spec(function(spec) {
    spec$info$title <- Sys.time()
    spec
  }) \%>\%
  pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
  pr_run()

# Set the API Spec using an object
pr() \%>\%
  pr_set_api_spec(my_custom_object) \%>\%
  pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
  pr_run()
}
}
