\name{gastric}
\alias{gastric}

\docType{data}

\title{
  Gastric Cancer Survival Data
}

\description{ Contains the survival times of 45 gastrointestinal tumor
  patients who were treated with both chemotherapy and radiotherapy. It
  has both exact and right-censored observations. }

\usage{gastric}

\format{ A data frame with 30 observations and 3 variables:
  
  L: left-end points of the interval-censored survival times;

  R: right-end points of the interval-censored survival times.}

\source{ Klein and Moeschberger (2003), page 224. }

\references{ Klein, J. P. and Moeschberger, M. L. (2003).  \emph{Survival
  Analysis: Techniques for Censored and Truncated Data (2nd ed.)}.
  Springer. }

\seealso{ \code{\link{npsurv}}, \code{\link{Uhaz}}. }

\examples{
data(gastric)
plot(npsurv(gastric), col="grey")      # survival function
plot(h0<-Uhaz(gastric, deg=0)$h, fn="s", add=TRUE, col="green3")
plot(h1<-Uhaz(gastric, deg=1)$h, fn="s", add=TRUE)
plot(h2<-Uhaz(gastric, deg=2)$h, fn="s", add=TRUE, col="red3")

plot(h0, fn="h", col="green3")         # hazard function
plot(h1, fn="h", add=TRUE)
plot(h2, fn="h", add=TRUE, col="red3")

plot(h0, fn="d", col="green3")         # density function
plot(h1, fn="d", add=TRUE)
plot(h2, fn="d", add=TRUE, col="red3") 

}

\keyword{datasets}

