% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervention.R
\name{intervention.lvm}
\alias{intervention.lvm}
\alias{intervention<-}
\alias{intervention}
\alias{intervention<-.lvm}
\title{Define intervention}
\usage{
\method{intervention}{lvm}(object, to, value, dist = none.lvm(), ...)
}
\arguments{
\item{object}{lvm object}

\item{to}{String defining variable or formula}

\item{value}{function defining intervention}

\item{dist}{Distribution}

\item{...}{Additional arguments to lower level functions}
}
\description{
Define intervention in a `lvm` object
}
\examples{
m <- lvm(y ~ a + x, a ~ x)
distribution(m, ~a+y) <- binomial.lvm()
mm <- intervention(m, "a", value=3)
sim(mm, 10)
mm <- intervention(m, a~x, function(x) (x>0)*1)
sim(mm, 10)
}
\seealso{
regression lvm sim
}
