% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimws.R
\name{trimws_ctl}
\alias{trimws_ctl}
\title{Control Sequence Aware Version of trimws}
\usage{
trimws_ctl(
  x,
  which = c("both", "left", "right"),
  whitespace = "[ \\t\\r\\n]",
  warn = getOption("fansi.warn", TRUE),
  term.cap = getOption("fansi.term.cap", dflt_term_cap()),
  ctl = "all",
  normalize = getOption("fansi.normalize", FALSE)
)
}
\arguments{
\item{x}{a character vector}

\item{which}{a character string specifying whether to remove both
    leading and trailing whitespace (default), or only leading
    (\code{"left"}) or trailing (\code{"right"}).  Can be abbreviated.}

\item{whitespace}{must be set to the default value, in the future it may
become possible to change this parameter.}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \code{\link[=fansi]{?fansi}}).
At most one warning will be issued per element in each input vector.  Will
also warn about some badly encoded UTF-8 strings, but a lack of UTF-8
warnings is not a guarantee of correct encoding (use \code{\link{validUTF8}} for
that).}

\item{term.cap}{character a vector of the capabilities of the terminal, can
be any combination of "bright" (SGR codes 90-97, 100-107), "256" (SGR codes
starting with "38;5" or "48;5"), "truecolor" (SGR codes starting with
"38;2" or "48;2"), and "all". "all" behaves as it does for the \code{ctl}
parameter: "all" combined with any other value means all terminal
capabilities except that one.  \code{fansi} will warn if it encounters SGR codes
that exceed the terminal capabilities specified (see \code{\link{term_cap_test}}
for details).  In versions prior to 1.0, \code{fansi} would also skip exceeding
SGRs entirely instead of interpreting them.  You may add the string "old"
to any otherwise valid \code{term.cap} spec to restore the pre 1.0 behavior.
"old" will not interact with "all" the way other valid values for this
parameter do.}

\item{ctl}{character, which \emph{Control Sequences} should be treated
specially.  Special treatment is context dependent, and may include
detecting them and/or computing their display/character width as zero.  For
the SGR subset of the ANSI CSI sequences, and OSC hyperlinks, \code{fansi}
will also parse, interpret, and reapply the sequences as needed.  You can
modify whether a \emph{Control Sequence} is treated specially with the \code{ctl}
parameter.
\itemize{
\item "nl": newlines.
\item "c0": all other "C0" control characters (i.e. 0x01-0x1f, 0x7F), except
for newlines and the actual ESC (0x1B) character.
\item "sgr": ANSI CSI SGR sequences.
\item "csi": all non-SGR ANSI CSI sequences.
\item "url": OSC hyperlinks
\item "osc": all non-OSC-hyperlink OSC sequences.
\item "esc": all other escape sequences.
\item "all": all of the above, except when used in combination with any of the
above, in which case it means "all but".
}}

\item{normalize}{TRUE or FALSE (default) whether SGR sequence should be
normalized out such that there is one distinct sequence for each SGR code.
normalized strings will occupy more space (e.g. "\033[31;42m" becomes
"\033[31m\033[42m"), but will work better with code that assumes each SGR
code will be in its own escape as \code{crayon} does.}
}
\value{
The input with white space removed as described.
}
\description{
Removes any whitespace before the first and/or after the last non-\emph{Control
Sequence} character.  Unlike with the \code{\link[base:trimws]{base::trimws}}, only the default
\code{whitespace} specification is supported.
}
\section{Control and Special Sequences}{


\emph{Control Sequences} are non-printing characters or sequences of characters.
\emph{Special Sequences} are a subset of the \emph{Control Sequences}, and include CSI
SGR sequences which can be used to change rendered appearance of text, and
OSC hyperlinks.  See \code{\link{fansi}} for details.
}

\section{Output Stability}{


Several factors could affect the exact output produced by \code{fansi}
functions across versions of \code{fansi}, \code{R}, and/or across systems.
\strong{In general it is best not to rely on exact \code{fansi} output, e.g. by
embedding it in tests}.

Width and grapheme calculations depend on locale, Unicode database
version, and grapheme processing logic (which is still in development), among
other things.  For the most part \code{fansi} (currently) uses the internals of
\code{base::nchar(type='width')}, but there are exceptions and this may change in
the future.

How a particular display format is encoded in \emph{Control Sequences} is
not guaranteed to be stable across \code{fansi} versions.  Additionally, which
\emph{Special Sequences} are re-encoded vs transcribed untouched may change.
In general we will strive to keep the rendered appearance stable.

To maximize the odds of getting stable output set \code{normalize_state} to
\code{TRUE} and \code{type} to \code{"chars"} in functions that allow it, and
set \code{term.cap} to a specific set of capabilities.
}

\examples{
trimws_ctl(" \033[31m\thello world\t\033[39m  ")
}
