% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-result-clear-result.R
\docType{data}
\name{spec_result_clear_result}
\alias{spec_result_clear_result}
\title{spec_result_clear_result}
\value{
\code{dbClearResult()} returns \code{TRUE}, invisibly, for result sets obtained from
\code{dbSendQuery()},
\code{dbSendStatement()},
or \code{dbSendQueryArrow()},
}
\description{
spec_result_clear_result
}
\section{Failure modes}{

An attempt to close an already closed result set issues a warning
for \code{dbSendQuery()},
\code{dbSendStatement()},
and \code{dbSendQueryArrow()},
}

\section{Specification}{

\code{dbClearResult()} frees all resources associated with retrieving
the result of a query or update operation.
The DBI backend can expect a call to \code{dbClearResult()} for each
\code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}} or \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}} call.
}

\seealso{
Other result specifications: 
\code{\link{spec_result_create_table_with_data_type}},
\code{\link{spec_result_execute}},
\code{\link{spec_result_fetch}},
\code{\link{spec_result_get_query}},
\code{\link{spec_result_roundtrip}},
\code{\link{spec_result_send_query}},
\code{\link{spec_result_send_statement}}

Other Arrow specifications: 
\code{\link{spec_arrow_append_table_arrow}},
\code{\link{spec_arrow_create_table_arrow}},
\code{\link{spec_arrow_fetch_arrow}},
\code{\link{spec_arrow_fetch_arrow_chunk}},
\code{\link{spec_arrow_get_query_arrow}},
\code{\link{spec_arrow_read_table_arrow}},
\code{\link{spec_arrow_send_query_arrow}},
\code{\link{spec_arrow_write_table_arrow}}
}
\concept{Arrow specifications}
\concept{result specifications}
