% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{tpr}
\alias{tpr}
\alias{fpr}
\alias{tnr}
\alias{fnr}
\title{Calculate true / false positive / negative rate}
\usage{
tpr(tp, fn, ...)

fpr(fp, tn, ...)

tnr(fp, tn, ...)

fnr(tp, fn, ...)
}
\arguments{
\item{tp}{(numeric) number of true positives.}

\item{fn}{(numeric) number of false negatives.}

\item{...}{for capturing additional arguments passed by method.}

\item{fp}{(numeric) number of false positives.}

\item{tn}{(numeric) number of true negatives.}
}
\description{
Calculate the true positive rate (tpr, equal to sensitivity and recall),
the false positive rate (fpr, equal to fall-out),
the true negative rate (tnr, equal to specificity),
or the false negative rate (fnr) from
true positives, false positives, true negatives and false negatives.
The inputs must be vectors of equal length. \cr \cr
tpr = tp / (tp + fn) \cr
fpr = fp / (fp + tn) \cr
tnr = tn / (tn + fp) \cr
fnr = fn / (fn + tp) \cr
}
\examples{
tpr(10, 5, 20, 10)
tpr(c(10, 8), c(5, 7), c(20, 12), c(10, 18))
}
\seealso{
Other metric functions: 
\code{\link{F1_score}()},
\code{\link{Jaccard}()},
\code{\link{abs_d_ppv_npv}()},
\code{\link{abs_d_sens_spec}()},
\code{\link{accuracy}()},
\code{\link{cohens_kappa}()},
\code{\link{cutpoint}()},
\code{\link{false_omission_rate}()},
\code{\link{metric_constrain}()},
\code{\link{misclassification_cost}()},
\code{\link{npv}()},
\code{\link{odds_ratio}()},
\code{\link{p_chisquared}()},
\code{\link{plr}()},
\code{\link{ppv}()},
\code{\link{precision}()},
\code{\link{prod_ppv_npv}()},
\code{\link{prod_sens_spec}()},
\code{\link{recall}()},
\code{\link{risk_ratio}()},
\code{\link{roc01}()},
\code{\link{sensitivity}()},
\code{\link{specificity}()},
\code{\link{sum_ppv_npv}()},
\code{\link{sum_sens_spec}()},
\code{\link{total_utility}()},
\code{\link{tp}()},
\code{\link{youden}()}
}
\concept{metric functions}
