write.csv(file="../extdata/2.0.0/metadata-zeisel-brain.csv", 
    data.frame(
        Title = sprintf("Zeisel brain %s", c("counts", "rowData", "colData")),
        Description = sprintf("%s for the Zeisel brain single-cell RNA-seq dataset", 
            c("Count matrix", "Per-gene metadata", "Per-cell metadata")),
        RDataPath = file.path("scRNAseq", "zeisel-brain", "2.0.0", 
            c("counts.rds", "rowdata.rds", "coldata.rds")),
        BiocVersion="3.10",
        Genome="mm10",
        SourceType="TSV",
        SourceUrl="https://storage.googleapis.com/linnarsson-lab-www-blobs/blobs/cortex",
        SourceVersion=paste(
            "expression_mRNA_17-Aug-2014.txt",
            "expression_mito_17-Aug-2014.txt",
            "expression_rep_17-Aug-2014.txt",
            "expression_spikes_17-Aug-2014.txt", sep=";"),
        Species="Mus musculus",
        TaxonomyId="10090",
        Coordinate_1_based=NA,
        DataProvider="Sten Linnarsson",
        Maintainer="Aaron Lun <infinite.monkeys.with.keyboards@gmail.com>",
        RDataClass=c("matrix", "DataFrame", "DataFrame"),
        DispatchClass="Rds",
        stringsAsFactors = FALSE
    ),
    row.names=FALSE)
