% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{plot,ihwResult,ANY-method}
\alias{plot,ihwResult,ANY-method}
\alias{plot,ihwResult-method}
\title{Plot functions for IHW}
\usage{
\S4method{plot}{ihwResult,ANY}(x, x_axis = c(weights = "group",
  decisionboundary = "covariate")[what], what = "weights",
  scale = covariate_type(x))
}
\arguments{
\item{x}{Object of class \code{ihwResult}}

\item{x_axis}{\code{Character}: "group" or "covariate". Default is "group" if "what" is "weights", and "covariate" if "what" is "decisionboundary".}

\item{what}{\code{Character}: "weights" or "decisionboundary"}

\item{scale}{\code{Character}: "ordinal" or "nominal"}
}
\value{
A \code{ggplot2} object.
}
\description{
See the vignette for usage examples.
}
\examples{

   save.seed <- .Random.seed; set.seed(1)
   X   <- runif(20000, min = 0.5, max = 4.5) # covariate
   H   <- rbinom(20000, 1, 0.1)              # hypothesis true or false
   Z   <- rnorm(20000, H*X)                  # z-score
   .Random.seed <- save.seed
   pvalue <- 1-pnorm(Z)                      #pvalue
   ihw_res <- ihw(pvalue, X, .1)
   plot(ihw_res)

}
