/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QGRAPHICSZIONGROUP_H__
#define __QGRAPHICSZIONGROUP_H__

#include <QGraphicsItem>
#include <QGraphicsRectItem>

#include "qzionabstractcanvas.h"

class QGraphicsZionGroup : public QGraphicsItem
{
public:
    QGraphicsZionGroup(QGraphicsItem *parent = 0);
    virtual ~QGraphicsZionGroup();

    bool clipping() const;
    void setClipping(const bool on=true);

    QSize size() const;
    void setSize(const QSize &size);

    virtual QRectF boundingRect() const;

    void paint(QPainter * painter,
               const QStyleOptionGraphicsItem* option, QWidget* widget);

    void mouseMoveEvent(QGraphicsSceneMouseEvent *e);
    void mousePressEvent(QGraphicsSceneMouseEvent *e);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *e);
    void hoverMoveEvent(QGraphicsSceneHoverEvent *e);

    QZionAbstractCanvas *owner;

private:
    QRectF _boundingRect;
};

#endif
